/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.alg.tracker.sfot.SparseFlowObjectTracker;
import boofcv.struct.RectangleRotate_F32;
import boofcv.struct.RectangleRotate_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.geometry.UtilPoint2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;

public class Sfot_to_TrackObjectQuad<T extends ImageGray, D extends ImageGray>
implements TrackerObjectQuad<T> {
    SparseFlowObjectTracker<T, D> alg;
    RectangleRotate_F64 region = new RectangleRotate_F64();
    ImageType<T> type;

    public Sfot_to_TrackObjectQuad(SparseFlowObjectTracker<T, D> alg, Class<T> imageType) {
        this.alg = alg;
        this.type = ImageType.single(imageType);
    }

    @Override
    public boolean initialize(T image, Quadrilateral_F64 location) {
        Sfot_to_TrackObjectQuad.quadToRectRot(location, this.region);
        this.alg.init(image, this.region);
        return true;
    }

    @Override
    public boolean process(T image, Quadrilateral_F64 location) {
        if (!this.alg.update(image, this.region)) {
            return false;
        }
        Sfot_to_TrackObjectQuad.rectRotToQuad(this.region, location);
        return true;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.type;
    }

    public static void quadToRectRot(Quadrilateral_F64 q, RectangleRotate_F64 r) {
        double centerX = (q.a.x + q.b.x + q.c.x + q.d.x) / 4.0;
        double centerY = (q.a.y + q.b.y + q.c.y + q.d.y) / 4.0;
        double topX = (q.a.x + q.b.x) / 2.0;
        double topY = (q.a.y + q.b.y) / 2.0;
        double sideX = (q.b.x + q.c.x) / 2.0;
        double sideY = (q.b.y + q.c.y) / 2.0;
        r.cx = centerX;
        r.cy = centerY;
        r.height = 2.0 * UtilPoint2D_F64.distance((double)topX, (double)topY, (double)centerX, (double)centerY);
        r.width = 2.0 * UtilPoint2D_F64.distance((double)sideX, (double)sideY, (double)centerX, (double)centerY);
        r.theta = Math.atan2(sideY - centerY, sideX - centerX);
    }

    public static void quadToRectRot(Quadrilateral_F64 q, RectangleRotate_F32 r) {
        double centerX = (q.a.x + q.b.x + q.c.x + q.d.x) / 4.0;
        double centerY = (q.a.y + q.b.y + q.c.y + q.d.y) / 4.0;
        double topX = (q.a.x + q.b.x) / 2.0;
        double topY = (q.a.y + q.b.y) / 2.0;
        double sideX = (q.b.x + q.c.x) / 2.0;
        double sideY = (q.b.y + q.c.y) / 2.0;
        r.cx = (float)centerX;
        r.cy = (float)centerY;
        r.height = 2.0f * (float)UtilPoint2D_F64.distance((double)topX, (double)topY, (double)centerX, (double)centerY);
        r.width = 2.0f * (float)UtilPoint2D_F64.distance((double)sideX, (double)sideY, (double)centerX, (double)centerY);
        r.theta = (float)Math.atan2(sideY - centerY, sideX - centerX);
    }

    public static void rectRotToQuad(RectangleRotate_F64 r, Quadrilateral_F64 q) {
        double c = Math.cos(r.theta);
        double s = Math.sin(r.theta);
        Sfot_to_TrackObjectQuad.setPoint(q.a, -r.width / 2.0, -r.height / 2.0, c, s);
        Sfot_to_TrackObjectQuad.setPoint(q.b, r.width / 2.0, -r.height / 2.0, c, s);
        Sfot_to_TrackObjectQuad.setPoint(q.c, r.width / 2.0, r.height / 2.0, c, s);
        Sfot_to_TrackObjectQuad.setPoint(q.d, -r.width / 2.0, r.height / 2.0, c, s);
        q.a.x += r.cx;
        q.a.y += r.cy;
        q.b.x += r.cx;
        q.b.y += r.cy;
        q.c.x += r.cx;
        q.c.y += r.cy;
        q.d.x += r.cx;
        q.d.y += r.cy;
    }

    public static void rectRotToQuad(RectangleRotate_F32 r, Quadrilateral_F64 q) {
        double c = Math.cos(r.theta);
        double s = Math.sin(r.theta);
        Sfot_to_TrackObjectQuad.setPoint(q.a, -r.width / 2.0f, (double)(-r.height) / 2.0, c, s);
        Sfot_to_TrackObjectQuad.setPoint(q.b, r.width / 2.0f, (double)(-r.height) / 2.0, c, s);
        Sfot_to_TrackObjectQuad.setPoint(q.c, r.width / 2.0f, (double)r.height / 2.0, c, s);
        Sfot_to_TrackObjectQuad.setPoint(q.d, -r.width / 2.0f, (double)r.height / 2.0, c, s);
        q.a.x += (double)r.cx;
        q.a.y += (double)r.cy;
        q.b.x += (double)r.cx;
        q.b.y += (double)r.cy;
        q.c.x += (double)r.cx;
        q.c.y += (double)r.cy;
        q.d.x += (double)r.cx;
        q.d.y += (double)r.cy;
    }

    private static void setPoint(Point2D_F64 p, double x, double y, double c, double s) {
        p.x = x * c - y * s;
        p.y = x * s + y * c;
    }
}

