/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib;

import boofcv.alg.fiducial.square.BaseDetectFiducialSquare;
import boofcv.alg.fiducial.square.FoundFiducial;
import boofcv.struct.image.ImageGray;
import georegression.struct.shapes.Quadrilateral_F64;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class DetectFiducialSquareGrid<T extends ImageGray> {
    int numRows;
    int numCols;
    long[] numbers;
    BaseDetectFiducialSquare<T> detector;
    FastQueue<Detection> detections = new FastQueue(Detection.class, true);

    public DetectFiducialSquareGrid(int numRows, int numCols, long[] numbers, BaseDetectFiducialSquare<T> detector) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.numbers = numbers;
        this.detector = detector;
    }

    public boolean detect(T input) {
        int i;
        this.detections.reset();
        this.detector.process(input);
        FastQueue<FoundFiducial> found = this.detector.getFound();
        for (i = 0; i < found.size(); ++i) {
            FoundFiducial fid = (FoundFiducial)found.get(i);
            int gridIndex = this.isExpected(fid.id);
            if (gridIndex < 0) continue;
            Detection d = this.lookupDetection(fid.id, gridIndex);
            d.location.set(fid.distortedPixels);
            ++d.numDetected;
        }
        for (i = this.detections.size - 1; i >= 0; --i) {
            if (((Detection)this.detections.get((int)i)).numDetected == 1) continue;
            this.detections.remove(i);
        }
        return this.detections.size > 0;
    }

    private int isExpected(long found) {
        for (int i = 0; i < this.numbers.length; ++i) {
            if (this.numbers[i] != found) continue;
            return i;
        }
        return -1;
    }

    private Detection lookupDetection(long found, int gridIndex) {
        for (int i = 0; i < this.detections.size(); ++i) {
            Detection d = (Detection)this.detections.get(i);
            if (d.id != found) continue;
            return d;
        }
        Detection d = (Detection)this.detections.grow();
        d.reset();
        d.id = found;
        d.gridIndex = gridIndex;
        return d;
    }

    public List<Detection> getDetections() {
        return this.detections.toList();
    }

    public BaseDetectFiducialSquare<T> getDetector() {
        return this.detector;
    }

    public static class Detection {
        public int numDetected;
        public Quadrilateral_F64 location = new Quadrilateral_F64();
        public long id;
        public int gridIndex;

        public void reset() {
            this.numDetected = 0;
            this.id = -1L;
            this.gridIndex = -1;
            this.location.a.set(0.0, 0.0);
            this.location.b.set(0.0, 0.0);
            this.location.c.set(0.0, 0.0);
            this.location.d.set(0.0, 0.0);
        }
    }
}

