/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoAsymmetricGrid;
import boofcv.alg.fiducial.calib.circle.EllipsesIntoClusters;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetector;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.EllipseRotated_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class DetectAsymmetricCircleGrid<T extends ImageGray> {
    private BinaryEllipseDetector<T> ellipseDetector;
    private InputToBinary<T> inputToBinary;
    private GrayU8 binary = new GrayU8(1, 1);
    private int numRows;
    private int numCols;
    private EllipsesIntoClusters clustering;
    private EllipseClustersIntoAsymmetricGrid grider;
    private List<EllipseClustersIntoAsymmetricGrid.Grid> validGrids = new ArrayList<EllipseClustersIntoAsymmetricGrid.Grid>();
    private List<EllipseRotated_F64> work = new ArrayList<EllipseRotated_F64>();
    private List<List<EllipsesIntoClusters.Node>> clusters = new ArrayList<List<EllipsesIntoClusters.Node>>();
    private List<List<EllipsesIntoClusters.Node>> clustersPruned = new ArrayList<List<EllipsesIntoClusters.Node>>();
    private boolean verbose = false;

    public DetectAsymmetricCircleGrid(int numRows, int numCols, InputToBinary<T> inputToBinary, BinaryEllipseDetector<T> ellipseDetector, EllipsesIntoClusters clustering) {
        this.ellipseDetector = ellipseDetector;
        this.inputToBinary = inputToBinary;
        this.numRows = numRows;
        this.numCols = numCols;
        this.clustering = clustering;
        this.grider = new EllipseClustersIntoAsymmetricGrid();
    }

    public void process(T gray) {
        if (this.verbose) {
            System.out.println("ENTER DetectAsymmetricCircleGrid.process()");
        }
        this.binary.reshape(((ImageGray)gray).width, ((ImageGray)gray).height);
        this.inputToBinary.process(gray, (ImageBase)this.binary);
        this.ellipseDetector.process(gray, this.binary);
        List found = this.ellipseDetector.getFoundEllipses().toList();
        if (this.verbose) {
            System.out.println("  Found " + found.size() + " ellpises");
        }
        this.clusters.clear();
        this.clustering.process(found, this.clusters);
        this.clustersPruned.clear();
        this.clustersPruned.addAll(this.clusters);
        if (this.verbose) {
            System.out.println("  Found " + this.clusters.size() + " clusters");
        }
        DetectAsymmetricCircleGrid.pruneIncorrectSize(this.clustersPruned, DetectAsymmetricCircleGrid.totalEllipses(this.numRows, this.numCols));
        if (this.verbose) {
            System.out.println("  Remaining clusters after pruning " + this.clustersPruned.size());
        }
        this.grider.process(found, this.clustersPruned);
        FastQueue<EllipseClustersIntoAsymmetricGrid.Grid> grids = this.grider.getGrids();
        if (this.verbose) {
            System.out.println("  Found " + grids.size() + " grids");
        }
        DetectAsymmetricCircleGrid.pruneIncorrectShape(grids, this.numRows, this.numCols);
        if (this.verbose) {
            System.out.println("  Remaining grids after pruning " + grids.size());
        }
        this.validGrids.clear();
        for (int i = 0; i < grids.size(); ++i) {
            EllipseClustersIntoAsymmetricGrid.Grid g = (EllipseClustersIntoAsymmetricGrid.Grid)grids.get(i);
            this.putGridIntoCanonical(g);
            this.validGrids.add(g);
        }
        if (this.verbose) {
            System.out.println("EXIT DetectAsymmetricCircleGrid.process()");
        }
    }

    public static int totalEllipses(int numRows, int numCols) {
        return numRows / 2 * (numCols / 2) + (numRows + 1) / 2 * ((numCols + 1) / 2);
    }

    void putGridIntoCanonical(EllipseClustersIntoAsymmetricGrid.Grid g) {
        if (g.columns != this.numCols) {
            this.rotateGridCCW(g);
        }
        if (g.get(0, 0) == null) {
            this.reverse(g);
        }
        if (g.columns % 2 == 1 && g.rows % 2 == 1) {
            if (DetectAsymmetricCircleGrid.isClockWise(g)) {
                this.flipHorizontal(g);
            }
            int numRotationsCCW = DetectAsymmetricCircleGrid.closestCorner4(g);
            if (g.columns == g.rows) {
                for (int i = 0; i < numRotationsCCW; ++i) {
                    this.rotateGridCCW(g);
                }
            } else if (numRotationsCCW == 2) {
                this.rotateGridCCW(g);
                this.rotateGridCCW(g);
            }
        } else if (g.columns % 2 == 1) {
            if (DetectAsymmetricCircleGrid.isClockWise(g)) {
                this.flipHorizontal(g);
            }
        } else if (g.rows % 2 == 1 && DetectAsymmetricCircleGrid.isClockWise(g)) {
            this.flipVertical(g);
        }
    }

    private static boolean isClockWise(EllipseClustersIntoAsymmetricGrid.Grid g) {
        EllipseRotated_F64 v00 = g.get(0, 0);
        EllipseRotated_F64 v02 = g.columns < 3 ? g.get(1, 1) : g.get(0, 2);
        EllipseRotated_F64 v20 = g.rows < 3 ? g.get(1, 1) : g.get(2, 0);
        double a_x = v02.center.x - v00.center.x;
        double a_y = v02.center.y - v00.center.y;
        double b_x = v20.center.x - v00.center.x;
        double b_y = v20.center.y - v00.center.y;
        return a_x * b_y - a_y * b_x < 0.0;
    }

    static int closestCorner4(EllipseClustersIntoAsymmetricGrid.Grid g) {
        double bestDistance = g.get((int)0, (int)0).center.normSq();
        int bestIdx = 0;
        double d = g.get((int)0, (int)(g.columns - 1)).center.normSq();
        if (d < bestDistance) {
            bestDistance = d;
            bestIdx = 3;
        }
        if ((d = g.get((int)(g.rows - 1), (int)(g.columns - 1)).center.normSq()) < bestDistance) {
            bestDistance = d;
            bestIdx = 2;
        }
        if ((d = g.get((int)(g.rows - 1), (int)0).center.normSq()) < bestDistance) {
            bestIdx = 1;
        }
        return bestIdx;
    }

    void rotateGridCCW(EllipseClustersIntoAsymmetricGrid.Grid g) {
        this.work.clear();
        for (int i = 0; i < g.rows * g.columns; ++i) {
            this.work.add(null);
        }
        for (int row = 0; row < g.rows; ++row) {
            for (int col = 0; col < g.columns; ++col) {
                this.work.set(col * g.rows + row, g.get(g.rows - row - 1, col));
            }
        }
        g.ellipses.clear();
        g.ellipses.addAll(this.work);
        int tmp = g.columns;
        g.columns = g.rows;
        g.rows = tmp;
    }

    void reverse(EllipseClustersIntoAsymmetricGrid.Grid g) {
        this.work.clear();
        int N = g.rows * g.columns;
        for (int i = 0; i < N; ++i) {
            this.work.add(g.ellipses.get(N - i - 1));
        }
        g.ellipses.clear();
        g.ellipses.addAll(this.work);
    }

    void flipHorizontal(EllipseClustersIntoAsymmetricGrid.Grid g) {
        this.work.clear();
        for (int row = 0; row < g.rows; ++row) {
            for (int col = 0; col < g.columns; ++col) {
                this.work.add(g.get(row, g.columns - col - 1));
            }
        }
        g.ellipses.clear();
        g.ellipses.addAll(this.work);
    }

    void flipVertical(EllipseClustersIntoAsymmetricGrid.Grid g) {
        this.work.clear();
        for (int row = 0; row < g.rows; ++row) {
            for (int col = 0; col < g.columns; ++col) {
                this.work.add(g.get(g.rows - row - 1, col));
            }
        }
        g.ellipses.clear();
        g.ellipses.addAll(this.work);
    }

    static void pruneIncorrectShape(FastQueue<EllipseClustersIntoAsymmetricGrid.Grid> grids, int numRows, int numCols) {
        for (int i = grids.size() - 1; i >= 0; --i) {
            EllipseClustersIntoAsymmetricGrid.Grid g = (EllipseClustersIntoAsymmetricGrid.Grid)grids.get(i);
            if (g.rows == numRows && g.columns == numCols || g.rows == numCols && g.columns == numRows) continue;
            grids.remove(i);
        }
    }

    static void pruneIncorrectSize(List<List<EllipsesIntoClusters.Node>> clusters, int N) {
        for (int i = clusters.size() - 1; i >= 0; --i) {
            if (clusters.get(i).size() == N) continue;
            clusters.remove(i);
        }
    }

    public BinaryEllipseDetector<T> getEllipseDetector() {
        return this.ellipseDetector;
    }

    public EllipseClustersIntoAsymmetricGrid getGrider() {
        return this.grider;
    }

    public EllipsesIntoClusters getClustering() {
        return this.clustering;
    }

    public List<List<EllipsesIntoClusters.Node>> getClusters() {
        return this.clusters;
    }

    public List<List<EllipsesIntoClusters.Node>> getClustersPruned() {
        return this.clustersPruned;
    }

    public List<EllipseClustersIntoAsymmetricGrid.Grid> getGrids() {
        return this.validGrids;
    }

    public List<Point2D_F64> getCalibrationPoints() {
        return null;
    }

    public GrayU8 getBinary() {
        return this.binary;
    }

    public int getColumns() {
        return this.numCols;
    }

    public int getRows() {
        return this.numRows;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.ellipseDetector.setVerbose(verbose);
        this.grider.setVerbose(verbose);
        this.verbose = verbose;
    }
}

