/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import boofcv.alg.fiducial.calib.circle.DetectAsymmetricCircleGrid;
import boofcv.alg.fiducial.calib.circle.EllipsesIntoClusters;
import georegression.metric.Intersection2D_F64;
import georegression.metric.UtilAngle;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.EllipseRotated_F64;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.ddogleg.sorting.QuickSortComparator;
import org.ddogleg.struct.FastQueue;

public class EllipseClustersIntoAsymmetricGrid {
    private FastQueue<Grid> foundGrids = new FastQueue(Grid.class, true);
    private static double MAX_LINE_ANGLE_CHANGE = UtilAngle.degreeToRadian((float)10.0f);
    FastQueue<NodeInfo> listInfo = new FastQueue(NodeInfo.class, true);
    private QuickSortComparator<Edge> sorter;
    FastQueue<NodeInfo> contour = new FastQueue(NodeInfo.class, false);
    private LineSegment2D_F64 line0110 = new LineSegment2D_F64();
    private LineSegment2D_F64 line0011 = new LineSegment2D_F64();
    private Point2D_F64 intersection = new Point2D_F64();
    private boolean verbose = false;

    public EllipseClustersIntoAsymmetricGrid() {
        this.sorter = new QuickSortComparator((Comparator)new Comparator<Edge>(){

            @Override
            public int compare(Edge o1, Edge o2) {
                if (o1.angle < o2.angle) {
                    return -1;
                }
                if (o1.angle > o2.angle) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void process(List<EllipseRotated_F64> ellipses, List<List<EllipsesIntoClusters.Node>> clusters) {
        this.foundGrids.reset();
        for (int i = 0; i < clusters.size(); ++i) {
            List<EllipsesIntoClusters.Node> cluster = clusters.get(i);
            int clusterSize = cluster.size();
            this.computeNodeInfo(ellipses, cluster);
            if (!this.findContour()) {
                if (!this.verbose) continue;
                System.out.println("Contour find failed");
                continue;
            }
            NodeInfo corner = this.selectSeedCorner();
            List<NodeInfo> cornerRow = EllipseClustersIntoAsymmetricGrid.findLine(corner, corner.left, clusterSize);
            List<NodeInfo> cornerColumn = EllipseClustersIntoAsymmetricGrid.findLine(corner, corner.right, clusterSize);
            ArrayList<List<NodeInfo>> outerGrid = new ArrayList<List<NodeInfo>>();
            outerGrid.add(cornerRow);
            boolean failed = false;
            for (int j = 1; j < cornerColumn.size(); ++j) {
                List prev = (List)outerGrid.get(j - 1);
                NodeInfo seed = cornerColumn.get(j);
                NodeInfo next = EllipseClustersIntoAsymmetricGrid.selectSeedNext((NodeInfo)prev.get(0), (NodeInfo)prev.get(1), seed);
                if (next == null) {
                    if (this.verbose) {
                        System.out.println("Outer column with a row that has only one element");
                    }
                    failed = true;
                    break;
                }
                List<NodeInfo> row = EllipseClustersIntoAsymmetricGrid.findLine(seed, next, clusterSize);
                outerGrid.add(row);
            }
            if (failed) continue;
            List<List<NodeInfo>> innerGrid = this.findInnerGrid(outerGrid, clusterSize);
            if (innerGrid == null) {
                if (!this.verbose) continue;
                System.out.println("Inner grid find failed");
                continue;
            }
            if (!EllipseClustersIntoAsymmetricGrid.checkGridSize(outerGrid, innerGrid, cluster.size())) {
                int j;
                if (!this.verbose) continue;
                System.out.println("grid size check failed");
                for (j = 0; j < outerGrid.size(); ++j) {
                    System.out.println("  outer row " + ((List)outerGrid.get(j)).size());
                }
                for (j = 0; j < innerGrid.size(); ++j) {
                    System.out.println("  inner row " + innerGrid.get(j).size());
                }
                continue;
            }
            if (this.checkDuplicates(outerGrid) || this.checkDuplicates(innerGrid)) {
                if (!this.verbose) continue;
                System.out.println("contains duplicates");
                continue;
            }
            this.combineGrids(outerGrid, innerGrid);
        }
    }

    static boolean checkGridSize(List<List<NodeInfo>> outerGrid, List<List<NodeInfo>> innerGrid, int clusterSize) {
        int i;
        int total = 0;
        int expected = outerGrid.get(0).size();
        for (i = 0; i < outerGrid.size(); ++i) {
            if (expected != outerGrid.get(i).size()) {
                return false;
            }
            total += outerGrid.get(i).size();
        }
        expected = innerGrid.get(0).size();
        for (i = 0; i < innerGrid.size(); ++i) {
            if (expected != innerGrid.get(i).size()) {
                return false;
            }
            total += innerGrid.get(i).size();
        }
        return total == clusterSize;
    }

    boolean checkDuplicates(List<List<NodeInfo>> grid) {
        for (int i = 0; i < grid.size(); ++i) {
            List<NodeInfo> list = grid.get(i);
            for (int j = 0; j < list.size(); ++j) {
                NodeInfo n = list.get(j);
                if (n.marked) {
                    return true;
                }
                n.marked = true;
            }
        }
        return false;
    }

    void combineGrids(List<List<NodeInfo>> outerGrid, List<List<NodeInfo>> innerGrid) {
        Grid g = (Grid)this.foundGrids.grow();
        g.reset();
        g.columns = outerGrid.get(0).size() + innerGrid.get(0).size();
        g.rows = outerGrid.size() + innerGrid.size();
        for (int row = 0; row < g.rows; ++row) {
            List<NodeInfo> list = row % 2 == 0 ? outerGrid.get(row / 2) : innerGrid.get(row / 2);
            for (int i = 0; i < g.columns; ++i) {
                if (i % 2 == row % 2) {
                    g.ellipses.add(list.get((int)(i / 2)).ellipse);
                    continue;
                }
                g.ellipses.add(null);
            }
        }
    }

    List<List<NodeInfo>> findInnerGrid(List<List<NodeInfo>> outerGrid, int clusterSize) {
        NodeInfo c11;
        NodeInfo c10;
        NodeInfo c01;
        NodeInfo c00 = outerGrid.get(0).get(0);
        NodeInfo corner = this.selectInnerSeed(c00, c01 = outerGrid.get(0).get(1), c10 = outerGrid.get(1).get(0), c11 = outerGrid.get(1).get(1));
        if (corner == null) {
            if (this.verbose) {
                System.out.println("Can't select inner grid seed");
            }
            return null;
        }
        NodeInfo rowNext = EllipseClustersIntoAsymmetricGrid.selectSeedNext(c00, c01, corner);
        NodeInfo colNext = EllipseClustersIntoAsymmetricGrid.selectSeedNext(c00, c10, corner);
        List<NodeInfo> row = EllipseClustersIntoAsymmetricGrid.findLine(corner, rowNext, clusterSize);
        List<NodeInfo> column = EllipseClustersIntoAsymmetricGrid.findLine(corner, colNext, clusterSize);
        ArrayList<List<NodeInfo>> grid = new ArrayList<List<NodeInfo>>();
        if (row != null && column != null) {
            grid.add(row);
            for (int i = 1; i < column.size(); ++i) {
                NodeInfo next;
                List prev = (List)grid.get(i - 1);
                NodeInfo seed = column.get(i);
                row = EllipseClustersIntoAsymmetricGrid.findLine(seed, next = EllipseClustersIntoAsymmetricGrid.selectSeedNext((NodeInfo)prev.get(0), (NodeInfo)prev.get(1), seed), clusterSize);
                if (row == null) {
                    if (this.verbose) {
                        System.out.println("Inner grid missing a row");
                    }
                    return null;
                }
                grid.add(row);
            }
        } else if (row != null) {
            grid.add(row);
        } else if (column != null) {
            for (int i = 0; i < column.size(); ++i) {
                ArrayList<NodeInfo> l = new ArrayList<NodeInfo>();
                l.add(column.get(i));
                grid.add(l);
            }
        } else {
            row = new ArrayList<NodeInfo>();
            row.add(corner);
            grid.add(row);
        }
        return grid;
    }

    protected static NodeInfo selectSeedNext(NodeInfo prevSeed, NodeInfo prevNext, NodeInfo currentSeed) {
        double angleTarget = EllipseClustersIntoAsymmetricGrid.direction(prevSeed, prevNext);
        double bestScore = Double.MAX_VALUE;
        NodeInfo best = null;
        Point2D_F64 c = currentSeed.ellipse.center;
        for (int i = 0; i < currentSeed.edges.size(); ++i) {
            double score;
            Edge edge = (Edge)currentSeed.edges.get(i);
            double angleDiff = UtilAngle.dist((double)edge.angle, (double)angleTarget);
            if (angleDiff > MAX_LINE_ANGLE_CHANGE * 1.5 || !((score = (angleDiff + 0.001) * c.distance((GeoTuple2D_F64)edge.target.ellipse.center)) < bestScore)) continue;
            bestScore = score;
            best = edge.target;
        }
        return best;
    }

    protected NodeInfo selectInnerSeed(NodeInfo c00, NodeInfo c01, NodeInfo c10, NodeInfo c11) {
        NodeInfo b;
        this.line0110.a.set(c01.ellipse.center);
        this.line0110.b.set(c10.ellipse.center);
        this.line0011.a.set(c00.ellipse.center);
        this.line0011.b.set(c11.ellipse.center);
        if (null == Intersection2D_F64.intersection((LineSegment2D_F64)this.line0110, (LineSegment2D_F64)this.line0011, (Point2D_F64)this.intersection)) {
            return null;
        }
        NodeInfo a = EllipseClustersIntoAsymmetricGrid.findClosestEdge(c00, this.intersection);
        if (a == (b = EllipseClustersIntoAsymmetricGrid.findClosestEdge(c11, this.intersection))) {
            return a;
        }
        return null;
    }

    protected static NodeInfo findClosestEdge(NodeInfo n, Point2D_F64 p) {
        double bestDistance = Double.MAX_VALUE;
        NodeInfo best = null;
        for (int i = 0; i < n.edges.size(); ++i) {
            Edge e = (Edge)n.edges.get(i);
            double d = e.target.ellipse.center.distance2((GeoTuple2D_F64)p);
            if (!(d < bestDistance)) continue;
            bestDistance = d;
            best = e.target;
        }
        return best;
    }

    protected static List<NodeInfo> findLine(NodeInfo seed, NodeInfo next, int clusterSize) {
        if (next == null) {
            return null;
        }
        double anglePrev = EllipseClustersIntoAsymmetricGrid.direction(seed, next);
        ArrayList<NodeInfo> line = new ArrayList<NodeInfo>();
        line.add(seed);
        line.add(next);
        for (int i = 0; i < clusterSize + 1; ++i) {
            double bestScore = Double.MAX_VALUE;
            double bestDistance = Double.MAX_VALUE;
            double bestAngle = Double.NaN;
            double closestDistance = Double.MAX_VALUE;
            NodeInfo best = null;
            for (int j = 0; j < next.edges.size(); ++j) {
                double angle = ((Edge)next.edges.get((int)j)).angle;
                NodeInfo c = ((Edge)next.edges.get((int)j)).target;
                double diff = UtilAngle.dist((double)angle, (double)anglePrev);
                if (!(diff <= MAX_LINE_ANGLE_CHANGE)) continue;
                double d = c.ellipse.center.distance((GeoTuple2D_F64)next.ellipse.center);
                double score = (diff + 0.01) * d;
                if (score < bestScore) {
                    bestDistance = d;
                    bestScore = score;
                    bestAngle = angle;
                    best = c;
                }
                closestDistance = Math.min(d, closestDistance);
            }
            if (best == null || bestDistance > closestDistance * 2.0) {
                return line;
            }
            line.add(best);
            anglePrev = bestAngle;
            next = best;
        }
        throw new RuntimeException("Stuck in a loop?  Maximum line length exceeded");
    }

    private static double direction(NodeInfo seed, NodeInfo next) {
        return Math.atan2(next.ellipse.center.y - seed.ellipse.center.y, next.ellipse.center.x - seed.ellipse.center.x);
    }

    void computeNodeInfo(List<EllipseRotated_F64> ellipses, List<EllipsesIntoClusters.Node> cluster) {
        this.listInfo.reset();
        for (int i = 0; i < cluster.size(); ++i) {
            EllipsesIntoClusters.Node n = cluster.get(i);
            EllipseRotated_F64 t = ellipses.get(n.which);
            NodeInfo info = (NodeInfo)this.listInfo.grow();
            info.reset();
            info.ellipse = t;
        }
        this.addEdgesToInfo(cluster);
        this.pruneNearlyIdenticalAngles();
        this.findLargestAnglesForAllNodes();
    }

    void addEdgesToInfo(List<EllipsesIntoClusters.Node> cluster) {
        for (int i = 0; i < cluster.size(); ++i) {
            EllipsesIntoClusters.Node n = cluster.get(i);
            NodeInfo infoA = (NodeInfo)this.listInfo.get(i);
            EllipseRotated_F64 a = infoA.ellipse;
            for (int j = 0; j < n.connections.size(); ++j) {
                NodeInfo infoB = (NodeInfo)this.listInfo.get(EllipseClustersIntoAsymmetricGrid.indexOf(cluster, n.connections.get(j)));
                EllipseRotated_F64 b = infoB.ellipse;
                Edge edge = (Edge)infoA.edges.grow();
                edge.target = infoB;
                edge.angle = Math.atan2(b.center.y - a.center.y, b.center.x - a.center.x);
            }
            this.sorter.sort(infoA.edges.data, infoA.edges.size);
        }
    }

    void pruneNearlyIdenticalAngles() {
        for (int i = 0; i < this.listInfo.size(); ++i) {
            NodeInfo infoN = (NodeInfo)this.listInfo.get(i);
            int j = 0;
            while (j < infoN.edges.size()) {
                int k = (j + 1) % infoN.edges.size;
                double angularDiff = UtilAngle.dist((double)((Edge)infoN.edges.get((int)j)).angle, (double)((Edge)infoN.edges.get((int)k)).angle);
                if (angularDiff < (double)UtilAngle.radian((float)5.0f)) {
                    double distK;
                    NodeInfo infoJ = ((Edge)infoN.edges.get((int)j)).target;
                    NodeInfo infoK = ((Edge)infoN.edges.get((int)k)).target;
                    double distJ = infoN.ellipse.center.distance((GeoTuple2D_F64)infoJ.ellipse.center);
                    if (distJ < (distK = infoN.ellipse.center.distance((GeoTuple2D_F64)infoK.ellipse.center))) {
                        infoN.edges.remove(k);
                        continue;
                    }
                    infoN.edges.remove(j);
                    continue;
                }
                ++j;
            }
        }
    }

    void findLargestAnglesForAllNodes() {
        for (int i = 0; i < this.listInfo.size(); ++i) {
            NodeInfo info = (NodeInfo)this.listInfo.get(i);
            if (info.edges.size < 2) continue;
            int k = 0;
            int j = info.edges.size - 1;
            while (k < info.edges.size) {
                double angleA = ((Edge)info.edges.get((int)j)).angle;
                double angleB = ((Edge)info.edges.get((int)k)).angle;
                double distance = UtilAngle.distanceCCW((double)angleA, (double)angleB);
                if (distance > info.angleBetween) {
                    info.angleBetween = distance;
                    info.left = ((Edge)info.edges.get((int)j)).target;
                    info.right = ((Edge)info.edges.get((int)k)).target;
                }
                j = k++;
            }
        }
    }

    boolean findContour() {
        NodeInfo seed = (NodeInfo)this.listInfo.get(0);
        for (int i = 1; i < this.listInfo.size(); ++i) {
            NodeInfo info = (NodeInfo)this.listInfo.get(i);
            if (!(info.angleBetween > seed.angleBetween)) continue;
            seed = info;
        }
        this.contour.reset();
        this.contour.add((Object)seed);
        seed.contour = true;
        NodeInfo prev = seed;
        NodeInfo current = seed.right;
        while (current != null && current != seed && this.contour.size() < this.listInfo.size()) {
            if (prev != current.left) {
                return false;
            }
            this.contour.add((Object)current);
            current.contour = true;
            prev = current;
            current = current.right;
        }
        return this.contour.size >= 4 && this.contour.size < this.listInfo.size();
    }

    public static int indexOf(List<EllipsesIntoClusters.Node> list, int value) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).which != value) continue;
            return i;
        }
        return -1;
    }

    NodeInfo selectSeedCorner() {
        NodeInfo best = null;
        double bestError = Double.MAX_VALUE;
        for (int i = 0; i < this.contour.size; ++i) {
            NodeInfo info = (NodeInfo)this.contour.get(i);
            double error = UtilAngle.dist((double)4.71238898038469, (double)info.angleBetween);
            if (!(error < bestError)) continue;
            bestError = error;
            best = info;
        }
        return best;
    }

    public FastQueue<Grid> getGrids() {
        return this.foundGrids;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static class Grid {
        public List<EllipseRotated_F64> ellipses = new ArrayList<EllipseRotated_F64>();
        public int rows;
        public int columns;

        public void reset() {
            this.columns = -1;
            this.rows = -1;
            this.ellipses.clear();
        }

        public EllipseRotated_F64 get(int row, int col) {
            return this.ellipses.get(row * this.columns + col);
        }

        public int idx(int row, int col) {
            return row * this.columns + col;
        }

        public void setShape(int rows, int columns) {
            this.rows = rows;
            this.columns = columns;
        }

        public int getNumberOfEllipses() {
            return DetectAsymmetricCircleGrid.totalEllipses(this.rows, this.columns);
        }

        public int getIndexOfEllipse(int row, int col) {
            int index = 0;
            return (index += row / 2 * this.columns + row % 2 * (this.columns / 2 + this.columns % 2)) + col / 2;
        }
    }

    public static class Edge {
        NodeInfo target;
        double angle;
    }

    public static class NodeInfo {
        EllipseRotated_F64 ellipse;
        FastQueue<Edge> edges = new FastQueue(Edge.class, true);
        boolean contour;
        NodeInfo left;
        NodeInfo right;
        double angleBetween;
        boolean marked;

        public void reset() {
            this.contour = false;
            this.ellipse = null;
            this.right = null;
            this.left = null;
            this.angleBetween = 0.0;
            this.marked = false;
            this.edges.reset();
        }
    }
}

