/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.square;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.geo.RefineEpipolar;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.PixelTransformCached_F32;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.PointTransformHomography_F32;
import boofcv.alg.fiducial.square.FoundFiducial;
import boofcv.alg.geo.h.HomographyLinear4;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.shapes.polygon.BinaryPolygonDetector;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.geo.EpipolarError;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.distort.DoNothing2Transform2_F64;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.distort.SequencePoint2Transform2_F32;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.homography.Homography2D_F32;
import georegression.struct.homography.UtilHomography;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DenseMatrix64F;

public abstract class BaseDetectFiducialSquare<T extends ImageGray> {
    private FastQueue<FoundFiducial> found = new FastQueue(FoundFiducial.class, true);
    InputToBinary<T> inputToBinary;
    private BinaryPolygonDetector<T> squareDetector;
    GrayF32 square;
    GrayU8 binary = new GrayU8(1, 1);
    private HomographyLinear4 computeHomography = new HomographyLinear4(true);
    private RefineEpipolar refineHomography = FactoryMultiView.refineHomography((double)1.0E-4, (int)100, (EpipolarError)EpipolarError.SAMPSON);
    private DenseMatrix64F H = new DenseMatrix64F(3, 3);
    private DenseMatrix64F H_refined = new DenseMatrix64F(3, 3);
    private List<AssociatedPair> pairsRemovePerspective = new ArrayList<AssociatedPair>();
    private ImageDistort<T, GrayF32> removePerspective;
    private PointTransformHomography_F32 transformHomography = new PointTransformHomography_F32();
    private Point2Transform2_F64 undistToDist = new DoNothing2Transform2_F64();
    protected double borderWidthFraction;
    private double minimumBorderBlackFraction;
    private Result result = new Result();
    private Class<T> inputType;
    protected boolean verbose = false;
    private Polygon2D_F64 interpolationHack = new Polygon2D_F64(4);
    private Quadrilateral_F64 q = new Quadrilateral_F64();

    protected BaseDetectFiducialSquare(InputToBinary<T> inputToBinary, BinaryPolygonDetector<T> squareDetector, double borderWidthFraction, double minimumBorderBlackFraction, int squarePixels, Class<T> inputType) {
        if (squareDetector.getMinimumSides() != 4 || squareDetector.getMaximumSides() != 4) {
            throw new IllegalArgumentException("quadDetector not configured to detect quadrilaterals");
        }
        if (squareDetector.isOutputClockwise()) {
            throw new IllegalArgumentException("output polygons needs to be counter-clockwise");
        }
        if (borderWidthFraction <= 0.0 || borderWidthFraction >= 0.5) {
            throw new RuntimeException("Border width fraction must be 0 < x < 0.5");
        }
        this.borderWidthFraction = borderWidthFraction;
        this.minimumBorderBlackFraction = minimumBorderBlackFraction;
        this.inputToBinary = inputToBinary;
        this.squareDetector = squareDetector;
        this.inputType = inputType;
        this.square = new GrayF32(squarePixels, squarePixels);
        for (int i = 0; i < 4; ++i) {
            this.pairsRemovePerspective.add(new AssociatedPair());
        }
        InterpolatePixelS interp = FactoryInterpolation.nearestNeighborPixelS(inputType);
        interp.setBorder(FactoryImageBorder.single(inputType, (BorderType)BorderType.EXTENDED));
        this.removePerspective = FactoryDistort.distortSB((boolean)false, (InterpolatePixelS)interp, GrayF32.class);
        this.removePerspective.setModel((PixelTransform2_F32)new PointToPixelTransform_F32((Point2Transform2_F32)this.transformHomography));
    }

    public void configure(LensDistortionNarrowFOV distortion, int width, int height, boolean cache) {
        Point2Transform2_F32 pointDistToUndist = distortion.undistort_F32(true, true);
        Point2Transform2_F32 pointUndistToDist = distortion.distort_F32(true, true);
        PointToPixelTransform_F32 distToUndist = new PointToPixelTransform_F32(pointDistToUndist);
        PointToPixelTransform_F32 undistToDist = new PointToPixelTransform_F32(pointUndistToDist);
        if (cache) {
            distToUndist = new PixelTransformCached_F32(width, height, (PixelTransform2_F32)distToUndist);
            undistToDist = new PixelTransformCached_F32(width, height, (PixelTransform2_F32)undistToDist);
        }
        this.squareDetector.setLensDistortion(width, height, (PixelTransform2_F32)distToUndist, (PixelTransform2_F32)undistToDist);
        SequencePoint2Transform2_F32 pointSquareToInput = new SequencePoint2Transform2_F32(new Point2Transform2_F32[]{this.transformHomography, pointUndistToDist});
        PointToPixelTransform_F32 squareToInput = new PointToPixelTransform_F32((Point2Transform2_F32)pointSquareToInput);
        this.removePerspective.setModel((PixelTransform2_F32)squareToInput);
        this.undistToDist = distortion.distort_F64(true, true);
    }

    public void process(T gray) {
        this.binary.reshape(((ImageGray)gray).width, ((ImageGray)gray).height);
        this.inputToBinary.process(gray, (ImageBase)this.binary);
        this.squareDetector.process(gray, this.binary);
        FastQueue candidates = this.squareDetector.getFoundPolygons();
        this.found.reset();
        if (this.verbose) {
            System.out.println("---------- Got Polygons! " + candidates.size);
        }
        for (int i = 0; i < candidates.size; ++i) {
            double pixelThreshold;
            double foundFraction;
            Polygon2D_F64 p = (Polygon2D_F64)candidates.get(i);
            double best = Double.MAX_VALUE;
            for (int j = 0; j < 4; ++j) {
                double found = p.get(0).normSq();
                if (found < best) {
                    best = found;
                    this.interpolationHack.set(p);
                }
                UtilPolygons2D_F64.shiftDown((Polygon2D_F64)p);
            }
            UtilPolygons2D_F64.convert((Polygon2D_F64)this.interpolationHack, (Quadrilateral_F64)this.q);
            this.pairsRemovePerspective.get(0).set(0.0, 0.0, this.q.a.x, this.q.a.y);
            this.pairsRemovePerspective.get(1).set((double)this.square.width, 0.0, this.q.b.x, this.q.b.y);
            this.pairsRemovePerspective.get(2).set((double)this.square.width, (double)this.square.height, this.q.c.x, this.q.c.y);
            this.pairsRemovePerspective.get(3).set(0.0, (double)this.square.height, this.q.d.x, this.q.d.y);
            if (!this.computeHomography.process(this.pairsRemovePerspective, this.H)) {
                if (!this.verbose) continue;
                System.out.println("rejected initial homography");
                continue;
            }
            if (!this.refineHomography.fitModel(this.pairsRemovePerspective, (Object)this.H, (Object)this.H_refined)) {
                if (!this.verbose) continue;
                System.out.println("rejected refine homography");
                continue;
            }
            UtilHomography.convert((DenseMatrix64F)this.H_refined, (Homography2D_F32)this.transformHomography.getModel());
            this.removePerspective.apply(gray, (ImageBase)this.square);
            BinaryPolygonDetector.Info info = (BinaryPolygonDetector.Info)this.squareDetector.getPolygonInfo().get(i);
            if (this.minimumBorderBlackFraction > 0.0 && (foundFraction = this.computeFractionBoundary((float)(pixelThreshold = (info.edgeInside + info.edgeOutside) / 2.0))) < this.minimumBorderBlackFraction) {
                if (!this.verbose) continue;
                System.out.println("rejected black border fraction " + foundFraction);
                continue;
            }
            if (this.processSquare(this.square, this.result, info.edgeInside, info.edgeOutside)) {
                this.prepareForOutput(this.q, this.result);
                if (!this.verbose) continue;
                System.out.println("accepted!");
                continue;
            }
            if (!this.verbose) continue;
            System.out.println("rejected process square");
        }
    }

    protected double computeFractionBoundary(float pixelThreshold) {
        int x;
        int y;
        int w = this.square.width;
        int radius = (int)((double)w * this.borderWidthFraction);
        int innerWidth = w - 2 * radius;
        int total = w * w - innerWidth * innerWidth;
        int count = 0;
        for (y = 0; y < radius; ++y) {
            int indexTop = y * w;
            int indexBottom = (w - radius + y) * w;
            for (x = 0; x < w; ++x) {
                int n = indexTop++;
                if (this.square.data[n] < pixelThreshold) {
                    ++count;
                }
                int n2 = indexBottom++;
                if (!(this.square.data[n2] < pixelThreshold)) continue;
                ++count;
            }
        }
        for (y = radius; y < w - radius; ++y) {
            int indexLeft = y * w;
            int indexRight = y * w + w - radius;
            for (x = 0; x < radius; ++x) {
                int n = indexLeft++;
                if (this.square.data[n] < pixelThreshold) {
                    ++count;
                }
                int n3 = indexRight++;
                if (!(this.square.data[n3] < pixelThreshold)) continue;
                ++count;
            }
        }
        return (double)count / (double)total;
    }

    private void prepareForOutput(Quadrilateral_F64 imageShape, Result result) {
        int rotationCCW = (4 - result.rotation) % 4;
        for (int j = 0; j < rotationCCW; ++j) {
            this.rotateCounterClockwise(imageShape);
        }
        FoundFiducial f = (FoundFiducial)this.found.grow();
        f.id = result.which;
        this.undistToDist.compute(imageShape.a.x, imageShape.a.y, f.distortedPixels.a);
        this.undistToDist.compute(imageShape.b.x, imageShape.b.y, f.distortedPixels.b);
        this.undistToDist.compute(imageShape.c.x, imageShape.c.y, f.distortedPixels.c);
        this.undistToDist.compute(imageShape.d.x, imageShape.d.y, f.distortedPixels.d);
    }

    private void rotateCounterClockwise(Quadrilateral_F64 quad) {
        Point2D_F64 a = quad.a;
        Point2D_F64 b = quad.b;
        Point2D_F64 c = quad.c;
        Point2D_F64 d = quad.d;
        quad.a = b;
        quad.b = c;
        quad.c = d;
        quad.d = a;
    }

    public FastQueue<FoundFiducial> getFound() {
        return this.found;
    }

    protected abstract boolean processSquare(GrayF32 var1, Result var2, double var3, double var5);

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public BinaryPolygonDetector getSquareDetector() {
        return this.squareDetector;
    }

    public GrayU8 getBinary() {
        return this.binary;
    }

    public Class<T> getInputType() {
        return this.inputType;
    }

    public double getBorderWidthFraction() {
        return this.borderWidthFraction;
    }

    public static class Result {
        int which;
        double lengthSide;
        int rotation;
    }
}

