/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.square;

import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.EstimateNofPnP;
import boofcv.abst.geo.RefinePnP;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.factory.geo.EnumPNP;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.Point2D3D;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.D1Matrix64F;

public class QuadPoseEstimator {
    public static final double SMALL_PIXELS = 60.0;
    public static final double FUDGE_FACTOR = 0.5;
    private EstimateNofPnP p3p;
    private RefinePnP refine;
    private Estimate1ofPnP epnp = FactoryMultiView.computePnP_1((EnumPNP)EnumPNP.EPNP, (int)50, (int)0);
    private Point2Transform2_F64 normToUndistorted;
    private Point2Transform2_F64 pixelToNorm;
    private Point2Transform2_F64 normToPixel;
    protected List<Point2D3D> points = new ArrayList<Point2D3D>();
    protected List<Point2D_F64> listObs = new ArrayList<Point2D_F64>();
    private List<Point2D3D> inputP3P = new ArrayList<Point2D3D>();
    private FastQueue<Se3_F64> solutions = new FastQueue(Se3_F64.class, true);
    private Se3_F64 outputFiducialToCamera = new Se3_F64();
    private Se3_F64 foundEPNP = new Se3_F64();
    private double outputError;
    private Point3D_F64 cameraP3 = new Point3D_F64();
    private Point2D_F64 predicted = new Point2D_F64();
    protected double bestError;
    protected Se3_F64 bestPose = new Se3_F64();
    CameraPinholeRadial intrinsicUndist = new CameraPinholeRadial();
    Quadrilateral_F64 pixelCorners = new Quadrilateral_F64();
    Quadrilateral_F64 enlargedCorners = new Quadrilateral_F64();
    Se3_F64 foundEnlarged = new Se3_F64();
    Se3_F64 foundRegular = new Se3_F64();
    Point2D_F64 center = new Point2D_F64();

    public QuadPoseEstimator(double refineTol, int refineIterations) {
        this(FactoryMultiView.computePnP_N((EnumPNP)EnumPNP.P3P_GRUNERT, (int)-1), FactoryMultiView.refinePnP((double)refineTol, (int)refineIterations));
    }

    public QuadPoseEstimator(EstimateNofPnP p3p, RefinePnP refine) {
        this.p3p = p3p;
        this.refine = refine;
        for (int i = 0; i < 4; ++i) {
            this.points.add(new Point2D3D());
        }
    }

    public void setLensDistoriton(LensDistortionNarrowFOV distortion) {
        this.pixelToNorm = distortion.undistort_F64(true, false);
        this.normToPixel = distortion.distort_F64(false, true);
    }

    public void setFiducial(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        this.points.get((int)0).location.set(x0, y0, 0.0);
        this.points.get((int)1).location.set(x1, y1, 0.0);
        this.points.get((int)2).location.set(x2, y2, 0.0);
        this.points.get((int)3).location.set(x3, y3, 0.0);
    }

    public boolean process(Quadrilateral_F64 corners) {
        this.normToPixel.compute(corners.a.x, corners.a.y, this.pixelCorners.a);
        this.normToPixel.compute(corners.b.x, corners.b.y, this.pixelCorners.b);
        this.normToPixel.compute(corners.c.x, corners.c.y, this.pixelCorners.c);
        this.normToPixel.compute(corners.d.x, corners.d.y, this.pixelCorners.d);
        double length0 = this.pixelCorners.getSideLength(0);
        double length1 = this.pixelCorners.getSideLength(1);
        double ratio = Math.max(length0, length1) / Math.min(length0, length1);
        boolean success = this.estimate(this.pixelCorners, this.outputFiducialToCamera);
        if (success) {
            this.outputError = this.computeErrors(this.outputFiducialToCamera);
        }
        return success;
    }

    private boolean estimatePathological(Se3_F64 outputFiducialToCamera) {
        this.enlargedCorners.set(this.pixelCorners);
        this.enlarge(this.enlargedCorners, 4.0);
        if (!this.estimate(this.enlargedCorners, this.foundEnlarged)) {
            return false;
        }
        if (!this.estimate(this.pixelCorners, this.foundRegular)) {
            return false;
        }
        double errorRegular = this.computeErrors(this.foundRegular);
        outputFiducialToCamera.getT().set(this.foundRegular.getT());
        outputFiducialToCamera.getR().set((D1Matrix64F)this.foundEnlarged.getR());
        double errorModified = this.computeErrors(outputFiducialToCamera);
        if (errorModified > errorRegular + 0.5) {
            outputFiducialToCamera.set(this.foundRegular);
        }
        return true;
    }

    protected boolean estimate(Quadrilateral_F64 corners, Se3_F64 foundFiducialToCamera) {
        double error;
        this.listObs.clear();
        this.listObs.add(corners.a);
        this.listObs.add(corners.b);
        this.listObs.add(corners.c);
        this.listObs.add(corners.d);
        this.pixelToNorm.compute(corners.a.x, corners.a.y, this.points.get((int)0).observation);
        this.pixelToNorm.compute(corners.b.x, corners.b.y, this.points.get((int)1).observation);
        this.pixelToNorm.compute(corners.c.x, corners.c.y, this.points.get((int)2).observation);
        this.pixelToNorm.compute(corners.d.x, corners.d.y, this.points.get((int)3).observation);
        this.bestError = Double.MAX_VALUE;
        this.estimateP3P(0);
        this.estimateP3P(1);
        this.estimateP3P(2);
        this.estimateP3P(3);
        if (this.bestError == Double.MAX_VALUE) {
            return false;
        }
        this.inputP3P.clear();
        for (int i = 0; i < 4; ++i) {
            this.inputP3P.add(this.points.get(i));
        }
        if (this.bestError > 2.0 && this.epnp.process(this.inputP3P, (Object)this.foundEPNP) && this.foundEPNP.T.z > 0.0 && (error = this.computeErrors(this.foundEPNP)) < this.bestError) {
            this.bestPose.set(this.foundEPNP);
        }
        if (!this.refine.fitModel(this.inputP3P, (Object)this.bestPose, (Object)foundFiducialToCamera)) {
            foundFiducialToCamera.set(this.bestPose);
            return true;
        }
        return true;
    }

    protected void estimateP3P(int excluded) {
        int i;
        this.inputP3P.clear();
        for (i = 0; i < 4; ++i) {
            if (i == excluded) continue;
            this.inputP3P.add(this.points.get(i));
        }
        this.solutions.reset();
        if (!this.p3p.process(this.inputP3P, this.solutions)) {
            System.out.println("Failed!?!");
            return;
        }
        for (i = 0; i < this.solutions.size; ++i) {
            double error = this.computeErrors((Se3_F64)this.solutions.get(i));
            if (!(error < this.bestError)) continue;
            this.bestError = error;
            this.bestPose.set((Se3_F64)this.solutions.get(i));
        }
    }

    protected void enlarge(Quadrilateral_F64 corners, double scale) {
        UtilPolygons2D_F64.center((Quadrilateral_F64)corners, (Point2D_F64)this.center);
        this.extend(this.center, corners.a, scale);
        this.extend(this.center, corners.b, scale);
        this.extend(this.center, corners.c, scale);
        this.extend(this.center, corners.d, scale);
    }

    protected void extend(Point2D_F64 pivot, Point2D_F64 corner, double scale) {
        corner.x = pivot.x + (corner.x - pivot.x) * scale;
        corner.y = pivot.y + (corner.y - pivot.y) * scale;
    }

    protected double computeErrors(Se3_F64 fiducialToCamera) {
        if (fiducialToCamera.T.z < 0.0) {
            return Double.MAX_VALUE;
        }
        double maxError = 0.0;
        for (int i = 0; i < 4; ++i) {
            maxError = Math.max(maxError, this.computePixelError(fiducialToCamera, this.points.get((int)i).location, this.listObs.get(i)));
        }
        return maxError;
    }

    private double computePixelError(Se3_F64 fiducialToCamera, Point3D_F64 X, Point2D_F64 pixel) {
        SePointOps_F64.transform((Se3_F64)fiducialToCamera, (Point3D_F64)X, (Point3D_F64)this.cameraP3);
        this.normToPixel.compute(this.cameraP3.x / this.cameraP3.z, this.cameraP3.y / this.cameraP3.z, this.predicted);
        return this.predicted.distance((GeoTuple2D_F64)pixel);
    }

    public Se3_F64 getWorldToCamera() {
        return this.outputFiducialToCamera;
    }

    public double getError() {
        return this.outputError;
    }

    public List<Point2D3D> createCopyPoints2D3D() {
        ArrayList<Point2D3D> out = new ArrayList<Point2D3D>();
        for (int i = 0; i < 4; ++i) {
            out.add(this.points.get(i).copy());
        }
        return out;
    }
}

