/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.distort.FDistort;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.se.Se3_F64;

public class StereoVisualOdometryScaleInput<T extends ImageBase>
implements StereoVisualOdometry<T> {
    double scaleFactor;
    StereoParameters scaleParameter;
    T scaleLeft;
    T scaleRight;
    StereoVisualOdometry<T> alg;

    public StereoVisualOdometryScaleInput(StereoVisualOdometry<T> alg, double scaleFactor) {
        this.alg = alg;
        this.scaleFactor = scaleFactor;
        this.scaleLeft = alg.getImageType().createImage(1, 1);
        this.scaleRight = alg.getImageType().createImage(1, 1);
    }

    @Override
    public void setCalibration(StereoParameters parameters) {
        this.scaleParameter = new StereoParameters(parameters);
        PerspectiveOps.scaleIntrinsic((CameraPinholeRadial)this.scaleParameter.left, (double)this.scaleFactor);
        PerspectiveOps.scaleIntrinsic((CameraPinholeRadial)this.scaleParameter.right, (double)this.scaleFactor);
        this.scaleLeft.reshape(this.scaleParameter.left.width, this.scaleParameter.left.height);
        this.scaleRight.reshape(this.scaleParameter.right.width, this.scaleParameter.right.height);
        this.alg.setCalibration(this.scaleParameter);
    }

    @Override
    public boolean process(T leftImage, T rightImage) {
        new FDistort(leftImage, this.scaleLeft).scaleExt().apply();
        new FDistort(rightImage, this.scaleRight).scaleExt().apply();
        return this.alg.process(this.scaleLeft, this.scaleRight);
    }

    @Override
    public ImageType<T> getImageType() {
        return this.alg.getImageType();
    }

    @Override
    public void reset() {
        this.alg.reset();
    }

    @Override
    public boolean isFault() {
        return this.alg.isFault();
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        return (Se3_F64)this.alg.getCameraToWorld();
    }
}

