/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.alg.feature.associate.AssociateStereo2D;
import boofcv.alg.geo.DistanceModelMonoPixels;
import boofcv.alg.geo.pose.PnPStereoDistanceReprojectionSq;
import boofcv.alg.geo.pose.PnPStereoEstimator;
import boofcv.alg.geo.pose.RefinePnPStereo;
import boofcv.alg.sfm.d3.VisOdomDualTrackPnP;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;

public class WrapVisOdomDualTrackPnP<T extends ImageGray>
implements StereoVisualOdometry<T>,
AccessPointTracks3D {
    RefinePnPStereo refine;
    PnPStereoEstimator pnp;
    DistanceModelMonoPixels<Se3_F64, Point2D3D> distanceMono;
    PnPStereoDistanceReprojectionSq distanceStereo;
    AssociateStereo2D<?> assoc;
    VisOdomDualTrackPnP<T, ?> alg;
    Class<T> imageType;
    boolean success;

    public WrapVisOdomDualTrackPnP(PnPStereoEstimator pnp, DistanceModelMonoPixels<Se3_F64, Point2D3D> distanceMono, PnPStereoDistanceReprojectionSq distanceStereo, AssociateStereo2D<?> assoc, VisOdomDualTrackPnP<T, ?> alg, RefinePnPStereo refine, Class<T> imageType) {
        this.pnp = pnp;
        this.distanceMono = distanceMono;
        this.distanceStereo = distanceStereo;
        this.assoc = assoc;
        this.alg = alg;
        this.refine = refine;
        this.imageType = imageType;
    }

    @Override
    public Point3D_F64 getTrackLocation(int index) {
        VisOdomDualTrackPnP.LeftTrackInfo info = (VisOdomDualTrackPnP.LeftTrackInfo)this.alg.getCandidates().get(index).getCookie();
        return info.location.location;
    }

    @Override
    public long getTrackId(int index) {
        return this.alg.getCandidates().get((int)index).featureId;
    }

    @Override
    public List<Point2D_F64> getAllTracks() {
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        for (PointTrack c : this.alg.getCandidates()) {
            ret.add((Point2D_F64)c);
        }
        return ret;
    }

    @Override
    public boolean isInlier(int index) {
        VisOdomDualTrackPnP.LeftTrackInfo info = (VisOdomDualTrackPnP.LeftTrackInfo)this.alg.getCandidates().get(index).getCookie();
        return info.lastInlier == this.alg.getTick();
    }

    @Override
    public boolean isNew(int index) {
        return false;
    }

    @Override
    public void setCalibration(StereoParameters parameters) {
        Se3_F64 leftToRight = parameters.getRightToLeft().invert(null);
        this.pnp.setLeftToRight(leftToRight);
        if (this.refine != null) {
            this.refine.setLeftToRight(leftToRight);
        }
        this.alg.setCalibration(parameters);
        CameraPinholeRadial left = parameters.left;
        this.distanceMono.setIntrinsic(left.fx, left.fy, left.skew);
        this.distanceStereo.setStereoParameters(parameters);
        this.assoc.setCalibration(parameters);
    }

    @Override
    public void reset() {
        this.alg.reset();
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        return this.alg.getCurrToWorld();
    }

    @Override
    public boolean process(T leftImage, T rightImage) {
        this.success = this.alg.process(leftImage, rightImage);
        return this.success;
    }

    @Override
    public boolean isFault() {
        if (!this.success) {
            return this.alg.isFault();
        }
        return false;
    }

    @Override
    public ImageType<T> getImageType() {
        return ImageType.single(this.imageType);
    }
}

