/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.NormalizedToPixelError;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;

public class PnPStereoDistanceReprojectionSq
implements DistanceFromModel<Se3_F64, Stereo2D3D> {
    private Se3_F64 worldToLeft;
    private Se3_F64 leftToRight;
    private Point3D_F64 X = new Point3D_F64();
    private NormalizedToPixelError leftPixelError;
    private NormalizedToPixelError rightPixelError;

    public void setStereoParameters(StereoParameters param) {
        this.leftToRight = param.getRightToLeft().invert(null);
        CameraPinholeRadial left = param.left;
        CameraPinholeRadial right = param.right;
        this.leftPixelError = new NormalizedToPixelError(left.fx, left.fy, left.skew);
        this.rightPixelError = new NormalizedToPixelError(right.fx, right.fy, right.skew);
    }

    public void setModel(Se3_F64 worldToLeft) {
        this.worldToLeft = worldToLeft;
    }

    public double computeDistance(Stereo2D3D pt) {
        SePointOps_F64.transform((Se3_F64)this.worldToLeft, (Point3D_F64)pt.location, (Point3D_F64)this.X);
        if (this.X.z <= 0.0) {
            return Double.MAX_VALUE;
        }
        Point2D_F64 p = pt.leftObs;
        double errorLeft = this.leftPixelError.errorSq(this.X.x / this.X.z, this.X.y / this.X.z, p.x, p.y);
        SePointOps_F64.transform((Se3_F64)this.leftToRight, (Point3D_F64)this.X, (Point3D_F64)this.X);
        if (this.X.z <= 0.0) {
            return Double.MAX_VALUE;
        }
        p = pt.rightObs;
        double errorRight = this.rightPixelError.errorSq(this.X.x / this.X.z, this.X.y / this.X.z, p.x, p.y);
        return errorLeft + errorRight;
    }

    public void computeDistance(List<Stereo2D3D> observations, double[] distance) {
        for (int i = 0; i < observations.size(); ++i) {
            distance[i] = this.computeDistance(observations.get(i));
        }
    }
}

