/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm;

import boofcv.alg.distort.radtan.RemoveRadialPtoN_F64;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;

public abstract class DepthSparse3D<T extends ImageGray> {
    protected T depthImage;
    private RemoveRadialPtoN_F64 p2n = new RemoveRadialPtoN_F64();
    private Point3D_F64 worldPt = new Point3D_F64();
    private Point2D_F64 norm = new Point2D_F64();
    private PixelTransform2_F32 visualToDepth;
    private double depthScale;

    public DepthSparse3D(double depthScale) {
        this.depthScale = depthScale;
    }

    public void configure(CameraPinholeRadial paramVisual, PixelTransform2_F32 visualToDepth) {
        this.visualToDepth = visualToDepth;
        this.p2n.setK(paramVisual.fx, paramVisual.fy, paramVisual.skew, paramVisual.cx, paramVisual.cy).setDistortion(paramVisual.radial, paramVisual.t1, paramVisual.t2);
    }

    public void setDepthImage(T depthImage) {
        this.depthImage = depthImage;
    }

    public boolean process(int x, int y) {
        this.visualToDepth.compute(x, y);
        int depthX = (int)this.visualToDepth.distX;
        int depthY = (int)this.visualToDepth.distY;
        if (this.depthImage.isInBounds(depthX, depthY)) {
            double value = this.lookupDepth(depthX, depthY);
            if (value == 0.0) {
                return false;
            }
            this.p2n.compute((double)x, (double)y, this.norm);
            this.worldPt.z = value * this.depthScale;
            this.worldPt.x = this.worldPt.z * this.norm.x;
            this.worldPt.y = this.worldPt.z * this.norm.y;
            return true;
        }
        return false;
    }

    public Point3D_F64 getWorldPt() {
        return this.worldPt;
    }

    protected abstract double lookupDepth(int var1, int var2);

    public static class F32
    extends DepthSparse3D<GrayF32> {
        public F32(double depthScale) {
            super(depthScale);
        }

        @Override
        protected double lookupDepth(int depthX, int depthY) {
            return ((GrayF32)this.depthImage).unsafe_get(depthX, depthY);
        }
    }

    public static class I<T extends GrayI>
    extends DepthSparse3D<T> {
        public I(double depthScale) {
            super(depthScale);
        }

        @Override
        protected double lookupDepth(int depthX, int depthY) {
            return ((GrayI)this.depthImage).unsafe_get(depthX, depthY);
        }
    }
}

