/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.gui.JavaRuntimeLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class ApplicationLauncherApp
extends JPanel
implements ActionListener {
    private JTree tree;
    JButton bKill = new JButton("Kill");
    JButton bKillAll = new JButton("Kill All");
    JList processList;
    DefaultListModel listModel = new DefaultListModel();
    int memoryMB = 1024;
    final List<ActiveProcess> processes = new ArrayList<ActiveProcess>();

    public ApplicationLauncherApp() {
        this.setLayout(new BorderLayout());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("All Categories");
        this.createTree(root);
        this.tree = new JTree(root);
        this.tree.getSelectionModel().setSelectionMode(1);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = ApplicationLauncherApp.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = ApplicationLauncherApp.this.tree.getPathForLocation(e.getX(), e.getY());
                if (e.getClickCount() == 2) {
                    ApplicationLauncherApp.this.handleClick((DefaultMutableTreeNode)ApplicationLauncherApp.this.tree.getLastSelectedPathComponent());
                }
            }
        };
        this.tree.addMouseListener(ml);
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setPreferredSize(new Dimension(300, 600));
        JPanel actionPanel = new JPanel();
        actionPanel.setLayout(new BoxLayout(actionPanel, 0));
        actionPanel.add(this.bKill);
        actionPanel.add(Box.createHorizontalGlue());
        actionPanel.add(this.bKillAll);
        this.bKill.addActionListener(this);
        this.bKillAll.addActionListener(this);
        this.processList = new JList(this.listModel);
        this.processList.setSelectionMode(1);
        this.processList.setLayoutOrientation(0);
        this.processList.setVisibleRowCount(-1);
        this.processList.setPreferredSize(new Dimension(500, 600));
        JPanel processPanel = new JPanel();
        processPanel.setLayout(new BoxLayout(processPanel, 1));
        processPanel.add(actionPanel);
        processPanel.add(this.processList);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.add(treeView);
        splitPane.add(processPanel);
        this.add((Component)splitPane, "Center");
        new ProcessStatusThread().start();
    }

    protected abstract void createTree(DefaultMutableTreeNode var1);

    protected void createNodes(DefaultMutableTreeNode root, String subjectName, Class ... apps) {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(subjectName);
        for (int i = 0; i < apps.length; ++i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new AppInfo(apps[i]));
            top.add(node);
        }
        root.add(top);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launch(AppInfo info) {
        URL[] urls;
        ArrayList<String> classPath = new ArrayList<String>();
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
            classPath.add(url.getFile());
        }
        final ActiveProcess process = new ActiveProcess();
        process.info = info;
        process.launcher = new JavaRuntimeLauncher(classPath);
        process.launcher.setFrozenTime(-1L);
        process.launcher.setMemoryInMB(this.memoryMB);
        List<ActiveProcess> list = this.processes;
        synchronized (list) {
            this.processes.add(process);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationLauncherApp.this.listModel.addElement(process);
                ApplicationLauncherApp.this.processList.invalidate();
            }
        });
        process.start();
    }

    public void handleClick(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        if (!node.isLeaf()) {
            return;
        }
        AppInfo info = (AppInfo)node.getUserObject();
        System.out.println("clicked " + info);
        this.launch(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bKill) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActiveProcess selected = (ActiveProcess)ApplicationLauncherApp.this.processList.getSelectedValue();
                    if (selected == null) {
                        return;
                    }
                    selected.kill();
                }
            });
        } else if (e.getSource() == this.bKillAll) {
            List<ActiveProcess> list = this.processes;
            synchronized (list) {
                for (int i = 0; i < this.processes.size(); ++i) {
                    this.processes.get(i).kill();
                }
            }
        }
    }

    class ProcessStatusThread
    extends Thread {
        ProcessStatusThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                List<ActiveProcess> list = ApplicationLauncherApp.this.processes;
                synchronized (list) {
                    for (int i = ApplicationLauncherApp.this.processes.size() - 1; i >= 0; --i) {
                        final ActiveProcess p = ApplicationLauncherApp.this.processes.get(i);
                        if (p.isActive()) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ApplicationLauncherApp.this.listModel.removeElement(p);
                                ApplicationLauncherApp.this.processList.invalidate();
                            }
                        });
                        ApplicationLauncherApp.this.processes.remove(i);
                    }
                }
                try {
                    ProcessStatusThread.sleep(250L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    public static class ActiveProcess
    extends Thread {
        AppInfo info;
        JavaRuntimeLauncher launcher;
        volatile boolean active = false;
        JavaRuntimeLauncher.Exit exit;

        @Override
        public void run() {
            this.active = true;
            this.exit = this.launcher.launch(this.info.app, new String[0]);
            System.out.println();
            System.out.println("------------------- Exit condition " + (Object)((Object)this.exit));
            this.active = false;
        }

        public void kill() {
            this.launcher.requestKill();
        }

        public boolean isActive() {
            return this.active;
        }

        @Override
        public String toString() {
            if (this.launcher.isKillRequested() && this.active) {
                return "Killing " + this.info;
            }
            return this.info.toString();
        }
    }

    public static class AppInfo {
        Class app;

        public AppInfo(Class app) {
            this.app = app;
        }

        public String toString() {
            return this.app.getSimpleName();
        }
    }
}

