/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public abstract class SelectAlgorithmPanel
extends JPanel
implements ActionListener {
    JToolBar toolbar;
    JComboBox algBox;
    List<Object> algCookies = new ArrayList<Object>();
    Component gui;

    public SelectAlgorithmPanel() {
        super(new BorderLayout());
        this.toolbar = new JToolBar();
        this.algBox = new JComboBox();
        this.algBox.setMaximumSize(this.algBox.getPreferredSize());
        this.toolbar.add(this.algBox);
        this.algBox.addActionListener(this);
        this.toolbar.add(Box.createHorizontalGlue());
        this.add((Component)this.toolbar, "First");
    }

    public void setMainGUI(final Component gui) {
        this.gui = gui;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectAlgorithmPanel.this.add(gui, "Center");
            }
        });
    }

    public void addAlgorithm(final String name, Object cookie) {
        this.algCookies.add(cookie);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectAlgorithmPanel.this.algBox.addItem(name);
            }
        });
    }

    public void refreshAlgorithm() {
        Object cookie = this.algCookies.get(this.algBox.getSelectedIndex());
        String name = (String)this.algBox.getSelectedItem();
        this.performSetAlgorithm(name, cookie);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.algBox) {
            final Object cookie = this.algCookies.get(this.algBox.getSelectedIndex());
            final String name = (String)this.algBox.getSelectedItem();
            new Thread(){

                @Override
                public void run() {
                    SelectAlgorithmPanel.this.performSetAlgorithm(name, cookie);
                }
            }.start();
        }
    }

    private void performSetAlgorithm(String name, Object cookie) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectAlgorithmPanel.this.toolbar.setEnabled(false);
            }
        });
        this.setActiveAlgorithm(name, cookie);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectAlgorithmPanel.this.toolbar.setEnabled(true);
            }
        });
    }

    public abstract void setActiveAlgorithm(String var1, Object var2);
}

