/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.gui.image.ScaleOptions;
import boofcv.io.image.UtilImageIO;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ImagePanel
extends JPanel {
    protected BufferedImage img;
    protected ScaleOptions scaling = ScaleOptions.DOWN;
    public double scale = 1.0;
    public static int saveCounter = 0;

    public ImagePanel(BufferedImage img) {
        this(img, ScaleOptions.NONE);
    }

    public ImagePanel(BufferedImage img, ScaleOptions scaling) {
        this.addMouseSaveImage();
        this.img = img;
        this.scaling = scaling;
        this.autoSetPreferredSize();
    }

    public ImagePanel(int width, int height) {
        this.addMouseSaveImage();
        this.setPreferredSize(new Dimension(width, height));
    }

    public ImagePanel() {
        this.addMouseSaveImage();
    }

    public void addMouseSaveImage() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 2) {
                    System.out.println("Image saved " + saveCounter);
                    UtilImageIO.saveImage((BufferedImage)ImagePanel.this.img, (String)String.format("saved_image%03d.png", saveCounter++));
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        BufferedImage img = this.img;
        if (img != null) {
            if (this.scaling != ScaleOptions.NONE) {
                double ratioW = (double)this.getWidth() / (double)img.getWidth();
                double ratioH = (double)this.getHeight() / (double)img.getHeight();
                this.scale = Math.min(ratioW, ratioH);
                if (this.scaling == ScaleOptions.DOWN && this.scale >= 1.0) {
                    this.scale = 1.0;
                }
                if (this.scale == 1.0) {
                    g.drawImage(img, 0, 0, this);
                } else {
                    AffineTransform tran = AffineTransform.getScaleInstance(this.scale, this.scale);
                    g2.drawImage(img, tran, null);
                }
            } else {
                this.scale = 1.0;
                g2.drawImage((Image)img, 0, 0, this);
            }
        }
    }

    public void setBufferedImage(BufferedImage image) {
        this.img = image;
        this.repaint();
    }

    public void setBufferedImageSafe(final BufferedImage image) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImagePanel.this.setBufferedImage(image);
            }
        });
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public void setScaling(ScaleOptions scaling) {
        this.scaling = scaling;
    }

    public void autoSetPreferredSize() {
        this.setPreferredSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
    }
}

