/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.CharBuffer;
import org.bytedeco.javacpp.indexer.CharIndexer;

public class CharBufferIndexer
extends CharIndexer {
    protected CharBuffer buffer;

    public CharBufferIndexer(CharBuffer buffer, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public char get(int i) {
        return this.buffer.get(i);
    }

    @Override
    public CharIndexer get(int i, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.buffer.get(i * this.strides[0] + n);
        }
        return this;
    }

    @Override
    public char get(int i, int j) {
        return this.buffer.get(i * this.strides[0] + j);
    }

    @Override
    public CharIndexer get(int i, int j, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.buffer.get(i * this.strides[0] + j * this.strides[1] + n);
        }
        return this;
    }

    @Override
    public char get(int i, int j, int k) {
        return this.buffer.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public char get(int ... indices) {
        return this.buffer.get(this.index(indices));
    }

    @Override
    public CharIndexer get(int[] indices, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.buffer.get(this.index(indices) + n);
        }
        return this;
    }

    @Override
    public CharIndexer put(int i, char c) {
        this.buffer.put(i, c);
        return this;
    }

    @Override
    public CharIndexer put(int i, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + n, c[offset + n]);
        }
        return this;
    }

    @Override
    public CharIndexer put(int i, int j, char c) {
        this.buffer.put(i * this.strides[0] + j, c);
        return this;
    }

    @Override
    public CharIndexer put(int i, int j, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + j * this.strides[1] + n, c[offset + n]);
        }
        return this;
    }

    @Override
    public CharIndexer put(int i, int j, int k, char c) {
        this.buffer.put(i * this.strides[0] + j * this.strides[1] + k, c);
        return this;
    }

    @Override
    public CharIndexer put(int[] indices, char c) {
        this.buffer.put(this.index(indices), c);
        return this;
    }

    @Override
    public CharIndexer put(int[] indices, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(this.index(indices) + n, c[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

