/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.tools.Attribute;
import org.bytedeco.javacpp.tools.Context;
import org.bytedeco.javacpp.tools.Declaration;
import org.bytedeco.javacpp.tools.DeclarationList;
import org.bytedeco.javacpp.tools.Declarator;
import org.bytedeco.javacpp.tools.Generator;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.InfoMapper;
import org.bytedeco.javacpp.tools.Logger;
import org.bytedeco.javacpp.tools.Parameters;
import org.bytedeco.javacpp.tools.ParserException;
import org.bytedeco.javacpp.tools.TemplateMap;
import org.bytedeco.javacpp.tools.Token;
import org.bytedeco.javacpp.tools.TokenIndexer;
import org.bytedeco.javacpp.tools.Tokenizer;
import org.bytedeco.javacpp.tools.Type;

public class Parser {
    final Logger logger;
    final Properties properties;
    InfoMap infoMap = null;
    InfoMap leafInfoMap = null;
    TokenIndexer tokens = null;
    String lineSeparator = null;
    String[] docTags = new String[]{"author", "deprecated", "exception", "param", "return", "see", "since", "throws", "version"};

    public Parser(Logger logger, Properties properties) {
        this(logger, properties, null);
    }

    public Parser(Logger logger, Properties properties, String lineSeparator) {
        this.logger = logger;
        this.properties = properties;
        this.lineSeparator = lineSeparator;
    }

    Parser(Parser p, String text) {
        this.logger = p.logger;
        this.properties = p.properties;
        this.infoMap = p.infoMap;
        this.tokens = new TokenIndexer(this.infoMap, new Tokenizer(text).tokenize(), false);
        this.lineSeparator = p.lineSeparator;
    }

    String translate(String text) {
        int namespace = text.lastIndexOf("::");
        if (namespace >= 0) {
            Info info2 = this.infoMap.getFirst(text.substring(0, namespace));
            text = text.substring(namespace + 2);
            if (info2 != null && info2.pointerTypes != null) {
                text = info2.pointerTypes[0] + "." + text;
            }
        }
        return text;
    }

    void containers(Context context, DeclarationList declList) throws ParserException {
        ArrayList<String> basicContainers = new ArrayList<String>();
        for (Info info : this.infoMap.get("basic/containers")) {
            basicContainers.addAll(Arrays.asList(info.cppTypes));
        }
        for (String containerName : basicContainers) {
            List<Info> infoList = this.leafInfoMap.get(containerName);
            for (Info info : infoList) {
                char c;
                int i;
                String args;
                String indices;
                String indent;
                int i2;
                int i3;
                Info valueInfo;
                Type valueType;
                Type indexType;
                boolean resizable;
                Declaration decl = new Declaration();
                if (info == null || info.skip || !info.define) continue;
                int dim = containerName.startsWith("std::pair") ? 0 : 1;
                Type containerType = new Parser(this, info.cppNames[0]).type(context);
                Type firstType = null;
                Type secondType = null;
                if (containerType.arguments == null || containerType.arguments.length == 0 || containerType.arguments[0] == null || containerType.arguments[containerType.arguments.length - 1] == null) continue;
                if (containerType.arguments.length > 1 && containerType.arguments[1].javaName.length() > 0) {
                    resizable = false;
                    indexType = containerType.arguments[0];
                    valueType = containerType.arguments[1];
                } else {
                    resizable = containerType.arguments.length == 1;
                    indexType = new Type();
                    indexType.annotations = "@Cast(\"size_t\") ";
                    indexType.cppName = "size_t";
                    indexType.javaName = "long";
                    valueType = containerType.arguments[0];
                }
                if (valueType.javaName == null || valueType.javaName.length() == 0 || containerName.startsWith("std::bitset")) {
                    valueType.javaName = "boolean";
                    resizable = false;
                }
                while (valueType.cppName.startsWith(containerName) && this.leafInfoMap.get(valueType.cppName, false).size() == 0) {
                    ++dim;
                    valueType = valueType.arguments[0];
                }
                if (containerName.startsWith("std::pair")) {
                    firstType = containerType.arguments[0];
                    secondType = containerType.arguments[1];
                }
                if (valueType.cppName.startsWith("std::pair")) {
                    firstType = valueType.arguments[0];
                    secondType = valueType.arguments[1];
                }
                if (firstType != null && (firstType.annotations == null || firstType.annotations.length() == 0)) {
                    firstType.annotations = (firstType.constValue ? "@Const " : "") + (firstType.indirections == 0 && !firstType.value ? "@ByRef " : "");
                }
                if (secondType != null && (secondType.annotations == null || secondType.annotations.length() == 0)) {
                    secondType.annotations = (secondType.constValue ? "@Const " : "") + (secondType.indirections == 0 && !secondType.value ? "@ByRef " : "");
                }
                if (valueType != null && (valueType.annotations == null || valueType.annotations.length() == 0)) {
                    valueType.annotations = (valueType.constValue ? "@Const " : "") + (valueType.indirections == 0 && !valueType.value ? "@ByRef " : "");
                }
                if ((valueInfo = this.infoMap.getFirst(valueType.cppName)) != null && valueInfo.cast) {
                    String cast = valueType.cppName;
                    if (valueType.constValue && !cast.startsWith("const ")) {
                        cast = "const " + cast;
                    }
                    if (valueType.constPointer && !cast.endsWith(" const")) {
                        cast = cast + " const";
                    }
                    if (valueType.indirections > 0) {
                        for (i3 = 0; i3 < valueType.indirections; ++i3) {
                            cast = cast + "*";
                        }
                    }
                    if (valueType.reference) {
                        cast = cast + "&";
                    }
                    valueType.annotations = "@Cast(\"" + cast + "\") " + valueType.annotations;
                }
                String arrayBrackets = "";
                for (i3 = 0; i3 < dim - 1; ++i3) {
                    arrayBrackets = arrayBrackets + "[]";
                }
                decl.text = decl.text + (dim == 0 ? "\n@NoOffset " : "\n") + "@Name(\"" + containerType.cppName + "\") public static class " + containerType.javaName + " extends Pointer {\n    static { Loader.load(); }\n    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */\n    public " + containerType.javaName + "(Pointer p) { super(p); }\n";
                if ((dim == 0 || containerType.arguments.length == 1) && firstType != null && secondType != null) {
                    String[] stringArray;
                    String[] stringArray2;
                    if (firstType.javaNames != null) {
                        stringArray2 = firstType.javaNames;
                    } else {
                        String[] stringArray3 = new String[1];
                        stringArray2 = stringArray3;
                        stringArray3[0] = firstType.javaName;
                    }
                    String[] firstNames = stringArray2;
                    if (secondType.javaNames != null) {
                        stringArray = secondType.javaNames;
                    } else {
                        String[] stringArray4 = new String[1];
                        stringArray = stringArray4;
                        stringArray4[0] = secondType.javaName;
                    }
                    String[] secondNames = stringArray;
                    String brackets = arrayBrackets + (dim > 0 ? "[]" : "");
                    for (int n = 0; n < firstNames.length || n < secondNames.length; ++n) {
                        decl.text = decl.text + "    public " + containerType.javaName + "(" + firstNames[Math.min(n, firstNames.length - 1)] + brackets + " firstValue, " + secondNames[Math.min(n, secondNames.length - 1)] + brackets + " secondValue) { this(" + (dim > 0 ? "Math.min(firstValue.length, secondValue.length)" : "") + "); put(firstValue, secondValue); }\n";
                    }
                } else if (resizable && firstType == null && secondType == null) {
                    String[] stringArray;
                    if (valueType.javaNames != null) {
                        stringArray = valueType.javaNames;
                    } else {
                        String[] stringArray5 = new String[1];
                        stringArray = stringArray5;
                        stringArray5[0] = valueType.javaName;
                    }
                    for (String javaName : stringArray) {
                        decl.text = decl.text + "    public " + containerType.javaName + "(" + javaName + arrayBrackets + " ... array) { this(array.length); put(array); }\n";
                    }
                }
                decl.text = decl.text + "    public " + containerType.javaName + "()       { allocate();  }\n" + (!resizable ? "" : "    public " + containerType.javaName + "(long n) { allocate(n); }\n") + "    private native void allocate();\n" + (!resizable ? "" : "    private native void allocate(@Cast(\"size_t\") long n);\n") + "    public native @Name(\"operator=\") @ByRef " + containerType.javaName + " put(@ByRef " + containerType.javaName + " x);\n\n";
                for (int i4 = 0; i4 < dim; ++i4) {
                    String indexAnnotation = i4 > 0 ? "@Index" + (i4 > 1 ? "(" + i4 + ") " : " ") : "";
                    String indices2 = "";
                    String separator = "";
                    for (int j = 0; j < i4; ++j) {
                        indices2 = indices2 + separator + indexType.annotations + indexType.javaName + " " + (char)(105 + j);
                        separator = ", ";
                    }
                    decl.text = decl.text + "    public native " + indexAnnotation + "long size(" + indices2 + ");\n" + (!resizable ? "" : "    public native " + indexAnnotation + "void resize(" + indices2 + separator + "@Cast(\"size_t\") long n);\n");
                }
                String params = "";
                String separator = "";
                for (i2 = 0; i2 < dim; ++i2) {
                    params = params + separator + indexType.annotations + indexType.javaName + " " + (char)(105 + i2);
                    separator = ", ";
                }
                if (firstType != null && secondType != null) {
                    int i5;
                    String indexAnnotation = dim == 0 ? "@MemberGetter " : "@Index" + (dim > 1 ? "(" + dim + ") " : " ");
                    decl.text = decl.text + "\n    " + indexAnnotation + "public native " + firstType.annotations + firstType.javaName + " first(" + params + "); public native " + containerType.javaName + " first(" + params + separator + firstType.javaName + " first);\n    " + indexAnnotation + "public native " + secondType.annotations + secondType.javaName + " second(" + params + ");  public native " + containerType.javaName + " second(" + params + separator + secondType.javaName + " second);\n";
                    for (i5 = 1; firstType.javaNames != null && i5 < firstType.javaNames.length; ++i5) {
                        decl.text = decl.text + "    @MemberSetter @Index public native " + containerType.javaName + " first(" + params + separator + firstType.annotations + firstType.javaNames[i5] + " first);\n";
                    }
                    for (i5 = 1; secondType.javaNames != null && i5 < secondType.javaNames.length; ++i5) {
                        decl.text = decl.text + "    @MemberSetter @Index public native " + containerType.javaName + " second(" + params + separator + secondType.annotations + secondType.javaNames[i5] + " second);\n";
                    }
                } else {
                    decl.text = decl.text + "\n    @Index public native " + valueType.annotations + valueType.javaName + " get(" + params + ");\n    public native " + containerType.javaName + " put(" + params + separator + valueType.javaName + " value);\n";
                    for (i2 = 1; valueType.javaNames != null && i2 < valueType.javaNames.length; ++i2) {
                        decl.text = decl.text + "    @ValueSetter @Index public native " + containerType.javaName + " put(" + params + separator + valueType.annotations + valueType.javaNames[i2] + " value);\n";
                    }
                    if (containerType.arguments.length > 1 && containerType.arguments[1].javaName.length() > 0) {
                        decl.text = decl.text + "\n    public native @ByVal Iterator begin();\n    public native @ByVal Iterator end();\n    @NoOffset @Name(\"iterator\") public static class Iterator extends Pointer {\n        public Iterator(Pointer p) { super(p); }\n        public Iterator() { }\n\n        public native @Name(\"operator++\") @ByRef Iterator increment();\n        public native @Name(\"operator==\") boolean equals(@ByRef Iterator it);\n        public native @Name(\"operator*().first\") @MemberGetter " + indexType.annotations + indexType.javaName + " first();\n        public native @Name(\"operator*().second\") @MemberGetter " + valueType.annotations + valueType.javaName + " second();\n    }\n";
                    }
                }
                if ((dim == 0 || containerType.arguments.length == 1) && firstType != null && secondType != null) {
                    String[] stringArray;
                    String[] stringArray6;
                    if (firstType.javaNames != null) {
                        stringArray6 = firstType.javaNames;
                    } else {
                        String[] stringArray7 = new String[1];
                        stringArray6 = stringArray7;
                        stringArray7[0] = firstType.javaName;
                    }
                    String[] firstNames = stringArray6;
                    if (secondType.javaNames != null) {
                        stringArray = secondType.javaNames;
                    } else {
                        String[] stringArray8 = new String[1];
                        stringArray = stringArray8;
                        stringArray8[0] = secondType.javaName;
                    }
                    String[] secondNames = stringArray;
                    String brackets = arrayBrackets + (dim > 0 ? "[]" : "");
                    for (int n = 0; n < firstNames.length || n < secondNames.length; ++n) {
                        decl.text = decl.text + "\n    public " + containerType.javaName + " put(" + firstNames[Math.min(n, firstNames.length - 1)] + brackets + " firstValue, " + secondNames[Math.min(n, secondNames.length - 1)] + brackets + " secondValue) {\n";
                        indent = "        ";
                        indices = "";
                        args = "";
                        separator = "";
                        for (i = 0; i < dim; ++i) {
                            c = (char)(105 + i);
                            decl.text = decl.text + indent + "for (int " + c + " = 0; " + c + " < firstValue" + indices + ".length && " + c + " < secondValue" + indices + ".length; " + c + "++) {\n";
                            indent = indent + "    ";
                            indices = indices + "[" + c + "]";
                            args = args + separator + c;
                            separator = ", ";
                        }
                        decl.text = decl.text + indent + "first(" + args + separator + "firstValue" + indices + ");\n" + indent + "second(" + args + separator + "secondValue" + indices + ");\n";
                        for (i = 0; i < dim; ++i) {
                            indent = indent.substring(4);
                            decl.text = decl.text + indent + "}\n";
                        }
                        decl.text = decl.text + "        return this;\n    }\n";
                    }
                } else if (resizable && firstType == null && secondType == null) {
                    String[] stringArray;
                    if (valueType.javaNames != null) {
                        stringArray = valueType.javaNames;
                    } else {
                        String[] stringArray9 = new String[1];
                        stringArray = stringArray9;
                        stringArray9[0] = valueType.javaName;
                    }
                    for (String javaName : stringArray) {
                        decl.text = decl.text + "\n    public " + containerType.javaName + " put(" + javaName + arrayBrackets + " ... array) {\n";
                        indent = "        ";
                        indices = "";
                        args = "";
                        separator = "";
                        for (i = 0; i < dim; ++i) {
                            c = (char)(105 + i);
                            decl.text = decl.text + indent + "if (size(" + args + ") != array" + indices + ".length) { resize(" + args + separator + "array" + indices + ".length); }\n" + indent + "for (int " + c + " = 0; " + c + " < array" + indices + ".length; " + c + "++) {\n";
                            indent = indent + "    ";
                            indices = indices + "[" + c + "]";
                            args = args + separator + c;
                            separator = ", ";
                        }
                        decl.text = decl.text + indent + "put(" + args + separator + "array" + indices + ");\n";
                        for (i = 0; i < dim; ++i) {
                            indent = indent.substring(4);
                            decl.text = decl.text + indent + "}\n";
                        }
                        decl.text = decl.text + "        return this;\n    }\n";
                    }
                }
                decl.text = decl.text + "}\n";
                declList.add(decl);
            }
        }
    }

    TemplateMap template(Context context) throws ParserException {
        if (!this.tokens.get().match(Token.TEMPLATE)) {
            return null;
        }
        TemplateMap map = new TemplateMap(context.templateMap);
        this.tokens.next().expect(Character.valueOf('<'));
        Token token = this.tokens.next();
        while (!token.match(Token.EOF)) {
            if (token.match(5)) {
                Token t = this.tokens.next();
                if (t.match("...")) {
                    map.variadic = true;
                    t = this.tokens.next();
                }
                if (t.match(5)) {
                    String key = t.value;
                    map.put(key, map.get(key));
                    token = this.tokens.next();
                }
            }
            if (!token.match(Character.valueOf(','), Character.valueOf('>'))) {
                int count = 0;
                token = this.tokens.get();
                while (!(token.match(Token.EOF) || count == 0 && token.match(Character.valueOf(','), Character.valueOf('>')))) {
                    if (token.match(Character.valueOf('<'), Character.valueOf('('))) {
                        ++count;
                    } else if (token.match(Character.valueOf('>'), Character.valueOf(')'))) {
                        --count;
                    }
                    token = this.tokens.next();
                }
            }
            if (token.expect(Character.valueOf(','), Character.valueOf('>')).match(Character.valueOf('>'))) {
                if (!this.tokens.next().match(Token.TEMPLATE)) break;
                this.tokens.next().expect(Character.valueOf('<'));
            }
            token = this.tokens.next();
        }
        return map;
    }

    Type[] templateArguments(Context context) throws ParserException {
        if (!this.tokens.get().match(Character.valueOf('<'))) {
            return null;
        }
        ArrayList<Type> arguments = new ArrayList<Type>();
        Token token = this.tokens.next();
        while (!token.match(Token.EOF)) {
            Type type = this.type(context);
            arguments.add(type);
            token = this.tokens.get();
            if (!token.match(Character.valueOf(','), Character.valueOf('>'))) {
                int count = 0;
                token = this.tokens.get();
                while (!(token.match(Token.EOF) || count == 0 && token.match(Character.valueOf(','), Character.valueOf('>')))) {
                    if (token.match(Character.valueOf('<'), Character.valueOf('('))) {
                        ++count;
                    } else if (token.match(Character.valueOf('>'), Character.valueOf(')'))) {
                        --count;
                    }
                    type.cppName = type.cppName + token;
                    if (token.match(Token.CONST)) {
                        type.cppName = type.cppName + " ";
                    }
                    token = this.tokens.next();
                }
                if (type.cppName.endsWith("*")) {
                    type.javaName = "PointerPointer";
                    type.annotations = type.annotations + "@Cast(\"" + type.cppName + "*\") ";
                }
            }
            if (token.expect(Character.valueOf(','), Character.valueOf('>')).match(Character.valueOf('>'))) break;
            token = this.tokens.next();
        }
        return arguments.toArray(new Type[arguments.size()]);
    }

    Type type(Context context) throws ParserException {
        Type type = new Type();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Token token = this.tokens.get();
        while (!token.match(Token.EOF)) {
            block60: {
                block53: {
                    block65: {
                        int backIndex;
                        block66: {
                            block64: {
                                block63: {
                                    block62: {
                                        block61: {
                                            block58: {
                                                block59: {
                                                    block57: {
                                                        block56: {
                                                            block55: {
                                                                block54: {
                                                                    block52: {
                                                                        if (!token.match("::")) break block52;
                                                                        type.cppName = type.cppName + token;
                                                                        break block53;
                                                                    }
                                                                    if (!token.match(Character.valueOf('<'))) break block54;
                                                                    type.arguments = this.templateArguments(context);
                                                                    type.cppName = type.cppName + "<";
                                                                    String separator = "";
                                                                    for (Type t : type.arguments) {
                                                                        String s;
                                                                        if (t == null) continue;
                                                                        type.cppName = type.cppName + separator;
                                                                        Info info = this.infoMap.getFirst(t.cppName);
                                                                        String string = s = info != null && info.cppTypes != null ? info.cppTypes[0] : t.cppName;
                                                                        if (t.constValue && !s.startsWith("const ")) {
                                                                            s = "const " + s;
                                                                        }
                                                                        if (t.constPointer && !s.endsWith(" const")) {
                                                                            s = s + " const";
                                                                        }
                                                                        for (int i = 0; i < t.indirections; ++i) {
                                                                            s = s + "*";
                                                                        }
                                                                        if (t.reference) {
                                                                            s = s + "&";
                                                                        }
                                                                        type.cppName = type.cppName + s;
                                                                        separator = ",";
                                                                    }
                                                                    type.cppName = type.cppName + (type.cppName.endsWith(">") ? " >" : ">");
                                                                    break block53;
                                                                }
                                                                if (!token.match(Token.CONST, Token.CONSTEXPR)) break block55;
                                                                if (type.cppName.length() == 0) {
                                                                    type.constValue = true;
                                                                } else {
                                                                    type.constPointer = true;
                                                                }
                                                                break block53;
                                                            }
                                                            if (token.match(Character.valueOf('*'))) {
                                                                ++type.indirections;
                                                                this.tokens.next();
                                                                break;
                                                            }
                                                            if (token.match(Character.valueOf('&'))) {
                                                                type.reference = true;
                                                                this.tokens.next();
                                                                break;
                                                            }
                                                            if (token.match("&&")) break block53;
                                                            if (!token.match(Character.valueOf('~'))) break block56;
                                                            type.cppName = type.cppName + "~";
                                                            type.destructor = true;
                                                            break block53;
                                                        }
                                                        if (!token.match(Token.STATIC)) break block57;
                                                        type.staticMember = true;
                                                        break block53;
                                                    }
                                                    if (!token.match(Token.OPERATOR)) break block58;
                                                    if (type.cppName.length() != 0) break block59;
                                                    type.operator = true;
                                                    this.tokens.next();
                                                    break block60;
                                                }
                                                if (!type.cppName.endsWith("::")) break;
                                                type.operator = true;
                                                this.tokens.next();
                                                break;
                                            }
                                            if (!token.match(Token.FRIEND)) break block61;
                                            type.friend = true;
                                            break block53;
                                        }
                                        if (!token.match(Token.VIRTUAL)) break block62;
                                        type.virtual = true;
                                        break block53;
                                    }
                                    if (!token.match(Token.AUTO, Token.ENUM, Token.EXPLICIT, Token.EXTERN, Token.INLINE, Token.CLASS, Token.INTERFACE, Token.__INTERFACE, Token.MUTABLE, Token.NAMESPACE, Token.STRUCT, Token.UNION, Token.TYPEDEF, Token.TYPENAME, Token.USING, Token.REGISTER, Token.THREAD_LOCAL, Token.VOLATILE)) break block63;
                                    token = this.tokens.next();
                                    break block60;
                                }
                                if (!token.match(this.infoMap.getFirst((String)"basic/types").cppTypes) || type.cppName.length() != 0 && !type.simple) break block64;
                                type.cppName = type.cppName + token.value + " ";
                                type.simple = true;
                                break block53;
                            }
                            if (!token.match(5)) break block65;
                            backIndex = this.tokens.index;
                            Attribute attr = this.attribute();
                            if (attr == null || !attr.annotation) break block66;
                            type.annotations = type.annotations + attr.javaName;
                            attributes.add(attr);
                            break block60;
                        }
                        this.tokens.index = backIndex;
                        if (type.cppName.length() == 0 || type.cppName.endsWith("::") || type.cppName.endsWith("~")) {
                            type.cppName = type.cppName + token.value;
                        } else {
                            Info info = this.infoMap.getFirst(this.tokens.get((int)1).value);
                            if (info != null && info.annotations != null || !this.tokens.get(1).match(Character.valueOf('*'), Character.valueOf('&'), 5, Token.CONST, Token.CONSTEXPR)) {
                                break;
                            }
                        }
                        break block53;
                    }
                    if (!token.match(Character.valueOf('}'))) break;
                    type.anonymous = true;
                    this.tokens.next();
                    break;
                }
                this.tokens.next();
            }
            token = this.tokens.get();
        }
        if (attributes.size() > 0) {
            type.attributes = attributes.toArray(new Attribute[attributes.size()]);
        }
        type.cppName = type.cppName.trim();
        if (this.tokens.get().match("...")) {
            this.tokens.next();
            if (this.tokens.get().match(5)) {
                this.tokens.next();
            }
            return null;
        }
        if (type.operator) {
            token = this.tokens.get();
            while (!token.match(Token.EOF, Character.valueOf('('))) {
                type.cppName = type.cppName + token;
                token = this.tokens.next();
            }
        }
        if (type.cppName.endsWith("*")) {
            ++type.indirections;
            type.cppName = type.cppName.substring(0, type.cppName.length() - 1);
        }
        if (type.cppName.endsWith("&")) {
            type.reference = true;
            type.cppName = type.cppName.substring(0, type.cppName.length() - 1);
        }
        if (context.templateMap != null) {
            String[] types = type.cppName.split("::");
            String separator = "";
            type.cppName = "";
            ArrayList<Type> arguments = new ArrayList<Type>();
            for (String t : types) {
                Type t2 = context.templateMap.get(t);
                type.cppName = type.cppName + separator + (t2 != null ? t2.cppName : t);
                if (t2 != null && t2.arguments != null) {
                    arguments.addAll(Arrays.asList(t2.arguments));
                }
                separator = "::";
            }
            if (arguments.size() > 0) {
                type.arguments = arguments.toArray(new Type[arguments.size()]);
            }
        }
        if (type.cppName.startsWith("const ")) {
            type.constValue = true;
            type.cppName = type.cppName.substring(6);
        }
        if (type.cppName.endsWith("*")) {
            ++type.indirections;
            if (type.reference) {
                type.constValue = false;
            }
            type.cppName = type.cppName.substring(0, type.cppName.length() - 1);
        }
        if (type.cppName.endsWith("&")) {
            type.reference = true;
            type.cppName = type.cppName.substring(0, type.cppName.length() - 1);
        }
        if (type.cppName.endsWith(" const")) {
            type.constPointer = true;
            type.cppName = type.cppName.substring(0, type.cppName.length() - 6);
        }
        Info info = null;
        for (String name : context.qualify(type.cppName)) {
            info = this.infoMap.getFirst(name, false);
            if (info != null) {
                type.cppName = name;
                break;
            }
            if (this.infoMap.getFirst(name) == null) continue;
            type.cppName = name;
        }
        if (info != null && info.cppTypes != null && info.cppTypes.length > 0) {
            type.cppName = info.cppTypes[0];
        }
        if (type.cppName.startsWith("const ")) {
            type.constValue = true;
            type.cppName = type.cppName.substring(6);
        }
        if (type.cppName.endsWith("*")) {
            ++type.indirections;
            if (type.reference) {
                type.constValue = false;
            }
            type.cppName = type.cppName.substring(0, type.cppName.length() - 1);
        }
        if (type.cppName.endsWith("&")) {
            type.reference = true;
            type.cppName = type.cppName.substring(0, type.cppName.length() - 1);
        }
        if (type.cppName.endsWith(" const")) {
            type.constPointer = true;
            type.cppName = type.cppName.substring(0, type.cppName.length() - 6);
        }
        int namespace = type.cppName.lastIndexOf("::");
        int template = type.cppName.lastIndexOf(60);
        String string = type.javaName = namespace >= 0 && template < 0 ? type.cppName.substring(namespace + 2) : type.cppName;
        if (info != null) {
            if (type.indirections == 0 && !type.reference && info.valueTypes != null && info.valueTypes.length > 0) {
                type.javaName = info.valueTypes[0];
                type.javaNames = info.valueTypes;
                type.value = true;
            } else if (info.pointerTypes != null && info.pointerTypes.length > 0) {
                type.javaName = info.pointerTypes[0];
                type.javaNames = info.pointerTypes;
            }
        }
        if (type.operator) {
            if (type.constValue) {
                type.annotations = type.annotations + "@Const ";
            }
            if (type.indirections == 0 && !type.reference && !type.value) {
                type.annotations = type.annotations + "@ByVal ";
            } else if (type.indirections == 0 && type.reference && !type.value) {
                type.annotations = type.annotations + "@ByRef ";
            }
            type.annotations = type.annotations + "@Name(\"operator " + (type.constValue ? "const " : "") + type.cppName + (type.indirections > 0 ? "*" : (type.reference ? "&" : "")) + "\") ";
        }
        if (info != null && info.annotations != null) {
            for (String s : info.annotations) {
                type.annotations = type.annotations + s + " ";
            }
        }
        if (context.cppName != null && type.javaName.length() > 0) {
            int namespace2;
            int template2;
            String groupName = context.cppName;
            int n = template2 = groupName != null ? groupName.lastIndexOf(60) : -1;
            if (template < 0 && template2 >= 0) {
                groupName = groupName.substring(0, template2);
            }
            int n2 = namespace2 = groupName != null ? groupName.lastIndexOf("::") : -1;
            if (namespace < 0 && namespace2 >= 0) {
                groupName = groupName.substring(namespace2 + 2);
            }
            if (type.cppName.equals(groupName)) {
                type.constructor = !type.destructor && !type.operator && type.indirections == 0 && !type.reference && this.tokens.get().match(Character.valueOf('('), Character.valueOf(':'));
            }
            type.javaName = context.shorten(type.javaName);
        }
        return type;
    }

    Declarator declarator(Context context, String defaultName, int infoNumber, boolean useDefaults, int varNumber, boolean arrayAsPointer, boolean pointerAsArray) throws ParserException {
        String originalName;
        boolean typedef = this.tokens.get().match(Token.TYPEDEF);
        boolean using = this.tokens.get().match(Token.USING);
        Declarator dcl = new Declarator();
        String[] type = this.type(context);
        if (type == null) {
            return null;
        }
        int count = 0;
        int number = 0;
        Token token = this.tokens.get();
        while (number < varNumber && !token.match(Token.EOF)) {
            if (token.match(Character.valueOf('('), Character.valueOf('['), Character.valueOf('{'))) {
                ++count;
            } else if (token.match(Character.valueOf(')'), Character.valueOf(']'), Character.valueOf('}'))) {
                --count;
            } else if (count <= 0) {
                if (token.match(Character.valueOf(','))) {
                    ++number;
                } else if (token.match(Character.valueOf(';'))) {
                    this.tokens.next();
                    return null;
                }
            }
            token = this.tokens.next();
        }
        String precast = null;
        String cast = type.cppName;
        if (type.constPointer) {
            dcl.constPointer = true;
            cast = cast + " const";
        }
        if (varNumber == 0 && type.indirections > 0) {
            dcl.indirections += type.indirections;
            for (int i = 0; i < type.indirections; ++i) {
                cast = cast + "*";
            }
        }
        if (varNumber == 0 && type.reference) {
            dcl.reference = true;
            cast = cast + "&";
        }
        Token token2 = this.tokens.get();
        while (!token2.match(Token.EOF)) {
            if (token2.match(Character.valueOf('*'))) {
                ++dcl.indirections;
            } else if (token2.match(Character.valueOf('&'))) {
                dcl.reference = true;
            } else if (!token2.match("&&")) {
                if (!token2.match(Token.CONST, Token.CONSTEXPR)) break;
                dcl.constPointer = true;
            }
            cast = cast + token2;
            token2 = this.tokens.next();
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (type.attributes != null) {
            attributes.addAll(Arrays.asList(type.attributes));
        }
        int backIndex = this.tokens.index;
        Attribute attr = this.attribute();
        while (attr != null && attr.annotation) {
            type.annotations = type.annotations + attr.javaName;
            attributes.add(attr);
            backIndex = this.tokens.index;
            attr = this.attribute();
        }
        attr = null;
        this.tokens.index = backIndex;
        for (Attribute a : attributes) {
            if (a.arguments.length() > 0 && Character.isJavaIdentifierStart(a.arguments.charAt(0))) {
                attr = a;
                for (char c : a.arguments.toCharArray()) {
                    if (Character.isJavaIdentifierPart(c)) continue;
                    attr = null;
                    break;
                }
            }
            if (attr == null) continue;
            break;
        }
        count = 0;
        while (this.tokens.get().match(Character.valueOf('(')) && this.tokens.get(1).match(Character.valueOf('('))) {
            this.tokens.next();
            ++count;
        }
        int[] dims = new int[256];
        int indirections2 = 0;
        dcl.cppName = "";
        Info groupInfo = null;
        Declaration definition = new Declaration();
        boolean fieldPointer = false;
        if (this.tokens.get().match(Character.valueOf('(')) || typedef && this.tokens.get(1).match(Character.valueOf('('))) {
            if (this.tokens.get().match(Character.valueOf('('))) {
                this.tokens.next();
            }
            Token token3 = this.tokens.get();
            while (!token3.match(Token.EOF)) {
                if (token3.match(5, "::")) {
                    dcl.cppName = dcl.cppName + token3;
                } else if (token3.match(Character.valueOf('*'))) {
                    ++indirections2;
                    if (dcl.cppName.endsWith("::")) {
                        dcl.cppName = dcl.cppName.substring(0, dcl.cppName.length() - 2);
                        for (String name : context.qualify(dcl.cppName)) {
                            groupInfo = this.infoMap.getFirst(name, false);
                            if (groupInfo != null) {
                                dcl.cppName = name;
                                break;
                            }
                            if (this.infoMap.getFirst(name) == null) continue;
                            dcl.cppName = name;
                        }
                        definition.text = definition.text + "@Namespace(\"" + dcl.cppName + "\") ";
                    } else if (dcl.cppName.length() > 0) {
                        definition.text = definition.text + "@Convention(\"" + dcl.cppName + "\") ";
                    }
                    dcl.cppName = "";
                } else if (token3.match(Character.valueOf('['))) {
                    Token n = this.tokens.get(1);
                    dims[dcl.indices++] = n.match(1) ? Integer.parseInt(n.value) : -1;
                } else if (token3.match(Character.valueOf('('), Character.valueOf(')'))) break;
                token3 = this.tokens.next();
            }
            if (this.tokens.get().match(Character.valueOf(')'))) {
                this.tokens.next();
            }
        } else if (this.tokens.get().match(5)) {
            Token token4 = this.tokens.get();
            while (!token4.match(Token.EOF)) {
                if (dcl.cppName.length() > 0 && token4.match(Character.valueOf('*'))) {
                    dcl.cppName = dcl.cppName.substring(0, dcl.cppName.length() - 2);
                    for (String name : context.qualify(dcl.cppName)) {
                        groupInfo = this.infoMap.getFirst(name, false);
                        if (groupInfo != null) {
                            dcl.cppName = name;
                            break;
                        }
                        if (this.infoMap.getFirst(name) == null) continue;
                        dcl.cppName = name;
                    }
                    definition.text = definition.text + "@Namespace(\"" + dcl.cppName + "\") ";
                    token4 = this.tokens.get();
                    while (!token4.match(Token.EOF) && token4.match(Character.valueOf('*'))) {
                        ++indirections2;
                        token4 = this.tokens.next();
                    }
                    dcl.cppName = token4.match(5) ? token4.toString() : "";
                    fieldPointer = groupInfo != null;
                } else if (token4.match("::")) {
                    dcl.cppName = dcl.cppName + token4;
                } else if (token4.match(Token.OPERATOR)) {
                    dcl.operator = true;
                    if (!this.tokens.get(1).match(5) || this.tokens.get(1).match(Token.NEW, Token.DELETE)) {
                        dcl.cppName = dcl.cppName + "operator " + this.tokens.next();
                        token4 = this.tokens.next();
                        while (!token4.match(Token.EOF, Character.valueOf('('))) {
                            dcl.cppName = dcl.cppName + token4;
                            token4 = this.tokens.next();
                        }
                        break;
                    }
                } else if (token4.match(Character.valueOf('<'))) {
                    dcl.cppName = dcl.cppName + token4;
                    int count2 = 0;
                    token4 = this.tokens.next();
                    while (!token4.match(Token.EOF)) {
                        dcl.cppName = dcl.cppName + token4;
                        if (count2 != 0 || !token4.match(Character.valueOf('>'))) {
                            if (token4.match(Character.valueOf('<'))) {
                                ++count2;
                            } else if (token4.match(Character.valueOf('>'))) {
                                --count2;
                            }
                            token4 = this.tokens.next();
                            continue;
                        }
                        break;
                    }
                } else {
                    if (!token4.match(5) || dcl.cppName.length() != 0 && !dcl.cppName.endsWith("::")) break;
                    dcl.cppName = dcl.cppName + token4;
                }
                token4 = this.tokens.next();
            }
        }
        if (dcl.cppName.length() == 0) {
            dcl.cppName = defaultName;
        }
        boolean bracket = false;
        Token token5 = this.tokens.get();
        while (!token5.match(Token.EOF)) {
            if (!bracket && token5.match(Character.valueOf('['))) {
                bracket = true;
                Token n = this.tokens.get(1);
                dims[dcl.indices++] = n.match(1) ? Integer.parseInt(n.value) : -1;
            } else {
                if (!bracket) break;
                if (bracket && token5.match(Character.valueOf(']'))) {
                    bracket = false;
                }
            }
            token5 = this.tokens.next();
        }
        while (dcl.indices > 0 && indirections2 > 0) {
            dims[dcl.indices++] = -1;
            --indirections2;
        }
        if (arrayAsPointer && dcl.indices > 0) {
            ++dcl.indirections;
            String dimCast = "";
            for (int i = 1; i < dcl.indices; ++i) {
                if (dims[i] <= 0) continue;
                dimCast = dimCast + "[" + dims[i] + "]";
            }
            if (!dimCast.isEmpty()) {
                cast = dims[0] != -1 ? cast + "(* /*[" + dims[0] + "]*/ )" : cast + "(*)";
                cast = cast + dimCast;
            } else {
                cast = cast + "*";
            }
        }
        if (pointerAsArray && dcl.indirections > (type.anonymous ? 0 : 1)) {
            dims[dcl.indices++] = -1;
            --dcl.indirections;
            cast = cast.substring(0, cast.length() - 1);
        }
        if (this.tokens.get().match(Character.valueOf(':'))) {
            type.annotations = type.annotations + "@NoOffset ";
            this.tokens.next().expect(1, 5);
            this.tokens.next().expect(Character.valueOf(','), Character.valueOf(';'));
        }
        dcl.parameters = this.parameters(context, infoNumber, useDefaults);
        int infoLength = 1;
        boolean valueType = false;
        boolean needCast = arrayAsPointer && dcl.indices > 1;
        boolean implicitConst = false;
        String prefix = type.constValue && dcl.indirections < 2 && !dcl.reference ? "const " : "";
        Info info = this.infoMap.getFirst(prefix + type.cppName, false);
        if (!(typedef && dcl.parameters == null || info != null && (info.cppTypes == null || info.cppTypes.length <= 0))) {
            String[] type2 = type;
            if (info != null) {
                type2 = new Parser(this, info.cppTypes[0]).type(context);
            }
            List<Info> infoList = this.infoMap.get(type2.cppName);
            for (Info info2 : infoList) {
                if (type2.arguments == null || info2.annotations == null) continue;
                type.constPointer = type2.arguments[0].constPointer;
                type.constValue = type2.arguments[0].constValue;
                type.simple = type2.arguments[0].simple;
                type.indirections = type2.arguments[0].indirections;
                type.reference = type2.arguments[0].reference;
                type.annotations = type2.arguments[0].annotations;
                type.cppName = type2.arguments[0].cppName;
                type.javaName = type2.arguments[0].javaName;
                dcl.indirections = 1;
                dcl.reference = false;
                if (context.virtualize) {
                    needCast = true;
                    precast = cast;
                }
                cast = type.cppName + "*";
                if (type.constValue && !cast.startsWith("const ")) {
                    cast = "const " + cast;
                }
                if (type.constPointer && !cast.endsWith(" const")) {
                    cast = cast + " const";
                }
                if (type.indirections > 0) {
                    dcl.indirections += type.indirections;
                    for (int i = 0; i < type.indirections; ++i) {
                        cast = cast + "*";
                    }
                }
                if (type.reference) {
                    dcl.reference = true;
                    cast = cast + "&";
                }
                String[] i = info2.annotations;
                int n = i.length;
                for (int j = 0; j < n; ++j) {
                    String s = i[j];
                    type.annotations = type.annotations + s + " ";
                }
                info = this.infoMap.getFirst(type.cppName, false);
                break;
            }
        }
        if (!using && info != null) {
            valueType = info.valueTypes != null && (type.constValue && dcl.reference || dcl.indirections == 0 && !dcl.reference || info.pointerTypes == null);
            implicitConst = info.cppNames[0].startsWith("const ");
            infoLength = valueType ? info.valueTypes.length : (info.pointerTypes != null ? info.pointerTypes.length : 1);
            int n = dcl.infoNumber = infoNumber < 0 ? 0 : infoNumber % infoLength;
            type.javaName = valueType ? info.valueTypes[dcl.infoNumber] : (info.pointerTypes != null ? info.pointerTypes[dcl.infoNumber] : type.javaName);
            type.javaName = context.shorten(type.javaName);
            needCast |= info.cast && !type.cppName.equals(type.javaName);
        }
        if (!valueType) {
            if (dcl.indirections == 0 && !dcl.reference) {
                type.annotations = type.annotations + "@ByVal ";
            } else if (dcl.indirections == 0 && dcl.reference) {
                type.annotations = type.annotations + "@ByRef ";
            } else if (dcl.indirections == 1 && dcl.reference) {
                type.annotations = type.annotations + "@ByPtrRef ";
            } else if (dcl.indirections == 2 && !dcl.reference && infoNumber >= 0) {
                type.annotations = type.annotations + "@ByPtrPtr ";
                needCast |= type.cppName.equals("void");
            } else if (dcl.indirections >= 2) {
                dcl.infoNumber += infoLength;
                needCast = true;
                type.javaName = "PointerPointer";
                if (dcl.reference) {
                    type.annotations = type.annotations + "@ByRef ";
                }
            }
            if (!needCast && !type.javaName.contains("@Cast")) {
                if (type.constValue && !implicitConst && !type.constPointer) {
                    type.annotations = "@Const " + type.annotations;
                } else if (type.constPointer) {
                    type.annotations = "@Const({" + type.constValue + ", " + type.constPointer + "}) " + type.annotations;
                }
            }
        }
        if (needCast) {
            if (dcl.indirections == 0 && dcl.reference) {
                cast = cast.replace('&', '*');
            }
            if (valueType && type.constValue && dcl.reference) {
                cast = cast.substring(0, cast.length() - 1);
            }
            if (type.constValue && !cast.startsWith("const ")) {
                cast = "const " + cast;
            }
            type.annotations = precast != null ? "@Cast({\"" + cast + "\", \"" + precast + "\"}) " + type.annotations : (!valueType && dcl.indirections == 0 && !dcl.reference ? type.annotations + "@Cast(\"" + cast + "*\") " : "@Cast(\"" + cast + "\") " + type.annotations);
        }
        dcl.javaName = attr != null ? attr.arguments : dcl.cppName;
        for (String name : context.qualify(dcl.cppName)) {
            info = this.infoMap.getFirst(name, false);
            if (info != null) {
                dcl.cppName = name;
                break;
            }
            if (this.infoMap.getFirst(name) == null) continue;
            dcl.cppName = name;
        }
        String string = originalName = fieldPointer ? groupInfo.pointerTypes[0] : dcl.javaName;
        if (attr == null && defaultName == null && info != null && info.javaNames != null && info.javaNames.length > 0 && (dcl.operator || !info.cppNames[0].contains("<") || context.templateMap != null && context.templateMap.type == null)) {
            dcl.javaName = info.javaNames[0];
        }
        if (info != null && info.annotations != null) {
            for (String s : info.annotations) {
                type.annotations = type.annotations + s + " ";
            }
        }
        dcl.type = type;
        dcl.signature = dcl.javaName;
        if (dcl.parameters != null || fieldPointer) {
            if (dcl.parameters != null) {
                dcl.infoNumber = Math.max(dcl.infoNumber, dcl.parameters.infoNumber);
            }
            if (dcl.parameters != null && indirections2 == 0 && !typedef) {
                dcl.signature = dcl.signature + dcl.parameters.signature;
            } else {
                String cppType = "";
                if (dcl.type != null) {
                    cppType = cppType + dcl.type.cppName;
                    for (int i = 0; i < dcl.indirections; ++i) {
                        cppType = cppType + "*";
                    }
                    if (dcl.reference) {
                        cppType = cppType + "&";
                    }
                }
                cppType = cppType + " (*)(";
                String separator = "";
                if (dcl.parameters != null) {
                    for (Declarator d : dcl.parameters.declarators) {
                        if (d == null) continue;
                        cppType = cppType + separator + d.type.cppName;
                        for (int i = 0; i < d.indirections; ++i) {
                            cppType = cppType + "*";
                        }
                        if (d.reference) {
                            cppType = cppType + "&";
                        }
                        separator = ", ";
                    }
                }
                cppType = cppType + ")";
                info = this.infoMap.getFirst(cppType);
                String functionType = null;
                if (originalName != null) {
                    functionType = Character.toUpperCase(originalName.charAt(0)) + originalName.substring(1);
                }
                if (info != null && info.pointerTypes != null && info.pointerTypes.length > 0) {
                    functionType = info.pointerTypes[0];
                } else if (typedef) {
                    functionType = originalName;
                } else if (dcl.parameters != null && dcl.parameters.signature.length() > 0) {
                    functionType = functionType + dcl.parameters.signature;
                } else if (!type.javaName.equals("void")) {
                    functionType = Character.toUpperCase(type.javaName.charAt(0)) + type.javaName.substring(1) + "_" + functionType;
                }
                if (info != null && info.annotations != null) {
                    for (String s : info.annotations) {
                        definition.text = definition.text + s + " ";
                    }
                }
                definition.text = definition.text + (this.tokens.get().match(Token.CONST, Token.CONSTEXPR) ? "@Const " : "") + "public static class " + functionType + " extends FunctionPointer {\n    static { Loader.load(); }\n    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */\n    public    " + functionType + "(Pointer p) { super(p); }\n" + (groupInfo != null ? "" : "    protected " + functionType + "() { allocate(); }\n    private native void allocate();\n");
                definition.text = fieldPointer ? definition.text + "    public native " + type.annotations + type.javaName + " get(" + groupInfo.pointerTypes[0] + " o);\n    public native " + functionType + " put(" + groupInfo.pointerTypes[0] + " o, " + type.annotations + type.javaName + " v);\n}\n" : definition.text + "    public native " + type.annotations + type.javaName + " call" + (groupInfo != null ? "(" + groupInfo.pointerTypes[0] + " o" + (dcl.parameters.list.charAt(1) == ')' ? ")" : ", " + dcl.parameters.list.substring(1)) : dcl.parameters.list) + ";\n}\n";
                definition.signature = functionType;
                definition.declarator = new Declarator();
                definition.declarator.parameters = dcl.parameters;
                dcl.definition = definition;
                if (!fieldPointer) {
                    dcl.parameters = null;
                }
                type.annotations = "";
                type.javaName = functionType;
            }
        }
        if (dcl.cppName != null) {
            int template;
            String simpleName;
            String localName = dcl.cppName;
            if (context.namespace != null && localName.startsWith(context.namespace + "::")) {
                localName = dcl.cppName.substring(context.namespace.length() + 2);
            }
            String string2 = simpleName = (template = localName.lastIndexOf(60)) >= 0 ? localName.substring(0, template) : localName;
            if (!(simpleName.equals(dcl.javaName) || localName.contains("::") && context.javaName != null)) {
                type.annotations = type.annotations + "@Name(\"" + localName + "\") ";
            }
        }
        while (this.tokens.get().match(Character.valueOf(')')) && count > 0) {
            this.tokens.next();
            --count;
        }
        return dcl;
    }

    /*
     * WARNING - void declaration
     */
    String commentDoc(String s, int startIndex) {
        if (startIndex < 0 || startIndex > s.length()) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        for (int index = s.indexOf("/**", startIndex); index < sb.length(); ++index) {
            char c = sb.charAt(index);
            String ss = sb.substring(index + 1);
            if (c == '`' && ss.startsWith("``") && sb.length() - index > 3) {
                sb.replace(index, index + 3, "<pre>{@code" + (Character.isWhitespace(sb.charAt(index + 3)) ? "" : " "));
                index = sb.indexOf("```", index);
                if (index < 0) break;
                sb.replace(index, index + 3, "}</pre>");
                continue;
            }
            if (c == '`') {
                sb.replace(index, index + 1, "{@code ");
                index = sb.indexOf("`", index);
                if (index < 0) break;
                sb.replace(index, index + 1, "}");
                continue;
            }
            if ((c == '\\' || c == '@') && ss.startsWith("code")) {
                sb.replace(index, index + 5, "<pre>{@code" + (Character.isWhitespace(sb.charAt(index + 5)) ? "" : " "));
                index = sb.indexOf(c + "endcode", index);
                if (index < 0) break;
                sb.replace(index, index + 8, "}</pre>");
                continue;
            }
            if ((c == '\\' || c == '@') && ss.startsWith("verbatim")) {
                sb.replace(index, index + 9, "<pre>{@literal" + (Character.isWhitespace(sb.charAt(index + 9)) ? "" : " "));
                index = sb.indexOf(c + "endverbatim", index);
                if (index < 0) break;
                sb.replace(index, index + 12, "}</pre>");
                continue;
            }
            if (c == '\n' && ss.length() > 0 && ss.charAt(0) == '\n') {
                void var8_10;
                int n;
                for (n = 0; n < ss.length() && ss.charAt(n) == '\n'; ++n) {
                }
                String string = "";
                while (n < ss.length() && Character.isWhitespace(ss.charAt(n))) {
                    String string2 = (String)var8_10 + ss.charAt(n);
                    ++n;
                }
                sb.insert(index + 1, (String)var8_10 + "<p>");
                continue;
            }
            if (c == '\\' || c == '@') {
                String foundTag = null;
                for (String tag : this.docTags) {
                    if (!ss.startsWith(tag)) continue;
                    foundTag = tag;
                    break;
                }
                if (foundTag != null) {
                    sb.setCharAt(index, '@');
                    int n = index + foundTag.length() + 1;
                    if (sb.charAt(n) == 's' && !foundTag.endsWith("s")) {
                        sb.deleteCharAt(n);
                        continue;
                    }
                    if (Character.isWhitespace(sb.charAt(n))) continue;
                    sb.insert(n, ' ');
                    continue;
                }
                sb.setCharAt(index, '\\');
                continue;
            }
            if (c == '*' && ss.charAt(0) == '/' && (index = sb.indexOf("/**", index)) < 0) break;
        }
        return sb.toString();
    }

    String commentBefore() throws ParserException {
        String comment = "";
        this.tokens.raw = true;
        while (this.tokens.index > 0 && this.tokens.get(-1).match(4)) {
            --this.tokens.index;
        }
        boolean closeComment = false;
        int startDoc = -1;
        Token token = this.tokens.get();
        while (token.match(4)) {
            block10: {
                String s;
                block11: {
                    block9: {
                        s = token.value;
                        if (!s.startsWith("/**") && !s.startsWith("/*!") && !s.startsWith("///") && !s.startsWith("//!")) break block9;
                        if (s.length() > 3 && s.charAt(3) == '<') break block10;
                        if (s.length() >= 3 && (s.startsWith("///") || s.startsWith("//!")) && !s.startsWith("////") && !s.startsWith("///*")) {
                            String lastComment = comment.trim();
                            int n2 = lastComment.indexOf(10);
                            while (!lastComment.startsWith("/*") && n2 > 0) {
                                lastComment = n2 + 1 < lastComment.length() ? lastComment.substring(n2 + 1).trim() : "";
                                n2 = lastComment.indexOf(10);
                            }
                            s = (comment.length() == 0 || comment.contains("*/") || !lastComment.startsWith("/*") ? "/**" : " * ") + s.substring(3);
                            closeComment = true;
                        } else if (s.length() > 3 && !s.startsWith("///")) {
                            s = "/**" + s.substring(3);
                        }
                        break block11;
                    }
                    if (closeComment && !comment.endsWith("*/")) {
                        closeComment = false;
                        comment = comment + " */";
                    }
                }
                if (startDoc < 0 && s.startsWith("/**")) {
                    startDoc = comment.length();
                }
                comment = comment + token.spacing + s;
            }
            token = this.tokens.next();
        }
        if (closeComment && !comment.endsWith("*/")) {
            comment = comment + " */";
        }
        this.tokens.raw = false;
        return this.commentDoc(comment, startDoc);
    }

    String commentAfter() throws ParserException {
        String comment = "";
        this.tokens.raw = true;
        while (this.tokens.index > 0 && this.tokens.get(-1).match(4)) {
            --this.tokens.index;
        }
        boolean closeComment = false;
        int startDoc = -1;
        Token token = this.tokens.get();
        while (token.match(4)) {
            String s = token.value;
            String spacing = token.spacing;
            int n = spacing.lastIndexOf(10) + 1;
            if ((s.startsWith("/**") || s.startsWith("/*!") || s.startsWith("///") || s.startsWith("//!")) && (s.length() <= 3 || s.charAt(3) == '<')) {
                if (s.length() > 4 && (s.startsWith("///") || s.startsWith("//!"))) {
                    String lastComment = comment.trim();
                    int n2 = lastComment.indexOf(10);
                    while (!lastComment.startsWith("/*") && n2 > 0) {
                        lastComment = n2 + 1 < lastComment.length() ? lastComment.substring(n2 + 1).trim() : "";
                        n2 = lastComment.indexOf(10);
                    }
                    s = (comment.length() == 0 || comment.contains("*/") || !lastComment.startsWith("/*") ? "/**" : " * ") + s.substring(4);
                    closeComment = true;
                } else if (s.length() > 4) {
                    s = "/**" + s.substring(4);
                }
                if (startDoc < 0 && s.startsWith("/**")) {
                    startDoc = comment.length();
                }
                comment = comment + spacing.substring(0, n) + s;
            }
            token = this.tokens.next();
        }
        if (closeComment && !comment.endsWith("*/")) {
            comment = comment + " */";
        }
        if (comment.length() > 0) {
            comment = comment + "\n";
        }
        this.tokens.raw = false;
        return this.commentDoc(comment, startDoc);
    }

    Attribute attribute() throws ParserException {
        if (!this.tokens.get().match(5)) {
            return null;
        }
        Attribute attr = new Attribute();
        attr.cppName = this.tokens.get().value;
        Info info = this.infoMap.getFirst(attr.cppName);
        attr.annotation = info != null && info.annotations != null && info.javaNames == null && info.valueTypes == null && info.pointerTypes == null;
        if (attr.annotation) {
            for (String s : info.annotations) {
                attr.javaName = attr.javaName + s + " ";
            }
        }
        if (!this.tokens.next().match(Character.valueOf('('))) {
            return attr;
        }
        int count = 1;
        this.tokens.raw = true;
        Token token = this.tokens.next();
        while (!token.match(Token.EOF) && count > 0) {
            if (token.match(Character.valueOf('('))) {
                ++count;
            } else if (token.match(Character.valueOf(')'))) {
                --count;
            } else if (info == null || !info.skip) {
                attr.arguments = attr.arguments + token.value;
            }
            token = this.tokens.next();
        }
        this.tokens.raw = false;
        return attr;
    }

    String body() throws ParserException {
        if (!this.tokens.get().match(Character.valueOf('{'))) {
            return null;
        }
        int count = 1;
        this.tokens.raw = true;
        Token token = this.tokens.next();
        while (!token.match(Token.EOF) && count > 0) {
            if (token.match(Character.valueOf('{'))) {
                ++count;
            } else if (token.match(Character.valueOf('}'))) {
                --count;
            }
            token = this.tokens.next();
        }
        this.tokens.raw = false;
        return "";
    }

    Parameters parameters(Context context, int infoNumber, boolean useDefaults) throws ParserException {
        if (!this.tokens.get().match(Character.valueOf('('))) {
            return null;
        }
        int count = 0;
        Parameters params = new Parameters();
        ArrayList<Declarator> dcls = new ArrayList<Declarator>();
        params.list = "(";
        params.names = "(";
        int lastVarargs = -1;
        Token token = this.tokens.next();
        while (!token.match(Token.EOF)) {
            int n;
            String spacing = token.spacing;
            if (token.match(Character.valueOf(')'))) {
                params.list = params.list + spacing + ")";
                params.names = params.names + ")";
                this.tokens.next();
                break;
            }
            Declarator dcl = this.declarator(context, "arg" + count++, infoNumber, useDefaults, 0, true, false);
            boolean hasDefault = !this.tokens.get().match(Character.valueOf(','), Character.valueOf(')'));
            Token defaultToken = null;
            String defaultValue = "";
            if (dcl != null && hasDefault) {
                String s;
                int n2;
                Object cppName;
                defaultToken = this.tokens.get();
                int count2 = 0;
                token = this.tokens.next();
                token.spacing = "";
                while (!(token.match(Token.EOF) || count2 == 0 && token.match(Character.valueOf(','), Character.valueOf(')')))) {
                    if (token.match(Character.valueOf('('))) {
                        ++count2;
                    } else if (token.match(Character.valueOf(')'))) {
                        --count2;
                    }
                    cppName = token.value;
                    String[] stringArray = context.qualify((String)cppName);
                    n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String name = stringArray[i];
                        if (this.infoMap.getFirst(name, false) != null) {
                            cppName = name;
                            break;
                        }
                        if (this.infoMap.getFirst(name) == null) continue;
                        cppName = name;
                    }
                    if (token.match(5)) {
                        while (this.tokens.get(1).equals("::")) {
                            this.tokens.next();
                            Token t = this.tokens.next();
                            cppName = (String)cppName + "::" + t.spacing + t;
                        }
                    }
                    defaultValue = defaultValue + token.spacing + (cppName != null && ((String)cppName).length() > 0 ? cppName : token);
                    token = this.tokens.next();
                }
                cppName = context.qualify(defaultValue);
                int t = ((String[])cppName).length;
                for (n = 0; n < t; ++n) {
                    String name = cppName[n];
                    if (this.infoMap.getFirst(name, false) != null) {
                        defaultValue = name;
                        break;
                    }
                    if (this.infoMap.getFirst(name) == null) continue;
                    defaultValue = name;
                }
                if ((n2 = (s = dcl.type.annotations).indexOf("@ByVal ")) < 0) {
                    n2 = s.indexOf("@ByRef ");
                }
                if (n2 >= 0) {
                    s = s.substring(0, n2 + 6) + "(nullValue = \"" + defaultValue.replaceAll("\"", "\\\\\"").replaceAll("\n(\\s*)", "\"\n$1 + \"") + "\")" + s.substring(n2 + 6);
                }
                dcl.type.annotations = s;
            }
            if (!(dcl == null || dcl.type.javaName.equals("void") || hasDefault && useDefaults)) {
                if (lastVarargs >= 0) {
                    params.list = params.list.substring(0, lastVarargs) + "[]" + params.list.substring(lastVarargs + 3);
                }
                int n3 = params.list.length();
                params.infoNumber = Math.max(params.infoNumber, dcl.infoNumber);
                params.list = params.list + (count > 1 ? "," : "") + spacing + dcl.type.annotations + dcl.type.javaName + " " + dcl.javaName;
                lastVarargs = params.list.indexOf("...", n3);
                if (hasDefault) {
                    params.list = params.list + "/*" + defaultToken + defaultValue + "*/";
                }
                params.signature = params.signature + '_';
                char[] cArray = dcl.type.javaName.substring(dcl.type.javaName.lastIndexOf(32) + 1).toCharArray();
                int n4 = cArray.length;
                for (n = 0; n < n4; ++n) {
                    char c = cArray[n];
                    params.signature = params.signature + (Character.isJavaIdentifierPart(c) ? c : (char)'_');
                }
                params.names = params.names + (count > 1 ? ", " : "") + dcl.javaName;
                if (dcl.javaName.startsWith("arg")) {
                    try {
                        count = Integer.parseInt(dcl.javaName.substring(3)) + 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (!hasDefault || !useDefaults) {
                dcls.add(dcl);
            }
            if (this.tokens.get().expect(Character.valueOf(','), Character.valueOf(')')).match(Character.valueOf(','))) {
                this.tokens.next();
            }
            token = this.tokens.get();
        }
        params.declarators = dcls.toArray(new Declarator[dcls.size()]);
        return params;
    }

    boolean function(Context context, DeclarationList declList) throws ParserException {
        String localName;
        int backIndex = this.tokens.index;
        String spacing = this.tokens.get().spacing;
        String modifiers = "public native ";
        int startIndex = this.tokens.index;
        Type type = this.type(context);
        Parameters params = this.parameters(context, 0, false);
        Declarator dcl = new Declarator();
        Declaration decl = new Declaration();
        if (type.javaName.length() == 0) {
            this.tokens.index = backIndex;
            return false;
        }
        if (context.javaName == null && !type.operator && params != null) {
            if (this.tokens.get().match(Character.valueOf(':'))) {
                Token token = this.tokens.next();
                while (!token.match(Token.EOF) && !token.match(Character.valueOf('{'), Character.valueOf(';'))) {
                    token = this.tokens.next();
                }
            }
            if (this.tokens.get().match(Character.valueOf('{'))) {
                this.body();
            } else {
                this.tokens.next();
            }
            decl.text = spacing;
            decl.function = true;
            declList.add(decl);
            return true;
        }
        if ((type.constructor || type.destructor || type.operator) && params != null) {
            dcl.type = type;
            dcl.parameters = params;
            dcl.cppName = type.cppName;
            dcl.javaName = type.javaName.substring(type.javaName.lastIndexOf(32) + 1);
            if (type.operator) {
                dcl.cppName = "operator " + dcl.cppName;
                dcl.javaName = "as" + Character.toUpperCase(dcl.javaName.charAt(0)) + dcl.javaName.substring(1);
            }
            dcl.signature = dcl.javaName + params.signature;
        } else {
            this.tokens.index = startIndex;
            dcl = this.declarator(context, null, 0, false, 0, false, false);
            type = dcl.type;
        }
        if (dcl.cppName == null || type.javaName.length() == 0 || dcl.parameters == null) {
            this.tokens.index = backIndex;
            return false;
        }
        int namespace = dcl.cppName.lastIndexOf("::");
        if (context.namespace != null && namespace < 0) {
            dcl.cppName = context.namespace + "::" + dcl.cppName;
        }
        Info info = null;
        if (dcl.parameters != null) {
            String name = dcl.cppName + "(";
            String separator = "";
            for (Declarator d : dcl.parameters.declarators) {
                if (d == null) continue;
                name = name + separator + d.type.cppName;
                for (int i = 0; i < d.indirections; ++i) {
                    name = name + "*";
                }
                if (d.reference) {
                    name = name + "&";
                }
                separator = ", ";
            }
            info = this.infoMap.getFirst(name = name + ")");
            if (!(info != null || type.constructor || type.destructor || type.operator)) {
                this.infoMap.put(new Info(name));
            }
        }
        if (info == null) {
            info = this.infoMap.getFirst(dcl.cppName);
        }
        if ((localName = dcl.cppName).startsWith(context.namespace + "::")) {
            localName = dcl.cppName.substring(context.namespace.length() + 2);
        }
        if (type.friend || context.javaName == null && localName.contains("::") || info != null && info.skip) {
            Token token = this.tokens.get();
            while (!token.match(Token.EOF) && this.attribute() != null) {
                token = this.tokens.get();
            }
            if (this.tokens.get().match(Character.valueOf(':'))) {
                token = this.tokens.next();
                while (!token.match(Token.EOF) && !token.match(Character.valueOf('{'), Character.valueOf(';'))) {
                    token = this.tokens.next();
                }
            }
            if (this.tokens.get().match(Character.valueOf('{'))) {
                this.body();
            } else {
                this.tokens.next();
            }
            decl.text = spacing;
            decl.function = true;
            declList.add(decl);
            return true;
        }
        if (type.staticMember || context.javaName == null) {
            modifiers = "public static native ";
            if (this.tokens.isCFile) {
                modifiers = "@NoException " + modifiers;
            }
        }
        ArrayList<Declarator> prevDcl = new ArrayList<Declarator>();
        boolean first = true;
        for (int n = -2; n < Integer.MAX_VALUE; ++n) {
            decl = new Declaration();
            this.tokens.index = startIndex;
            if ((type.constructor || type.destructor || type.operator) && params != null) {
                type = this.type(context);
                params = this.parameters(context, n / 2, n % 2 != 0);
                dcl = new Declarator();
                dcl.type = type;
                dcl.parameters = params;
                dcl.cppName = type.cppName;
                dcl.javaName = type.javaName.substring(type.javaName.lastIndexOf(32) + 1);
                if (type.operator) {
                    dcl.cppName = "operator " + dcl.cppName;
                    dcl.javaName = "as" + Character.toUpperCase(dcl.javaName.charAt(0)) + dcl.javaName.substring(1);
                }
                dcl.signature = dcl.javaName + params.signature;
                if (this.tokens.get().match(Character.valueOf(':'))) {
                    Token token = this.tokens.next();
                    while (!token.match(Token.EOF) && !token.match(Character.valueOf('{'), Character.valueOf(';'))) {
                        token = this.tokens.next();
                    }
                }
            } else {
                dcl = this.declarator(context, null, n / 2, n % 2 != 0, 0, false, false);
                type = dcl.type;
                namespace = dcl.cppName.lastIndexOf("::");
                if (context.namespace != null && namespace < 0) {
                    dcl.cppName = context.namespace + "::" + dcl.cppName;
                }
            }
            Token token = this.tokens.get();
            while (!token.match(Token.EOF)) {
                decl.constMember |= token.match(Token.CONST, Token.CONSTEXPR);
                if (this.attribute() == null) break;
                token = this.tokens.get();
            }
            if (this.tokens.get().match(Character.valueOf('{'))) {
                this.body();
            } else {
                if (this.tokens.get().match(Character.valueOf('='))) {
                    token = this.tokens.next().expect("0", Token.DELETE, Token.DEFAULT);
                    if (token.match("0")) {
                        decl.abstractMember = true;
                    } else if (token.match(Token.DELETE)) {
                        decl.text = spacing;
                        declList.add(decl);
                        return true;
                    }
                    this.tokens.next().expect(Character.valueOf(';'));
                }
                this.tokens.next();
            }
            if (type.virtual && context.virtualize) {
                modifiers = "@Virtual" + (decl.abstractMember ? "(true) " : " ") + (context.inaccessible ? "protected native " : "public native ");
            }
            decl.declarator = dcl;
            if (context.namespace != null && context.javaName == null) {
                decl.text = decl.text + "@Namespace(\"" + context.namespace + "\") ";
            }
            decl.text = type.constructor && params != null ? decl.text + "public " + type.annotations + context.shorten(context.javaName) + dcl.parameters.list + " { super((Pointer)null); allocate" + params.names + "; }\nprivate native void allocate" + dcl.parameters.list + ";\n" : decl.text + modifiers + type.annotations + context.shorten(type.javaName) + " " + dcl.javaName + dcl.parameters.list + ";\n";
            decl.signature = dcl.signature;
            if (info != null && info.javaText != null) {
                if (!first) break;
                decl.text = info.javaText;
            }
            String comment = this.commentAfter();
            if (first) {
                declList.spacing = spacing;
                decl.text = comment + decl.text;
            }
            decl.function = true;
            boolean found = false;
            for (Declarator d : prevDcl) {
                found |= dcl.signature.equals(d.signature);
            }
            if (dcl.javaName.length() > 0 && !found && (!type.destructor || info != null && info.javaText != null)) {
                if (declList.add(decl)) {
                    first = false;
                }
                if (type.virtual && context.virtualize) {
                    break;
                }
            } else if (found && n / 2 > 0 && n % 2 == 0) break;
            prevDcl.add(dcl);
        }
        declList.spacing = null;
        return true;
    }

    boolean variable(Context context, DeclarationList declList) throws ParserException {
        Info info;
        int backIndex = this.tokens.index;
        String spacing = this.tokens.get().spacing;
        String modifiers = "public static native ";
        String setterType = "void ";
        Declarator dcl = this.declarator(context, null, 0, false, 0, false, true);
        Declaration decl = new Declaration();
        String cppName = dcl.cppName;
        String javaName = dcl.javaName;
        if (javaName == null || !this.tokens.get().match(Character.valueOf('['), Character.valueOf('='), Character.valueOf(','), Character.valueOf(':'), Character.valueOf(';'))) {
            this.tokens.index = backIndex;
            return false;
        }
        if (!dcl.type.staticMember && context.javaName != null) {
            modifiers = "public native ";
            setterType = context.shorten(context.javaName) + " ";
        }
        int namespace = cppName.lastIndexOf("::");
        if (context.namespace != null && namespace < 0) {
            cppName = context.namespace + "::" + cppName;
        }
        if ((info = this.infoMap.getFirst(cppName)) != null && info.skip) {
            decl.text = spacing;
            declList.add(decl);
            return true;
        }
        if (info == null) {
            Info info2 = this.infoMap.getFirst(dcl.cppName);
            this.infoMap.put(info2 != null ? new Info(info2).cppNames(cppName) : new Info(cppName));
        }
        boolean first = true;
        Declarator metadcl = context.variable;
        for (int n = 0; n < Integer.MAX_VALUE; ++n) {
            int i;
            String indices;
            decl = new Declaration();
            this.tokens.index = backIndex;
            dcl = this.declarator(context, null, -1, false, n, false, true);
            if (dcl == null || dcl.cppName == null) break;
            decl.declarator = dcl;
            cppName = dcl.cppName;
            namespace = cppName.lastIndexOf("::");
            if (context.namespace != null && namespace < 0) {
                cppName = context.namespace + "::" + cppName;
            }
            info = this.infoMap.getFirst(cppName);
            namespace = cppName.lastIndexOf("::");
            String shortName = cppName;
            if (namespace >= 0) {
                shortName = cppName.substring(namespace + 2);
            }
            javaName = dcl.javaName;
            if (metadcl == null || metadcl.indices == 0 || dcl.indices == 0) {
                String rawType;
                indices = "";
                for (i = 0; i < (metadcl == null || metadcl.indices == 0 ? dcl.indices : metadcl.indices); ++i) {
                    if (i > 0) {
                        indices = indices + ", ";
                    }
                    indices = indices + "int " + (char)(105 + i);
                }
                if (context.namespace != null && context.javaName == null) {
                    decl.text = decl.text + "@Namespace(\"" + context.namespace + "\") ";
                }
                if (metadcl != null && metadcl.cppName.length() > 0) {
                    decl.text = decl.text + (metadcl.indices == 0 ? "@Name(\"" + metadcl.cppName + "." + shortName + "\") " : "@Name({\"" + metadcl.cppName + "\", \"." + shortName + "\"}) ");
                    javaName = metadcl.javaName + "_" + dcl.javaName;
                }
                if (dcl.type.constValue) {
                    decl.text = decl.text + "@MemberGetter ";
                }
                decl.text = decl.text + modifiers + dcl.type.annotations.replace("@ByVal ", "@ByRef ") + dcl.type.javaName + " " + javaName + "(" + indices + ");";
                if (!dcl.type.constValue) {
                    if (indices.length() > 0) {
                        indices = indices + ", ";
                    }
                    decl.text = decl.text + " " + modifiers + setterType + javaName + "(" + indices + dcl.type.javaName + " " + javaName + ");";
                }
                decl.text = decl.text + "\n";
                if (dcl.type.constValue && dcl.type.staticMember && indices.length() == 0 && ("byte".equals(rawType = dcl.type.javaName.substring(dcl.type.javaName.lastIndexOf(32) + 1)) || "short".equals(rawType) || "int".equals(rawType) || "long".equals(rawType) || "float".equals(rawType) || "double".equals(rawType) || "char".equals(rawType) || "boolean".equals(rawType))) {
                    decl.text = decl.text + "public static final " + rawType + " " + javaName + " = " + javaName + "();\n";
                }
            }
            if (dcl.indices > 0) {
                this.tokens.index = backIndex;
                dcl = this.declarator(context, null, -1, false, n, true, false);
                indices = "";
                for (i = 0; i < (metadcl == null ? 0 : metadcl.indices); ++i) {
                    if (i > 0) {
                        indices = indices + ", ";
                    }
                    indices = indices + "int " + (char)(105 + i);
                }
                if (context.namespace != null && context.javaName == null) {
                    decl.text = decl.text + "@Namespace(\"" + context.namespace + "\") ";
                }
                if (metadcl != null && metadcl.cppName.length() > 0) {
                    decl.text = decl.text + (metadcl.indices == 0 ? "@Name(\"" + metadcl.cppName + "." + shortName + "\") " : "@Name({\"" + metadcl.cppName + "\", \"." + shortName + "\"}) ");
                    javaName = metadcl.javaName + "_" + dcl.javaName;
                }
                decl.text = decl.text + "@MemberGetter " + modifiers + dcl.type.annotations.replace("@ByVal ", "@ByRef ") + dcl.type.javaName + " " + javaName + "(" + indices + ");\n";
            }
            decl.signature = dcl.signature;
            if (info != null && info.javaText != null) {
                decl.text = info.javaText;
                decl.declarator = null;
            }
            while (!this.tokens.get().match(Token.EOF, Character.valueOf(';'))) {
                this.tokens.next();
            }
            this.tokens.next();
            String comment = this.commentAfter();
            if (first) {
                first = false;
                declList.spacing = spacing;
                decl.text = comment + decl.text;
            }
            decl.variable = true;
            declList.add(decl);
        }
        declList.spacing = null;
        return true;
    }

    boolean macro(Context context, DeclarationList declList) throws ParserException {
        int backIndex = this.tokens.index;
        if (!this.tokens.get().match(Character.valueOf('#'))) {
            return false;
        }
        this.tokens.raw = true;
        String spacing = this.tokens.get().spacing;
        Token keyword = this.tokens.next();
        this.tokens.next();
        int beginIndex = this.tokens.index;
        Token token = this.tokens.get();
        while (!token.match(Token.EOF) && token.spacing.indexOf(10) < 0) {
            token = this.tokens.next();
        }
        int endIndex = this.tokens.index;
        while (this.tokens.get(-1).match(4)) {
            --this.tokens.index;
        }
        int lastIndex = this.tokens.index;
        Declaration decl = new Declaration();
        if (keyword.match(Token.DEFINE) && beginIndex < endIndex) {
            this.tokens.index = beginIndex;
            String macroName = this.tokens.get().value;
            Token first = this.tokens.next();
            boolean hasArgs = first.spacing.length() == 0 && first.match(Character.valueOf('('));
            List<Info> infoList = this.infoMap.get(macroName);
            for (Info info : infoList.size() > 0 ? infoList : Arrays.asList(new Info[]{null})) {
                int i;
                if (info != null && info.skip) break;
                if (info == null && (hasArgs || beginIndex + 1 == endIndex) || info != null && info.cppText == null && info.cppTypes != null && info.cppTypes.length == 0) {
                    info = new Info(macroName).cppText("");
                    this.tokens.index = backIndex;
                    Token token2 = this.tokens.get();
                    while (this.tokens.index < endIndex) {
                        info.cppText = info.cppText + (token2.match("\n") ? token2 : token2.spacing + token2);
                        token2 = this.tokens.next();
                    }
                    this.infoMap.putFirst(info);
                    break;
                }
                if (info != null && info.cppText == null && info.cppTypes != null && info.cppTypes.length > (hasArgs ? 0 : 1)) {
                    ArrayList<Declarator> prevDcl = new ArrayList<Declarator>();
                    for (int n = -1; n < Integer.MAX_VALUE; ++n) {
                        int count = 1;
                        this.tokens.index = beginIndex + 2;
                        String params = "(";
                        Token token3 = this.tokens.get();
                        while (hasArgs && this.tokens.index < lastIndex && count < info.cppTypes.length) {
                            if (token3.match(5)) {
                                String type = info.cppTypes[count];
                                String name = token3.value;
                                if (name.equals("...")) {
                                    name = "arg" + count;
                                }
                                params = params + type + " " + name;
                                if (++count < info.cppTypes.length) {
                                    params = params + ", ";
                                }
                            } else if (token3.match(Character.valueOf(')'))) break;
                            token3 = this.tokens.next();
                        }
                        while (count < info.cppTypes.length) {
                            String type = info.cppTypes[count];
                            String name = "arg" + count;
                            params = params + type + " " + name;
                            if (++count >= info.cppTypes.length) continue;
                            params = params + ", ";
                        }
                        params = params + ")";
                        Declarator dcl = new Parser(this, info.cppTypes[0] + " " + macroName + params).declarator(context, null, n, false, 0, false, false);
                        for (i = 0; i < info.cppNames.length; ++i) {
                            if (!macroName.equals(info.cppNames[i]) || info.javaNames == null) continue;
                            macroName = "@Name(\"" + info.cppNames[0] + "\") " + info.javaNames[i];
                            break;
                        }
                        boolean found = false;
                        for (Declarator d : prevDcl) {
                            found |= dcl.signature.equals(d.signature);
                        }
                        if (!found) {
                            decl.text = decl.text + "public static native " + dcl.type.annotations + dcl.type.javaName + " " + macroName + dcl.parameters.list + ";\n";
                        } else if (found && n > 0) break;
                        prevDcl.add(dcl);
                    }
                } else if (info == null || info.cppText == null && (info.cppTypes == null || info.cppTypes.length == 1)) {
                    String value = "";
                    String type = "int";
                    String cat = "";
                    this.tokens.index = beginIndex + 1;
                    Token prevToken = new Token();
                    boolean translate = true;
                    Token token4 = this.tokens.get();
                    while (this.tokens.index < lastIndex) {
                        if (token4.match(3)) {
                            type = "String";
                            cat = " + ";
                            break;
                        }
                        if (token4.match(2)) {
                            type = "double";
                            cat = "";
                            break;
                        }
                        if (token4.match(1) && token4.value.endsWith("L")) {
                            type = "long";
                            cat = "";
                            break;
                        }
                        if (prevToken.match(5, Character.valueOf('>')) && token4.match(Character.valueOf('(')) || token4.match(Character.valueOf('{'), Character.valueOf('}'))) {
                            translate = false;
                        }
                        prevToken = token4;
                        token4 = this.tokens.next();
                    }
                    if (info != null) {
                        if (info.cppTypes != null) {
                            Declarator dcl = new Parser(this, info.cppTypes[0]).declarator(context, null, -1, false, 0, false, true);
                            type = dcl.type.annotations + dcl.type.javaName;
                        }
                        for (int i2 = 0; i2 < info.cppNames.length; ++i2) {
                            if (!macroName.equals(info.cppNames[i2]) || info.javaNames == null) continue;
                            macroName = "@Name(\"" + info.cppNames[0] + "\") " + info.javaNames[i2];
                            break;
                        }
                        translate = info.translate;
                    }
                    this.tokens.index = beginIndex + 1;
                    if (translate) {
                        token = this.tokens.get();
                        while (this.tokens.index < lastIndex) {
                            value = value + token.spacing + token + (this.tokens.index + 1 < lastIndex ? cat : "");
                            token = this.tokens.next();
                        }
                        value = this.translate(value);
                    } else {
                        decl.text = decl.text + "public static native @MemberGetter " + type + " " + macroName + "();\n";
                        value = " " + macroName + "()";
                    }
                    i = type.lastIndexOf(32);
                    if (i >= 0) {
                        type = type.substring(i + 1);
                    }
                    if (value.length() > 0) {
                        decl.text = decl.text + "public static final " + type + " " + macroName + " =" + value + ";\n";
                    }
                    decl.signature = macroName;
                }
                if (info == null || info.javaText == null) continue;
                decl.text = info.javaText;
                break;
            }
        }
        if (decl.text.length() == 0) {
            this.tokens.index = beginIndex;
            int n = spacing.lastIndexOf(10) + 1;
            decl.text = decl.text + "// " + spacing.substring(n) + "#" + keyword.spacing + keyword;
            Token token5 = this.tokens.get();
            while (this.tokens.index < lastIndex) {
                decl.text = decl.text + (token5.match("\n") ? "\n// " : token5.spacing + token5.toString().replace("\n", "\n//"));
                token5 = this.tokens.next();
            }
            spacing = spacing.substring(0, n);
        }
        if (decl.text.length() > 0) {
            this.tokens.index = lastIndex;
            String comment = this.commentAfter();
            decl.text = comment + decl.text;
        }
        this.tokens.raw = false;
        declList.spacing = spacing;
        declList.add(decl);
        declList.spacing = null;
        return true;
    }

    boolean typedef(Context context, DeclarationList declList) throws ParserException {
        Info info;
        String spacing = this.tokens.get().spacing;
        if (!this.tokens.get().match(Token.TYPEDEF)) {
            return false;
        }
        Declaration decl = new Declaration();
        Declarator dcl = this.declarator(context, null, 0, false, 0, true, false);
        this.tokens.next();
        String typeName = dcl.type.cppName;
        String defName = dcl.cppName;
        if (context.namespace != null) {
            defName = context.namespace + "::" + defName;
        }
        if (dcl.definition != null) {
            decl = dcl.definition;
            if (dcl.javaName.length() > 0 && context.javaName != null) {
                dcl.javaName = context.javaName + "." + dcl.javaName;
            }
            this.infoMap.put(new Info(defName).valueTypes(dcl.javaName).pointerTypes((dcl.indirections > 0 ? "@ByPtrPtr " : "") + dcl.javaName));
        } else if (typeName.equals("void")) {
            info = this.infoMap.getFirst(defName);
            if (info == null || !info.skip) {
                if (dcl.indirections > 0) {
                    decl.text = decl.text + "@Namespace @Name(\"void\") ";
                    info = info != null ? new Info(info) : new Info(defName);
                    this.infoMap.put(info.valueTypes(dcl.javaName).pointerTypes("@ByPtrPtr " + dcl.javaName));
                } else if (context.namespace != null && context.javaName == null) {
                    decl.text = decl.text + "@Namespace(\"" + context.namespace + "\") ";
                }
                decl.text = decl.text + "@Opaque public static class " + dcl.javaName + " extends Pointer {\n    /** Empty constructor. Calls {@code super((Pointer)null)}. */\n    public " + dcl.javaName + "() { super((Pointer)null); }\n    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */\n    public " + dcl.javaName + "(Pointer p) { super(p); }\n}";
            }
        } else {
            info = this.infoMap.getFirst(typeName);
            if (info == null || !info.skip) {
                Info info2 = info = info != null ? new Info(info).cppNames(defName) : new Info(defName);
                if (info.cppTypes == null && info.annotations != null) {
                    String s = typeName;
                    if (dcl.type.constValue && !s.startsWith("const ")) {
                        s = "const " + s;
                    }
                    if (dcl.type.constPointer && !s.endsWith(" const")) {
                        s = s + " const";
                    }
                    if (dcl.type.indirections > 0) {
                        for (int i = 0; i < dcl.type.indirections; ++i) {
                            s = s + "*";
                        }
                    }
                    if (dcl.type.reference) {
                        s = s + "&";
                    }
                    info.cppNames(defName, s).cppTypes(s);
                }
                if (info.valueTypes == null && dcl.indirections > 0) {
                    String[] stringArray;
                    if (info.pointerTypes != null) {
                        stringArray = info.pointerTypes;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = typeName;
                    }
                    info.valueTypes(stringArray);
                    info.pointerTypes("PointerPointer");
                } else if (info.pointerTypes == null) {
                    info.pointerTypes(typeName);
                }
                if (info.annotations == null) {
                    info.cast(!dcl.cppName.equals(info.pointerTypes[0]));
                }
                this.infoMap.put(info);
            }
        }
        String comment = this.commentAfter();
        decl.text = comment + decl.text;
        declList.spacing = spacing;
        declList.add(decl);
        declList.spacing = null;
        return true;
    }

    boolean using(Context context, DeclarationList declList) throws ParserException {
        if (!this.tokens.get().match(Token.USING)) {
            return false;
        }
        String spacing = this.tokens.get().spacing;
        boolean namespace = this.tokens.get(1).match(Token.NAMESPACE);
        Declarator dcl = this.declarator(context, null, 0, false, 0, true, false);
        this.tokens.next();
        context.usingList.add(dcl.type.cppName + (namespace ? "::" : ""));
        Declaration decl = new Declaration();
        if (dcl.definition != null) {
            decl = dcl.definition;
        }
        String comment = this.commentAfter();
        decl.text = comment + decl.text;
        declList.spacing = spacing;
        declList.add(decl);
        declList.spacing = null;
        return true;
    }

    boolean group(Context context, DeclarationList declList) throws ParserException {
        Info info;
        int backIndex = this.tokens.index;
        String spacing = this.tokens.get().spacing;
        boolean typedef = this.tokens.get().match(Token.TYPEDEF);
        boolean foundGroup = false;
        boolean friend = false;
        Context ctx = new Context(context);
        Token token = this.tokens.get();
        while (!token.match(Token.EOF)) {
            if (token.match(Token.CLASS, Token.INTERFACE, Token.__INTERFACE, Token.STRUCT, Token.UNION)) {
                foundGroup = true;
                ctx.inaccessible = token.match(Token.CLASS);
                break;
            }
            if (token.match(Token.FRIEND)) {
                friend = true;
            } else if (!token.match(5)) break;
            token = this.tokens.next();
        }
        if (!foundGroup) {
            this.tokens.index = backIndex;
            return false;
        }
        this.tokens.next().expect(5, Character.valueOf('{'), "::");
        if (!this.tokens.get().match(Character.valueOf('{')) && this.tokens.get(1).match(5) && (typedef || !this.tokens.get(2).match(Character.valueOf(';')))) {
            this.tokens.next();
        }
        Type type = this.type(context);
        ArrayList<Type> baseClasses = new ArrayList<Type>();
        Declaration decl = new Declaration();
        decl.text = type.annotations;
        String name = type.javaName;
        boolean anonymous = !typedef && type.cppName.length() == 0;
        boolean derivedClass = false;
        if (type.cppName.length() > 0 && this.tokens.get().match(Character.valueOf(':'))) {
            derivedClass = true;
            Token token2 = this.tokens.next();
            while (!token2.match(Token.EOF)) {
                boolean accessible = false;
                if (!token2.match(Token.VIRTUAL)) {
                    if (token2.match(Token.PRIVATE, Token.PROTECTED, Token.PUBLIC)) {
                        accessible = token2.match(Token.PUBLIC);
                        this.tokens.next();
                    }
                    Type t = this.type(context);
                    if (accessible) {
                        baseClasses.add(t);
                    }
                    if (this.tokens.get().expect(Character.valueOf(','), Character.valueOf('{')).match(Character.valueOf('{'))) break;
                }
                token2 = this.tokens.next();
            }
        }
        if (typedef && type.indirections > 0) {
            while (!this.tokens.get().match(Character.valueOf(';'), Token.EOF)) {
                this.tokens.next();
            }
        }
        if (!this.tokens.get().match(Character.valueOf('{'), Character.valueOf(';'))) {
            this.tokens.index = backIndex;
            return false;
        }
        int startIndex = this.tokens.index;
        ArrayList<Declarator> variables = new ArrayList<Declarator>();
        String originalName = type.cppName;
        if (this.body() != null && !this.tokens.get().match(Character.valueOf(';'))) {
            if (typedef) {
                Token prevToken = null;
                Token token3 = this.tokens.get();
                while (!token3.match(Token.EOF)) {
                    if (token3.match(Character.valueOf(';'))) {
                        decl.text = decl.text + token3.spacing;
                        break;
                    }
                    if ((prevToken == null || prevToken.match(Character.valueOf('}'), Character.valueOf(','))) && token3.match(5)) {
                        type.javaName = type.cppName = token3.value;
                        name = type.cppName;
                    }
                    prevToken = token3;
                    token3 = this.tokens.next();
                }
            } else {
                int n;
                int index = this.tokens.index - 1;
                for (n = 0; n < Integer.MAX_VALUE; ++n) {
                    this.tokens.index = index;
                    Declarator dcl = this.declarator(context, null, -1, false, n, false, true);
                    if (dcl == null) break;
                    variables.add(dcl);
                }
                if ((n = spacing.lastIndexOf(10)) >= 0) {
                    decl.text = decl.text + spacing.substring(0, n);
                }
            }
        }
        int namespace = type.cppName.lastIndexOf("::");
        if (context.namespace != null && namespace < 0) {
            type.cppName = context.namespace + "::" + type.cppName;
            originalName = context.namespace + "::" + originalName;
        }
        if ((info = this.infoMap.getFirst(type.cppName)) != null && info.skip) {
            decl.text = "";
            declList.add(decl);
            return true;
        }
        if (info != null && info.pointerTypes != null && info.pointerTypes.length > 0) {
            type.javaName = info.pointerTypes[0];
            name = context.shorten(type.javaName);
        } else if (info == null) {
            if (type.javaName.length() > 0 && context.javaName != null) {
                type.javaName = context.javaName + "." + type.javaName;
            }
            info = new Info(type.cppName).pointerTypes(type.javaName);
            this.infoMap.put(info);
        }
        Type base = new Type("Pointer");
        Iterator it = baseClasses.iterator();
        while (it.hasNext()) {
            Type next = (Type)it.next();
            Info nextInfo = this.infoMap.getFirst(next.cppName);
            if (nextInfo != null && nextInfo.flatten) continue;
            base = next;
            it.remove();
            break;
        }
        String casts = "";
        if (baseClasses.size() > 0) {
            for (Type t : baseClasses) {
                casts = casts + "    public " + t.javaName + " as" + t.javaName + "() { return as" + t.javaName + "(this); }\n    @Namespace public static native @Name(\"static_cast<" + t.cppName + "*>\") " + t.javaName + " as" + t.javaName + "(" + type.javaName + " pointer);\n";
            }
        }
        decl.signature = type.javaName;
        this.tokens.index = startIndex;
        if (name.length() > 0 && this.tokens.get().match(Character.valueOf(';'))) {
            String fullName;
            this.tokens.next();
            if (friend) {
                decl.text = "";
                declList.add(decl);
                return true;
            }
            if (info != null && info.base != null) {
                base.javaName = info.base;
            }
            String string = fullName = context.namespace != null ? context.namespace + "::" + name : name;
            if (!fullName.equals(type.cppName)) {
                decl.text = decl.text + "@Name(\"" + (context.javaName == null || namespace < 0 ? type.cppName : type.cppName.substring(namespace + 2)) + "\") ";
            } else if (context.namespace != null && context.javaName == null) {
                decl.text = decl.text + "@Namespace(\"" + context.namespace + "\") ";
            }
            decl.text = decl.text + "@Opaque public static class " + name + " extends " + base.javaName + " {\n    /** Empty constructor. Calls {@code super((Pointer)null)}. */\n    public " + name + "() { super((Pointer)null); }\n    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */\n    public " + name + "(Pointer p) { super(p); }\n}";
            decl.type = type;
            decl.incomplete = true;
            String comment = this.commentAfter();
            decl.text = (String)comment + decl.text;
            declList.spacing = spacing;
            declList.add(decl);
            declList.spacing = null;
            return true;
        }
        if (this.tokens.get().match(Character.valueOf('{'))) {
            this.tokens.next();
        }
        if (!anonymous) {
            ctx.namespace = type.cppName;
            ctx.cppName = originalName;
            ctx.javaName = type.javaName;
        }
        if (info != null && info.virtualize) {
            ctx.virtualize = true;
        }
        DeclarationList declList2 = new DeclarationList();
        if (variables.size() == 0) {
            this.declarations(ctx, declList2);
        } else {
            for (Declarator var : variables) {
                if (context.variable != null) {
                    var.cppName = context.variable.cppName + "." + var.cppName;
                    var.javaName = context.variable.javaName + "_" + var.javaName;
                }
                ctx.variable = var;
                this.declarations(ctx, declList2);
            }
        }
        String modifiers = "public static ";
        boolean implicitConstructor = true;
        boolean defaultConstructor = false;
        boolean longConstructor = false;
        boolean pointerConstructor = false;
        boolean abstractClass = info != null && info.purify && !ctx.virtualize;
        boolean havePureConst = false;
        boolean haveVariables = false;
        for (Declaration d : declList2) {
            if (d.declarator != null && d.declarator.type != null && d.declarator.type.constructor) {
                implicitConstructor = false;
                Declarator[] paramDcls = d.declarator.parameters.declarators;
                defaultConstructor |= (paramDcls.length == 0 || paramDcls.length == 1 && paramDcls[0].type.javaName.equals("void")) && !d.inaccessible;
                longConstructor |= paramDcls.length == 1 && paramDcls[0].type.javaName.equals("long") && !d.inaccessible;
                pointerConstructor |= paramDcls.length == 1 && paramDcls[0].type.javaName.equals("Pointer") && !d.inaccessible;
            }
            abstractClass |= d.abstractMember;
            havePureConst |= d.constMember && d.abstractMember;
            haveVariables |= d.variable;
        }
        if (havePureConst && ctx.virtualize) {
            modifiers = "@Const " + modifiers;
        }
        if (!anonymous) {
            Iterator fullName;
            Iterator iterator = fullName = context.namespace != null ? context.namespace + "::" + name : name;
            if (!((String)((Object)fullName)).equals(type.cppName)) {
                decl.text = decl.text + "@Name(\"" + type.cppName + "\") ";
            } else if (context.namespace != null && context.javaName == null) {
                decl.text = decl.text + "@Namespace(\"" + context.namespace + "\") ";
            }
            if ((!implicitConstructor || derivedClass) && haveVariables) {
                decl.text = decl.text + "@NoOffset ";
            }
            if (info != null && info.base != null) {
                base.javaName = info.base;
            }
            decl.text = decl.text + modifiers + "class " + name + " extends " + base.javaName + " {\n    static { Loader.load(); }\n";
            if (implicitConstructor && (!abstractClass || ctx.virtualize)) {
                decl.text = decl.text + "    /** Default native constructor. */\n    public " + name + "() { super((Pointer)null); allocate(); }\n    /** Native array allocator. Access with {@link Pointer#position(long)}. */\n    public " + name + "(long size) { super((Pointer)null); allocateArray(size); }\n    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */\n    public " + name + "(Pointer p) { super(p); }\n    private native void allocate();\n    private native void allocateArray(long size);\n    @Override public " + name + " position(long position) {\n        return (" + name + ")super.position(position);\n    }\n";
            } else {
                if (!pointerConstructor) {
                    decl.text = decl.text + "    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */\n    public " + name + "(Pointer p) { super(p); }\n";
                }
                if (defaultConstructor && (!abstractClass || ctx.virtualize) && !longConstructor) {
                    decl.text = decl.text + "    /** Native array allocator. Access with {@link Pointer#position(long)}. */\n    public " + name + "(long size) { super((Pointer)null); allocateArray(size); }\n    private native void allocateArray(long size);\n    @Override public " + name + " position(long position) {\n        return (" + name + ")super.position(position);\n    }\n";
                }
            }
            declList.spacing = spacing;
            decl.text = declList.rescan(decl.text + casts + "\n");
            declList.spacing = null;
        }
        for (Type base2 : baseClasses) {
            Info baseInfo = this.infoMap.getFirst(base2.cppName);
            if (baseInfo == null || !baseInfo.flatten || baseInfo.javaText == null) continue;
            String text = baseInfo.javaText;
            int start = text.indexOf(123);
            int n = 0;
            while (n < 2) {
                char c = text.charAt(start);
                if (c == '\n') {
                    ++n;
                } else if (!Character.isWhitespace((int)c)) {
                    n = 0;
                }
                ++start;
            }
            int end = text.lastIndexOf(125);
            decl.text = decl.text + text.substring(start, end).replaceAll("(\\s+)" + base2.javaName + "(\\s+)", "$1" + type.javaName + "$2");
        }
        for (Declaration d : declList2) {
            if (d.inaccessible || d.declarator != null && d.declarator.type != null && d.declarator.type.constructor && abstractClass) continue;
            decl.text = decl.text + d.text;
        }
        if (!anonymous) {
            decl.text = decl.text + this.tokens.get().spacing + '}';
        }
        Token token4 = this.tokens.next();
        while (!token4.match(Token.EOF)) {
            if (token4.match(Character.valueOf(';'))) {
                decl.text = decl.text + token4.spacing;
                break;
            }
            token4 = this.tokens.next();
        }
        this.tokens.next();
        decl.type = type;
        if (info != null && info.javaText != null) {
            decl.text = info.javaText;
        } else if (info != null && info.flatten) {
            info.javaText = decl.text;
        }
        declList.add(decl);
        return true;
    }

    boolean enumeration(Context context, DeclarationList declList) throws ParserException {
        Info info;
        String comment;
        int backIndex = this.tokens.index;
        String enumSpacing = this.tokens.get().spacing;
        boolean typedef = this.tokens.get().match(Token.TYPEDEF);
        boolean foundEnum = false;
        Token token = this.tokens.get();
        while (!token.match(Token.EOF)) {
            if (token.match(Token.ENUM)) {
                foundEnum = true;
                break;
            }
            if (!token.match(5)) break;
            token = this.tokens.next();
        }
        if (!foundEnum) {
            this.tokens.index = backIndex;
            return false;
        }
        String enumType = "enum";
        if (this.tokens.get(1).match(Token.CLASS, Token.STRUCT)) {
            enumType = enumType + " " + this.tokens.next();
        }
        if (typedef && !this.tokens.get(1).match(Character.valueOf('{')) && this.tokens.get(2).match(5)) {
            this.tokens.next();
        }
        int count = 0;
        boolean longenum = false;
        String cppType = "int";
        String javaType = "int";
        String separator = "";
        String enumPrefix = "public static final " + javaType;
        String countPrefix = " ";
        String enumerators = "";
        String extraText = "";
        String name = "";
        Token token2 = this.tokens.next().expect(5, Character.valueOf('{'), Character.valueOf(':'), Character.valueOf(';'));
        if (token2.match(5)) {
            name = token2.value;
            token2 = this.tokens.next();
        }
        if (token2.match(Character.valueOf(':'))) {
            token2 = this.tokens.next();
            Type type = this.type(context);
            cppType = type.cppName;
            javaType = type.javaName;
            enumPrefix = "public static final " + javaType;
            token2 = this.tokens.get();
        }
        if (typedef || !token2.match(Character.valueOf(';'))) {
            if (!token2.match(Character.valueOf('{'))) {
                this.tokens.index = backIndex;
                return false;
            }
            token2 = this.tokens.next();
            while (!token2.match(Token.EOF, Character.valueOf('}'))) {
                comment = this.commentBefore();
                if (this.macro(context, declList)) {
                    Declaration macroDecl = (Declaration)declList.remove(declList.size() - 1);
                    extraText = extraText + comment + macroDecl.text;
                    if (separator.equals(",") && !macroDecl.text.trim().startsWith("//")) {
                        separator = ";";
                        enumPrefix = "\npublic static final " + javaType;
                    }
                } else {
                    Info info2;
                    String cppName;
                    Token enumerator = this.tokens.get();
                    String javaName = cppName = enumerator.value;
                    if (context.namespace != null) {
                        cppName = context.namespace + "::" + cppName;
                    }
                    if ((info2 = this.infoMap.getFirst(cppName)) != null && info2.javaNames != null && info2.javaNames.length > 0) {
                        javaName = info2.javaNames[0];
                    } else if (info2 == null) {
                        info2 = new Info(cppName);
                        this.infoMap.put(info2);
                    }
                    String spacing2 = " ";
                    if (this.tokens.next().match(Character.valueOf('='))) {
                        spacing2 = this.tokens.get().spacing;
                        countPrefix = " ";
                        int count2 = 0;
                        Token prevToken = new Token();
                        boolean translate = true;
                        token2 = this.tokens.next();
                        while (!token2.match(Token.EOF, Character.valueOf(','), Character.valueOf('}')) || count2 > 0) {
                            if (token2.match(1) && token2.value.endsWith("L")) {
                                longenum = true;
                            }
                            countPrefix = countPrefix + token2.spacing + token2;
                            if (token2.match(Character.valueOf('('))) {
                                ++count2;
                            } else if (token2.match(Character.valueOf(')'))) {
                                --count2;
                            }
                            if (prevToken.match(5) && token2.match(Character.valueOf('(')) || token2.match(Character.valueOf('{'), Character.valueOf('}'))) {
                                translate = false;
                            }
                            prevToken = token2;
                            token2 = this.tokens.next();
                        }
                        try {
                            count = Integer.parseInt(countPrefix.trim());
                            countPrefix = " ";
                        }
                        catch (NumberFormatException e) {
                            count = 0;
                            if (translate) {
                                countPrefix = this.translate(countPrefix);
                            }
                            if (separator.equals(",")) {
                                separator = ";";
                            }
                            extraText = "\npublic static native @MemberGetter " + javaType + " " + javaName + "();\n";
                            enumPrefix = "public static final " + javaType;
                            countPrefix = " " + javaName + "()";
                        }
                    }
                    enumerators = enumerators + separator + extraText + enumPrefix + comment;
                    separator = ",";
                    enumPrefix = "";
                    extraText = "";
                    comment = this.commentAfter();
                    if (comment.length() == 0 && this.tokens.get().match(Character.valueOf(','))) {
                        this.tokens.next();
                        comment = this.commentAfter();
                    }
                    String spacing = enumerator.spacing;
                    if (comment.length() > 0) {
                        enumerators = enumerators + spacing + comment;
                        int newline = spacing.lastIndexOf(10);
                        if (newline >= 0) {
                            spacing = spacing.substring(newline + 1);
                        }
                    }
                    if (spacing.length() == 0 && !enumerators.endsWith(",")) {
                        spacing = " ";
                    }
                    enumerators = enumerators + spacing + javaName + spacing2 + "=" + countPrefix;
                    if (countPrefix.trim().length() > 0) {
                        if (count > 0) {
                            enumerators = enumerators + " + " + count;
                        }
                    } else {
                        enumerators = enumerators + count;
                    }
                    ++count;
                }
                token2 = this.tokens.get();
            }
        }
        comment = this.commentBefore();
        Declaration decl = new Declaration();
        token2 = this.tokens.get();
        if (!token2.match(Character.valueOf(';'))) {
            token2 = this.tokens.next();
        }
        if (token2.match(5)) {
            name = token2.value;
            token2 = this.tokens.next();
        }
        if (context.namespace != null) {
            name = context.namespace + "::" + name;
        }
        if ((info = this.infoMap.getFirst(name)) != null && info.skip) {
            decl.text = enumSpacing;
        } else {
            decl.text = decl.text + enumSpacing + "/** " + enumType + " " + name + " */\n";
            int newline = enumSpacing.lastIndexOf(10);
            if (newline >= 0) {
                enumSpacing = enumSpacing.substring(newline + 1);
            }
            decl.text = decl.text + enumSpacing + enumerators + token2.expect((Object[])new Object[]{Character.valueOf((char)';')}).spacing + ";";
            if (name.length() > 0) {
                if (longenum) {
                    decl.text = decl.text.replace(" " + javaType, " long");
                    cppType = "long long";
                    javaType = "long";
                }
                Info info2 = this.infoMap.getFirst(cppType);
                this.infoMap.put(new Info(info2).cast().cppNames(name));
            }
            decl.text = decl.text + extraText + comment;
        }
        declList.add(decl);
        this.tokens.next();
        return true;
    }

    boolean namespace(Context context, DeclarationList declList) throws ParserException {
        if (!this.tokens.get().match(Token.NAMESPACE)) {
            return false;
        }
        Declaration decl = new Declaration();
        String spacing = this.tokens.get().spacing;
        String name = null;
        this.tokens.next();
        if (this.tokens.get().match(5)) {
            name = this.tokens.get().value;
            this.tokens.next();
        }
        if (this.tokens.get().match(Character.valueOf('='))) {
            this.tokens.next();
            Type type = this.type(context);
            context.namespaceMap.put(name, type.cppName);
            this.tokens.get().expect(Character.valueOf(';'));
            this.tokens.next();
            return true;
        }
        this.tokens.get().expect(Character.valueOf('{'));
        this.tokens.next();
        if (this.tokens.get().spacing.indexOf(10) < 0) {
            this.tokens.get().spacing = spacing;
        }
        context = new Context(context);
        context.namespace = name == null ? null : (context.namespace != null ? context.namespace + "::" + name : name);
        this.declarations(context, declList);
        decl.text = decl.text + this.tokens.get().expect((Object[])new Object[]{Character.valueOf((char)'}')}).spacing;
        this.tokens.next();
        declList.add(decl);
        return true;
    }

    boolean extern(Context context, DeclarationList declList) throws ParserException {
        if (!this.tokens.get().match(Token.EXTERN) || !this.tokens.get(1).match(3)) {
            return false;
        }
        String spacing = this.tokens.get().spacing;
        Declaration decl = new Declaration();
        this.tokens.next().expect("\"C\"");
        if (!this.tokens.next().match(Character.valueOf('{'))) {
            this.tokens.get().spacing = spacing;
            declList.add(decl);
            return true;
        }
        this.tokens.next();
        this.declarations(context, declList);
        this.tokens.get().expect(Character.valueOf('}'));
        this.tokens.next();
        declList.add(decl);
        return true;
    }

    void declarations(Context context, DeclarationList declList) throws ParserException {
        Token token = this.tokens.get();
        while (!token.match(Token.EOF, Character.valueOf('}'))) {
            if (token.match(Token.PRIVATE, Token.PROTECTED, Token.PUBLIC) && this.tokens.get(1).match(Character.valueOf(':'))) {
                context.inaccessible = !token.match(Token.PUBLIC);
                this.tokens.next();
                this.tokens.next();
            } else {
                Context ctx = context;
                String comment = this.commentBefore();
                token = this.tokens.get();
                String spacing = token.spacing;
                TemplateMap map = this.template(ctx);
                if (map != null) {
                    token = this.tokens.get();
                    token.spacing = spacing;
                    ctx = new Context(ctx);
                    ctx.templateMap = map;
                }
                Declaration decl = new Declaration();
                if (comment != null && comment.length() > 0) {
                    decl.inaccessible = ctx.inaccessible;
                    decl.text = comment;
                    declList.add(decl);
                }
                int startIndex = this.tokens.index;
                declList.infoMap = this.infoMap;
                declList.context = ctx;
                declList.templateMap = map;
                declList.infoIterator = null;
                declList.spacing = null;
                do {
                    if (map != null && declList.infoIterator != null && declList.infoIterator.hasNext()) {
                        Info info = declList.infoIterator.next();
                        if (info == null) continue;
                        Type type = new Parser(this, info.cppNames[0]).type(context);
                        if (type.arguments == null) continue;
                        int count = 0;
                        for (Map.Entry entry : map.entrySet()) {
                            if (count >= type.arguments.length) continue;
                            Type t = type.arguments[count++];
                            String s = t.cppName;
                            if (t.constValue && !s.startsWith("const ")) {
                                s = "const " + s;
                            }
                            if (t.constPointer && !s.endsWith(" const")) {
                                s = s + " const";
                            }
                            if (t.indirections > 0) {
                                for (int i = 0; i < t.indirections; ++i) {
                                    s = s + "*";
                                }
                            }
                            if (t.reference) {
                                s = s + "&";
                            }
                            t.cppName = s;
                            entry.setValue(t);
                        }
                        this.tokens.index = startIndex;
                    }
                    if (!(this.macro(ctx, declList) || this.extern(ctx, declList) || this.namespace(ctx, declList) || this.enumeration(ctx, declList) || this.group(ctx, declList) || this.typedef(ctx, declList) || this.using(ctx, declList) || this.function(ctx, declList) || this.variable(ctx, declList))) {
                        spacing = this.tokens.get().spacing;
                        if (this.attribute() != null) {
                            this.tokens.get().spacing = spacing;
                        } else {
                            throw new ParserException(token.file + ":" + token.lineNumber + ": Could not parse declaration at '" + token + "'");
                        }
                    }
                    while (this.tokens.get().match(Character.valueOf(';')) && !this.tokens.get().match(Token.EOF)) {
                        this.tokens.next();
                    }
                } while (declList.infoIterator != null && declList.infoIterator.hasNext());
            }
            token = this.tokens.get();
        }
        String comment = this.commentBefore();
        Declaration decl = new Declaration();
        if (comment != null && comment.length() > 0) {
            decl.text = comment;
            declList.add(decl);
        }
    }

    void parse(Context context, DeclarationList declList, String[] includePath, String include, boolean isCFile) throws IOException, ParserException {
        Info info;
        ArrayList<Token> tokenList = new ArrayList<Token>();
        Object file = null;
        String filename = include;
        if (filename.startsWith("<") && filename.endsWith(">")) {
            filename = filename.substring(1, filename.length() - 1);
        } else {
            String[] f = new File(filename);
            if (f.exists()) {
                file = f;
            }
        }
        if (file == null && includePath != null) {
            for (String path : includePath) {
                File f = new File(path, filename).getCanonicalFile();
                if (!f.exists()) continue;
                file = f;
                break;
            }
        }
        if (file == null) {
            file = new File(filename);
        }
        if ((info = this.infoMap.getFirst(((File)file).getName())) != null && info.skip && info.linePatterns == null) {
            return;
        }
        if (!((File)file).exists()) {
            throw new FileNotFoundException("Could not parse \"" + file + "\": File does not exist");
        }
        this.logger.info("Parsing " + file);
        Token token = new Token();
        token.type = 4;
        token.value = "\n// Parsed from " + include + "\n\n";
        tokenList.add(token);
        Tokenizer tokenizer = new Tokenizer((File)file);
        if (info != null && info.linePatterns != null) {
            tokenizer.filterLines(info.linePatterns, info.skip);
        }
        while (!(token = tokenizer.nextToken()).isEmpty()) {
            if (token.type == -1) {
                token.type = 4;
            }
            tokenList.add(token);
        }
        if (this.lineSeparator == null) {
            this.lineSeparator = tokenizer.lineSeparator;
        }
        tokenizer.close();
        token = new Token();
        token.type = 4;
        token.spacing = "\n";
        tokenList.add(token);
        this.tokens = new TokenIndexer(this.infoMap, tokenList.toArray(new Token[tokenList.size()]), isCFile);
        this.declarations(context, declList);
    }

    public File parse(String outputDirectory, String[] classPath, Class cls) throws IOException, ParserException {
        return this.parse(new File(outputDirectory), classPath, cls);
    }

    public File parse(File outputDirectory, String[] classPath, Class cls) throws IOException, ParserException {
        File targetDir;
        boolean isCFile;
        ClassProperties allProperties = Loader.loadProperties(cls, this.properties, true);
        ClassProperties clsProperties = Loader.loadProperties(cls, this.properties, false);
        ArrayList<String> cIncludes = new ArrayList<String>();
        cIncludes.addAll(clsProperties.get("platform.cinclude"));
        cIncludes.addAll(allProperties.get("platform.cinclude"));
        ArrayList<String> clsIncludes = new ArrayList<String>();
        clsIncludes.addAll(clsProperties.get("platform.include"));
        clsIncludes.addAll(clsProperties.get("platform.cinclude"));
        ArrayList<String> allIncludes = new ArrayList<String>();
        allIncludes.addAll(allProperties.get("platform.include"));
        allIncludes.addAll(allProperties.get("platform.cinclude"));
        List<String> allTargets = allProperties.get("target");
        List<String> clsTargets = clsProperties.get("target");
        List<String> clsHelpers = clsProperties.get("helper");
        String target = clsTargets.get(0);
        List<Class> allInherited = allProperties.getInheritedClasses();
        this.infoMap = new InfoMap();
        for (Class c : allInherited) {
            try {
                ((InfoMapper)c.newInstance()).map(this.infoMap);
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException exception) {}
        }
        this.leafInfoMap = new InfoMap();
        try {
            ((InfoMapper)cls.newInstance()).map(this.leafInfoMap);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException exception) {
            // empty catch block
        }
        this.infoMap.putAll(this.leafInfoMap);
        String version = Generator.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "unknown";
        }
        String text = "// Targeted by JavaCPP version " + version + ": DO NOT EDIT THIS FILE\n\n";
        int n = target.lastIndexOf(46);
        if (n >= 0) {
            text = text + "package " + target.substring(0, n) + ";\n\n";
        }
        List<Info> infoList = this.leafInfoMap.get(null);
        for (Info info : infoList) {
            if (info.javaText == null || !info.javaText.startsWith("import")) continue;
            text = text + info.javaText + "\n";
        }
        text = text + "import java.nio.*;\nimport org.bytedeco.javacpp.*;\nimport org.bytedeco.javacpp.annotation.*;\n\n";
        for (String s : allTargets) {
            if (target.equals(s)) continue;
            text = text + "import static " + s + ".*;\n";
        }
        if (allTargets.size() > 1) {
            text = text + "\n";
        }
        text = text + "public class " + target.substring(n + 1) + " extends " + (clsHelpers.size() > 0 && clsIncludes.size() > 0 ? clsHelpers.get(0) : cls.getCanonicalName()) + " {\n    static { Loader.load(); }\n";
        String targetPath = target.replace('.', File.separatorChar);
        File targetFile = new File(outputDirectory, targetPath + ".java");
        this.logger.info("Targeting " + targetFile);
        Context context = new Context();
        context.infoMap = this.infoMap;
        String[] includePath = classPath;
        n = targetPath.lastIndexOf(File.separatorChar);
        if (n >= 0) {
            includePath = (String[])classPath.clone();
            int i = 0;
            while (i < includePath.length) {
                int n2 = i++;
                includePath[n2] = includePath[n2] + File.separator + targetPath.substring(0, n);
            }
        }
        List<String> paths = allProperties.get("platform.includepath");
        String[] includePaths = paths.toArray(new String[paths.size() + includePath.length]);
        System.arraycopy(includePath, 0, includePaths, paths.size(), includePath.length);
        DeclarationList declList = new DeclarationList();
        for (String include : allIncludes) {
            if (clsIncludes.contains(include)) continue;
            isCFile = cIncludes.contains(include);
            this.parse(context, declList, includePaths, include, isCFile);
        }
        declList = new DeclarationList(declList);
        if (clsIncludes.size() > 0) {
            this.containers(context, declList);
            for (String include : clsIncludes) {
                if (!allIncludes.contains(include)) continue;
                isCFile = cIncludes.contains(include);
                this.parse(context, declList, includePaths, include, isCFile);
            }
        }
        if ((targetDir = targetFile.getParentFile()) != null) {
            targetDir.mkdirs();
        }
        final String newline = this.lineSeparator != null ? this.lineSeparator : "\n";
        try (FileWriter out = new FileWriter(targetFile){

            @Override
            public Writer append(CharSequence text) throws IOException {
                return super.append(((String)text).replace("\n", newline).replace("\\u", "\\u005Cu"));
            }
        };){
            ((Writer)out).append(text);
            for (Info info : infoList) {
                if (info.javaText == null || info.javaText.startsWith("import")) continue;
                ((Writer)out).append(info.javaText + "\n");
            }
            for (Declaration d : declList) {
                ((Writer)out).append(d.text);
            }
            ((Writer)out).append("\n}\n").close();
        }
        return targetFile;
    }
}

