/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.CharPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.CharIndexer;
import org.bytedeco.javacpp.indexer.Raw;

public class CharRawIndexer
extends CharIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected CharPointer pointer;
    final long base;
    final long size;

    public CharRawIndexer(CharPointer pointer) {
        this(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public CharRawIndexer(CharPointer pointer, long[] sizes) {
        this(pointer, sizes, CharRawIndexer.strides(sizes));
    }

    public CharRawIndexer(CharPointer pointer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.pointer = pointer;
        this.base = pointer.address() + pointer.position() * 2L;
        this.size = pointer.limit() - pointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    @Override
    public char get(long i) {
        return RAW.getChar(this.base + CharRawIndexer.checkIndex(i, this.size) * 2L);
    }

    @Override
    public CharIndexer get(long i, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.get(i * this.strides[0] + (long)n);
        }
        return this;
    }

    @Override
    public char get(long i, long j) {
        return this.get(i * this.strides[0] + j);
    }

    @Override
    public CharIndexer get(long i, long j, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.get(i * this.strides[0] + j * this.strides[1] + (long)n);
        }
        return this;
    }

    @Override
    public char get(long i, long j, long k) {
        return this.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public char get(long ... indices) {
        return this.get(this.index(indices));
    }

    @Override
    public CharIndexer get(long[] indices, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            c[offset + n] = this.get(this.index(indices) + (long)n);
        }
        return this;
    }

    @Override
    public CharIndexer put(long i, char c) {
        RAW.putChar(this.base + CharRawIndexer.checkIndex(i, this.size) * 2L, c);
        return this;
    }

    @Override
    public CharIndexer put(long i, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + (long)n, c[offset + n]);
        }
        return this;
    }

    @Override
    public CharIndexer put(long i, long j, char c) {
        this.put(i * this.strides[0] + j, c);
        return this;
    }

    @Override
    public CharIndexer put(long i, long j, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + j * this.strides[1] + (long)n, c[offset + n]);
        }
        return this;
    }

    @Override
    public CharIndexer put(long i, long j, long k, char c) {
        this.put(i * this.strides[0] + j * this.strides[1] + k, c);
        return this;
    }

    @Override
    public CharIndexer put(long[] indices, char c) {
        this.put(this.index(indices), c);
        return this;
    }

    @Override
    public CharIndexer put(long[] indices, char[] c, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(this.index(indices) + (long)n, c[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

