/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.ShortBuffer;
import org.bytedeco.javacpp.indexer.ShortIndexer;

public class ShortBufferIndexer
extends ShortIndexer {
    protected ShortBuffer buffer;

    public ShortBufferIndexer(ShortBuffer buffer) {
        this(buffer, new long[]{buffer.limit()}, ONE_STRIDE);
    }

    public ShortBufferIndexer(ShortBuffer buffer, long[] sizes) {
        this(buffer, sizes, ShortBufferIndexer.strides(sizes));
    }

    public ShortBufferIndexer(ShortBuffer buffer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public short get(long i) {
        return this.buffer.get((int)i);
    }

    @Override
    public ShortIndexer get(long i, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.buffer.get((int)i * (int)this.strides[0] + n);
        }
        return this;
    }

    @Override
    public short get(long i, long j) {
        return this.buffer.get((int)i * (int)this.strides[0] + (int)j);
    }

    @Override
    public ShortIndexer get(long i, long j, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.buffer.get((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n);
        }
        return this;
    }

    @Override
    public short get(long i, long j, long k) {
        return this.buffer.get((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k);
    }

    @Override
    public short get(long ... indices) {
        return this.buffer.get((int)this.index(indices));
    }

    @Override
    public ShortIndexer get(long[] indices, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.buffer.get((int)this.index(indices) + n);
        }
        return this;
    }

    @Override
    public ShortIndexer put(long i, short s) {
        this.buffer.put((int)i, s);
        return this;
    }

    @Override
    public ShortIndexer put(long i, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)i * (int)this.strides[0] + n, s[offset + n]);
        }
        return this;
    }

    @Override
    public ShortIndexer put(long i, long j, short s) {
        this.buffer.put((int)i * (int)this.strides[0] + (int)j, s);
        return this;
    }

    @Override
    public ShortIndexer put(long i, long j, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n, s[offset + n]);
        }
        return this;
    }

    @Override
    public ShortIndexer put(long i, long j, long k, short s) {
        this.buffer.put((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k, s);
        return this;
    }

    @Override
    public ShortIndexer put(long[] indices, short s) {
        this.buffer.put((int)this.index(indices), s);
        return this;
    }

    @Override
    public ShortIndexer put(long[] indices, short[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)this.index(indices) + n, s[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

