// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.global;

import org.bytedeco.opencv.opencv_videoio.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;

public class opencv_videoio extends org.bytedeco.opencv.presets.opencv_videoio {
    static { Loader.load(); }

// Parsed from <opencv2/videoio.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_VIDEOIO_HPP
// #define OPENCV_VIDEOIO_HPP

// #include "opencv2/core.hpp"
// Targeting ..\opencv_videoio\CvCapture.java


// Targeting ..\opencv_videoio\CvVideoWriter.java



/** \addtogroup videoio
 *  \{
 <p>
 *  \addtogroup videoio_flags_base
 *  \{
<p>
<p>
/** \brief cv::VideoCapture API backends identifier.
<p>
Select preferred API for a capture object.
To be used in the VideoCapture::VideoCapture() constructor or VideoCapture::open()
<p>
\note Backends are available only if they have been built with your OpenCV binaries.
See \ref videoio_overview for more information.
*/
/** enum cv::VideoCaptureAPIs */
public static final int
       /** Auto detect == 0 */
       CAP_ANY          = 0,
       /** Video For Windows (obsolete, removed) */
       CAP_VFW          = 200,
       /** V4L/V4L2 capturing support */
       CAP_V4L          = 200,
       /** Same as CAP_V4L */
       CAP_V4L2         = CAP_V4L,
       /** IEEE 1394 drivers */
       CAP_FIREWIRE     = 300,
       /** Same value as CAP_FIREWIRE */
       CAP_FIREWARE     = CAP_FIREWIRE,
       /** Same value as CAP_FIREWIRE */
       CAP_IEEE1394     = CAP_FIREWIRE,
       /** Same value as CAP_FIREWIRE */
       CAP_DC1394       = CAP_FIREWIRE,
       /** Same value as CAP_FIREWIRE */
       CAP_CMU1394      = CAP_FIREWIRE,
       /** QuickTime (obsolete, removed) */
       CAP_QT           = 500,
       /** Unicap drivers (obsolete, removed) */
       CAP_UNICAP       = 600,
       /** DirectShow (via videoInput) */
       CAP_DSHOW        = 700,
       /** PvAPI, Prosilica GigE SDK */
       CAP_PVAPI        = 800,
       /** OpenNI (for Kinect) */
       CAP_OPENNI       = 900,
       /** OpenNI (for Asus Xtion) */
       CAP_OPENNI_ASUS  = 910,
       /** Android - not used */
       CAP_ANDROID      = 1000,
       /** XIMEA Camera API */
       CAP_XIAPI        = 1100,
       /** AVFoundation framework for iOS (OS X Lion will have the same API) */
       CAP_AVFOUNDATION = 1200,
       /** Smartek Giganetix GigEVisionSDK */
       CAP_GIGANETIX    = 1300,
       /** Microsoft Media Foundation (via videoInput) */
       CAP_MSMF         = 1400,
       /** Microsoft Windows Runtime using Media Foundation */
       CAP_WINRT        = 1410,
       /** RealSense (former Intel Perceptual Computing SDK) */
       CAP_INTELPERC    = 1500,
       /** Synonym for CAP_INTELPERC */
       CAP_REALSENSE    = 1500,
       /** OpenNI2 (for Kinect) */
       CAP_OPENNI2      = 1600,
       /** OpenNI2 (for Asus Xtion and Occipital Structure sensors) */
       CAP_OPENNI2_ASUS = 1610,
       /** OpenNI2 (for Orbbec Astra) */
       CAP_OPENNI2_ASTRA = 1620,
       /** gPhoto2 connection */
       CAP_GPHOTO2      = 1700,
       /** GStreamer */
       CAP_GSTREAMER    = 1800,
       /** Open and record video file or stream using the FFMPEG library */
       CAP_FFMPEG       = 1900,
       /** OpenCV Image Sequence (e.g. img_%02d.jpg) */
       CAP_IMAGES       = 2000,
       /** Aravis SDK */
       CAP_ARAVIS       = 2100,
       /** Built-in OpenCV MotionJPEG codec */
       CAP_OPENCV_MJPEG = 2200,
       /** Intel MediaSDK */
       CAP_INTEL_MFX    = 2300,
       /** XINE engine (Linux) */
       CAP_XINE         = 2400,
       /** uEye Camera API */
       CAP_UEYE         = 2500;

/** \brief cv::VideoCapture generic properties identifier.
 <p>
 Reading / writing properties involves many layers. Some unexpected result might happens along this chain.
 Effective behaviour depends from device hardware, driver and API Backend.
 @see videoio_flags_others, VideoCapture::get(), VideoCapture::set()
*/
/** enum cv::VideoCaptureProperties */
public static final int
       /** Current position of the video file in milliseconds. */
       CAP_PROP_POS_MSEC       = 0,
       /** 0-based index of the frame to be decoded/captured next. */
       CAP_PROP_POS_FRAMES     = 1,
       /** Relative position of the video file: 0=start of the film, 1=end of the film. */
       CAP_PROP_POS_AVI_RATIO  = 2,
       /** Width of the frames in the video stream. */
       CAP_PROP_FRAME_WIDTH    = 3,
       /** Height of the frames in the video stream. */
       CAP_PROP_FRAME_HEIGHT   = 4,
       /** Frame rate. */
       CAP_PROP_FPS            = 5,
       /** 4-character code of codec. see VideoWriter::fourcc . */
       CAP_PROP_FOURCC         = 6,
       /** Number of frames in the video file. */
       CAP_PROP_FRAME_COUNT    = 7,
       /** Format of the %Mat objects (see Mat::type()) returned by VideoCapture::retrieve().
 *  Set value -1 to fetch undecoded RAW video streams (as Mat 8UC1). */
       CAP_PROP_FORMAT         = 8,
       /** Backend-specific value indicating the current capture mode. */
       CAP_PROP_MODE           = 9,
       /** Brightness of the image (only for those cameras that support). */
       CAP_PROP_BRIGHTNESS    = 10,
       /** Contrast of the image (only for cameras). */
       CAP_PROP_CONTRAST      = 11,
       /** Saturation of the image (only for cameras). */
       CAP_PROP_SATURATION    = 12,
       /** Hue of the image (only for cameras). */
       CAP_PROP_HUE           = 13,
       /** Gain of the image (only for those cameras that support). */
       CAP_PROP_GAIN          = 14,
       /** Exposure (only for those cameras that support). */
       CAP_PROP_EXPOSURE      = 15,
       /** Boolean flags indicating whether images should be converted to RGB. <br/>
 *  *GStreamer note*: The flag is ignored in case if custom pipeline is used. It's user responsibility to interpret pipeline output. */
       CAP_PROP_CONVERT_RGB   = 16,
       /** Currently unsupported. */
       CAP_PROP_WHITE_BALANCE_BLUE_U = 17,
       /** Rectification flag for stereo cameras (note: only supported by DC1394 v 2.x backend currently). */
       CAP_PROP_RECTIFICATION = 18,
       CAP_PROP_MONOCHROME    = 19,
       CAP_PROP_SHARPNESS     = 20,
       /** DC1394: exposure control done by camera, user can adjust reference level using this feature. */
       CAP_PROP_AUTO_EXPOSURE = 21,
       CAP_PROP_GAMMA         = 22,
       CAP_PROP_TEMPERATURE   = 23,
       CAP_PROP_TRIGGER       = 24,
       CAP_PROP_TRIGGER_DELAY = 25,
       CAP_PROP_WHITE_BALANCE_RED_V = 26,
       CAP_PROP_ZOOM          = 27,
       CAP_PROP_FOCUS         = 28,
       CAP_PROP_GUID          = 29,
       CAP_PROP_ISO_SPEED     = 30,
       CAP_PROP_BACKLIGHT     = 32,
       CAP_PROP_PAN           = 33,
       CAP_PROP_TILT          = 34,
       CAP_PROP_ROLL          = 35,
       CAP_PROP_IRIS          = 36,
       /** Pop up video/camera filter dialog (note: only supported by DSHOW backend currently. The property value is ignored) */
       CAP_PROP_SETTINGS      = 37,
       CAP_PROP_BUFFERSIZE    = 38,
       CAP_PROP_AUTOFOCUS     = 39,
       /** Sample aspect ratio: num/den (num) */
       CAP_PROP_SAR_NUM       = 40,
       /** Sample aspect ratio: num/den (den) */
       CAP_PROP_SAR_DEN       = 41,
       /** Current backend (enum VideoCaptureAPIs). Read-only property */
       CAP_PROP_BACKEND       = 42,
       /** Video input or Channel Number (only for those cameras that support) */
       CAP_PROP_CHANNEL       = 43,
       /** enable/ disable auto white-balance */
       CAP_PROP_AUTO_WB       = 44,
       /** white-balance color temperature */
       CAP_PROP_WB_TEMPERATURE = 45,
       /** (read-only) codec's pixel format. 4-character code - see VideoWriter::fourcc . Subset of [AV_PIX_FMT_*](https://github.com/FFmpeg/FFmpeg/blob/master/libavcodec/raw.c) or -1 if unknown */
       CAP_PROP_CODEC_PIXEL_FORMAT = 46,
       /** (read-only) Video bitrate in kbits/s */
       CAP_PROP_BITRATE       = 47,
       /** (read-only) Frame rotation defined by stream meta (applicable for FFmpeg back-end only) */
       CAP_PROP_ORIENTATION_META = 48,
       /** if true - rotates output frames of CvCapture considering video file's metadata  (applicable for FFmpeg back-end only) (https://github.com/opencv/opencv/issues/15499) */
       CAP_PROP_ORIENTATION_AUTO = 49,
       /** (**open-only**) Hardware acceleration type (see #VideoAccelerationType). Setting supported only via {@code params} parameter in cv::VideoCapture constructor / .open() method. Default value is backend-specific. */
       CAP_PROP_HW_ACCELERATION = 50,
       /** (**open-only**) Hardware device index (select GPU if multiple available). Device enumeration is acceleration type specific. */
       CAP_PROP_HW_DEVICE      = 51,
       /** (**open-only**) If non-zero, create new OpenCL context and bind it to current thread. The OpenCL context created with Video Acceleration context attached it (if not attached yet) for optimized GPU data copy between HW accelerated decoder and cv::UMat. */
       CAP_PROP_HW_ACCELERATION_USE_OPENCL = 52,
       /** (**open-only**) timeout in milliseconds for opening a video capture (applicable for FFmpeg back-end only) */
       CAP_PROP_OPEN_TIMEOUT_MSEC = 53,
       /** (**open-only**) timeout in milliseconds for reading from a video capture (applicable for FFmpeg back-end only) */
       CAP_PROP_READ_TIMEOUT_MSEC = 54,
       CAP_PROP_STREAM_OPEN_TIME_USEC = 55, //<! (read-only) time in microseconds since Jan 1 1970 when stream was opened. Applicable for FFmpeg backend only. Useful for RTSP and other live streams
       /** (read-only) Number of video channels */
       CAP_PROP_VIDEO_TOTAL_CHANNELS = 56,
       /** (**open-only**) Specify video stream, 0-based index. Use -1 to disable video stream from file or IP cameras. Default value is 0. */
       CAP_PROP_VIDEO_STREAM = 57,
       /** (**open-only**) Specify stream in multi-language media files, -1 - disable audio processing or microphone. Default value is -1. */
       CAP_PROP_AUDIO_STREAM = 58,
       /** (read-only) Audio position is measured in samples. Accurate audio sample timestamp of previous grabbed fragment. See CAP_PROP_AUDIO_SAMPLES_PER_SECOND and CAP_PROP_AUDIO_SHIFT_NSEC. */
       CAP_PROP_AUDIO_POS = 59,
       /** (read only) Contains the time difference between the start of the audio stream and the video stream in nanoseconds. Positive value means that audio is started after the first video frame. Negative value means that audio is started before the first video frame. */
       CAP_PROP_AUDIO_SHIFT_NSEC = 60,
       /** (open, read) Alternative definition to bits-per-sample, but with clear handling of 32F / 32S */
       CAP_PROP_AUDIO_DATA_DEPTH = 61,
       /** (open, read) determined from file/codec input. If not specified, then selected audio sample rate is 44100 */
       CAP_PROP_AUDIO_SAMPLES_PER_SECOND = 62,
       /** (read-only) Index of the first audio channel for .retrieve() calls. That audio channel number continues enumeration after video channels. */
       CAP_PROP_AUDIO_BASE_INDEX = 63,
       /** (read-only) Number of audio channels in the selected audio stream (mono, stereo, etc) */
       CAP_PROP_AUDIO_TOTAL_CHANNELS = 64,
       /** (read-only) Number of audio streams. */
       CAP_PROP_AUDIO_TOTAL_STREAMS = 65,
       /** (open, read) Enables audio synchronization. */
       CAP_PROP_AUDIO_SYNCHRONIZE = 66,
       /** FFmpeg back-end only - Indicates whether the Last Raw Frame (LRF), output from VideoCapture::read() when VideoCapture is initialized with VideoCapture::open(CAP_FFMPEG, {CAP_PROP_FORMAT, -1}) or VideoCapture::set(CAP_PROP_FORMAT,-1) is called before the first call to VideoCapture::read(), contains encoded data for a key frame. */
       CAP_PROP_LRF_HAS_KEY_FRAME = 67,
       /** Positive index indicates that returning extra data is supported by the video back end.  This can be retrieved as cap.retrieve(data, <returned index>).  E.g. When reading from a h264 encoded RTSP stream, the FFmpeg backend could return the SPS and/or PPS if available (if sent in reply to a DESCRIBE request), from calls to cap.retrieve(data, <returned index>). */
       CAP_PROP_CODEC_EXTRADATA_INDEX = 68,
// #ifndef CV_DOXYGEN
       CV__CAP_PROP_LATEST = 69;
// #endif

/** \brief cv::VideoWriter generic properties identifier.
 @see VideoWriter::get(), VideoWriter::set()
*/
/** enum cv::VideoWriterProperties */
public static final int
  /** Current quality (0..100%) of the encoded videostream. Can be adjusted dynamically in some codecs. */
  VIDEOWRITER_PROP_QUALITY = 1,
  /** (Read-only): Size of just encoded video frame. Note that the encoding order may be different from representation order. */
  VIDEOWRITER_PROP_FRAMEBYTES = 2,
  /** Number of stripes for parallel encoding. -1 for auto detection. */
  VIDEOWRITER_PROP_NSTRIPES = 3,
  /** If it is not zero, the encoder will expect and encode color frames, otherwise it
 *  will work with grayscale frames. */
  VIDEOWRITER_PROP_IS_COLOR = 4,
  /** Defaults to CV_8U. */
  VIDEOWRITER_PROP_DEPTH = 5,
  /** (**open-only**) Hardware acceleration type (see #VideoAccelerationType). Setting supported only via {@code params} parameter in VideoWriter constructor / .open() method. Default value is backend-specific. */
  VIDEOWRITER_PROP_HW_ACCELERATION = 6,
  /** (**open-only**) Hardware device index (select GPU if multiple available). Device enumeration is acceleration type specific. */
  VIDEOWRITER_PROP_HW_DEVICE       = 7,
  /** (**open-only**) If non-zero, create new OpenCL context and bind it to current thread. The OpenCL context created with Video Acceleration context attached it (if not attached yet) for optimized GPU data copy between cv::UMat and HW accelerated encoder. */
  VIDEOWRITER_PROP_HW_ACCELERATION_USE_OPENCL = 8,
// #ifndef CV_DOXYGEN
  CV__VIDEOWRITER_PROP_LATEST = 9;
// #endif

/** \} videoio_flags_base
 <p>
 *  \addtogroup videoio_flags_others
 *  \{
<p>
/** \name Hardware acceleration support
    \{
*/

/** \brief Video Acceleration type
 *
 * Used as value in #CAP_PROP_HW_ACCELERATION and #VIDEOWRITER_PROP_HW_ACCELERATION
 *
 * \note In case of FFmpeg backend, it translated to enum AVHWDeviceType (https://github.com/FFmpeg/FFmpeg/blob/master/libavutil/hwcontext.h)
 */
/** enum cv::VideoAccelerationType */
public static final int
    /** Do not require any specific H/W acceleration, prefer software processing.
 *  Reading of this value means that special H/W accelerated handling is not added or not detected by OpenCV. */
    VIDEO_ACCELERATION_NONE     = 0,

    /** Prefer to use H/W acceleration. If no one supported, then fallback to software processing.
 *  \note H/W acceleration may require special configuration of used environment.
 *  \note Results in encoding scenario may differ between software and hardware accelerated encoders. */
    VIDEO_ACCELERATION_ANY      = 1,

    /** DirectX 11 */
    VIDEO_ACCELERATION_D3D11    = 2,
    /** VAAPI */
    VIDEO_ACCELERATION_VAAPI    = 3,
    /** libmfx (Intel MediaSDK/oneVPL) */
    VIDEO_ACCELERATION_MFX      = 4;

/** \} Hardware acceleration support
<p>
/** \name IEEE 1394 drivers
    \{
*/

/** \brief Modes of the IEEE 1394 controlling registers
(can be: auto, manual, auto single push, absolute Latter allowed with any other mode)
every feature can have only one mode turned on at a time
*/
/** enum cv:: */
public static final int /** turn the feature off (not controlled manually nor automatically). */
 CAP_PROP_DC1394_OFF                = -4,
       /** set automatically when a value of the feature is set by the user. */
       CAP_PROP_DC1394_MODE_MANUAL        = -3,
       CAP_PROP_DC1394_MODE_AUTO          = -2,
       CAP_PROP_DC1394_MODE_ONE_PUSH_AUTO = -1,
       CAP_PROP_DC1394_MAX                = 31;

/** \} IEEE 1394 drivers
<p>
/** \name OpenNI (for Kinect)
    \{
*/

/** OpenNI map generators */
/** enum cv:: */
public static final int CAP_OPENNI_DEPTH_GENERATOR = 1 << 31,
       CAP_OPENNI_IMAGE_GENERATOR = 1 << 30,
       CAP_OPENNI_IR_GENERATOR    = 1 << 29,
       CAP_OPENNI_GENERATORS_MASK = CAP_OPENNI_DEPTH_GENERATOR + CAP_OPENNI_IMAGE_GENERATOR + CAP_OPENNI_IR_GENERATOR;

/** Properties of cameras available through OpenNI backend */
/** enum cv:: */
public static final int CAP_PROP_OPENNI_OUTPUT_MODE       = 100,
       /** In mm */
       CAP_PROP_OPENNI_FRAME_MAX_DEPTH   = 101,
       /** In mm */
       CAP_PROP_OPENNI_BASELINE          = 102,
       /** In pixels */
       CAP_PROP_OPENNI_FOCAL_LENGTH      = 103,
       /** Flag that synchronizes the remapping depth map to image map
 *  by changing depth generator's view point (if the flag is "on") or
 *  sets this view point to its normal one (if the flag is "off"). */
       CAP_PROP_OPENNI_REGISTRATION      = 104,
       CAP_PROP_OPENNI_REGISTRATION_ON   = CAP_PROP_OPENNI_REGISTRATION,
       CAP_PROP_OPENNI_APPROX_FRAME_SYNC = 105,
       CAP_PROP_OPENNI_MAX_BUFFER_SIZE   = 106,
       CAP_PROP_OPENNI_CIRCLE_BUFFER     = 107,
       CAP_PROP_OPENNI_MAX_TIME_DURATION = 108,
       CAP_PROP_OPENNI_GENERATOR_PRESENT = 109,
       CAP_PROP_OPENNI2_SYNC             = 110,
       CAP_PROP_OPENNI2_MIRROR           = 111;

/** OpenNI shortcuts */
/** enum cv:: */
public static final int CAP_OPENNI_IMAGE_GENERATOR_PRESENT         = CAP_OPENNI_IMAGE_GENERATOR + CAP_PROP_OPENNI_GENERATOR_PRESENT,
       CAP_OPENNI_IMAGE_GENERATOR_OUTPUT_MODE     = CAP_OPENNI_IMAGE_GENERATOR + CAP_PROP_OPENNI_OUTPUT_MODE,
       CAP_OPENNI_DEPTH_GENERATOR_PRESENT         = CAP_OPENNI_DEPTH_GENERATOR + CAP_PROP_OPENNI_GENERATOR_PRESENT,
       CAP_OPENNI_DEPTH_GENERATOR_BASELINE        = CAP_OPENNI_DEPTH_GENERATOR + CAP_PROP_OPENNI_BASELINE,
       CAP_OPENNI_DEPTH_GENERATOR_FOCAL_LENGTH    = CAP_OPENNI_DEPTH_GENERATOR + CAP_PROP_OPENNI_FOCAL_LENGTH,
       CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION    = CAP_OPENNI_DEPTH_GENERATOR + CAP_PROP_OPENNI_REGISTRATION,
       CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION_ON = CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION,
       CAP_OPENNI_IR_GENERATOR_PRESENT            = CAP_OPENNI_IR_GENERATOR + CAP_PROP_OPENNI_GENERATOR_PRESENT;

/** OpenNI data given from depth generator */
/** enum cv:: */
public static final int /** Depth values in mm (CV_16UC1) */
 CAP_OPENNI_DEPTH_MAP         = 0,
       /** XYZ in meters (CV_32FC3) */
       CAP_OPENNI_POINT_CLOUD_MAP   = 1,
       /** Disparity in pixels (CV_8UC1) */
       CAP_OPENNI_DISPARITY_MAP     = 2,
       /** Disparity in pixels (CV_32FC1) */
       CAP_OPENNI_DISPARITY_MAP_32F = 3,
       /** CV_8UC1 */
       CAP_OPENNI_VALID_DEPTH_MASK  = 4,

       /** Data given from RGB image generator */
       CAP_OPENNI_BGR_IMAGE         = 5,
       /** Data given from RGB image generator */
       CAP_OPENNI_GRAY_IMAGE        = 6,

       /** Data given from IR image generator */
       CAP_OPENNI_IR_IMAGE          = 7;

/** Supported output modes of OpenNI image generator */
/** enum cv:: */
public static final int CAP_OPENNI_VGA_30HZ  = 0,
       CAP_OPENNI_SXGA_15HZ = 1,
       CAP_OPENNI_SXGA_30HZ = 2,
       CAP_OPENNI_QVGA_30HZ = 3,
       CAP_OPENNI_QVGA_60HZ = 4;

/** \} OpenNI
<p>
/** \name GStreamer
    \{
*/

/** enum cv:: */
public static final int /** Default is 1 */
 CAP_PROP_GSTREAMER_QUEUE_LENGTH = 200;

/** \} GStreamer
<p>
/** \name PvAPI, Prosilica GigE SDK
    \{
*/

/** PVAPI */
/** enum cv:: */
public static final int /** IP for enable multicast master mode. 0 for disable multicast. */
 CAP_PROP_PVAPI_MULTICASTIP           = 300,
       /** FrameStartTriggerMode: Determines how a frame is initiated. */
       CAP_PROP_PVAPI_FRAMESTARTTRIGGERMODE = 301,
       /** Horizontal sub-sampling of the image. */
       CAP_PROP_PVAPI_DECIMATIONHORIZONTAL  = 302,
       /** Vertical sub-sampling of the image. */
       CAP_PROP_PVAPI_DECIMATIONVERTICAL    = 303,
       /** Horizontal binning factor. */
       CAP_PROP_PVAPI_BINNINGX              = 304,
       /** Vertical binning factor. */
       CAP_PROP_PVAPI_BINNINGY              = 305,
       /** Pixel format. */
       CAP_PROP_PVAPI_PIXELFORMAT           = 306;

/** PVAPI: FrameStartTriggerMode */
/** enum cv:: */
public static final int /** Freerun */
 CAP_PVAPI_FSTRIGMODE_FREERUN     = 0,
       /** SyncIn1 */
       CAP_PVAPI_FSTRIGMODE_SYNCIN1     = 1,
       /** SyncIn2 */
       CAP_PVAPI_FSTRIGMODE_SYNCIN2     = 2,
       /** FixedRate */
       CAP_PVAPI_FSTRIGMODE_FIXEDRATE   = 3,
       /** Software */
       CAP_PVAPI_FSTRIGMODE_SOFTWARE    = 4;

/** PVAPI: DecimationHorizontal, DecimationVertical */
/** enum cv:: */
public static final int /** Off */
 CAP_PVAPI_DECIMATION_OFF       = 1,
       /** 2 out of 4 decimation */
       CAP_PVAPI_DECIMATION_2OUTOF4   = 2,
       /** 2 out of 8 decimation */
       CAP_PVAPI_DECIMATION_2OUTOF8   = 4,
       /** 2 out of 16 decimation */
       CAP_PVAPI_DECIMATION_2OUTOF16  = 8;

/** PVAPI: PixelFormat */
/** enum cv:: */
public static final int /** Mono8 */
 CAP_PVAPI_PIXELFORMAT_MONO8    = 1,
       /** Mono16 */
       CAP_PVAPI_PIXELFORMAT_MONO16   = 2,
       /** Bayer8 */
       CAP_PVAPI_PIXELFORMAT_BAYER8   = 3,
       /** Bayer16 */
       CAP_PVAPI_PIXELFORMAT_BAYER16  = 4,
       /** Rgb24 */
       CAP_PVAPI_PIXELFORMAT_RGB24    = 5,
       /** Bgr24 */
       CAP_PVAPI_PIXELFORMAT_BGR24    = 6,
       /** Rgba32 */
       CAP_PVAPI_PIXELFORMAT_RGBA32   = 7,
       /** Bgra32 */
       CAP_PVAPI_PIXELFORMAT_BGRA32   = 8;

/** \} PvAPI
<p>
/** \name XIMEA Camera API
    \{
*/

/** Properties of cameras available through XIMEA SDK backend */
/** enum cv:: */
public static final int /** Change image resolution by binning or skipping. */
 CAP_PROP_XI_DOWNSAMPLING                                 = 400,
       /** Output data format. */
       CAP_PROP_XI_DATA_FORMAT                                  = 401,
       /** Horizontal offset from the origin to the area of interest (in pixels). */
       CAP_PROP_XI_OFFSET_X                                     = 402,
       /** Vertical offset from the origin to the area of interest (in pixels). */
       CAP_PROP_XI_OFFSET_Y                                     = 403,
       /** Defines source of trigger. */
       CAP_PROP_XI_TRG_SOURCE                                   = 404,
       /** Generates an internal trigger. PRM_TRG_SOURCE must be set to TRG_SOFTWARE. */
       CAP_PROP_XI_TRG_SOFTWARE                                 = 405,
       /** Selects general purpose input. */
       CAP_PROP_XI_GPI_SELECTOR                                 = 406,
       /** Set general purpose input mode. */
       CAP_PROP_XI_GPI_MODE                                     = 407,
       /** Get general purpose level. */
       CAP_PROP_XI_GPI_LEVEL                                    = 408,
       /** Selects general purpose output. */
       CAP_PROP_XI_GPO_SELECTOR                                 = 409,
       /** Set general purpose output mode. */
       CAP_PROP_XI_GPO_MODE                                     = 410,
       /** Selects camera signalling LED. */
       CAP_PROP_XI_LED_SELECTOR                                 = 411,
       /** Define camera signalling LED functionality. */
       CAP_PROP_XI_LED_MODE                                     = 412,
       /** Calculates White Balance(must be called during acquisition). */
       CAP_PROP_XI_MANUAL_WB                                    = 413,
       /** Automatic white balance. */
       CAP_PROP_XI_AUTO_WB                                      = 414,
       /** Automatic exposure/gain. */
       CAP_PROP_XI_AEAG                                         = 415,
       /** Exposure priority (0.5 - exposure 50%, gain 50%). */
       CAP_PROP_XI_EXP_PRIORITY                                 = 416,
       /** Maximum limit of exposure in AEAG procedure. */
       CAP_PROP_XI_AE_MAX_LIMIT                                 = 417,
       /** Maximum limit of gain in AEAG procedure. */
       CAP_PROP_XI_AG_MAX_LIMIT                                 = 418,
       /** Average intensity of output signal AEAG should achieve(in %). */
       CAP_PROP_XI_AEAG_LEVEL                                   = 419,
       /** Image capture timeout in milliseconds. */
       CAP_PROP_XI_TIMEOUT                                      = 420,
       /** Exposure time in microseconds. */
       CAP_PROP_XI_EXPOSURE                                     = 421,
       /** Sets the number of times of exposure in one frame. */
       CAP_PROP_XI_EXPOSURE_BURST_COUNT                         = 422,
       /** Gain selector for parameter Gain allows to select different type of gains. */
       CAP_PROP_XI_GAIN_SELECTOR                                = 423,
       /** Gain in dB. */
       CAP_PROP_XI_GAIN                                         = 424,
       /** Change image downsampling type. */
       CAP_PROP_XI_DOWNSAMPLING_TYPE                            = 426,
       /** Binning engine selector. */
       CAP_PROP_XI_BINNING_SELECTOR                             = 427,
       /** Vertical Binning - number of vertical photo-sensitive cells to combine together. */
       CAP_PROP_XI_BINNING_VERTICAL                             = 428,
       /** Horizontal Binning - number of horizontal photo-sensitive cells to combine together. */
       CAP_PROP_XI_BINNING_HORIZONTAL                           = 429,
       /** Binning pattern type. */
       CAP_PROP_XI_BINNING_PATTERN                              = 430,
       /** Decimation engine selector. */
       CAP_PROP_XI_DECIMATION_SELECTOR                          = 431,
       /** Vertical Decimation - vertical sub-sampling of the image - reduces the vertical resolution of the image by the specified vertical decimation factor. */
       CAP_PROP_XI_DECIMATION_VERTICAL                          = 432,
       /** Horizontal Decimation - horizontal sub-sampling of the image - reduces the horizontal resolution of the image by the specified vertical decimation factor. */
       CAP_PROP_XI_DECIMATION_HORIZONTAL                        = 433,
       /** Decimation pattern type. */
       CAP_PROP_XI_DECIMATION_PATTERN                           = 434,
       /** Selects which test pattern generator is controlled by the TestPattern feature. */
       CAP_PROP_XI_TEST_PATTERN_GENERATOR_SELECTOR              = 587,
       /** Selects which test pattern type is generated by the selected generator. */
       CAP_PROP_XI_TEST_PATTERN                                 = 588,
       /** Output data format. */
       CAP_PROP_XI_IMAGE_DATA_FORMAT                            = 435,
       /** Change sensor shutter type(CMOS sensor). */
       CAP_PROP_XI_SHUTTER_TYPE                                 = 436,
       /** Number of taps. */
       CAP_PROP_XI_SENSOR_TAPS                                  = 437,
       /** Automatic exposure/gain ROI offset X. */
       CAP_PROP_XI_AEAG_ROI_OFFSET_X                            = 439,
       /** Automatic exposure/gain ROI offset Y. */
       CAP_PROP_XI_AEAG_ROI_OFFSET_Y                            = 440,
       /** Automatic exposure/gain ROI Width. */
       CAP_PROP_XI_AEAG_ROI_WIDTH                               = 441,
       /** Automatic exposure/gain ROI Height. */
       CAP_PROP_XI_AEAG_ROI_HEIGHT                              = 442,
       /** Correction of bad pixels. */
       CAP_PROP_XI_BPC                                          = 445,
       /** White balance red coefficient. */
       CAP_PROP_XI_WB_KR                                        = 448,
       /** White balance green coefficient. */
       CAP_PROP_XI_WB_KG                                        = 449,
       /** White balance blue coefficient. */
       CAP_PROP_XI_WB_KB                                        = 450,
       /** Width of the Image provided by the device (in pixels). */
       CAP_PROP_XI_WIDTH                                        = 451,
       /** Height of the Image provided by the device (in pixels). */
       CAP_PROP_XI_HEIGHT                                       = 452,
       /** Selects Region in Multiple ROI which parameters are set by width, height, ... ,region mode. */
       CAP_PROP_XI_REGION_SELECTOR                              = 589,
       /** Activates/deactivates Region selected by Region Selector. */
       CAP_PROP_XI_REGION_MODE                                  = 595,
       /** Set/get bandwidth(datarate)(in Megabits). */
       CAP_PROP_XI_LIMIT_BANDWIDTH                              = 459,
       /** Sensor output data bit depth. */
       CAP_PROP_XI_SENSOR_DATA_BIT_DEPTH                        = 460,
       /** Device output data bit depth. */
       CAP_PROP_XI_OUTPUT_DATA_BIT_DEPTH                        = 461,
       /** bitdepth of data returned by function xiGetImage. */
       CAP_PROP_XI_IMAGE_DATA_BIT_DEPTH                         = 462,
       /** Device output data packing (or grouping) enabled. Packing could be enabled if output_data_bit_depth > 8 and packing capability is available. */
       CAP_PROP_XI_OUTPUT_DATA_PACKING                          = 463,
       /** Data packing type. Some cameras supports only specific packing type. */
       CAP_PROP_XI_OUTPUT_DATA_PACKING_TYPE                     = 464,
       /** Returns 1 for cameras that support cooling. */
       CAP_PROP_XI_IS_COOLED                                    = 465,
       /** Start camera cooling. */
       CAP_PROP_XI_COOLING                                      = 466,
       /** Set sensor target temperature for cooling. */
       CAP_PROP_XI_TARGET_TEMP                                  = 467,
       /** Camera sensor temperature. */
       CAP_PROP_XI_CHIP_TEMP                                    = 468,
       /** Camera housing temperature. */
       CAP_PROP_XI_HOUS_TEMP                                    = 469,
       /** Camera housing back side temperature. */
       CAP_PROP_XI_HOUS_BACK_SIDE_TEMP                          = 590,
       /** Camera sensor board temperature. */
       CAP_PROP_XI_SENSOR_BOARD_TEMP                            = 596,
       /** Mode of color management system. */
       CAP_PROP_XI_CMS                                          = 470,
       /** Enable applying of CMS profiles to xiGetImage (see XI_PRM_INPUT_CMS_PROFILE, XI_PRM_OUTPUT_CMS_PROFILE). */
       CAP_PROP_XI_APPLY_CMS                                    = 471,
       /** Returns 1 for color cameras. */
       CAP_PROP_XI_IMAGE_IS_COLOR                               = 474,
       /** Returns color filter array type of RAW data. */
       CAP_PROP_XI_COLOR_FILTER_ARRAY                           = 475,
       /** Luminosity gamma. */
       CAP_PROP_XI_GAMMAY                                       = 476,
       /** Chromaticity gamma. */
       CAP_PROP_XI_GAMMAC                                       = 477,
       /** Sharpness Strength. */
       CAP_PROP_XI_SHARPNESS                                    = 478,
       /** Color Correction Matrix element [0][0]. */
       CAP_PROP_XI_CC_MATRIX_00                                 = 479,
       /** Color Correction Matrix element [0][1]. */
       CAP_PROP_XI_CC_MATRIX_01                                 = 480,
       /** Color Correction Matrix element [0][2]. */
       CAP_PROP_XI_CC_MATRIX_02                                 = 481,
       /** Color Correction Matrix element [0][3]. */
       CAP_PROP_XI_CC_MATRIX_03                                 = 482,
       /** Color Correction Matrix element [1][0]. */
       CAP_PROP_XI_CC_MATRIX_10                                 = 483,
       /** Color Correction Matrix element [1][1]. */
       CAP_PROP_XI_CC_MATRIX_11                                 = 484,
       /** Color Correction Matrix element [1][2]. */
       CAP_PROP_XI_CC_MATRIX_12                                 = 485,
       /** Color Correction Matrix element [1][3]. */
       CAP_PROP_XI_CC_MATRIX_13                                 = 486,
       /** Color Correction Matrix element [2][0]. */
       CAP_PROP_XI_CC_MATRIX_20                                 = 487,
       /** Color Correction Matrix element [2][1]. */
       CAP_PROP_XI_CC_MATRIX_21                                 = 488,
       /** Color Correction Matrix element [2][2]. */
       CAP_PROP_XI_CC_MATRIX_22                                 = 489,
       /** Color Correction Matrix element [2][3]. */
       CAP_PROP_XI_CC_MATRIX_23                                 = 490,
       /** Color Correction Matrix element [3][0]. */
       CAP_PROP_XI_CC_MATRIX_30                                 = 491,
       /** Color Correction Matrix element [3][1]. */
       CAP_PROP_XI_CC_MATRIX_31                                 = 492,
       /** Color Correction Matrix element [3][2]. */
       CAP_PROP_XI_CC_MATRIX_32                                 = 493,
       /** Color Correction Matrix element [3][3]. */
       CAP_PROP_XI_CC_MATRIX_33                                 = 494,
       /** Set default Color Correction Matrix. */
       CAP_PROP_XI_DEFAULT_CC_MATRIX                            = 495,
       /** Selects the type of trigger. */
       CAP_PROP_XI_TRG_SELECTOR                                 = 498,
       /** Sets number of frames acquired by burst. This burst is used only if trigger is set to FrameBurstStart. */
       CAP_PROP_XI_ACQ_FRAME_BURST_COUNT                        = 499,
       /** Enable/Disable debounce to selected GPI. */
       CAP_PROP_XI_DEBOUNCE_EN                                  = 507,
       /** Debounce time (x * 10us). */
       CAP_PROP_XI_DEBOUNCE_T0                                  = 508,
       /** Debounce time (x * 10us). */
       CAP_PROP_XI_DEBOUNCE_T1                                  = 509,
       /** Debounce polarity (pol = 1 t0 - falling edge, t1 - rising edge). */
       CAP_PROP_XI_DEBOUNCE_POL                                 = 510,
       /** Status of lens control interface. This shall be set to XI_ON before any Lens operations. */
       CAP_PROP_XI_LENS_MODE                                    = 511,
       /** Current lens aperture value in stops. Examples: 2.8, 4, 5.6, 8, 11. */
       CAP_PROP_XI_LENS_APERTURE_VALUE                          = 512,
       /** Lens current focus movement value to be used by XI_PRM_LENS_FOCUS_MOVE in motor steps. */
       CAP_PROP_XI_LENS_FOCUS_MOVEMENT_VALUE                    = 513,
       /** Moves lens focus motor by steps set in XI_PRM_LENS_FOCUS_MOVEMENT_VALUE. */
       CAP_PROP_XI_LENS_FOCUS_MOVE                              = 514,
       /** Lens focus distance in cm. */
       CAP_PROP_XI_LENS_FOCUS_DISTANCE                          = 515,
       /** Lens focal distance in mm. */
       CAP_PROP_XI_LENS_FOCAL_LENGTH                            = 516,
       /** Selects the current feature which is accessible by XI_PRM_LENS_FEATURE. */
       CAP_PROP_XI_LENS_FEATURE_SELECTOR                        = 517,
       /** Allows access to lens feature value currently selected by XI_PRM_LENS_FEATURE_SELECTOR. */
       CAP_PROP_XI_LENS_FEATURE                                 = 518,
       /** Returns device model id. */
       CAP_PROP_XI_DEVICE_MODEL_ID                              = 521,
       /** Returns device serial number. */
       CAP_PROP_XI_DEVICE_SN                                    = 522,
       /** The alpha channel of RGB32 output image format. */
       CAP_PROP_XI_IMAGE_DATA_FORMAT_RGB32_ALPHA                = 529,
       /** Buffer size in bytes sufficient for output image returned by xiGetImage. */
       CAP_PROP_XI_IMAGE_PAYLOAD_SIZE                           = 530,
       /** Current format of pixels on transport layer. */
       CAP_PROP_XI_TRANSPORT_PIXEL_FORMAT                       = 531,
       /** Sensor clock frequency in Hz. */
       CAP_PROP_XI_SENSOR_CLOCK_FREQ_HZ                         = 532,
       /** Sensor clock frequency index. Sensor with selected frequencies have possibility to set the frequency only by this index. */
       CAP_PROP_XI_SENSOR_CLOCK_FREQ_INDEX                      = 533,
       /** Number of output channels from sensor used for data transfer. */
       CAP_PROP_XI_SENSOR_OUTPUT_CHANNEL_COUNT                  = 534,
       /** Define framerate in Hz. */
       CAP_PROP_XI_FRAMERATE                                    = 535,
       /** Select counter. */
       CAP_PROP_XI_COUNTER_SELECTOR                             = 536,
       /** Counter status. */
       CAP_PROP_XI_COUNTER_VALUE                                = 537,
       /** Type of sensor frames timing. */
       CAP_PROP_XI_ACQ_TIMING_MODE                              = 538,
       /** Calculate and returns available interface bandwidth(int Megabits). */
       CAP_PROP_XI_AVAILABLE_BANDWIDTH                          = 539,
       /** Data move policy. */
       CAP_PROP_XI_BUFFER_POLICY                                = 540,
       /** Activates LUT. */
       CAP_PROP_XI_LUT_EN                                       = 541,
       /** Control the index (offset) of the coefficient to access in the LUT. */
       CAP_PROP_XI_LUT_INDEX                                    = 542,
       /** Value at entry LUTIndex of the LUT. */
       CAP_PROP_XI_LUT_VALUE                                    = 543,
       /** Specifies the delay in microseconds (us) to apply after the trigger reception before activating it. */
       CAP_PROP_XI_TRG_DELAY                                    = 544,
       /** Defines how time stamp reset engine will be armed. */
       CAP_PROP_XI_TS_RST_MODE                                  = 545,
       /** Defines which source will be used for timestamp reset. Writing this parameter will trigger settings of engine (arming). */
       CAP_PROP_XI_TS_RST_SOURCE                                = 546,
       /** Returns 1 if camera connected and works properly. */
       CAP_PROP_XI_IS_DEVICE_EXIST                              = 547,
       /** Acquisition buffer size in buffer_size_unit. Default bytes. */
       CAP_PROP_XI_ACQ_BUFFER_SIZE                              = 548,
       /** Acquisition buffer size unit in bytes. Default 1. E.g. Value 1024 means that buffer_size is in KiBytes. */
       CAP_PROP_XI_ACQ_BUFFER_SIZE_UNIT                         = 549,
       /** Acquisition transport buffer size in bytes. */
       CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_SIZE                    = 550,
       /** Queue of field/frame buffers. */
       CAP_PROP_XI_BUFFERS_QUEUE_SIZE                           = 551,
       /** Number of buffers to commit to low level. */
       CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_COMMIT                  = 552,
       /** GetImage returns most recent frame. */
       CAP_PROP_XI_RECENT_FRAME                                 = 553,
       /** Resets the camera to default state. */
       CAP_PROP_XI_DEVICE_RESET                                 = 554,
       /** Correction of column FPN. */
       CAP_PROP_XI_COLUMN_FPN_CORRECTION                        = 555,
       /** Correction of row FPN. */
       CAP_PROP_XI_ROW_FPN_CORRECTION                           = 591,
       /** Current sensor mode. Allows to select sensor mode by one integer. Setting of this parameter affects: image dimensions and downsampling. */
       CAP_PROP_XI_SENSOR_MODE                                  = 558,
       /** Enable High Dynamic Range feature. */
       CAP_PROP_XI_HDR                                          = 559,
       /** The number of kneepoints in the PWLR. */
       CAP_PROP_XI_HDR_KNEEPOINT_COUNT                          = 560,
       /** Position of first kneepoint(in % of XI_PRM_EXPOSURE). */
       CAP_PROP_XI_HDR_T1                                       = 561,
       /** Position of second kneepoint (in % of XI_PRM_EXPOSURE). */
       CAP_PROP_XI_HDR_T2                                       = 562,
       /** Value of first kneepoint (% of sensor saturation). */
       CAP_PROP_XI_KNEEPOINT1                                   = 563,
       /** Value of second kneepoint (% of sensor saturation). */
       CAP_PROP_XI_KNEEPOINT2                                   = 564,
       /** Last image black level counts. Can be used for Offline processing to recall it. */
       CAP_PROP_XI_IMAGE_BLACK_LEVEL                            = 565,
       /** Returns hardware revision number. */
       CAP_PROP_XI_HW_REVISION                                  = 571,
       /** Set debug level. */
       CAP_PROP_XI_DEBUG_LEVEL                                  = 572,
       /** Automatic bandwidth calculation. */
       CAP_PROP_XI_AUTO_BANDWIDTH_CALCULATION                   = 573,
       /** File number. */
       CAP_PROP_XI_FFS_FILE_ID                                  = 594,
       /** Size of file. */
       CAP_PROP_XI_FFS_FILE_SIZE                                = 580,
       /** Size of free camera FFS. */
       CAP_PROP_XI_FREE_FFS_SIZE                                = 581,
       /** Size of used camera FFS. */
       CAP_PROP_XI_USED_FFS_SIZE                                = 582,
       /** Setting of key enables file operations on some cameras. */
       CAP_PROP_XI_FFS_ACCESS_KEY                               = 583,
       /** Selects the current feature which is accessible by XI_PRM_SENSOR_FEATURE_VALUE. */
       CAP_PROP_XI_SENSOR_FEATURE_SELECTOR                      = 585,
       /** Allows access to sensor feature value currently selected by XI_PRM_SENSOR_FEATURE_SELECTOR. */
       CAP_PROP_XI_SENSOR_FEATURE_VALUE                         = 586;

/** \} XIMEA
<p>
<p>
/** \name ARAVIS Camera API
    \{
*/

/** Properties of cameras available through ARAVIS backend */
/** enum cv:: */
public static final int /** Automatically trigger frame capture if camera is configured with software trigger */
 CAP_PROP_ARAVIS_AUTOTRIGGER                              = 600;

/** \} ARAVIS
<p>
/** \name AVFoundation framework for iOS
    \{
*/

/** Properties of cameras available through AVFOUNDATION backend */
/** enum cv:: */
public static final int CAP_PROP_IOS_DEVICE_FOCUS        = 9001,
       CAP_PROP_IOS_DEVICE_EXPOSURE     = 9002,
       CAP_PROP_IOS_DEVICE_FLASH        = 9003,
       CAP_PROP_IOS_DEVICE_WHITEBALANCE = 9004,
       CAP_PROP_IOS_DEVICE_TORCH        = 9005;

/** \} AVFoundation framework for iOS
<p>
<p>
/** \name Smartek Giganetix GigEVisionSDK
    \{
*/

/** Properties of cameras available through Smartek Giganetix Ethernet Vision backend */
/* --- Vladimir Litvinenko (litvinenko.vladimir@gmail.com) --- */
/** enum cv:: */
public static final int CAP_PROP_GIGA_FRAME_OFFSET_X   = 10001,
       CAP_PROP_GIGA_FRAME_OFFSET_Y   = 10002,
       CAP_PROP_GIGA_FRAME_WIDTH_MAX  = 10003,
       CAP_PROP_GIGA_FRAME_HEIGH_MAX  = 10004,
       CAP_PROP_GIGA_FRAME_SENS_WIDTH = 10005,
       CAP_PROP_GIGA_FRAME_SENS_HEIGH = 10006;

/** \} Smartek
<p>
/** \name Intel Perceptual Computing SDK
    \{
*/
/** enum cv:: */
public static final int CAP_PROP_INTELPERC_PROFILE_COUNT               = 11001,
       CAP_PROP_INTELPERC_PROFILE_IDX                 = 11002,
       CAP_PROP_INTELPERC_DEPTH_LOW_CONFIDENCE_VALUE  = 11003,
       CAP_PROP_INTELPERC_DEPTH_SATURATION_VALUE      = 11004,
       CAP_PROP_INTELPERC_DEPTH_CONFIDENCE_THRESHOLD  = 11005,
       CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_HORZ     = 11006,
       CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_VERT     = 11007;

/** Intel Perceptual Streams */
/** enum cv:: */
public static final int CAP_INTELPERC_DEPTH_GENERATOR = 1 << 29,
       CAP_INTELPERC_IMAGE_GENERATOR = 1 << 28,
       CAP_INTELPERC_IR_GENERATOR    = 1 << 27,
       CAP_INTELPERC_GENERATORS_MASK = CAP_INTELPERC_DEPTH_GENERATOR + CAP_INTELPERC_IMAGE_GENERATOR + CAP_INTELPERC_IR_GENERATOR;

/** enum cv:: */
public static final int /** Each pixel is a 16-bit integer. The value indicates the distance from an object to the camera's XY plane or the Cartesian depth. */
 CAP_INTELPERC_DEPTH_MAP              = 0,
       /** Each pixel contains two 32-bit floating point values in the range of 0-1, representing the mapping of depth coordinates to the color coordinates. */
       CAP_INTELPERC_UVDEPTH_MAP            = 1,
       /** Each pixel is a 16-bit integer. The value indicates the intensity of the reflected laser beam. */
       CAP_INTELPERC_IR_MAP                 = 2,
       CAP_INTELPERC_IMAGE                  = 3;

/** \} Intel Perceptual
<p>
/** \name gPhoto2 connection
    \{
*/

/** \brief gPhoto2 properties
<p>
If {@code propertyId} is less than 0 then work on widget with that __additive inversed__ camera setting ID
Get IDs by using CAP_PROP_GPHOTO2_WIDGET_ENUMERATE.
@see CvCaptureCAM_GPHOTO2 for more info
*/
/** enum cv:: */
public static final int /** Capture only preview from liveview mode. */
 CAP_PROP_GPHOTO2_PREVIEW           = 17001,
       /** Readonly, returns (const char *). */
       CAP_PROP_GPHOTO2_WIDGET_ENUMERATE  = 17002,
       /** Trigger, only by set. Reload camera settings. */
       CAP_PROP_GPHOTO2_RELOAD_CONFIG     = 17003,
       /** Reload all settings on set. */
       CAP_PROP_GPHOTO2_RELOAD_ON_CHANGE  = 17004,
       /** Collect messages with details. */
       CAP_PROP_GPHOTO2_COLLECT_MSGS      = 17005,
       /** Readonly, returns (const char *). */
       CAP_PROP_GPHOTO2_FLUSH_MSGS        = 17006,
       /** Exposure speed. Can be readonly, depends on camera program. */
       CAP_PROP_SPEED                     = 17007,
       /** Aperture. Can be readonly, depends on camera program. */
       CAP_PROP_APERTURE                  = 17008,
       /** Camera exposure program. */
       CAP_PROP_EXPOSUREPROGRAM           = 17009,
       /** Enter liveview mode. */
       CAP_PROP_VIEWFINDER                = 17010;

/** \} gPhoto2
<p>
<p>
/** \name Images backend
    \{
*/

/** \brief Images backend properties
<p>
*/
/** enum cv:: */
public static final int CAP_PROP_IMAGES_BASE = 18000,
       CAP_PROP_IMAGES_LAST = 19000; // excluding
// Targeting ..\opencv_videoio\IVideoCapture.java


// Targeting ..\opencv_videoio\VideoCapturePrivateAccessor.java

 
// Targeting ..\opencv_videoio\VideoCapture.java


// Targeting ..\opencv_videoio\IVideoWriter.java


// Targeting ..\opencv_videoio\VideoWriter.java


// Targeting ..\opencv_videoio\CvCaptureDefaultDeleter.java


// Targeting ..\opencv_videoio\CvVideoWriterDefaultDeleter.java


/** \endcond IGNORED
 <p>
 *  \} videoio */

 // cv

// #endif //OPENCV_VIDEOIO_HPP


}
