// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_core;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.opencv.global.opencv_core.*;



@Namespace("cv::ocl") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_core.class)
public class OpenCLExecutionContext extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public OpenCLExecutionContext(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public OpenCLExecutionContext(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public OpenCLExecutionContext position(long position) {
        return (OpenCLExecutionContext)super.position(position);
    }
    @Override public OpenCLExecutionContext getPointer(long i) {
        return new OpenCLExecutionContext((Pointer)this).offsetAddress(i);
    }

    public OpenCLExecutionContext() { super((Pointer)null); allocate(); }
    private native void allocate();

    public OpenCLExecutionContext(@Const @ByRef OpenCLExecutionContext arg0) { super((Pointer)null); allocate(arg0); }
    private native void allocate(@Const @ByRef OpenCLExecutionContext arg0);

    public native @ByRef @Name("operator =") OpenCLExecutionContext put(@Const @ByRef OpenCLExecutionContext arg0);

    /** Get associated ocl::Context */
    public native @ByRef Context getContext();
    /** Get the single default associated ocl::Device */
    public native @ByRef Device getDevice();
    /** Get the single ocl::Queue that is associated with the ocl::Context and
     *  the single default ocl::Device
     */
    public native @ByRef Queue getQueue();

    public native @Cast("bool") boolean useOpenCL();
    public native void setUseOpenCL(@Cast("bool") boolean flag);

    /** Get OpenCL execution context of current thread.
     *
     * Initialize OpenCL execution context if it is empty
     * - create new
     * - reuse context of the main thread (threadID = 0)
     */
    public static native @ByRef OpenCLExecutionContext getCurrent();

    /** Get OpenCL execution context of current thread (can be empty) */
    public static native @ByRef OpenCLExecutionContext getCurrentRef();

    /** Bind this OpenCL execution context to current thread.
     *
     * Context can't be empty.
     *
     * \note clFinish is not called for queue of previous execution context
     */
    public native void bind();

    /** Creates new execution context with same OpenCV context and device
     *
     * @param q OpenCL queue
     */
    public native @ByVal OpenCLExecutionContext cloneWithNewQueue(@Const @ByRef Queue q);
    /** \overload */
    public native @ByVal OpenCLExecutionContext cloneWithNewQueue();

    /** \brief Creates OpenCL execution context
     * OpenCV will check if available OpenCL platform has platformName name,
     * then assign context to OpenCV.
     * The deviceID device will be used as target device and a new command queue will be created.
     *
     * \note On success, ownership of one reference of the context and device is taken.
     * The caller should additionally call {@code clRetainContext} and/or {@code clRetainDevice}
     * to increase the reference count if it wishes to continue using them.
     *
     * @param platformName name of OpenCL platform to attach, this string is used to check if platform is available to OpenCV at runtime
     * @param platformID ID of platform attached context was created for (cl_platform_id)
     * @param context OpenCL context to be attached to OpenCV (cl_context)
     * @param deviceID OpenCL device (cl_device_id)
     */
    public static native @ByVal OpenCLExecutionContext create(@StdString BytePointer platformName, Pointer platformID, Pointer context, Pointer deviceID);
    public static native @ByVal OpenCLExecutionContext create(@StdString String platformName, Pointer platformID, Pointer context, Pointer deviceID);

    /** \brief Creates OpenCL execution context
     *
     * @param context non-empty OpenCL context
     * @param device non-empty OpenCL device (must be a part of context)
     * @param queue non-empty OpenCL queue for provided context and device
     */
    public static native @ByVal OpenCLExecutionContext create(@Const @ByRef Context context, @Const @ByRef Device device, @Const @ByRef Queue queue);
    /** \overload */
    public static native @ByVal OpenCLExecutionContext create(@Const @ByRef Context context, @Const @ByRef Device device);

    @Opaque public static class Impl extends Pointer {
        /** Empty constructor. Calls {@code super((Pointer)null)}. */
        public Impl() { super((Pointer)null); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public Impl(Pointer p) { super(p); }
    }
    public native @Cast("bool") boolean empty();
    public native void release();
}
