// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.global;

import org.bytedeco.opencv.opencv_cudaarithm.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;

public class opencv_cudaarithm extends org.bytedeco.opencv.presets.opencv_cudaarithm {
    static { Loader.load(); }

// Parsed from <opencv2/cudaarithm.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_CUDAARITHM_HPP
// #define OPENCV_CUDAARITHM_HPP

// #ifndef __cplusplus
// #endif

// #include "opencv2/core/cuda.hpp"

/**
  \addtogroup cuda
  \{
    \defgroup cudaarithm Operations on Matrices
    \{
        \defgroup cudaarithm_core Core Operations on Matrices
        \defgroup cudaarithm_elem Per-element Operations
        \defgroup cudaarithm_reduce Matrix Reductions
        \defgroup cudaarithm_arithm Arithm Operations on Matrices
    \}
  \}
 */

/** \addtogroup cudaarithm
 *  \{
 <p>
 *  \addtogroup cudaarithm_elem
 *  \{
<p>
/** \brief Computes a matrix-matrix or matrix-scalar sum.
<p>
@param src1 First source matrix or scalar.
@param src2 Second source matrix or scalar. Matrix should have the same size and type as src1 .
@param dst Destination matrix that has the same size and number of channels as the input array(s).
The depth is defined by dtype or src1 depth.
@param mask Optional operation mask, 8-bit single channel array, that specifies elements of the
destination array to be changed. The mask can be used only with single channel images.
@param dtype Optional depth of the output array.
@param stream Stream for the asynchronous version.
<p>
@see add
 */
@Namespace("cv::cuda") public static native void add(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void add(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void add(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void add(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void add(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void add(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief Computes a matrix-matrix or matrix-scalar difference.
<p>
@param src1 First source matrix or scalar.
@param src2 Second source matrix or scalar. Matrix should have the same size and type as src1 .
@param dst Destination matrix that has the same size and number of channels as the input array(s).
The depth is defined by dtype or src1 depth.
@param mask Optional operation mask, 8-bit single channel array, that specifies elements of the
destination array to be changed. The mask can be used only with single channel images.
@param dtype Optional depth of the output array.
@param stream Stream for the asynchronous version.
<p>
@see subtract
 */
@Namespace("cv::cuda") public static native void subtract(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void subtract(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void subtract(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void subtract(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void subtract(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void subtract(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief Computes a matrix-matrix or matrix-scalar per-element product.
<p>
@param src1 First source matrix or scalar.
@param src2 Second source matrix or scalar.
@param dst Destination matrix that has the same size and number of channels as the input array(s).
The depth is defined by dtype or src1 depth.
@param scale Optional scale factor.
@param dtype Optional depth of the output array.
@param stream Stream for the asynchronous version.
<p>
@see multiply
 */
@Namespace("cv::cuda") public static native void multiply(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, double scale/*=1*/, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void multiply(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void multiply(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, double scale/*=1*/, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void multiply(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void multiply(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, double scale/*=1*/, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void multiply(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief Computes a matrix-matrix or matrix-scalar division.
<p>
@param src1 First source matrix or a scalar.
@param src2 Second source matrix or scalar.
@param dst Destination matrix that has the same size and number of channels as the input array(s).
The depth is defined by dtype or src1 depth.
@param scale Optional scale factor.
@param dtype Optional depth of the output array.
@param stream Stream for the asynchronous version.
<p>
This function, in contrast to divide, uses a round-down rounding mode.
<p>
@see divide
 */
@Namespace("cv::cuda") public static native void divide(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, double scale/*=1*/, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void divide(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void divide(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, double scale/*=1*/, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void divide(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void divide(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, double scale/*=1*/, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void divide(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief Computes per-element absolute difference of two matrices (or of a matrix and scalar).
<p>
@param src1 First source matrix or scalar.
@param src2 Second source matrix or scalar.
@param dst Destination matrix that has the same size and type as the input array(s).
@param stream Stream for the asynchronous version.
<p>
@see absdiff
 */
@Namespace("cv::cuda") public static native void absdiff(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void absdiff(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void absdiff(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void absdiff(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void absdiff(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void absdiff(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief Computes an absolute value of each matrix element.
<p>
@param src Source matrix.
@param dst Destination matrix with the same size and type as src .
@param stream Stream for the asynchronous version.
<p>
@see abs
 */
@Namespace("cv::cuda") public static native void abs(@ByVal Mat src, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void abs(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void abs(@ByVal UMat src, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void abs(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void abs(@ByVal GpuMat src, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void abs(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Computes a square value of each matrix element.
<p>
@param src Source matrix.
@param dst Destination matrix with the same size and type as src .
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void sqr(@ByVal Mat src, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void sqr(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void sqr(@ByVal UMat src, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void sqr(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void sqr(@ByVal GpuMat src, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void sqr(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Computes a square root of each matrix element.
<p>
@param src Source matrix.
@param dst Destination matrix with the same size and type as src .
@param stream Stream for the asynchronous version.
<p>
@see sqrt
 */
@Namespace("cv::cuda") public static native void sqrt(@ByVal Mat src, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void sqrt(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void sqrt(@ByVal UMat src, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void sqrt(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void sqrt(@ByVal GpuMat src, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void sqrt(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Computes an exponent of each matrix element.
<p>
@param src Source matrix.
@param dst Destination matrix with the same size and type as src .
@param stream Stream for the asynchronous version.
<p>
@see exp
 */
@Namespace("cv::cuda") public static native void exp(@ByVal Mat src, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void exp(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void exp(@ByVal UMat src, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void exp(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void exp(@ByVal GpuMat src, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void exp(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Computes a natural logarithm of absolute value of each matrix element.
<p>
@param src Source matrix.
@param dst Destination matrix with the same size and type as src .
@param stream Stream for the asynchronous version.
<p>
@see log
 */
@Namespace("cv::cuda") public static native void log(@ByVal Mat src, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void log(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void log(@ByVal UMat src, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void log(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void log(@ByVal GpuMat src, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void log(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Raises every matrix element to a power.
<p>
@param src Source matrix.
@param power Exponent of power.
@param dst Destination matrix with the same size and type as src .
@param stream Stream for the asynchronous version.
<p>
The function pow raises every element of the input matrix to power :
<p>
<pre>{@code \[\texttt{dst} (I) =  \fork{\texttt{src}(I)^power}{if \texttt{power} is integer}{|\texttt{src}(I)|^power}{otherwise}\]}</pre>
<p>
@see pow
 */
@Namespace("cv::cuda") public static native void pow(@ByVal Mat src, double power, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void pow(@ByVal Mat src, double power, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void pow(@ByVal UMat src, double power, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void pow(@ByVal UMat src, double power, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void pow(@ByVal GpuMat src, double power, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void pow(@ByVal GpuMat src, double power, @ByVal GpuMat dst);

/** \brief Compares elements of two matrices (or of a matrix and scalar).
<p>
@param src1 First source matrix or scalar.
@param src2 Second source matrix or scalar.
@param dst Destination matrix that has the same size as the input array(s) and type CV_8U.
@param cmpop Flag specifying the relation between the elements to be checked:
-   **CMP_EQ:** a(.) == b(.)
-   **CMP_GT:** a(.) \> b(.)
-   **CMP_GE:** a(.) \>= b(.)
-   **CMP_LT:** a(.) \< b(.)
-   **CMP_LE:** a(.) \<= b(.)
-   **CMP_NE:** a(.) != b(.)
@param stream Stream for the asynchronous version.
<p>
@see compare
 */
@Namespace("cv::cuda") public static native void compare(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, int cmpop, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void compare(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, int cmpop);
@Namespace("cv::cuda") public static native void compare(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, int cmpop, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void compare(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, int cmpop);
@Namespace("cv::cuda") public static native void compare(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, int cmpop, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void compare(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, int cmpop);

/** \brief Performs a per-element bitwise inversion.
<p>
@param src Source matrix.
@param dst Destination matrix with the same size and type as src .
@param mask Optional operation mask, 8-bit single channel array, that specifies elements of the
destination array to be changed. The mask can be used only with single channel images.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void bitwise_not(@ByVal Mat src, @ByVal Mat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bitwise_not(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void bitwise_not(@ByVal UMat src, @ByVal UMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bitwise_not(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void bitwise_not(@ByVal GpuMat src, @ByVal GpuMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bitwise_not(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Performs a per-element bitwise disjunction of two matrices (or of matrix and scalar).
<p>
@param src1 First source matrix or scalar.
@param src2 Second source matrix or scalar.
@param dst Destination matrix that has the same size and type as the input array(s).
@param mask Optional operation mask, 8-bit single channel array, that specifies elements of the
destination array to be changed. The mask can be used only with single channel images.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void bitwise_or(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bitwise_or(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void bitwise_or(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bitwise_or(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void bitwise_or(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bitwise_or(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief Performs a per-element bitwise conjunction of two matrices (or of matrix and scalar).
<p>
@param src1 First source matrix or scalar.
@param src2 Second source matrix or scalar.
@param dst Destination matrix that has the same size and type as the input array(s).
@param mask Optional operation mask, 8-bit single channel array, that specifies elements of the
destination array to be changed. The mask can be used only with single channel images.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void bitwise_and(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bitwise_and(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void bitwise_and(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bitwise_and(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void bitwise_and(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bitwise_and(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief Performs a per-element bitwise exclusive or operation of two matrices (or of matrix and scalar).
<p>
@param src1 First source matrix or scalar.
@param src2 Second source matrix or scalar.
@param dst Destination matrix that has the same size and type as the input array(s).
@param mask Optional operation mask, 8-bit single channel array, that specifies elements of the
destination array to be changed. The mask can be used only with single channel images.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void bitwise_xor(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bitwise_xor(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void bitwise_xor(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bitwise_xor(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void bitwise_xor(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void bitwise_xor(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief Performs pixel by pixel right shift of an image by a constant value.
<p>
@param src Source matrix. Supports 1, 3 and 4 channels images with integers elements.
@param val Constant values, one per channel.
@param dst Destination matrix with the same size and type as src .
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void rshift(@ByVal Mat src, @ByVal Scalar4i val, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void rshift(@ByVal Mat src, @ByVal Scalar4i val, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void rshift(@ByVal UMat src, @ByVal Scalar4i val, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void rshift(@ByVal UMat src, @ByVal Scalar4i val, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void rshift(@ByVal GpuMat src, @ByVal Scalar4i val, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void rshift(@ByVal GpuMat src, @ByVal Scalar4i val, @ByVal GpuMat dst);

@Namespace("cv::cuda") public static native void rshift(@ByVal Mat src, @ByVal Scalar val, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void rshift(@ByVal Mat src, @ByVal Scalar val, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void rshift(@ByVal UMat src, @ByVal Scalar val, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void rshift(@ByVal UMat src, @ByVal Scalar val, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void rshift(@ByVal GpuMat src, @ByVal Scalar val, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void rshift(@ByVal GpuMat src, @ByVal Scalar val, @ByVal GpuMat dst);

/** \brief Performs pixel by pixel right left of an image by a constant value.
<p>
@param src Source matrix. Supports 1, 3 and 4 channels images with CV_8U , CV_16U or CV_32S
depth.
@param val Constant values, one per channel.
@param dst Destination matrix with the same size and type as src .
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void lshift(@ByVal Mat src, @ByVal Scalar4i val, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void lshift(@ByVal Mat src, @ByVal Scalar4i val, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void lshift(@ByVal UMat src, @ByVal Scalar4i val, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void lshift(@ByVal UMat src, @ByVal Scalar4i val, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void lshift(@ByVal GpuMat src, @ByVal Scalar4i val, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void lshift(@ByVal GpuMat src, @ByVal Scalar4i val, @ByVal GpuMat dst);

@Namespace("cv::cuda") public static native void lshift(@ByVal Mat src, @ByVal Scalar val, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void lshift(@ByVal Mat src, @ByVal Scalar val, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void lshift(@ByVal UMat src, @ByVal Scalar val, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void lshift(@ByVal UMat src, @ByVal Scalar val, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void lshift(@ByVal GpuMat src, @ByVal Scalar val, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void lshift(@ByVal GpuMat src, @ByVal Scalar val, @ByVal GpuMat dst);

/** \brief Computes the per-element minimum of two matrices (or a matrix and a scalar).
<p>
@param src1 First source matrix or scalar.
@param src2 Second source matrix or scalar.
@param dst Destination matrix that has the same size and type as the input array(s).
@param stream Stream for the asynchronous version.
<p>
@see min
 */
@Namespace("cv::cuda") public static native void min(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void min(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void min(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void min(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void min(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void min(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief Computes the per-element maximum of two matrices (or a matrix and a scalar).
<p>
@param src1 First source matrix or scalar.
@param src2 Second source matrix or scalar.
@param dst Destination matrix that has the same size and type as the input array(s).
@param stream Stream for the asynchronous version.
<p>
@see max
 */
@Namespace("cv::cuda") public static native void max(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void max(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void max(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void max(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void max(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void max(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief Computes the weighted sum of two arrays.
<p>
@param src1 First source array.
@param alpha Weight for the first array elements.
@param src2 Second source array of the same size and channel number as src1 .
@param beta Weight for the second array elements.
@param dst Destination array that has the same size and number of channels as the input arrays.
@param gamma Scalar added to each sum.
@param dtype Optional depth of the destination array. When both input arrays have the same depth,
dtype can be set to -1, which will be equivalent to src1.depth().
@param stream Stream for the asynchronous version.
<p>
The function addWeighted calculates the weighted sum of two arrays as follows:
<p>
<pre>{@code \[\texttt{dst} (I)= \texttt{saturate} ( \texttt{src1} (I)* \texttt{alpha} +  \texttt{src2} (I)* \texttt{beta} +  \texttt{gamma} )\]}</pre>
<p>
where I is a multi-dimensional index of array elements. In case of multi-channel arrays, each
channel is processed independently.
<p>
@see addWeighted
 */
@Namespace("cv::cuda") public static native void addWeighted(@ByVal Mat src1, double alpha, @ByVal Mat src2, double beta, double gamma, @ByVal Mat dst,
                            int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void addWeighted(@ByVal Mat src1, double alpha, @ByVal Mat src2, double beta, double gamma, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void addWeighted(@ByVal UMat src1, double alpha, @ByVal UMat src2, double beta, double gamma, @ByVal UMat dst,
                            int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void addWeighted(@ByVal UMat src1, double alpha, @ByVal UMat src2, double beta, double gamma, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void addWeighted(@ByVal GpuMat src1, double alpha, @ByVal GpuMat src2, double beta, double gamma, @ByVal GpuMat dst,
                            int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void addWeighted(@ByVal GpuMat src1, double alpha, @ByVal GpuMat src2, double beta, double gamma, @ByVal GpuMat dst);

/** adds scaled array to another one (dst = alpha*src1 + src2) */
@Namespace("cv::cuda") public static native void scaleAdd(@ByVal Mat src1, double alpha, @ByVal Mat src2, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void scaleAdd(@ByVal Mat src1, double alpha, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void scaleAdd(@ByVal UMat src1, double alpha, @ByVal UMat src2, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void scaleAdd(@ByVal UMat src1, double alpha, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void scaleAdd(@ByVal GpuMat src1, double alpha, @ByVal GpuMat src2, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void scaleAdd(@ByVal GpuMat src1, double alpha, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief Applies a fixed-level threshold to each array element.
<p>
@param src Source array (single-channel).
@param dst Destination array with the same size and type as src .
@param thresh Threshold value.
@param maxval Maximum value to use with THRESH_BINARY and THRESH_BINARY_INV threshold types.
@param type Threshold type. For details, see threshold . The THRESH_OTSU and THRESH_TRIANGLE
threshold types are not supported.
@param stream Stream for the asynchronous version.
<p>
@see threshold
 */
@Namespace("cv::cuda") public static native double threshold(@ByVal Mat src, @ByVal Mat dst, double thresh, double maxval, int type, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native double threshold(@ByVal Mat src, @ByVal Mat dst, double thresh, double maxval, int type);
@Namespace("cv::cuda") public static native double threshold(@ByVal UMat src, @ByVal UMat dst, double thresh, double maxval, int type, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native double threshold(@ByVal UMat src, @ByVal UMat dst, double thresh, double maxval, int type);
@Namespace("cv::cuda") public static native double threshold(@ByVal GpuMat src, @ByVal GpuMat dst, double thresh, double maxval, int type, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native double threshold(@ByVal GpuMat src, @ByVal GpuMat dst, double thresh, double maxval, int type);

/** \brief  Checks if array elements lie between two scalars.
<p>
The function checks the range as follows:
-   For every element of a single-channel input array:
    <pre>{@code \[\texttt{dst} (I)= \texttt{lowerb}_0  \leq \texttt{src} (I)_0 \leq  \texttt{upperb}_0\]}</pre>
-   For two-channel arrays:
    <pre>{@code \[\texttt{dst} (I)= \texttt{lowerb}_0  \leq \texttt{src} (I)_0 \leq  \texttt{upperb}_0  \land \texttt{lowerb}_1  \leq \texttt{src} (I)_1 \leq  \texttt{upperb}_1\]}</pre>
-   and so forth.
<p>
That is, dst (I) is set to 255 (all 1 -bits) if src (I) is within the
specified 1D, 2D, 3D, ... box and 0 otherwise.
<p>
Note that unlike the CPU inRange, this does NOT accept an array for lowerb or
upperb, only a cv::Scalar.
<p>
@param src first input array.
@param lowerb inclusive lower boundary cv::Scalar.
@param upperb inclusive upper boundary cv::Scalar.
@param dst output array of the same size as src and CV_8U type.
@param stream Stream for the asynchronous version.
<p>
@see cv::inRange
 */
@Namespace("cv::cuda") public static native void inRange(@ByVal Mat src, @Const @ByRef Scalar lowerb, @Const @ByRef Scalar upperb, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void inRange(@ByVal Mat src, @Const @ByRef Scalar lowerb, @Const @ByRef Scalar upperb, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void inRange(@ByVal UMat src, @Const @ByRef Scalar lowerb, @Const @ByRef Scalar upperb, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void inRange(@ByVal UMat src, @Const @ByRef Scalar lowerb, @Const @ByRef Scalar upperb, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void inRange(@ByVal GpuMat src, @Const @ByRef Scalar lowerb, @Const @ByRef Scalar upperb, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void inRange(@ByVal GpuMat src, @Const @ByRef Scalar lowerb, @Const @ByRef Scalar upperb, @ByVal GpuMat dst);

/** \brief Computes magnitudes of complex matrix elements.
<p>
@param xy Source complex matrix in the interleaved format ( CV_32FC2 ).
@param magnitude Destination matrix of float magnitudes ( CV_32FC1 ).
@param stream Stream for the asynchronous version.
<p>
@see magnitude
 */
@Namespace("cv::cuda") public static native void magnitude(@ByVal Mat xy, @ByVal Mat magnitude, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void magnitude(@ByVal Mat xy, @ByVal Mat magnitude);
@Namespace("cv::cuda") public static native void magnitude(@ByVal UMat xy, @ByVal UMat magnitude, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void magnitude(@ByVal UMat xy, @ByVal UMat magnitude);
@Namespace("cv::cuda") public static native void magnitude(@ByVal GpuMat xy, @ByVal GpuMat magnitude, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void magnitude(@ByVal GpuMat xy, @ByVal GpuMat magnitude);

/** \brief Computes squared magnitudes of complex matrix elements.
<p>
@param xy Source complex matrix in the interleaved format ( CV_32FC2 ).
@param magnitude Destination matrix of float magnitude squares ( CV_32FC1 ).
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void magnitudeSqr(@ByVal Mat xy, @ByVal Mat magnitude, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void magnitudeSqr(@ByVal Mat xy, @ByVal Mat magnitude);
@Namespace("cv::cuda") public static native void magnitudeSqr(@ByVal UMat xy, @ByVal UMat magnitude, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void magnitudeSqr(@ByVal UMat xy, @ByVal UMat magnitude);
@Namespace("cv::cuda") public static native void magnitudeSqr(@ByVal GpuMat xy, @ByVal GpuMat magnitude, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void magnitudeSqr(@ByVal GpuMat xy, @ByVal GpuMat magnitude);

/** \overload
 computes magnitude of each (x(i), y(i)) vector
 supports only floating-point source
@param x Source matrix containing real components ( CV_32FC1 ).
@param y Source matrix containing imaginary components ( CV_32FC1 ).
@param magnitude Destination matrix of float magnitudes ( CV_32FC1 ).
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void magnitude(@ByVal Mat x, @ByVal Mat y, @ByVal Mat magnitude, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void magnitude(@ByVal Mat x, @ByVal Mat y, @ByVal Mat magnitude);
@Namespace("cv::cuda") public static native void magnitude(@ByVal UMat x, @ByVal UMat y, @ByVal UMat magnitude, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void magnitude(@ByVal UMat x, @ByVal UMat y, @ByVal UMat magnitude);
@Namespace("cv::cuda") public static native void magnitude(@ByVal GpuMat x, @ByVal GpuMat y, @ByVal GpuMat magnitude, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void magnitude(@ByVal GpuMat x, @ByVal GpuMat y, @ByVal GpuMat magnitude);

/** \overload
 computes squared magnitude of each (x(i), y(i)) vector
 supports only floating-point source
@param x Source matrix containing real components ( CV_32FC1 ).
@param y Source matrix containing imaginary components ( CV_32FC1 ).
@param magnitude Destination matrix of float magnitude squares ( CV_32FC1 ).
@param stream Stream for the asynchronous version.
*/
@Namespace("cv::cuda") public static native void magnitudeSqr(@ByVal Mat x, @ByVal Mat y, @ByVal Mat magnitude, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void magnitudeSqr(@ByVal Mat x, @ByVal Mat y, @ByVal Mat magnitude);
@Namespace("cv::cuda") public static native void magnitudeSqr(@ByVal UMat x, @ByVal UMat y, @ByVal UMat magnitude, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void magnitudeSqr(@ByVal UMat x, @ByVal UMat y, @ByVal UMat magnitude);
@Namespace("cv::cuda") public static native void magnitudeSqr(@ByVal GpuMat x, @ByVal GpuMat y, @ByVal GpuMat magnitude, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void magnitudeSqr(@ByVal GpuMat x, @ByVal GpuMat y, @ByVal GpuMat magnitude);

/** \brief Computes polar angles of complex matrix elements.
<p>
@param x Source matrix containing real components ( CV_32FC1 ).
@param y Source matrix containing imaginary components ( CV_32FC1 ).
@param angle Destination matrix of angles ( CV_32FC1 ).
@param angleInDegrees Flag for angles that must be evaluated in degrees.
@param stream Stream for the asynchronous version.
<p>
@see phase
 */
@Namespace("cv::cuda") public static native void phase(@ByVal Mat x, @ByVal Mat y, @ByVal Mat angle, @Cast("bool") boolean angleInDegrees/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void phase(@ByVal Mat x, @ByVal Mat y, @ByVal Mat angle);
@Namespace("cv::cuda") public static native void phase(@ByVal UMat x, @ByVal UMat y, @ByVal UMat angle, @Cast("bool") boolean angleInDegrees/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void phase(@ByVal UMat x, @ByVal UMat y, @ByVal UMat angle);
@Namespace("cv::cuda") public static native void phase(@ByVal GpuMat x, @ByVal GpuMat y, @ByVal GpuMat angle, @Cast("bool") boolean angleInDegrees/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void phase(@ByVal GpuMat x, @ByVal GpuMat y, @ByVal GpuMat angle);

/** \brief Converts Cartesian coordinates into polar.
<p>
@param x Source matrix containing real components ( CV_32FC1 ).
@param y Source matrix containing imaginary components ( CV_32FC1 ).
@param magnitude Destination matrix of float magnitudes ( CV_32FC1 ).
@param angle Destination matrix of angles ( CV_32FC1 ).
@param angleInDegrees Flag for angles that must be evaluated in degrees.
@param stream Stream for the asynchronous version.
<p>
@see cartToPolar
 */
@Namespace("cv::cuda") public static native void cartToPolar(@ByVal Mat x, @ByVal Mat y, @ByVal Mat magnitude, @ByVal Mat angle, @Cast("bool") boolean angleInDegrees/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void cartToPolar(@ByVal Mat x, @ByVal Mat y, @ByVal Mat magnitude, @ByVal Mat angle);
@Namespace("cv::cuda") public static native void cartToPolar(@ByVal UMat x, @ByVal UMat y, @ByVal UMat magnitude, @ByVal UMat angle, @Cast("bool") boolean angleInDegrees/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void cartToPolar(@ByVal UMat x, @ByVal UMat y, @ByVal UMat magnitude, @ByVal UMat angle);
@Namespace("cv::cuda") public static native void cartToPolar(@ByVal GpuMat x, @ByVal GpuMat y, @ByVal GpuMat magnitude, @ByVal GpuMat angle, @Cast("bool") boolean angleInDegrees/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void cartToPolar(@ByVal GpuMat x, @ByVal GpuMat y, @ByVal GpuMat magnitude, @ByVal GpuMat angle);

/** \brief Converts polar coordinates into Cartesian.
<p>
@param magnitude Source matrix containing magnitudes ( CV_32FC1 or CV_64FC1 ).
@param angle Source matrix containing angles ( same type as magnitude ).
@param x Destination matrix of real components ( same type as magnitude ).
@param y Destination matrix of imaginary components ( same type as magnitude ).
@param angleInDegrees Flag that indicates angles in degrees.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void polarToCart(@ByVal Mat magnitude, @ByVal Mat angle, @ByVal Mat x, @ByVal Mat y, @Cast("bool") boolean angleInDegrees/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void polarToCart(@ByVal Mat magnitude, @ByVal Mat angle, @ByVal Mat x, @ByVal Mat y);
@Namespace("cv::cuda") public static native void polarToCart(@ByVal UMat magnitude, @ByVal UMat angle, @ByVal UMat x, @ByVal UMat y, @Cast("bool") boolean angleInDegrees/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void polarToCart(@ByVal UMat magnitude, @ByVal UMat angle, @ByVal UMat x, @ByVal UMat y);
@Namespace("cv::cuda") public static native void polarToCart(@ByVal GpuMat magnitude, @ByVal GpuMat angle, @ByVal GpuMat x, @ByVal GpuMat y, @Cast("bool") boolean angleInDegrees/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void polarToCart(@ByVal GpuMat magnitude, @ByVal GpuMat angle, @ByVal GpuMat x, @ByVal GpuMat y);

/** \} cudaarithm_elem
 <p>
 *  \addtogroup cudaarithm_core
 *  \{
<p>
/** \brief Makes a multi-channel matrix out of several single-channel matrices.
<p>
@param src Array/vector of source matrices.
@param n Number of source matrices.
@param dst Destination matrix.
@param stream Stream for the asynchronous version.
<p>
@see merge
 */
@Namespace("cv::cuda") public static native void merge(@Const GpuMat src, @Cast("size_t") long n, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void merge(@Const GpuMat src, @Cast("size_t") long n, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void merge(@Const GpuMat src, @Cast("size_t") long n, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void merge(@Const GpuMat src, @Cast("size_t") long n, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void merge(@Const GpuMat src, @Cast("size_t") long n, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void merge(@Const GpuMat src, @Cast("size_t") long n, @ByVal GpuMat dst);
/** \overload */
@Namespace("cv::cuda") public static native void merge(@Const @ByRef GpuMatVector src, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void merge(@Const @ByRef GpuMatVector src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void merge(@Const @ByRef GpuMatVector src, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void merge(@Const @ByRef GpuMatVector src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void merge(@Const @ByRef GpuMatVector src, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void merge(@Const @ByRef GpuMatVector src, @ByVal GpuMat dst);

/** \brief Copies each plane of a multi-channel matrix into an array.
<p>
@param src Source matrix.
@param dst Destination array/vector of single-channel matrices.
@param stream Stream for the asynchronous version.
<p>
@see split
 */
@Namespace("cv::cuda") public static native void split(@ByVal Mat src, GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void split(@ByVal Mat src, GpuMat dst);
@Namespace("cv::cuda") public static native void split(@ByVal UMat src, GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void split(@ByVal UMat src, GpuMat dst);
@Namespace("cv::cuda") public static native void split(@ByVal GpuMat src, GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void split(@ByVal GpuMat src, GpuMat dst);
/** \overload */
@Namespace("cv::cuda") public static native void split(@ByVal Mat src, @ByRef GpuMatVector dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void split(@ByVal Mat src, @ByRef GpuMatVector dst);
@Namespace("cv::cuda") public static native void split(@ByVal UMat src, @ByRef GpuMatVector dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void split(@ByVal UMat src, @ByRef GpuMatVector dst);
@Namespace("cv::cuda") public static native void split(@ByVal GpuMat src, @ByRef GpuMatVector dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void split(@ByVal GpuMat src, @ByRef GpuMatVector dst);

/** \brief Transposes a matrix.
<p>
@param src1 Source matrix. 1-, 4-, 8-byte element sizes are supported for now.
@param dst Destination matrix.
@param stream Stream for the asynchronous version.
<p>
@see transpose
 */
@Namespace("cv::cuda") public static native void transpose(@ByVal Mat src1, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void transpose(@ByVal Mat src1, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void transpose(@ByVal UMat src1, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void transpose(@ByVal UMat src1, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void transpose(@ByVal GpuMat src1, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void transpose(@ByVal GpuMat src1, @ByVal GpuMat dst);

/** \brief Flips a 2D matrix around vertical, horizontal, or both axes.
<p>
@param src Source matrix. Supports 1, 3 and 4 channels images with CV_8U, CV_16U, CV_32S or
CV_32F depth.
@param dst Destination matrix.
@param flipCode Flip mode for the source:
-   0 Flips around x-axis.
-   \> 0 Flips around y-axis.
-   \< 0 Flips around both axes.
@param stream Stream for the asynchronous version.
<p>
@see flip
 */
@Namespace("cv::cuda") public static native void flip(@ByVal Mat src, @ByVal Mat dst, int flipCode, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void flip(@ByVal Mat src, @ByVal Mat dst, int flipCode);
@Namespace("cv::cuda") public static native void flip(@ByVal UMat src, @ByVal UMat dst, int flipCode, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void flip(@ByVal UMat src, @ByVal UMat dst, int flipCode);
@Namespace("cv::cuda") public static native void flip(@ByVal GpuMat src, @ByVal GpuMat dst, int flipCode, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void flip(@ByVal GpuMat src, @ByVal GpuMat dst, int flipCode);
// Targeting ..\opencv_cudaarithm\LookUpTable.java



/** \brief Creates implementation for cuda::LookUpTable .
<p>
@param lut Look-up table of 256 elements. It is a continuous CV_8U matrix.
 */
@Namespace("cv::cuda") public static native @Ptr LookUpTable createLookUpTable(@ByVal Mat lut);
@Namespace("cv::cuda") public static native @Ptr LookUpTable createLookUpTable(@ByVal UMat lut);
@Namespace("cv::cuda") public static native @Ptr LookUpTable createLookUpTable(@ByVal GpuMat lut);

/** \brief Forms a border around an image.
<p>
@param src Source image. CV_8UC1 , CV_8UC4 , CV_32SC1 , and CV_32FC1 types are supported.
@param dst Destination image with the same type as src. The size is
Size(src.cols+left+right, src.rows+top+bottom) .
@param top Number of top pixels
@param bottom Number of bottom pixels
@param left Number of left pixels
@param right Number of pixels in each direction from the source image rectangle to extrapolate.
For example: top=1, bottom=1, left=1, right=1 mean that 1 pixel-wide border needs to be built.
@param borderType Border type. See borderInterpolate for details. BORDER_REFLECT101 ,
BORDER_REPLICATE , BORDER_CONSTANT , BORDER_REFLECT and BORDER_WRAP are supported for now.
@param value Border value.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void copyMakeBorder(@ByVal Mat src, @ByVal Mat dst, int top, int bottom, int left, int right, int borderType,
                               @ByVal(nullValue = "cv::Scalar()") Scalar value, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void copyMakeBorder(@ByVal Mat src, @ByVal Mat dst, int top, int bottom, int left, int right, int borderType);
@Namespace("cv::cuda") public static native void copyMakeBorder(@ByVal UMat src, @ByVal UMat dst, int top, int bottom, int left, int right, int borderType,
                               @ByVal(nullValue = "cv::Scalar()") Scalar value, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void copyMakeBorder(@ByVal UMat src, @ByVal UMat dst, int top, int bottom, int left, int right, int borderType);
@Namespace("cv::cuda") public static native void copyMakeBorder(@ByVal GpuMat src, @ByVal GpuMat dst, int top, int bottom, int left, int right, int borderType,
                               @ByVal(nullValue = "cv::Scalar()") Scalar value, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void copyMakeBorder(@ByVal GpuMat src, @ByVal GpuMat dst, int top, int bottom, int left, int right, int borderType);

/** \} cudaarithm_core
 <p>
 *  \addtogroup cudaarithm_reduce
 *  \{
<p>
/** \brief Returns the norm of a matrix (or difference of two matrices).
<p>
@param src1 Source matrix. Any matrices except 64F are supported.
@param normType Norm type. NORM_L1 , NORM_L2 , and NORM_INF are supported for now.
@param mask optional operation mask; it must have the same size as src1 and CV_8UC1 type.
<p>
@see norm
 */
@Namespace("cv::cuda") public static native double norm(@ByVal Mat src1, int normType, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv::cuda") public static native double norm(@ByVal Mat src1, int normType);
@Namespace("cv::cuda") public static native double norm(@ByVal UMat src1, int normType, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv::cuda") public static native double norm(@ByVal UMat src1, int normType);
@Namespace("cv::cuda") public static native double norm(@ByVal GpuMat src1, int normType, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv::cuda") public static native double norm(@ByVal GpuMat src1, int normType);
/** \overload */
@Namespace("cv::cuda") public static native void calcNorm(@ByVal Mat src, @ByVal Mat dst, int normType, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcNorm(@ByVal Mat src, @ByVal Mat dst, int normType);
@Namespace("cv::cuda") public static native void calcNorm(@ByVal UMat src, @ByVal UMat dst, int normType, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcNorm(@ByVal UMat src, @ByVal UMat dst, int normType);
@Namespace("cv::cuda") public static native void calcNorm(@ByVal GpuMat src, @ByVal GpuMat dst, int normType, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcNorm(@ByVal GpuMat src, @ByVal GpuMat dst, int normType);

/** \brief Returns the difference of two matrices.
<p>
@param src1 Source matrix. Any matrices except 64F are supported.
@param src2 Second source matrix (if any) with the same size and type as src1.
@param normType Norm type. NORM_L1 , NORM_L2 , and NORM_INF are supported for now.
<p>
@see norm
 */
@Namespace("cv::cuda") public static native double norm(@ByVal Mat src1, @ByVal Mat src2, int normType/*=cv::NORM_L2*/);
@Namespace("cv::cuda") public static native double norm(@ByVal Mat src1, @ByVal Mat src2);
@Namespace("cv::cuda") public static native double norm(@ByVal UMat src1, @ByVal UMat src2, int normType/*=cv::NORM_L2*/);
@Namespace("cv::cuda") public static native double norm(@ByVal UMat src1, @ByVal UMat src2);
@Namespace("cv::cuda") public static native double norm(@ByVal GpuMat src1, @ByVal GpuMat src2, int normType/*=cv::NORM_L2*/);
@Namespace("cv::cuda") public static native double norm(@ByVal GpuMat src1, @ByVal GpuMat src2);
/** \overload */
@Namespace("cv::cuda") public static native void calcNormDiff(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, int normType/*=cv::NORM_L2*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcNormDiff(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void calcNormDiff(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, int normType/*=cv::NORM_L2*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcNormDiff(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void calcNormDiff(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, int normType/*=cv::NORM_L2*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcNormDiff(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst);

/** \brief Returns the sum of matrix elements.
<p>
@param src Source image of any depth except for CV_64F .
@param mask optional operation mask; it must have the same size as src1 and CV_8UC1 type.
<p>
@see sum
 */
@Namespace("cv::cuda") public static native @ByVal Scalar sum(@ByVal Mat src, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv::cuda") public static native @ByVal Scalar sum(@ByVal Mat src);
@Namespace("cv::cuda") public static native @ByVal Scalar sum(@ByVal UMat src, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv::cuda") public static native @ByVal Scalar sum(@ByVal UMat src);
@Namespace("cv::cuda") public static native @ByVal Scalar sum(@ByVal GpuMat src, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv::cuda") public static native @ByVal Scalar sum(@ByVal GpuMat src);
/** \overload */
@Namespace("cv::cuda") public static native void calcSum(@ByVal Mat src, @ByVal Mat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcSum(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void calcSum(@ByVal UMat src, @ByVal UMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcSum(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void calcSum(@ByVal GpuMat src, @ByVal GpuMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcSum(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Returns the sum of absolute values for matrix elements.
<p>
@param src Source image of any depth except for CV_64F .
@param mask optional operation mask; it must have the same size as src1 and CV_8UC1 type.
 */
@Namespace("cv::cuda") public static native @ByVal Scalar absSum(@ByVal Mat src, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv::cuda") public static native @ByVal Scalar absSum(@ByVal Mat src);
@Namespace("cv::cuda") public static native @ByVal Scalar absSum(@ByVal UMat src, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv::cuda") public static native @ByVal Scalar absSum(@ByVal UMat src);
@Namespace("cv::cuda") public static native @ByVal Scalar absSum(@ByVal GpuMat src, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv::cuda") public static native @ByVal Scalar absSum(@ByVal GpuMat src);
/** \overload */
@Namespace("cv::cuda") public static native void calcAbsSum(@ByVal Mat src, @ByVal Mat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcAbsSum(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void calcAbsSum(@ByVal UMat src, @ByVal UMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcAbsSum(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void calcAbsSum(@ByVal GpuMat src, @ByVal GpuMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcAbsSum(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Returns the squared sum of matrix elements.
<p>
@param src Source image of any depth except for CV_64F .
@param mask optional operation mask; it must have the same size as src1 and CV_8UC1 type.
 */
@Namespace("cv::cuda") public static native @ByVal Scalar sqrSum(@ByVal Mat src, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv::cuda") public static native @ByVal Scalar sqrSum(@ByVal Mat src);
@Namespace("cv::cuda") public static native @ByVal Scalar sqrSum(@ByVal UMat src, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv::cuda") public static native @ByVal Scalar sqrSum(@ByVal UMat src);
@Namespace("cv::cuda") public static native @ByVal Scalar sqrSum(@ByVal GpuMat src, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv::cuda") public static native @ByVal Scalar sqrSum(@ByVal GpuMat src);
/** \overload */
@Namespace("cv::cuda") public static native void calcSqrSum(@ByVal Mat src, @ByVal Mat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcSqrSum(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void calcSqrSum(@ByVal UMat src, @ByVal UMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcSqrSum(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void calcSqrSum(@ByVal GpuMat src, @ByVal GpuMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void calcSqrSum(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Finds global minimum and maximum matrix elements and returns their values.
<p>
@param src Single-channel source image.
@param minVal Pointer to the returned minimum value. Use NULL if not required.
@param maxVal Pointer to the returned maximum value. Use NULL if not required.
@param mask Optional mask to select a sub-matrix.
<p>
The function does not work with CV_64F images on GPUs with the compute capability \< 1.3.
<p>
@see minMaxLoc
 */
@Namespace("cv::cuda") public static native void minMax(@ByVal Mat src, DoublePointer minVal, DoublePointer maxVal, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv::cuda") public static native void minMax(@ByVal Mat src, DoublePointer minVal, DoublePointer maxVal);
@Namespace("cv::cuda") public static native void minMax(@ByVal Mat src, DoubleBuffer minVal, DoubleBuffer maxVal, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv::cuda") public static native void minMax(@ByVal Mat src, DoubleBuffer minVal, DoubleBuffer maxVal);
@Namespace("cv::cuda") public static native void minMax(@ByVal Mat src, double[] minVal, double[] maxVal, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv::cuda") public static native void minMax(@ByVal Mat src, double[] minVal, double[] maxVal);
@Namespace("cv::cuda") public static native void minMax(@ByVal UMat src, DoublePointer minVal, DoublePointer maxVal, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv::cuda") public static native void minMax(@ByVal UMat src, DoublePointer minVal, DoublePointer maxVal);
@Namespace("cv::cuda") public static native void minMax(@ByVal UMat src, DoubleBuffer minVal, DoubleBuffer maxVal, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv::cuda") public static native void minMax(@ByVal UMat src, DoubleBuffer minVal, DoubleBuffer maxVal);
@Namespace("cv::cuda") public static native void minMax(@ByVal UMat src, double[] minVal, double[] maxVal, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv::cuda") public static native void minMax(@ByVal UMat src, double[] minVal, double[] maxVal);
@Namespace("cv::cuda") public static native void minMax(@ByVal GpuMat src, DoublePointer minVal, DoublePointer maxVal, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv::cuda") public static native void minMax(@ByVal GpuMat src, DoublePointer minVal, DoublePointer maxVal);
@Namespace("cv::cuda") public static native void minMax(@ByVal GpuMat src, DoubleBuffer minVal, DoubleBuffer maxVal, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv::cuda") public static native void minMax(@ByVal GpuMat src, DoubleBuffer minVal, DoubleBuffer maxVal);
@Namespace("cv::cuda") public static native void minMax(@ByVal GpuMat src, double[] minVal, double[] maxVal, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv::cuda") public static native void minMax(@ByVal GpuMat src, double[] minVal, double[] maxVal);
/** \overload */
@Namespace("cv::cuda") public static native void findMinMax(@ByVal Mat src, @ByVal Mat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void findMinMax(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void findMinMax(@ByVal UMat src, @ByVal UMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void findMinMax(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void findMinMax(@ByVal GpuMat src, @ByVal GpuMat dst, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void findMinMax(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Finds global minimum and maximum matrix elements and returns their values with locations.
<p>
@param src Single-channel source image.
@param minVal Pointer to the returned minimum value. Use NULL if not required.
@param maxVal Pointer to the returned maximum value. Use NULL if not required.
@param minLoc Pointer to the returned minimum location. Use NULL if not required.
@param maxLoc Pointer to the returned maximum location. Use NULL if not required.
@param mask Optional mask to select a sub-matrix.
<p>
The function does not work with CV_64F images on GPU with the compute capability \< 1.3.
<p>
@see minMaxLoc
 */
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal Mat src, DoublePointer minVal, DoublePointer maxVal, Point minLoc, Point maxLoc,
                          @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal Mat src, DoublePointer minVal, DoublePointer maxVal, Point minLoc, Point maxLoc);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal Mat src, DoubleBuffer minVal, DoubleBuffer maxVal, Point minLoc, Point maxLoc,
                          @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal Mat src, DoubleBuffer minVal, DoubleBuffer maxVal, Point minLoc, Point maxLoc);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal Mat src, double[] minVal, double[] maxVal, Point minLoc, Point maxLoc,
                          @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal Mat src, double[] minVal, double[] maxVal, Point minLoc, Point maxLoc);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal UMat src, DoublePointer minVal, DoublePointer maxVal, Point minLoc, Point maxLoc,
                          @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal UMat src, DoublePointer minVal, DoublePointer maxVal, Point minLoc, Point maxLoc);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal UMat src, DoubleBuffer minVal, DoubleBuffer maxVal, Point minLoc, Point maxLoc,
                          @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal UMat src, DoubleBuffer minVal, DoubleBuffer maxVal, Point minLoc, Point maxLoc);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal UMat src, double[] minVal, double[] maxVal, Point minLoc, Point maxLoc,
                          @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal UMat src, double[] minVal, double[] maxVal, Point minLoc, Point maxLoc);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal GpuMat src, DoublePointer minVal, DoublePointer maxVal, Point minLoc, Point maxLoc,
                          @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal GpuMat src, DoublePointer minVal, DoublePointer maxVal, Point minLoc, Point maxLoc);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal GpuMat src, DoubleBuffer minVal, DoubleBuffer maxVal, Point minLoc, Point maxLoc,
                          @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal GpuMat src, DoubleBuffer minVal, DoubleBuffer maxVal, Point minLoc, Point maxLoc);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal GpuMat src, double[] minVal, double[] maxVal, Point minLoc, Point maxLoc,
                          @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask);
@Namespace("cv::cuda") public static native void minMaxLoc(@ByVal GpuMat src, double[] minVal, double[] maxVal, Point minLoc, Point maxLoc);
/** \overload */
@Namespace("cv::cuda") public static native void findMinMaxLoc(@ByVal Mat src, @ByVal Mat minMaxVals, @ByVal Mat loc,
                              @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void findMinMaxLoc(@ByVal Mat src, @ByVal Mat minMaxVals, @ByVal Mat loc);
@Namespace("cv::cuda") public static native void findMinMaxLoc(@ByVal UMat src, @ByVal UMat minMaxVals, @ByVal UMat loc,
                              @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void findMinMaxLoc(@ByVal UMat src, @ByVal UMat minMaxVals, @ByVal UMat loc);
@Namespace("cv::cuda") public static native void findMinMaxLoc(@ByVal GpuMat src, @ByVal GpuMat minMaxVals, @ByVal GpuMat loc,
                              @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void findMinMaxLoc(@ByVal GpuMat src, @ByVal GpuMat minMaxVals, @ByVal GpuMat loc);

/** \brief Counts non-zero matrix elements.
<p>
@param src Single-channel source image.
<p>
The function does not work with CV_64F images on GPUs with the compute capability \< 1.3.
<p>
@see countNonZero
 */
@Namespace("cv::cuda") public static native int countNonZero(@ByVal Mat src);
@Namespace("cv::cuda") public static native int countNonZero(@ByVal UMat src);
@Namespace("cv::cuda") public static native int countNonZero(@ByVal GpuMat src);
/** \overload */
@Namespace("cv::cuda") public static native void countNonZero(@ByVal Mat src, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void countNonZero(@ByVal Mat src, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void countNonZero(@ByVal UMat src, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void countNonZero(@ByVal UMat src, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void countNonZero(@ByVal GpuMat src, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void countNonZero(@ByVal GpuMat src, @ByVal GpuMat dst);

/** \brief Reduces a matrix to a vector.
<p>
@param mtx Source 2D matrix.
@param vec Destination vector. Its size and type is defined by dim and dtype parameters.
@param dim Dimension index along which the matrix is reduced. 0 means that the matrix is reduced
to a single row. 1 means that the matrix is reduced to a single column.
@param reduceOp Reduction operation that could be one of the following:
-   **REDUCE_SUM** The output is the sum of all rows/columns of the matrix.
-   **REDUCE_AVG** The output is the mean vector of all rows/columns of the matrix.
-   **REDUCE_MAX** The output is the maximum (column/row-wise) of all rows/columns of the
matrix.
-   **REDUCE_MIN** The output is the minimum (column/row-wise) of all rows/columns of the
matrix.
@param dtype When it is negative, the destination vector will have the same type as the source
matrix. Otherwise, its type will be CV_MAKE_TYPE(CV_MAT_DEPTH(dtype), mtx.channels()) .
@param stream Stream for the asynchronous version.
<p>
The function reduce reduces the matrix to a vector by treating the matrix rows/columns as a set of
1D vectors and performing the specified operation on the vectors until a single row/column is
obtained. For example, the function can be used to compute horizontal and vertical projections of a
raster image. In case of REDUCE_SUM and REDUCE_AVG , the output may have a larger element
bit-depth to preserve accuracy. And multi-channel arrays are also supported in these two reduction
modes.
<p>
@see reduce
 */
@Namespace("cv::cuda") public static native void reduce(@ByVal Mat mtx, @ByVal Mat vec, int dim, int reduceOp, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void reduce(@ByVal Mat mtx, @ByVal Mat vec, int dim, int reduceOp);
@Namespace("cv::cuda") public static native void reduce(@ByVal UMat mtx, @ByVal UMat vec, int dim, int reduceOp, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void reduce(@ByVal UMat mtx, @ByVal UMat vec, int dim, int reduceOp);
@Namespace("cv::cuda") public static native void reduce(@ByVal GpuMat mtx, @ByVal GpuMat vec, int dim, int reduceOp, int dtype/*=-1*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void reduce(@ByVal GpuMat mtx, @ByVal GpuMat vec, int dim, int reduceOp);

/** \brief Computes a mean value and a standard deviation of matrix elements.
<p>
@param src Source matrix. CV_8UC1 and CV_32FC1 matrices are supported for now.
@param dst Target GpuMat with size 1x2 and type CV_64FC1. The first value is mean, the second - stddev.
@param mask Operation mask.
@param stream Stream for the asynchronous version.
<p>
@see meanStdDev
 */
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal Mat src, @ByVal Mat dst, @ByVal Mat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal Mat src, @ByVal Mat dst, @ByVal Mat mask);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal UMat src, @ByVal UMat dst, @ByVal UMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal UMat src, @ByVal UMat dst, @ByVal UMat mask);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal GpuMat src, @ByVal GpuMat dst, @ByVal GpuMat mask, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal GpuMat src, @ByVal GpuMat dst, @ByVal GpuMat mask);
/** \overload
@param mtx Source matrix. CV_8UC1 and CV_32FC1 matrices are supported for now.
@param dst Target GpuMat with size 1x2 and type CV_64FC1. The first value is mean, the second - stddev.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal Mat mtx, @ByVal Mat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal Mat mtx, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal UMat mtx, @ByVal UMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal UMat mtx, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal GpuMat mtx, @ByVal GpuMat dst, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal GpuMat mtx, @ByVal GpuMat dst);
/** \overload
@param src Source matrix. CV_8UC1 and CV_32FC1 matrices are supported for now.
@param mean Mean value.
@param stddev Standard deviation value.
@param mask Operation mask.
 */
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal Mat src, @ByRef Scalar mean, @ByRef Scalar stddev, @ByVal Mat mask);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal UMat src, @ByRef Scalar mean, @ByRef Scalar stddev, @ByVal UMat mask);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal GpuMat src, @ByRef Scalar mean, @ByRef Scalar stddev, @ByVal GpuMat mask);
/** \overload
@param mtx Source matrix. CV_8UC1 and CV_32FC1 matrices are supported for now.
@param mean Mean value.
@param stddev Standard deviation value.
 */
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal Mat mtx, @ByRef Scalar mean, @ByRef Scalar stddev);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal UMat mtx, @ByRef Scalar mean, @ByRef Scalar stddev);
@Namespace("cv::cuda") public static native void meanStdDev(@ByVal GpuMat mtx, @ByRef Scalar mean, @ByRef Scalar stddev);

/** \brief Computes a standard deviation of integral images.
<p>
@param src Source image. Only the CV_32SC1 type is supported.
@param sqr Squared source image. Only the CV_32FC1 type is supported.
@param dst Destination image with the same type and size as src.
@param rect Rectangular window.
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void rectStdDev(@ByVal Mat src, @ByVal Mat sqr, @ByVal Mat dst, @ByVal Rect rect, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void rectStdDev(@ByVal Mat src, @ByVal Mat sqr, @ByVal Mat dst, @ByVal Rect rect);
@Namespace("cv::cuda") public static native void rectStdDev(@ByVal UMat src, @ByVal UMat sqr, @ByVal UMat dst, @ByVal Rect rect, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void rectStdDev(@ByVal UMat src, @ByVal UMat sqr, @ByVal UMat dst, @ByVal Rect rect);
@Namespace("cv::cuda") public static native void rectStdDev(@ByVal GpuMat src, @ByVal GpuMat sqr, @ByVal GpuMat dst, @ByVal Rect rect, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void rectStdDev(@ByVal GpuMat src, @ByVal GpuMat sqr, @ByVal GpuMat dst, @ByVal Rect rect);

/** \brief Normalizes the norm or value range of an array.
<p>
@param src Input array.
@param dst Output array of the same size as src .
@param alpha Norm value to normalize to or the lower range boundary in case of the range
normalization.
@param beta Upper range boundary in case of the range normalization; it is not used for the norm
normalization.
@param norm_type Normalization type ( NORM_MINMAX , NORM_L2 , NORM_L1 or NORM_INF ).
@param dtype When negative, the output array has the same type as src; otherwise, it has the same
number of channels as src and the depth =CV_MAT_DEPTH(dtype).
@param mask Optional operation mask.
@param stream Stream for the asynchronous version.
<p>
@see normalize
 */
@Namespace("cv::cuda") public static native void normalize(@ByVal Mat src, @ByVal Mat dst, double alpha, double beta,
                          int norm_type, int dtype, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat mask,
                          @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void normalize(@ByVal Mat src, @ByVal Mat dst, double alpha, double beta,
                          int norm_type, int dtype);
@Namespace("cv::cuda") public static native void normalize(@ByVal UMat src, @ByVal UMat dst, double alpha, double beta,
                          int norm_type, int dtype, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat mask,
                          @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void normalize(@ByVal UMat src, @ByVal UMat dst, double alpha, double beta,
                          int norm_type, int dtype);
@Namespace("cv::cuda") public static native void normalize(@ByVal GpuMat src, @ByVal GpuMat dst, double alpha, double beta,
                          int norm_type, int dtype, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat mask,
                          @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void normalize(@ByVal GpuMat src, @ByVal GpuMat dst, double alpha, double beta,
                          int norm_type, int dtype);

/** \brief Computes an integral image.
<p>
@param src Source image. Only CV_8UC1 images are supported for now.
@param sum Integral image containing 32-bit unsigned integer values packed into CV_32SC1 .
@param stream Stream for the asynchronous version.
<p>
@see integral
 */
@Namespace("cv::cuda") public static native void integral(@ByVal Mat src, @ByVal Mat sum, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void integral(@ByVal Mat src, @ByVal Mat sum);
@Namespace("cv::cuda") public static native void integral(@ByVal UMat src, @ByVal UMat sum, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void integral(@ByVal UMat src, @ByVal UMat sum);
@Namespace("cv::cuda") public static native void integral(@ByVal GpuMat src, @ByVal GpuMat sum, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void integral(@ByVal GpuMat src, @ByVal GpuMat sum);

/** \brief Computes a squared integral image.
<p>
@param src Source image. Only CV_8UC1 images are supported for now.
@param sqsum Squared integral image containing 64-bit unsigned integer values packed into
CV_64FC1 .
@param stream Stream for the asynchronous version.
 */
@Namespace("cv::cuda") public static native void sqrIntegral(@ByVal Mat src, @ByVal Mat sqsum, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void sqrIntegral(@ByVal Mat src, @ByVal Mat sqsum);
@Namespace("cv::cuda") public static native void sqrIntegral(@ByVal UMat src, @ByVal UMat sqsum, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void sqrIntegral(@ByVal UMat src, @ByVal UMat sqsum);
@Namespace("cv::cuda") public static native void sqrIntegral(@ByVal GpuMat src, @ByVal GpuMat sqsum, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void sqrIntegral(@ByVal GpuMat src, @ByVal GpuMat sqsum);

/** \} cudaarithm_reduce
 <p>
 *  \addtogroup cudaarithm_arithm
 *  \{
<p>
/** \brief Performs generalized matrix multiplication.
<p>
@param src1 First multiplied input matrix that should have CV_32FC1 , CV_64FC1 , CV_32FC2 , or
CV_64FC2 type.
@param src2 Second multiplied input matrix of the same type as src1 .
@param alpha Weight of the matrix product.
@param src3 Third optional delta matrix added to the matrix product. It should have the same type
as src1 and src2 .
@param beta Weight of src3 .
@param dst Destination matrix. It has the proper size and the same type as input matrices.
@param flags Operation flags:
-   **GEMM_1_T** transpose src1
-   **GEMM_2_T** transpose src2
-   **GEMM_3_T** transpose src3
@param stream Stream for the asynchronous version.
<p>
The function performs generalized matrix multiplication similar to the gemm functions in BLAS level
3. For example, gemm(src1, src2, alpha, src3, beta, dst, GEMM_1_T + GEMM_3_T) corresponds to
<p>
<pre>{@code \[\texttt{dst} =  \texttt{alpha} \cdot \texttt{src1} ^T  \cdot \texttt{src2} +  \texttt{beta} \cdot \texttt{src3} ^T\]}</pre>
<p>
\note Transposition operation doesn't support CV_64FC2 input type.
<p>
@see gemm
 */
@Namespace("cv::cuda") public static native void gemm(@ByVal Mat src1, @ByVal Mat src2, double alpha,
                     @ByVal Mat src3, double beta, @ByVal Mat dst, int flags/*=0*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void gemm(@ByVal Mat src1, @ByVal Mat src2, double alpha,
                     @ByVal Mat src3, double beta, @ByVal Mat dst);
@Namespace("cv::cuda") public static native void gemm(@ByVal UMat src1, @ByVal UMat src2, double alpha,
                     @ByVal UMat src3, double beta, @ByVal UMat dst, int flags/*=0*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void gemm(@ByVal UMat src1, @ByVal UMat src2, double alpha,
                     @ByVal UMat src3, double beta, @ByVal UMat dst);
@Namespace("cv::cuda") public static native void gemm(@ByVal GpuMat src1, @ByVal GpuMat src2, double alpha,
                     @ByVal GpuMat src3, double beta, @ByVal GpuMat dst, int flags/*=0*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void gemm(@ByVal GpuMat src1, @ByVal GpuMat src2, double alpha,
                     @ByVal GpuMat src3, double beta, @ByVal GpuMat dst);

/** \brief Performs a per-element multiplication of two Fourier spectrums.
<p>
@param src1 First spectrum.
@param src2 Second spectrum with the same size and type as a .
@param dst Destination spectrum.
@param flags Mock parameter used for CPU/CUDA interfaces similarity.
@param conjB Optional flag to specify if the second spectrum needs to be conjugated before the
multiplication.
@param stream Stream for the asynchronous version.
<p>
Only full (not packed) CV_32FC2 complex spectrums in the interleaved format are supported for now.
<p>
@see mulSpectrums
 */
@Namespace("cv::cuda") public static native void mulSpectrums(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, int flags, @Cast("bool") boolean conjB/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void mulSpectrums(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, int flags);
@Namespace("cv::cuda") public static native void mulSpectrums(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, int flags, @Cast("bool") boolean conjB/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void mulSpectrums(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, int flags);
@Namespace("cv::cuda") public static native void mulSpectrums(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, int flags, @Cast("bool") boolean conjB/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void mulSpectrums(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, int flags);

/** \brief Performs a per-element multiplication of two Fourier spectrums and scales the result.
<p>
@param src1 First spectrum.
@param src2 Second spectrum with the same size and type as a .
@param dst Destination spectrum.
@param flags Mock parameter used for CPU/CUDA interfaces similarity, simply add a {@code 0} value.
@param scale Scale constant.
@param conjB Optional flag to specify if the second spectrum needs to be conjugated before the
multiplication.
@param stream Stream for the asynchronous version.
<p>
Only full (not packed) CV_32FC2 complex spectrums in the interleaved format are supported for now.
<p>
@see mulSpectrums
 */
@Namespace("cv::cuda") public static native void mulAndScaleSpectrums(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, int flags, float scale, @Cast("bool") boolean conjB/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void mulAndScaleSpectrums(@ByVal Mat src1, @ByVal Mat src2, @ByVal Mat dst, int flags, float scale);
@Namespace("cv::cuda") public static native void mulAndScaleSpectrums(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, int flags, float scale, @Cast("bool") boolean conjB/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void mulAndScaleSpectrums(@ByVal UMat src1, @ByVal UMat src2, @ByVal UMat dst, int flags, float scale);
@Namespace("cv::cuda") public static native void mulAndScaleSpectrums(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, int flags, float scale, @Cast("bool") boolean conjB/*=false*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void mulAndScaleSpectrums(@ByVal GpuMat src1, @ByVal GpuMat src2, @ByVal GpuMat dst, int flags, float scale);

/** \brief Performs a forward or inverse discrete Fourier transform (1D or 2D) of the floating point matrix.
<p>
@param src Source matrix (real or complex).
@param dst Destination matrix (real or complex).
@param dft_size Size of a discrete Fourier transform.
@param flags Optional flags:
-   **DFT_ROWS** transforms each individual row of the source matrix.
-   **DFT_SCALE** scales the result: divide it by the number of elements in the transform
(obtained from dft_size ).
-   **DFT_INVERSE** inverts DFT. Use for complex-complex cases (real-complex and complex-real
cases are always forward and inverse, respectively).
-   **DFT_COMPLEX_INPUT** Specifies that input is complex input with 2 channels.
-   **DFT_REAL_OUTPUT** specifies the output as real. The source matrix is the result of
real-complex transform, so the destination matrix must be real.
@param stream Stream for the asynchronous version.
<p>
Use to handle real matrices ( CV32FC1 ) and complex matrices in the interleaved format ( CV32FC2 ).
<p>
The source matrix should be continuous, otherwise reallocation and data copying is performed. The
function chooses an operation mode depending on the flags, size, and channel count of the source
matrix:
<p>
-   If the source matrix is complex and the output is not specified as real, the destination
matrix is complex and has the dft_size size and CV_32FC2 type. The destination matrix
contains a full result of the DFT (forward or inverse).
-   If the source matrix is complex and the output is specified as real, the function assumes that
its input is the result of the forward transform (see the next item). The destination matrix
has the dft_size size and CV_32FC1 type. It contains the result of the inverse DFT.
-   If the source matrix is real (its type is CV_32FC1 ), forward DFT is performed. The result of
the DFT is packed into complex ( CV_32FC2 ) matrix. So, the width of the destination matrix
is dft_size.width / 2 + 1 . But if the source is a single column, the height is reduced
instead of the width.
<p>
@see dft
 */
@Namespace("cv::cuda") public static native void dft(@ByVal Mat src, @ByVal Mat dst, @ByVal Size dft_size, int flags/*=0*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void dft(@ByVal Mat src, @ByVal Mat dst, @ByVal Size dft_size);
@Namespace("cv::cuda") public static native void dft(@ByVal UMat src, @ByVal UMat dst, @ByVal Size dft_size, int flags/*=0*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void dft(@ByVal UMat src, @ByVal UMat dst, @ByVal Size dft_size);
@Namespace("cv::cuda") public static native void dft(@ByVal GpuMat src, @ByVal GpuMat dst, @ByVal Size dft_size, int flags/*=0*/, @ByRef(nullValue = "cv::cuda::Stream::Null()") Stream stream);
@Namespace("cv::cuda") public static native void dft(@ByVal GpuMat src, @ByVal GpuMat dst, @ByVal Size dft_size);
// Targeting ..\opencv_cudaarithm\DFT.java



/** \brief Creates implementation for cuda::DFT.
<p>
@param dft_size The image size.
@param flags Optional flags:
-   **DFT_ROWS** transforms each individual row of the source matrix.
-   **DFT_SCALE** scales the result: divide it by the number of elements in the transform
(obtained from dft_size ).
-   **DFT_INVERSE** inverts DFT. Use for complex-complex cases (real-complex and complex-real
cases are always forward and inverse, respectively).
-   **DFT_COMPLEX_INPUT** Specifies that inputs will be complex with 2 channels.
-   **DFT_REAL_OUTPUT** specifies the output as real. The source matrix is the result of
real-complex transform, so the destination matrix must be real.
 */
@Namespace("cv::cuda") public static native @Ptr DFT createDFT(@ByVal Size dft_size, int flags);
// Targeting ..\opencv_cudaarithm\Convolution.java



/** \brief Creates implementation for cuda::Convolution .
<p>
@param user_block_size Block size. If you leave default value Size(0,0) then automatic
estimation of block size will be used (which is optimized for speed). By varying user_block_size
you can reduce memory requirements at the cost of speed.
 */
@Namespace("cv::cuda") public static native @Ptr Convolution createConvolution(@ByVal(nullValue = "cv::Size()") Size user_block_size);
@Namespace("cv::cuda") public static native @Ptr Convolution createConvolution();

/** \} cudaarithm_arithm
 <p>
 *  \} cudaarithm */

 // namespace cv { namespace cuda {

// #endif /* OPENCV_CUDAARITHM_HPP */


}
