// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.global;

import org.bytedeco.opencv.opencv_highgui.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;

public class opencv_highgui extends org.bytedeco.opencv.presets.opencv_highgui {
    static { Loader.load(); }

// Parsed from <opencv2/highgui/highgui_c.h>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                        Intel License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000, Intel Corporation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of Intel Corporation may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_HIGHGUI_H
// #define OPENCV_HIGHGUI_H

// #include "opencv2/core/core_c.h"
// #include "opencv2/imgproc/imgproc_c.h"

// #ifdef __cplusplus
// #endif /* __cplusplus */

/** \addtogroup highgui_c
  \{
  */

/****************************************************************************************\
*                                  Basic GUI functions                                   *
\****************************************************************************************/
//YV
//-----------New for Qt
/* For font */
/** enum  */
public static final int  CV_FONT_LIGHT           = 25,//QFont::Light,
        CV_FONT_NORMAL          = 50,//QFont::Normal,
        CV_FONT_DEMIBOLD        = 63,//QFont::DemiBold,
        CV_FONT_BOLD            = 75,//QFont::Bold,
        CV_FONT_BLACK           = 87; //QFont::Black

/** enum  */
public static final int  CV_STYLE_NORMAL         = 0,//QFont::StyleNormal,
        CV_STYLE_ITALIC         = 1,//QFont::StyleItalic,
        CV_STYLE_OBLIQUE        = 2; //QFont::StyleOblique
/* ---------*/

//for color cvScalar(blue_component, green_component, red_component[, alpha_component])
//and alpha= 0 <-> 0xFF (not transparent <-> transparent)
public static native @ByVal @Platform("linux") CvFont cvFontQt(@Cast("const char*") BytePointer nameFont, int pointSize/*=-1*/, @ByVal(nullValue = "CvScalar(cvScalarAll(0))") CvScalar color, int weight/*=CV_FONT_NORMAL*/,  int style/*=CV_STYLE_NORMAL*/, int spacing/*=0*/);
public static native @ByVal @Platform("linux") CvFont cvFontQt(@Cast("const char*") BytePointer nameFont);
public static native @ByVal @Platform("linux") CvFont cvFontQt(String nameFont, int pointSize/*=-1*/, @ByVal(nullValue = "CvScalar(cvScalarAll(0))") CvScalar color, int weight/*=CV_FONT_NORMAL*/,  int style/*=CV_STYLE_NORMAL*/, int spacing/*=0*/);
public static native @ByVal @Platform("linux") CvFont cvFontQt(String nameFont);

public static native @Platform("linux") void cvAddText(@Const CvArr img, @Cast("const char*") BytePointer text, @ByVal CvPoint org, CvFont arg2);
public static native @Platform("linux") void cvAddText(@Const CvArr img, String text, @ByVal @Cast("CvPoint*") IntBuffer org, CvFont arg2);
public static native @Platform("linux") void cvAddText(@Const CvArr img, @Cast("const char*") BytePointer text, @ByVal @Cast("CvPoint*") int[] org, CvFont arg2);
public static native @Platform("linux") void cvAddText(@Const CvArr img, String text, @ByVal CvPoint org, CvFont arg2);
public static native @Platform("linux") void cvAddText(@Const CvArr img, @Cast("const char*") BytePointer text, @ByVal @Cast("CvPoint*") IntBuffer org, CvFont arg2);
public static native @Platform("linux") void cvAddText(@Const CvArr img, String text, @ByVal @Cast("CvPoint*") int[] org, CvFont arg2);

public static native @Platform("linux") void cvDisplayOverlay(@Cast("const char*") BytePointer name, @Cast("const char*") BytePointer text, int delayms/*=0*/);
public static native @Platform("linux") void cvDisplayOverlay(@Cast("const char*") BytePointer name, @Cast("const char*") BytePointer text);
public static native @Platform("linux") void cvDisplayOverlay(String name, String text, int delayms/*=0*/);
public static native @Platform("linux") void cvDisplayOverlay(String name, String text);
public static native @Platform("linux") void cvDisplayStatusBar(@Cast("const char*") BytePointer name, @Cast("const char*") BytePointer text, int delayms/*=0*/);
public static native @Platform("linux") void cvDisplayStatusBar(@Cast("const char*") BytePointer name, @Cast("const char*") BytePointer text);
public static native @Platform("linux") void cvDisplayStatusBar(String name, String text, int delayms/*=0*/);
public static native @Platform("linux") void cvDisplayStatusBar(String name, String text);

public static native @Platform("linux") void cvSaveWindowParameters(@Cast("const char*") BytePointer name);
public static native @Platform("linux") void cvSaveWindowParameters(String name);
public static native @Platform("linux") void cvLoadWindowParameters(@Cast("const char*") BytePointer name);
public static native @Platform("linux") void cvLoadWindowParameters(String name);
// Targeting ..\opencv_highgui\Pt2Func_int_PointerPointer.java


public static native @Platform("linux") int cvStartLoop(Pt2Func_int_PointerPointer pt2Func, int argc, @Cast("char**") PointerPointer argv);
// Targeting ..\opencv_highgui\Pt2Func_int_BytePointer.java


public static native @Platform("linux") int cvStartLoop(Pt2Func_int_BytePointer pt2Func, int argc, @Cast("char**") @ByPtrPtr BytePointer argv);
// Targeting ..\opencv_highgui\Pt2Func_int_ByteBuffer.java


public static native @Platform("linux") int cvStartLoop(Pt2Func_int_ByteBuffer pt2Func, int argc, @Cast("char**") @ByPtrPtr ByteBuffer argv);
// Targeting ..\opencv_highgui\Pt2Func_int_byte__.java


public static native @Platform("linux") int cvStartLoop(Pt2Func_int_byte__ pt2Func, int argc, @Cast("char**") @ByPtrPtr byte[] argv);
public static native @Platform("linux") void cvStopLoop( );
// Targeting ..\opencv_highgui\CvButtonCallback.java


/** enum  */
public static final int CV_PUSH_BUTTON = 0, CV_CHECKBOX = 1, CV_RADIOBOX = 2;
public static native @Platform("linux") int cvCreateButton( @Cast("const char*") BytePointer button_name/*=NULL*/,CvButtonCallback on_change/*=NULL*/, Pointer userdata/*=NULL*/, int button_type/*=CV_PUSH_BUTTON*/, int initial_button_state/*=0*/);
public static native @Platform("linux") int cvCreateButton();
public static native @Platform("linux") int cvCreateButton( String button_name/*=NULL*/,CvButtonCallback on_change/*=NULL*/, Pointer userdata/*=NULL*/, int button_type/*=CV_PUSH_BUTTON*/, int initial_button_state/*=0*/);
//----------------------


/* this function is used to set some external parameters in case of X Window */
public static native int cvInitSystem( int argc, @Cast("char**") PointerPointer argv );
public static native int cvInitSystem( int argc, @Cast("char**") @ByPtrPtr BytePointer argv );
public static native int cvInitSystem( int argc, @Cast("char**") @ByPtrPtr ByteBuffer argv );
public static native int cvInitSystem( int argc, @Cast("char**") @ByPtrPtr byte[] argv );

public static native int cvStartWindowThread( );

// ---------  YV ---------
/** enum  */
public static final int
    //These 3 flags are used by cvSet/GetWindowProperty
    CV_WND_PROP_FULLSCREEN = 0, //to change/get window's fullscreen property
    CV_WND_PROP_AUTOSIZE   = 1, //to change/get window's autosize property
    CV_WND_PROP_ASPECTRATIO = 2, //to change/get window's aspectratio property
    CV_WND_PROP_OPENGL     = 3, //to change/get window's opengl support
    CV_WND_PROP_VISIBLE    = 4,

    //These 2 flags are used by cvNamedWindow and cvSet/GetWindowProperty
    CV_WINDOW_NORMAL       = 0x00000000, //the user can resize the window (no constraint)  / also use to switch a fullscreen window to a normal size
    CV_WINDOW_AUTOSIZE     = 0x00000001, //the user cannot resize the window, the size is constrainted by the image displayed
    CV_WINDOW_OPENGL       = 0x00001000, //window with opengl support

    //Those flags are only for Qt
    CV_GUI_EXPANDED         = 0x00000000, //status bar and tool bar
    CV_GUI_NORMAL           = 0x00000010, //old fashious way

    //These 3 flags are used by cvNamedWindow and cvSet/GetWindowProperty
    CV_WINDOW_FULLSCREEN   = 1,//change the window to fullscreen
    CV_WINDOW_FREERATIO    = 0x00000100,//the image expends as much as it can (no ratio constraint)
    CV_WINDOW_KEEPRATIO    = 0x00000000;//the ration image is respected.

/* create window */
public static native int cvNamedWindow( @Cast("const char*") BytePointer name, int flags/*=CV_WINDOW_AUTOSIZE*/ );
public static native int cvNamedWindow( @Cast("const char*") BytePointer name );
public static native int cvNamedWindow( String name, int flags/*=CV_WINDOW_AUTOSIZE*/ );
public static native int cvNamedWindow( String name );

/* Set and Get Property of the window */
public static native void cvSetWindowProperty(@Cast("const char*") BytePointer name, int prop_id, double prop_value);
public static native void cvSetWindowProperty(String name, int prop_id, double prop_value);
public static native double cvGetWindowProperty(@Cast("const char*") BytePointer name, int prop_id);
public static native double cvGetWindowProperty(String name, int prop_id);

/* display image within window (highgui windows remember their content) */
public static native void cvShowImage( @Cast("const char*") BytePointer name, @Const CvArr image );
public static native void cvShowImage( String name, @Const CvArr image );

/* resize/move window */
public static native void cvResizeWindow( @Cast("const char*") BytePointer name, int width, int height );
public static native void cvResizeWindow( String name, int width, int height );
public static native void cvMoveWindow( @Cast("const char*") BytePointer name, int x, int y );
public static native void cvMoveWindow( String name, int x, int y );


/* destroy window and all the trackers associated with it */
public static native void cvDestroyWindow( @Cast("const char*") BytePointer name );
public static native void cvDestroyWindow( String name );

public static native void cvDestroyAllWindows();

/* get native window handle (HWND in case of Win32 and Widget in case of X Window) */
public static native Pointer cvGetWindowHandle( @Cast("const char*") BytePointer name );
public static native Pointer cvGetWindowHandle( String name );

/* get name of highgui window given its native handle */
public static native @Cast("const char*") BytePointer cvGetWindowName( Pointer window_handle );
// Targeting ..\opencv_highgui\CvTrackbarCallback.java



/* create trackbar and display it on top of given window, set callback */
public static native int cvCreateTrackbar( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name,
                             IntPointer value, int count, CvTrackbarCallback on_change/*=NULL*/);
public static native int cvCreateTrackbar( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name,
                             IntPointer value, int count);
public static native int cvCreateTrackbar( String trackbar_name, String window_name,
                             IntBuffer value, int count, CvTrackbarCallback on_change/*=NULL*/);
public static native int cvCreateTrackbar( String trackbar_name, String window_name,
                             IntBuffer value, int count);
public static native int cvCreateTrackbar( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name,
                             int[] value, int count, CvTrackbarCallback on_change/*=NULL*/);
public static native int cvCreateTrackbar( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name,
                             int[] value, int count);
public static native int cvCreateTrackbar( String trackbar_name, String window_name,
                             IntPointer value, int count, CvTrackbarCallback on_change/*=NULL*/);
public static native int cvCreateTrackbar( String trackbar_name, String window_name,
                             IntPointer value, int count);
public static native int cvCreateTrackbar( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name,
                             IntBuffer value, int count, CvTrackbarCallback on_change/*=NULL*/);
public static native int cvCreateTrackbar( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name,
                             IntBuffer value, int count);
public static native int cvCreateTrackbar( String trackbar_name, String window_name,
                             int[] value, int count, CvTrackbarCallback on_change/*=NULL*/);
public static native int cvCreateTrackbar( String trackbar_name, String window_name,
                             int[] value, int count);
// Targeting ..\opencv_highgui\CvTrackbarCallback2.java



public static native int cvCreateTrackbar2( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name,
                              IntPointer value, int count, CvTrackbarCallback2 on_change,
                              Pointer userdata/*=0*/);
public static native int cvCreateTrackbar2( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name,
                              IntPointer value, int count, CvTrackbarCallback2 on_change);
public static native int cvCreateTrackbar2( String trackbar_name, String window_name,
                              IntBuffer value, int count, CvTrackbarCallback2 on_change,
                              Pointer userdata/*=0*/);
public static native int cvCreateTrackbar2( String trackbar_name, String window_name,
                              IntBuffer value, int count, CvTrackbarCallback2 on_change);
public static native int cvCreateTrackbar2( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name,
                              int[] value, int count, CvTrackbarCallback2 on_change,
                              Pointer userdata/*=0*/);
public static native int cvCreateTrackbar2( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name,
                              int[] value, int count, CvTrackbarCallback2 on_change);
public static native int cvCreateTrackbar2( String trackbar_name, String window_name,
                              IntPointer value, int count, CvTrackbarCallback2 on_change,
                              Pointer userdata/*=0*/);
public static native int cvCreateTrackbar2( String trackbar_name, String window_name,
                              IntPointer value, int count, CvTrackbarCallback2 on_change);
public static native int cvCreateTrackbar2( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name,
                              IntBuffer value, int count, CvTrackbarCallback2 on_change,
                              Pointer userdata/*=0*/);
public static native int cvCreateTrackbar2( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name,
                              IntBuffer value, int count, CvTrackbarCallback2 on_change);
public static native int cvCreateTrackbar2( String trackbar_name, String window_name,
                              int[] value, int count, CvTrackbarCallback2 on_change,
                              Pointer userdata/*=0*/);
public static native int cvCreateTrackbar2( String trackbar_name, String window_name,
                              int[] value, int count, CvTrackbarCallback2 on_change);

/* retrieve or set trackbar position */
public static native int cvGetTrackbarPos( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name );
public static native int cvGetTrackbarPos( String trackbar_name, String window_name );
public static native void cvSetTrackbarPos( @Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name, int pos );
public static native void cvSetTrackbarPos( String trackbar_name, String window_name, int pos );
public static native void cvSetTrackbarMax(@Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name, int maxval);
public static native void cvSetTrackbarMax(String trackbar_name, String window_name, int maxval);
public static native void cvSetTrackbarMin(@Cast("const char*") BytePointer trackbar_name, @Cast("const char*") BytePointer window_name, int minval);
public static native void cvSetTrackbarMin(String trackbar_name, String window_name, int minval);

/** enum  */
public static final int
    CV_EVENT_MOUSEMOVE      = 0,
    CV_EVENT_LBUTTONDOWN    = 1,
    CV_EVENT_RBUTTONDOWN    = 2,
    CV_EVENT_MBUTTONDOWN    = 3,
    CV_EVENT_LBUTTONUP      = 4,
    CV_EVENT_RBUTTONUP      = 5,
    CV_EVENT_MBUTTONUP      = 6,
    CV_EVENT_LBUTTONDBLCLK  = 7,
    CV_EVENT_RBUTTONDBLCLK  = 8,
    CV_EVENT_MBUTTONDBLCLK  = 9,
    CV_EVENT_MOUSEWHEEL     = 10,
    CV_EVENT_MOUSEHWHEEL    = 11;

/** enum  */
public static final int
    CV_EVENT_FLAG_LBUTTON   = 1,
    CV_EVENT_FLAG_RBUTTON   = 2,
    CV_EVENT_FLAG_MBUTTON   = 4,
    CV_EVENT_FLAG_CTRLKEY   = 8,
    CV_EVENT_FLAG_SHIFTKEY  = 16,
    CV_EVENT_FLAG_ALTKEY    = 32;


// #define CV_GET_WHEEL_DELTA(flags) ((short)((flags >> 16) & 0xffff))
// Targeting ..\opencv_highgui\CvMouseCallback.java



/* assign callback for mouse events */
public static native void cvSetMouseCallback( @Cast("const char*") BytePointer window_name, CvMouseCallback on_mouse,
                                Pointer param/*=NULL*/);
public static native void cvSetMouseCallback( @Cast("const char*") BytePointer window_name, CvMouseCallback on_mouse);
public static native void cvSetMouseCallback( String window_name, CvMouseCallback on_mouse,
                                Pointer param/*=NULL*/);
public static native void cvSetMouseCallback( String window_name, CvMouseCallback on_mouse);

/* wait for key event infinitely (delay<=0) or for "delay" milliseconds */
public static native int cvWaitKey(int delay/*=0*/);
public static native int cvWaitKey();
// Targeting ..\opencv_highgui\CvOpenGlDrawCallback.java


public static native void cvSetOpenGlDrawCallback(@Cast("const char*") BytePointer window_name, CvOpenGlDrawCallback callback, Pointer userdata/*=NULL*/);
public static native void cvSetOpenGlDrawCallback(@Cast("const char*") BytePointer window_name, CvOpenGlDrawCallback callback);
public static native void cvSetOpenGlDrawCallback(String window_name, CvOpenGlDrawCallback callback, Pointer userdata/*=NULL*/);
public static native void cvSetOpenGlDrawCallback(String window_name, CvOpenGlDrawCallback callback);

public static native void cvSetOpenGlContext(@Cast("const char*") BytePointer window_name);
public static native void cvSetOpenGlContext(String window_name);
public static native void cvUpdateWindow(@Cast("const char*") BytePointer window_name);
public static native void cvUpdateWindow(String window_name);


/****************************************************************************************\
<p>
*                              Obsolete functions/synonyms                               *
\****************************************************************************************/

public static native void cvAddSearchPath(@Cast("const char*") BytePointer path);
public static native void cvAddSearchPath(String path);
public static native int cvvInitSystem(int arg1, @Cast("char**") PointerPointer arg2);
public static native int cvvInitSystem(int arg1, @Cast("char**") @ByPtrPtr BytePointer arg2);
public static native int cvvInitSystem(int arg1, @Cast("char**") @ByPtrPtr ByteBuffer arg2);
public static native int cvvInitSystem(int arg1, @Cast("char**") @ByPtrPtr byte[] arg2);
public static native void cvvNamedWindow(@Cast("const char*") BytePointer arg1, int arg2);
public static native void cvvNamedWindow(String arg1, int arg2);
public static native void cvvShowImage(@Cast("const char*") BytePointer arg1, CvArr arg2);
public static native void cvvShowImage(String arg1, CvArr arg2);
public static native void cvvResizeWindow(@Cast("const char*") BytePointer arg1, int arg2, int arg3);
public static native void cvvResizeWindow(String arg1, int arg2, int arg3);
public static native void cvvDestroyWindow(@Cast("const char*") BytePointer arg1);
public static native void cvvDestroyWindow(String arg1);
public static native int cvvCreateTrackbar(@Cast("const char*") BytePointer arg1, @Cast("const char*") BytePointer arg2, IntPointer arg3, int arg4, CvTrackbarCallback arg5);
public static native int cvvCreateTrackbar(String arg1, String arg2, IntBuffer arg3, int arg4, CvTrackbarCallback arg5);
public static native int cvvCreateTrackbar(@Cast("const char*") BytePointer arg1, @Cast("const char*") BytePointer arg2, int[] arg3, int arg4, CvTrackbarCallback arg5);
public static native int cvvCreateTrackbar(String arg1, String arg2, IntPointer arg3, int arg4, CvTrackbarCallback arg5);
public static native int cvvCreateTrackbar(@Cast("const char*") BytePointer arg1, @Cast("const char*") BytePointer arg2, IntBuffer arg3, int arg4, CvTrackbarCallback arg5);
public static native int cvvCreateTrackbar(String arg1, String arg2, int[] arg3, int arg4, CvTrackbarCallback arg5);
public static native void cvvAddSearchPath(@Cast("const char*") BytePointer arg1);
public static native void cvvAddSearchPath(String arg1);
public static native int cvvWaitKey(@Cast("const char*") BytePointer name);
public static native int cvvWaitKey(String name);
public static native int cvvWaitKeyEx(@Cast("const char*") BytePointer name, int delay);
public static native int cvvWaitKeyEx(String name, int delay);
public static final int HG_AUTOSIZE = CV_WINDOW_AUTOSIZE;
// #define set_preprocess_func cvSetPreprocessFuncWin32
// #define set_postprocess_func cvSetPostprocessFuncWin32

// #if defined _WIN32

// #endif

/** \} highgui_c */

// #ifdef __cplusplus
// #endif

// #endif


// Parsed from <opencv2/highgui.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_HIGHGUI_HPP
// #define OPENCV_HIGHGUI_HPP

// #include "opencv2/core.hpp"
// #ifdef HAVE_OPENCV_IMGCODECS
// #include "opencv2/imgcodecs.hpp"
// #endif
// #ifdef HAVE_OPENCV_VIDEOIO
// #include "opencv2/videoio.hpp"
// #endif

/**
\defgroup highgui High-level GUI
<p>
While OpenCV was designed for use in full-scale applications and can be used within functionally
rich UI frameworks (such as Qt\*, WinForms\*, or Cocoa\*) or without any UI at all, sometimes there
it is required to try functionality quickly and visualize the results. This is what the HighGUI
module has been designed for.
<p>
It provides easy interface to:
<p>
-   Create and manipulate windows that can display images and "remember" their content (no need to
    handle repaint events from OS).
-   Add trackbars to the windows, handle simple mouse events as well as keyboard commands.
<p>
\{
    \defgroup highgui_window_flags Flags related creating and manipulating HighGUI windows and mouse events
    \defgroup highgui_opengl OpenGL support
    \defgroup highgui_qt Qt New Functions
    <p>
    ![image](pics/qtgui.png)
    <p>
    This figure explains new functionality implemented with Qt\* GUI. The new GUI provides a statusbar,
    a toolbar, and a control panel. The control panel can have trackbars and buttonbars attached to it.
    If you cannot see the control panel, press Ctrl+P or right-click any Qt window and select **Display
    properties window**.
    <p>
    -   To attach a trackbar, the window name parameter must be NULL.
    <p>
    -   To attach a buttonbar, a button must be created. If the last bar attached to the control panel
        is a buttonbar, the new button is added to the right of the last button. If the last bar
        attached to the control panel is a trackbar, or the control panel is empty, a new buttonbar is
        created. Then, a new button is attached to it.
    <p>
    See below the example used to generate the figure:
    <pre>{@code
        int main(int argc, char *argv[])
        {

            int value = 50;
            int value2 = 0;


            namedWindow("main1",WINDOW_NORMAL);
            namedWindow("main2",WINDOW_AUTOSIZE | WINDOW_GUI_NORMAL);
            createTrackbar( "track1", "main1", &value, 255,  NULL);

            String nameb1 = "button1";
            String nameb2 = "button2";

            createButton(nameb1,callbackButton,&nameb1,QT_CHECKBOX,1);
            createButton(nameb2,callbackButton,NULL,QT_CHECKBOX,0);
            createTrackbar( "track2", NULL, &value2, 255, NULL);
            createButton("button5",callbackButton1,NULL,QT_RADIOBOX,0);
            createButton("button6",callbackButton2,NULL,QT_RADIOBOX,1);

            setMouseCallback( "main2",on_mouse,NULL );

            Mat img1 = imread("files/flower.jpg");
            VideoCapture video;
            video.open("files/hockey.avi");

            Mat img2,img3;

            while( waitKey(33) != 27 )
            {
                img1.convertTo(img2,-1,1,value);
                video >> img3;

                imshow("main1",img2);
                imshow("main2",img3);
            }

            destroyAllWindows();

            return 0;
        }
    }</pre>
    <p>
    <p>
    \defgroup highgui_winrt WinRT support
    <p>
    This figure explains new functionality implemented with WinRT GUI. The new GUI provides an Image control,
    and a slider panel. Slider panel holds trackbars attached to it.
    <p>
    Sliders are attached below the image control. Every new slider is added below the previous one.
    <p>
    See below the example used to generate the figure:
    <pre>{@code
        void sample_app::MainPage::ShowWindow()
        {
            static cv::String windowName("sample");
            cv::winrt_initContainer(this->cvContainer);
            cv::namedWindow(windowName); // not required

            cv::Mat image = cv::imread("Assets/sample.jpg");
            cv::Mat converted = cv::Mat(image.rows, image.cols, CV_8UC4);
            cv::cvtColor(image, converted, COLOR_BGR2BGRA);
            cv::imshow(windowName, converted); // this will create window if it hasn't been created before

            int state = 42;
            cv::TrackbarCallback callback = [](int pos, void* userdata)
            {
                if (pos == 0) {
                    cv::destroyWindow(windowName);
                }
            };
            cv::TrackbarCallback callbackTwin = [](int pos, void* userdata)
            {
                if (pos >= 70) {
                    cv::destroyAllWindows();
                }
            };
            cv::createTrackbar("Sample trackbar", windowName, &state, 100, callback);
            cv::createTrackbar("Twin brother", windowName, &state, 100, callbackTwin);
        }
    }</pre>
    <p>
    \defgroup highgui_c C API
\}
*/

///////////////////////// graphical user interface //////////////////////////

/** \addtogroup highgui
 *  \{
 <p>
 *  \addtogroup highgui_window_flags
 *  \{
 <p>
 *  Flags for cv::namedWindow */
/** enum cv::WindowFlags */
public static final int
       /** the user can resize the window (no constraint) / also use to switch a fullscreen window to a normal size. */
       WINDOW_NORMAL     = 0x00000000,
       /** the user cannot resize the window, the size is constrainted by the image displayed. */
       WINDOW_AUTOSIZE   = 0x00000001,
       /** window with opengl support. */
       WINDOW_OPENGL     = 0x00001000,

       /** change the window to fullscreen. */
       WINDOW_FULLSCREEN = 1,
       /** the image expends as much as it can (no ratio constraint). */
       WINDOW_FREERATIO  = 0x00000100,
       /** the ratio of the image is respected. */
       WINDOW_KEEPRATIO  = 0x00000000,
       /** status bar and tool bar */
       WINDOW_GUI_EXPANDED = 0x00000000,
       /** old fashious way */
       WINDOW_GUI_NORMAL = 0x00000010;

/** Flags for cv::setWindowProperty / cv::getWindowProperty */
/** enum cv::WindowPropertyFlags */
public static final int
       /** fullscreen property    (can be WINDOW_NORMAL or WINDOW_FULLSCREEN). */
       WND_PROP_FULLSCREEN   = 0,
       /** autosize property      (can be WINDOW_NORMAL or WINDOW_AUTOSIZE). */
       WND_PROP_AUTOSIZE     = 1,
       /** window's aspect ration (can be set to WINDOW_FREERATIO or WINDOW_KEEPRATIO). */
       WND_PROP_ASPECT_RATIO = 2,
       /** opengl support. */
       WND_PROP_OPENGL       = 3,
       /** checks whether the window exists and is visible */
       WND_PROP_VISIBLE      = 4,
       /** property to toggle normal window being topmost or not */
       WND_PROP_TOPMOST      = 5,
       /** enable or disable VSYNC (in OpenGL mode) */
       WND_PROP_VSYNC        = 6;

/** Mouse Events see cv::MouseCallback */
/** enum cv::MouseEventTypes */
public static final int
       /** indicates that the mouse pointer has moved over the window. */
       EVENT_MOUSEMOVE      = 0,
       /** indicates that the left mouse button is pressed. */
       EVENT_LBUTTONDOWN    = 1,
       /** indicates that the right mouse button is pressed. */
       EVENT_RBUTTONDOWN    = 2,
       /** indicates that the middle mouse button is pressed. */
       EVENT_MBUTTONDOWN    = 3,
       /** indicates that left mouse button is released. */
       EVENT_LBUTTONUP      = 4,
       /** indicates that right mouse button is released. */
       EVENT_RBUTTONUP      = 5,
       /** indicates that middle mouse button is released. */
       EVENT_MBUTTONUP      = 6,
       /** indicates that left mouse button is double clicked. */
       EVENT_LBUTTONDBLCLK  = 7,
       /** indicates that right mouse button is double clicked. */
       EVENT_RBUTTONDBLCLK  = 8,
       /** indicates that middle mouse button is double clicked. */
       EVENT_MBUTTONDBLCLK  = 9,
       /** positive and negative values mean forward and backward scrolling, respectively. */
       EVENT_MOUSEWHEEL     = 10,
       /** positive and negative values mean right and left scrolling, respectively. */
       EVENT_MOUSEHWHEEL    = 11;

/** Mouse Event Flags see cv::MouseCallback */
/** enum cv::MouseEventFlags */
public static final int
       /** indicates that the left mouse button is down. */
       EVENT_FLAG_LBUTTON   = 1,
       /** indicates that the right mouse button is down. */
       EVENT_FLAG_RBUTTON   = 2,
       /** indicates that the middle mouse button is down. */
       EVENT_FLAG_MBUTTON   = 4,
       /** indicates that CTRL Key is pressed. */
       EVENT_FLAG_CTRLKEY   = 8,
       /** indicates that SHIFT Key is pressed. */
       EVENT_FLAG_SHIFTKEY  = 16,
       /** indicates that ALT Key is pressed. */
       EVENT_FLAG_ALTKEY    = 32;

/** \} highgui_window_flags
 <p>
 *  \addtogroup highgui_qt
 *  \{
 <p>
 *  Qt font weight */
/** enum cv::QtFontWeights */
public static final int
        /** Weight of 25 */
        QT_FONT_LIGHT           = 25,
        /** Weight of 50 */
        QT_FONT_NORMAL          = 50,
        /** Weight of 63 */
        QT_FONT_DEMIBOLD        = 63,
        /** Weight of 75 */
        QT_FONT_BOLD            = 75,
        /** Weight of 87 */
        QT_FONT_BLACK           = 87;

/** Qt font style */
/** enum cv::QtFontStyles */
public static final int
        /** Normal font. */
        QT_STYLE_NORMAL         = 0,
        /** Italic font. */
        QT_STYLE_ITALIC         = 1,
        /** Oblique font. */
        QT_STYLE_OBLIQUE        = 2;

/** Qt "button" type */
/** enum cv::QtButtonTypes */
public static final int
       /** Push button. */
       QT_PUSH_BUTTON   = 0,
       /** Checkbox button. */
       QT_CHECKBOX      = 1,
       /** Radiobox button. */
       QT_RADIOBOX      = 2,
       /** Button should create a new buttonbar */
       QT_NEW_BUTTONBAR = 1024;
// Targeting ..\opencv_highgui\MouseCallback.java


// Targeting ..\opencv_highgui\TrackbarCallback.java


// Targeting ..\opencv_highgui\OpenGlDrawCallback.java


// Targeting ..\opencv_highgui\ButtonCallback.java



/** \brief Creates a window.
<p>
The function namedWindow creates a window that can be used as a placeholder for images and
trackbars. Created windows are referred to by their names.
<p>
If a window with the same name already exists, the function does nothing.
<p>
You can call cv::destroyWindow or cv::destroyAllWindows to close the window and de-allocate any associated
memory usage. For a simple program, you do not really have to call these functions because all the
resources and windows of the application are closed automatically by the operating system upon exit.
<p>
\note
<p>
Qt backend supports additional flags:
 -   **WINDOW_NORMAL or WINDOW_AUTOSIZE:** WINDOW_NORMAL enables you to resize the
     window, whereas WINDOW_AUTOSIZE adjusts automatically the window size to fit the
     displayed image (see imshow ), and you cannot change the window size manually.
 -   **WINDOW_FREERATIO or WINDOW_KEEPRATIO:** WINDOW_FREERATIO adjusts the image
     with no respect to its ratio, whereas WINDOW_KEEPRATIO keeps the image ratio.
 -   **WINDOW_GUI_NORMAL or WINDOW_GUI_EXPANDED:** WINDOW_GUI_NORMAL is the old way to draw the window
     without statusbar and toolbar, whereas WINDOW_GUI_EXPANDED is a new enhanced GUI.
By default, flags == WINDOW_AUTOSIZE | WINDOW_KEEPRATIO | WINDOW_GUI_EXPANDED
<p>
@param winname Name of the window in the window caption that may be used as a window identifier.
@param flags Flags of the window. The supported flags are: (cv::WindowFlags)
 */
@Namespace("cv") public static native void namedWindow(@Str BytePointer winname, int flags/*=cv::WINDOW_AUTOSIZE*/);
@Namespace("cv") public static native void namedWindow(@Str BytePointer winname);
@Namespace("cv") public static native void namedWindow(@Str String winname, int flags/*=cv::WINDOW_AUTOSIZE*/);
@Namespace("cv") public static native void namedWindow(@Str String winname);

/** \brief Destroys the specified window.
<p>
The function destroyWindow destroys the window with the given name.
<p>
@param winname Name of the window to be destroyed.
 */
@Namespace("cv") public static native void destroyWindow(@Str BytePointer winname);
@Namespace("cv") public static native void destroyWindow(@Str String winname);

/** \brief Destroys all of the HighGUI windows.
<p>
The function destroyAllWindows destroys all of the opened HighGUI windows.
 */
@Namespace("cv") public static native void destroyAllWindows();

@Namespace("cv") public static native int startWindowThread();

/** \brief Similar to #waitKey, but returns full key code.
<p>
\note
<p>
Key code is implementation specific and depends on used backend: QT/GTK/Win32/etc
<p>
*/
@Namespace("cv") public static native int waitKeyEx(int delay/*=0*/);
@Namespace("cv") public static native int waitKeyEx();

/** \brief Waits for a pressed key.
<p>
The function waitKey waits for a key event infinitely (when {@code \texttt{delay}\leq 0} ) or for delay
milliseconds, when it is positive. Since the OS has a minimum time between switching threads, the
function will not wait exactly delay ms, it will wait at least delay ms, depending on what else is
running on your computer at that time. It returns the code of the pressed key or -1 if no key was
pressed before the specified time had elapsed. To check for a key press but not wait for it, use
#pollKey.
<p>
\note The functions #waitKey and #pollKey are the only methods in HighGUI that can fetch and handle
GUI events, so one of them needs to be called periodically for normal event processing unless
HighGUI is used within an environment that takes care of event processing.
<p>
\note The function only works if there is at least one HighGUI window created and the window is
active. If there are several HighGUI windows, any of them can be active.
<p>
@param delay Delay in milliseconds. 0 is the special value that means "forever".
 */
@Namespace("cv") public static native int waitKey(int delay/*=0*/);
@Namespace("cv") public static native int waitKey();

/** \brief Polls for a pressed key.
<p>
The function pollKey polls for a key event without waiting. It returns the code of the pressed key
or -1 if no key was pressed since the last invocation. To wait until a key was pressed, use #waitKey.
<p>
\note The functions #waitKey and #pollKey are the only methods in HighGUI that can fetch and handle
GUI events, so one of them needs to be called periodically for normal event processing unless
HighGUI is used within an environment that takes care of event processing.
<p>
\note The function only works if there is at least one HighGUI window created and the window is
active. If there are several HighGUI windows, any of them can be active.
 */
@Namespace("cv") public static native int pollKey();

/** \brief Displays an image in the specified window.
<p>
The function imshow displays an image in the specified window. If the window was created with the
cv::WINDOW_AUTOSIZE flag, the image is shown with its original size, however it is still limited by the screen resolution.
Otherwise, the image is scaled to fit the window. The function may scale the image, depending on its depth:
<p>
-   If the image is 8-bit unsigned, it is displayed as is.
-   If the image is 16-bit unsigned, the pixels are divided by 256. That is, the
    value range [0,255\*256] is mapped to [0,255].
-   If the image is 32-bit or 64-bit floating-point, the pixel values are multiplied by 255. That is, the
    value range [0,1] is mapped to [0,255].
-   32-bit integer images are not processed anymore due to ambiguouty of required transform.
    Convert to 8-bit unsigned matrix using a custom preprocessing specific to image's context.
<p>
If window was created with OpenGL support, cv::imshow also support ogl::Buffer , ogl::Texture2D and
cuda::GpuMat as input.
<p>
If the window was not created before this function, it is assumed creating a window with cv::WINDOW_AUTOSIZE.
<p>
If you need to show an image that is bigger than the screen resolution, you will need to call namedWindow("", WINDOW_NORMAL) before the imshow.
<p>
\note This function should be followed by a call to cv::waitKey or cv::pollKey to perform GUI
housekeeping tasks that are necessary to actually show the given image and make the window respond
to mouse and keyboard events. Otherwise, it won't display the image and the window might lock up.
For example, **waitKey(0)** will display the window infinitely until any keypress (it is suitable
for image display). **waitKey(25)** will display a frame and wait approximately 25 ms for a key
press (suitable for displaying a video frame-by-frame). To remove the window, use cv::destroyWindow.
<p>
\note
<p>
[__Windows Backend Only__] Pressing Ctrl+C will copy the image to the clipboard.
<p>
[__Windows Backend Only__] Pressing Ctrl+S will show a dialog to save the image.
<p>
@param winname Name of the window.
@param mat Image to be shown.
 */
@Namespace("cv") public static native void imshow(@Str BytePointer winname, @ByVal Mat mat);
@Namespace("cv") public static native void imshow(@Str String winname, @ByVal Mat mat);
@Namespace("cv") public static native void imshow(@Str String winname, @ByVal UMat mat);
@Namespace("cv") public static native void imshow(@Str BytePointer winname, @ByVal UMat mat);
@Namespace("cv") public static native void imshow(@Str BytePointer winname, @ByVal GpuMat mat);
@Namespace("cv") public static native void imshow(@Str String winname, @ByVal GpuMat mat);

/** \brief Resizes the window to the specified size
<p>
\note
<p>
-   The specified window size is for the image area. Toolbars are not counted.
-   Only windows created without cv::WINDOW_AUTOSIZE flag can be resized.
<p>
@param winname Window name.
@param width The new window width.
@param height The new window height.
 */
@Namespace("cv") public static native void resizeWindow(@Str BytePointer winname, int width, int height);
@Namespace("cv") public static native void resizeWindow(@Str String winname, int width, int height);

/** \overload
@param winname Window name.
@param size The new window size.
*/
@Namespace("cv") public static native void resizeWindow(@Str BytePointer winname, @Const @ByRef Size size);
@Namespace("cv") public static native void resizeWindow(@Str String winname, @Const @ByRef Size size);

/** \brief Moves the window to the specified position
<p>
@param winname Name of the window.
@param x The new x-coordinate of the window.
@param y The new y-coordinate of the window.
 */
@Namespace("cv") public static native void moveWindow(@Str BytePointer winname, int x, int y);
@Namespace("cv") public static native void moveWindow(@Str String winname, int x, int y);

/** \brief Changes parameters of a window dynamically.
<p>
The function setWindowProperty enables changing properties of a window.
<p>
@param winname Name of the window.
@param prop_id Window property to edit. The supported operation flags are: (cv::WindowPropertyFlags)
@param prop_value New value of the window property. The supported flags are: (cv::WindowFlags)
 */
@Namespace("cv") public static native void setWindowProperty(@Str BytePointer winname, int prop_id, double prop_value);
@Namespace("cv") public static native void setWindowProperty(@Str String winname, int prop_id, double prop_value);

/** \brief Updates window title
@param winname Name of the window.
@param title New title.
*/
@Namespace("cv") public static native void setWindowTitle(@Str BytePointer winname, @Str BytePointer title);
@Namespace("cv") public static native void setWindowTitle(@Str String winname, @Str String title);

/** \brief Provides parameters of a window.
<p>
The function getWindowProperty returns properties of a window.
<p>
@param winname Name of the window.
@param prop_id Window property to retrieve. The following operation flags are available: (cv::WindowPropertyFlags)
<p>
@see setWindowProperty
 */
@Namespace("cv") public static native double getWindowProperty(@Str BytePointer winname, int prop_id);
@Namespace("cv") public static native double getWindowProperty(@Str String winname, int prop_id);

/** \brief Provides rectangle of image in the window.
<p>
The function getWindowImageRect returns the client screen coordinates, width and height of the image rendering area.
<p>
@param winname Name of the window.
<p>
@see resizeWindow moveWindow
 */
@Namespace("cv") public static native @ByVal Rect getWindowImageRect(@Str BytePointer winname);
@Namespace("cv") public static native @ByVal Rect getWindowImageRect(@Str String winname);

/** \example samples/cpp/create_mask.cpp
This program demonstrates using mouse events and how to make and use a mask image (black and white) .
*/
/** \brief Sets mouse handler for the specified window
<p>
@param winname Name of the window.
@param onMouse Callback function for mouse events. See OpenCV samples on how to specify and use the callback.
@param userdata The optional parameter passed to the callback.
 */
@Namespace("cv") public static native void setMouseCallback(@Str BytePointer winname, MouseCallback onMouse, Pointer userdata/*=0*/);
@Namespace("cv") public static native void setMouseCallback(@Str BytePointer winname, MouseCallback onMouse);
@Namespace("cv") public static native void setMouseCallback(@Str String winname, MouseCallback onMouse, Pointer userdata/*=0*/);
@Namespace("cv") public static native void setMouseCallback(@Str String winname, MouseCallback onMouse);

/** \brief Gets the mouse-wheel motion delta, when handling mouse-wheel events cv::EVENT_MOUSEWHEEL and
cv::EVENT_MOUSEHWHEEL.
<p>
For regular mice with a scroll-wheel, delta will be a multiple of 120. The value 120 corresponds to
a one notch rotation of the wheel or the threshold for action to be taken and one such action should
occur for each delta. Some high-precision mice with higher-resolution freely-rotating wheels may
generate smaller values.
<p>
For cv::EVENT_MOUSEWHEEL positive and negative values mean forward and backward scrolling,
respectively. For cv::EVENT_MOUSEHWHEEL, where available, positive and negative values mean right and
left scrolling, respectively.
<p>
\note
<p>
Mouse-wheel events are currently supported only on Windows.
<p>
@param flags The mouse callback flags parameter.
 */
@Namespace("cv") public static native int getMouseWheelDelta(int flags);

/** \brief Allows users to select a ROI on the given image.
<p>
The function creates a window and allows users to select a ROI using the mouse.
Controls: use {@code space} or {@code enter} to finish selection, use key {@code c} to cancel selection (function will return the zero cv::Rect).
<p>
@param windowName name of the window where selection process will be shown.
@param img image to select a ROI.
@param showCrosshair if true crosshair of selection rectangle will be shown.
@param fromCenter if true center of selection will match initial mouse position. In opposite case a corner of
selection rectangle will correspont to the initial mouse position.
@return selected ROI or empty rect if selection canceled.
<p>
\note The function sets it's own mouse callback for specified window using cv::setMouseCallback(windowName, ...).
After finish of work an empty callback will be set for the used window.
 */
@Namespace("cv") public static native @ByVal Rect selectROI(@Str BytePointer windowName, @ByVal Mat img, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native @ByVal Rect selectROI(@Str BytePointer windowName, @ByVal Mat img);
@Namespace("cv") public static native @ByVal Rect selectROI(@Str String windowName, @ByVal Mat img, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native @ByVal Rect selectROI(@Str String windowName, @ByVal Mat img);
@Namespace("cv") public static native @ByVal Rect selectROI(@Str String windowName, @ByVal UMat img, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native @ByVal Rect selectROI(@Str String windowName, @ByVal UMat img);
@Namespace("cv") public static native @ByVal Rect selectROI(@Str BytePointer windowName, @ByVal UMat img, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native @ByVal Rect selectROI(@Str BytePointer windowName, @ByVal UMat img);
@Namespace("cv") public static native @ByVal Rect selectROI(@Str BytePointer windowName, @ByVal GpuMat img, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native @ByVal Rect selectROI(@Str BytePointer windowName, @ByVal GpuMat img);
@Namespace("cv") public static native @ByVal Rect selectROI(@Str String windowName, @ByVal GpuMat img, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native @ByVal Rect selectROI(@Str String windowName, @ByVal GpuMat img);

/** \overload
 */
@Namespace("cv") public static native @ByVal Rect selectROI(@ByVal Mat img, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native @ByVal Rect selectROI(@ByVal Mat img);
@Namespace("cv") public static native @ByVal Rect selectROI(@ByVal UMat img, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native @ByVal Rect selectROI(@ByVal UMat img);
@Namespace("cv") public static native @ByVal Rect selectROI(@ByVal GpuMat img, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native @ByVal Rect selectROI(@ByVal GpuMat img);

/** \brief Allows users to select multiple ROIs on the given image.
<p>
The function creates a window and allows users to select multiple ROIs using the mouse.
Controls: use {@code space} or {@code enter} to finish current selection and start a new one,
use {@code esc} to terminate multiple ROI selection process.
<p>
@param windowName name of the window where selection process will be shown.
@param img image to select a ROI.
@param boundingBoxes selected ROIs.
@param showCrosshair if true crosshair of selection rectangle will be shown.
@param fromCenter if true center of selection will match initial mouse position. In opposite case a corner of
selection rectangle will correspont to the initial mouse position.
<p>
\note The function sets it's own mouse callback for specified window using cv::setMouseCallback(windowName, ...).
After finish of work an empty callback will be set for the used window.
 */
@Namespace("cv") public static native void selectROIs(@Str BytePointer windowName, @ByVal Mat img,
                             @ByRef RectVector boundingBoxes, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native void selectROIs(@Str BytePointer windowName, @ByVal Mat img,
                             @ByRef RectVector boundingBoxes);
@Namespace("cv") public static native void selectROIs(@Str String windowName, @ByVal Mat img,
                             @ByRef RectVector boundingBoxes, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native void selectROIs(@Str String windowName, @ByVal Mat img,
                             @ByRef RectVector boundingBoxes);
@Namespace("cv") public static native void selectROIs(@Str String windowName, @ByVal UMat img,
                             @ByRef RectVector boundingBoxes, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native void selectROIs(@Str String windowName, @ByVal UMat img,
                             @ByRef RectVector boundingBoxes);
@Namespace("cv") public static native void selectROIs(@Str BytePointer windowName, @ByVal UMat img,
                             @ByRef RectVector boundingBoxes, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native void selectROIs(@Str BytePointer windowName, @ByVal UMat img,
                             @ByRef RectVector boundingBoxes);
@Namespace("cv") public static native void selectROIs(@Str BytePointer windowName, @ByVal GpuMat img,
                             @ByRef RectVector boundingBoxes, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native void selectROIs(@Str BytePointer windowName, @ByVal GpuMat img,
                             @ByRef RectVector boundingBoxes);
@Namespace("cv") public static native void selectROIs(@Str String windowName, @ByVal GpuMat img,
                             @ByRef RectVector boundingBoxes, @Cast("bool") boolean showCrosshair/*=true*/, @Cast("bool") boolean fromCenter/*=false*/);
@Namespace("cv") public static native void selectROIs(@Str String windowName, @ByVal GpuMat img,
                             @ByRef RectVector boundingBoxes);

/** \brief Creates a trackbar and attaches it to the specified window.
<p>
The function createTrackbar creates a trackbar (a slider or range control) with the specified name
and range, assigns a variable value to be a position synchronized with the trackbar and specifies
the callback function onChange to be called on the trackbar position change. The created trackbar is
displayed in the specified window winname.
<p>
\note
<p>
[__Qt Backend Only__] winname can be empty if the trackbar should be attached to the
control panel.
<p>
Clicking the label of each trackbar enables editing the trackbar values manually.
<p>
@param trackbarname Name of the created trackbar.
@param winname Name of the window that will be used as a parent of the created trackbar.
@param value Optional pointer to an integer variable whose value reflects the position of the
slider. Upon creation, the slider position is defined by this variable.
@param count Maximal position of the slider. The minimal position is always 0.
@param onChange Pointer to the function to be called every time the slider changes position. This
function should be prototyped as void Foo(int,void\*); , where the first parameter is the trackbar
position and the second parameter is the user data (see the next parameter). If the callback is
the NULL pointer, no callbacks are called, but only value is updated.
@param userdata User data that is passed as is to the callback. It can be used to handle trackbar
events without using global variables.
 */
@Namespace("cv") public static native int createTrackbar(@Str BytePointer trackbarname, @Str BytePointer winname,
                              IntPointer value, int count,
                              TrackbarCallback onChange/*=0*/,
                              Pointer userdata/*=0*/);
@Namespace("cv") public static native int createTrackbar(@Str BytePointer trackbarname, @Str BytePointer winname,
                              IntPointer value, int count);
@Namespace("cv") public static native int createTrackbar(@Str String trackbarname, @Str String winname,
                              IntBuffer value, int count,
                              TrackbarCallback onChange/*=0*/,
                              Pointer userdata/*=0*/);
@Namespace("cv") public static native int createTrackbar(@Str String trackbarname, @Str String winname,
                              IntBuffer value, int count);
@Namespace("cv") public static native int createTrackbar(@Str BytePointer trackbarname, @Str BytePointer winname,
                              int[] value, int count,
                              TrackbarCallback onChange/*=0*/,
                              Pointer userdata/*=0*/);
@Namespace("cv") public static native int createTrackbar(@Str BytePointer trackbarname, @Str BytePointer winname,
                              int[] value, int count);
@Namespace("cv") public static native int createTrackbar(@Str String trackbarname, @Str String winname,
                              IntPointer value, int count,
                              TrackbarCallback onChange/*=0*/,
                              Pointer userdata/*=0*/);
@Namespace("cv") public static native int createTrackbar(@Str String trackbarname, @Str String winname,
                              IntPointer value, int count);
@Namespace("cv") public static native int createTrackbar(@Str BytePointer trackbarname, @Str BytePointer winname,
                              IntBuffer value, int count,
                              TrackbarCallback onChange/*=0*/,
                              Pointer userdata/*=0*/);
@Namespace("cv") public static native int createTrackbar(@Str BytePointer trackbarname, @Str BytePointer winname,
                              IntBuffer value, int count);
@Namespace("cv") public static native int createTrackbar(@Str String trackbarname, @Str String winname,
                              int[] value, int count,
                              TrackbarCallback onChange/*=0*/,
                              Pointer userdata/*=0*/);
@Namespace("cv") public static native int createTrackbar(@Str String trackbarname, @Str String winname,
                              int[] value, int count);

/** \brief Returns the trackbar position.
<p>
The function returns the current position of the specified trackbar.
<p>
\note
<p>
[__Qt Backend Only__] winname can be empty if the trackbar is attached to the control
panel.
<p>
@param trackbarname Name of the trackbar.
@param winname Name of the window that is the parent of the trackbar.
 */
@Namespace("cv") public static native int getTrackbarPos(@Str BytePointer trackbarname, @Str BytePointer winname);
@Namespace("cv") public static native int getTrackbarPos(@Str String trackbarname, @Str String winname);

/** \brief Sets the trackbar position.
<p>
The function sets the position of the specified trackbar in the specified window.
<p>
\note
<p>
[__Qt Backend Only__] winname can be empty if the trackbar is attached to the control
panel.
<p>
@param trackbarname Name of the trackbar.
@param winname Name of the window that is the parent of trackbar.
@param pos New position.
 */
@Namespace("cv") public static native void setTrackbarPos(@Str BytePointer trackbarname, @Str BytePointer winname, int pos);
@Namespace("cv") public static native void setTrackbarPos(@Str String trackbarname, @Str String winname, int pos);

/** \brief Sets the trackbar maximum position.
<p>
The function sets the maximum position of the specified trackbar in the specified window.
<p>
\note
<p>
[__Qt Backend Only__] winname can be empty if the trackbar is attached to the control
panel.
<p>
@param trackbarname Name of the trackbar.
@param winname Name of the window that is the parent of trackbar.
@param maxval New maximum position.
 */
@Namespace("cv") public static native void setTrackbarMax(@Str BytePointer trackbarname, @Str BytePointer winname, int maxval);
@Namespace("cv") public static native void setTrackbarMax(@Str String trackbarname, @Str String winname, int maxval);

/** \brief Sets the trackbar minimum position.
<p>
The function sets the minimum position of the specified trackbar in the specified window.
<p>
\note
<p>
[__Qt Backend Only__] winname can be empty if the trackbar is attached to the control
panel.
<p>
@param trackbarname Name of the trackbar.
@param winname Name of the window that is the parent of trackbar.
@param minval New minimum position.
 */
@Namespace("cv") public static native void setTrackbarMin(@Str BytePointer trackbarname, @Str BytePointer winname, int minval);
@Namespace("cv") public static native void setTrackbarMin(@Str String trackbarname, @Str String winname, int minval);

/** \addtogroup highgui_opengl OpenGL support
 *  \{
<p>
/** \brief Displays OpenGL 2D texture in the specified window.
<p>
@param winname Name of the window.
@param tex OpenGL 2D texture data.
 */
@Namespace("cv") public static native void imshow(@Str BytePointer winname, @Const @ByRef Texture2D tex);
@Namespace("cv") public static native void imshow(@Str String winname, @Const @ByRef Texture2D tex);

/** \brief Sets a callback function to be called to draw on top of displayed image.
<p>
The function setOpenGlDrawCallback can be used to draw 3D data on the window. See the example of
callback function below:
<pre>{@code
    void on_opengl(void* param)
    {
        glLoadIdentity();

        glTranslated(0.0, 0.0, -1.0);

        glRotatef( 55, 1, 0, 0 );
        glRotatef( 45, 0, 1, 0 );
        glRotatef( 0, 0, 0, 1 );

        static const int coords[6][4][3] = {
            { { +1, -1, -1 }, { -1, -1, -1 }, { -1, +1, -1 }, { +1, +1, -1 } },
            { { +1, +1, -1 }, { -1, +1, -1 }, { -1, +1, +1 }, { +1, +1, +1 } },
            { { +1, -1, +1 }, { +1, -1, -1 }, { +1, +1, -1 }, { +1, +1, +1 } },
            { { -1, -1, -1 }, { -1, -1, +1 }, { -1, +1, +1 }, { -1, +1, -1 } },
            { { +1, -1, +1 }, { -1, -1, +1 }, { -1, -1, -1 }, { +1, -1, -1 } },
            { { -1, -1, +1 }, { +1, -1, +1 }, { +1, +1, +1 }, { -1, +1, +1 } }
        };

        for (int i = 0; i < 6; ++i) {
                    glColor3ub( i*20, 100+i*10, i*42 );
                    glBegin(GL_QUADS);
                    for (int j = 0; j < 4; ++j) {
                            glVertex3d(0.2 * coords[i][j][0], 0.2 * coords[i][j][1], 0.2 * coords[i][j][2]);
                    }
                    glEnd();
        }
    }
}</pre>
<p>
@param winname Name of the window.
@param onOpenGlDraw Pointer to the function to be called every frame. This function should be
prototyped as void Foo(void\*) .
@param userdata Pointer passed to the callback function.(__Optional__)
 */
@Namespace("cv") public static native void setOpenGlDrawCallback(@Str BytePointer winname, OpenGlDrawCallback onOpenGlDraw, Pointer userdata/*=0*/);
@Namespace("cv") public static native void setOpenGlDrawCallback(@Str BytePointer winname, OpenGlDrawCallback onOpenGlDraw);
@Namespace("cv") public static native void setOpenGlDrawCallback(@Str String winname, OpenGlDrawCallback onOpenGlDraw, Pointer userdata/*=0*/);
@Namespace("cv") public static native void setOpenGlDrawCallback(@Str String winname, OpenGlDrawCallback onOpenGlDraw);

/** \brief Sets the specified window as current OpenGL context.
<p>
@param winname Name of the window.
 */
@Namespace("cv") public static native void setOpenGlContext(@Str BytePointer winname);
@Namespace("cv") public static native void setOpenGlContext(@Str String winname);

/** \brief Force window to redraw its context and call draw callback ( See cv::setOpenGlDrawCallback ).
<p>
@param winname Name of the window.
 */
@Namespace("cv") public static native void updateWindow(@Str BytePointer winname);
@Namespace("cv") public static native void updateWindow(@Str String winname);
// Targeting ..\opencv_highgui\QtFont.java



/** \brief Creates the font to draw a text on an image.
<p>
The function fontQt creates a cv::QtFont object. This cv::QtFont is not compatible with putText .
<p>
A basic usage of this function is the following: :
<pre>{@code
    QtFont font = fontQt("Times");
    addText( img1, "Hello World !", Point(50,50), font);
}</pre>
<p>
@param nameFont Name of the font. The name should match the name of a system font (such as
*Times*). If the font is not found, a default one is used.
@param pointSize Size of the font. If not specified, equal zero or negative, the point size of the
font is set to a system-dependent default value. Generally, this is 12 points.
@param color Color of the font in BGRA where A = 255 is fully transparent. Use the macro CV_RGB
for simplicity.
@param weight Font weight. Available operation flags are : cv::QtFontWeights You can also specify a positive integer for better control.
@param style Font style. Available operation flags are : cv::QtFontStyles
@param spacing Spacing between characters. It can be negative or positive.
 */
@Namespace("cv") public static native @ByVal QtFont fontQt(@Str BytePointer nameFont, int pointSize/*=-1*/,
                         @ByVal(nullValue = "cv::Scalar::all(0)") Scalar color, int weight/*=cv::QT_FONT_NORMAL*/,
                         int style/*=cv::QT_STYLE_NORMAL*/, int spacing/*=0*/);
@Namespace("cv") public static native @ByVal QtFont fontQt(@Str BytePointer nameFont);
@Namespace("cv") public static native @ByVal QtFont fontQt(@Str String nameFont, int pointSize/*=-1*/,
                         @ByVal(nullValue = "cv::Scalar::all(0)") Scalar color, int weight/*=cv::QT_FONT_NORMAL*/,
                         int style/*=cv::QT_STYLE_NORMAL*/, int spacing/*=0*/);
@Namespace("cv") public static native @ByVal QtFont fontQt(@Str String nameFont);

/** \brief Draws a text on the image.
<p>
The function addText draws *text* on the image *img* using a specific font *font* (see example cv::fontQt
)
<p>
@param img 8-bit 3-channel image where the text should be drawn.
@param text Text to write on an image.
@param org Point(x,y) where the text should start on an image.
@param font Font to use to draw a text.
 */
@Namespace("cv") public static native void addText( @Const @ByRef Mat img, @Str BytePointer text, @ByVal Point org, @Const @ByRef QtFont font);
@Namespace("cv") public static native void addText( @Const @ByRef Mat img, @Str String text, @ByVal Point org, @Const @ByRef QtFont font);

/** \brief Draws a text on the image.
<p>
@param img 8-bit 3-channel image where the text should be drawn.
@param text Text to write on an image.
@param org Point(x,y) where the text should start on an image.
@param nameFont Name of the font. The name should match the name of a system font (such as
*Times*). If the font is not found, a default one is used.
@param pointSize Size of the font. If not specified, equal zero or negative, the point size of the
font is set to a system-dependent default value. Generally, this is 12 points.
@param color Color of the font in BGRA where A = 255 is fully transparent.
@param weight Font weight. Available operation flags are : cv::QtFontWeights You can also specify a positive integer for better control.
@param style Font style. Available operation flags are : cv::QtFontStyles
@param spacing Spacing between characters. It can be negative or positive.
 */
@Namespace("cv") public static native void addText(@Const @ByRef Mat img, @Str BytePointer text, @ByVal Point org, @Str BytePointer nameFont, int pointSize/*=-1*/, @ByVal(nullValue = "cv::Scalar::all(0)") Scalar color,
        int weight/*=cv::QT_FONT_NORMAL*/, int style/*=cv::QT_STYLE_NORMAL*/, int spacing/*=0*/);
@Namespace("cv") public static native void addText(@Const @ByRef Mat img, @Str BytePointer text, @ByVal Point org, @Str BytePointer nameFont);
@Namespace("cv") public static native void addText(@Const @ByRef Mat img, @Str String text, @ByVal Point org, @Str String nameFont, int pointSize/*=-1*/, @ByVal(nullValue = "cv::Scalar::all(0)") Scalar color,
        int weight/*=cv::QT_FONT_NORMAL*/, int style/*=cv::QT_STYLE_NORMAL*/, int spacing/*=0*/);
@Namespace("cv") public static native void addText(@Const @ByRef Mat img, @Str String text, @ByVal Point org, @Str String nameFont);

/** \brief Displays a text on a window image as an overlay for a specified duration.
<p>
The function displayOverlay displays useful information/tips on top of the window for a certain
amount of time *delayms*. The function does not modify the image, displayed in the window, that is,
after the specified delay the original content of the window is restored.
<p>
@param winname Name of the window.
@param text Overlay text to write on a window image.
@param delayms The period (in milliseconds), during which the overlay text is displayed. If this
function is called before the previous overlay text timed out, the timer is restarted and the text
is updated. If this value is zero, the text never disappears.
 */
@Namespace("cv") public static native void displayOverlay(@Str BytePointer winname, @Str BytePointer text, int delayms/*=0*/);
@Namespace("cv") public static native void displayOverlay(@Str BytePointer winname, @Str BytePointer text);
@Namespace("cv") public static native void displayOverlay(@Str String winname, @Str String text, int delayms/*=0*/);
@Namespace("cv") public static native void displayOverlay(@Str String winname, @Str String text);

/** \brief Displays a text on the window statusbar during the specified period of time.
<p>
The function displayStatusBar displays useful information/tips on top of the window for a certain
amount of time *delayms* . This information is displayed on the window statusbar (the window must be
created with the CV_GUI_EXPANDED flags).
<p>
@param winname Name of the window.
@param text Text to write on the window statusbar.
@param delayms Duration (in milliseconds) to display the text. If this function is called before
the previous text timed out, the timer is restarted and the text is updated. If this value is
zero, the text never disappears.
 */
@Namespace("cv") public static native void displayStatusBar(@Str BytePointer winname, @Str BytePointer text, int delayms/*=0*/);
@Namespace("cv") public static native void displayStatusBar(@Str BytePointer winname, @Str BytePointer text);
@Namespace("cv") public static native void displayStatusBar(@Str String winname, @Str String text, int delayms/*=0*/);
@Namespace("cv") public static native void displayStatusBar(@Str String winname, @Str String text);

/** \brief Saves parameters of the specified window.
<p>
The function saveWindowParameters saves size, location, flags, trackbars value, zoom and panning
location of the window windowName.
<p>
@param windowName Name of the window.
 */
@Namespace("cv") public static native void saveWindowParameters(@Str BytePointer windowName);
@Namespace("cv") public static native void saveWindowParameters(@Str String windowName);

/** \brief Loads parameters of the specified window.
<p>
The function loadWindowParameters loads size, location, flags, trackbars value, zoom and panning
location of the window windowName.
<p>
@param windowName Name of the window.
 */
@Namespace("cv") public static native void loadWindowParameters(@Str BytePointer windowName);
@Namespace("cv") public static native void loadWindowParameters(@Str String windowName);

@Namespace("cv") public static native int startLoop(Pt2Func_int_PointerPointer pt2Func, int argc, @Cast("char**") PointerPointer argv);
@Namespace("cv") public static native int startLoop(Pt2Func_int_BytePointer pt2Func, int argc, @Cast("char**") @ByPtrPtr BytePointer argv);
@Namespace("cv") public static native int startLoop(Pt2Func_int_ByteBuffer pt2Func, int argc, @Cast("char**") @ByPtrPtr ByteBuffer argv);
@Namespace("cv") public static native int startLoop(Pt2Func_int_byte__ pt2Func, int argc, @Cast("char**") @ByPtrPtr byte[] argv);

@Namespace("cv") public static native void stopLoop();

/** \brief Attaches a button to the control panel.
<p>
The function createButton attaches a button to the control panel. Each button is added to a
buttonbar to the right of the last button. A new buttonbar is created if nothing was attached to the
control panel before, or if the last element attached to the control panel was a trackbar or if the
QT_NEW_BUTTONBAR flag is added to the type.
<p>
See below various examples of the cv::createButton function call: :
<pre>{@code
    createButton("",callbackButton);//create a push button "button 0", that will call callbackButton.
    createButton("button2",callbackButton,NULL,QT_CHECKBOX,0);
    createButton("button3",callbackButton,&value);
    createButton("button5",callbackButton1,NULL,QT_RADIOBOX);
    createButton("button6",callbackButton2,NULL,QT_PUSH_BUTTON,1);
    createButton("button6",callbackButton2,NULL,QT_PUSH_BUTTON|QT_NEW_BUTTONBAR);// create a push button in a new row
}</pre>
<p>
@param  bar_name Name of the button.
@param on_change Pointer to the function to be called every time the button changes its state.
This function should be prototyped as void Foo(int state,\*void); . *state* is the current state
of the button. It could be -1 for a push button, 0 or 1 for a check/radio box button.
@param userdata Pointer passed to the callback function.
@param type Optional type of the button. Available types are: (cv::QtButtonTypes)
@param initial_button_state Default state of the button. Use for checkbox and radiobox. Its
value could be 0 or 1. (__Optional__)
*/
@Namespace("cv") public static native int createButton( @Str BytePointer bar_name, ButtonCallback on_change,
                             Pointer userdata/*=0*/, int type/*=cv::QT_PUSH_BUTTON*/,
                             @Cast("bool") boolean initial_button_state/*=false*/);
@Namespace("cv") public static native int createButton( @Str BytePointer bar_name, ButtonCallback on_change);
@Namespace("cv") public static native int createButton( @Str String bar_name, ButtonCallback on_change,
                             Pointer userdata/*=0*/, int type/*=cv::QT_PUSH_BUTTON*/,
                             @Cast("bool") boolean initial_button_state/*=false*/);
@Namespace("cv") public static native int createButton( @Str String bar_name, ButtonCallback on_change);

/** \} highgui_qt
 <p>
 *  \} highgui */

 // cv

// #endif


}
