// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.global;

import org.bytedeco.opencv.opencv_video.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;

public class opencv_video extends org.bytedeco.opencv.presets.opencv_video {
    static { Loader.load(); }

// Parsed from <opencv2/video.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_VIDEO_HPP
// #define OPENCV_VIDEO_HPP

/**
  \defgroup video Video Analysis
  \{
    \defgroup video_motion Motion Analysis
    \defgroup video_track Object Tracking
    \defgroup video_c C API
  \}
*/

// #include "opencv2/video/tracking.hpp"
// #include "opencv2/video/background_segm.hpp"

// #endif //OPENCV_VIDEO_HPP


// Parsed from <opencv2/video/tracking.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_TRACKING_HPP
// #define OPENCV_TRACKING_HPP

// #include "opencv2/core.hpp"
// #include "opencv2/imgproc.hpp"

/** \addtogroup video_track
 *  \{ */

/** enum cv:: */
public static final int OPTFLOW_USE_INITIAL_FLOW     = 4,
       OPTFLOW_LK_GET_MIN_EIGENVALS = 8,
       OPTFLOW_FARNEBACK_GAUSSIAN   = 256;

/** \brief Finds an object center, size, and orientation.
<p>
@param probImage Back projection of the object histogram. See calcBackProject.
@param window Initial search window.
@param criteria Stop criteria for the underlying meanShift.
returns
(in old interfaces) Number of iterations CAMSHIFT took to converge
The function implements the CAMSHIFT object tracking algorithm \cite Bradski98 . First, it finds an
object center using meanShift and then adjusts the window size and finds the optimal rotation. The
function returns the rotated rectangle structure that includes the object position, size, and
orientation. The next position of the search window can be obtained with RotatedRect::boundingRect()
<p>
See the OpenCV sample camshiftdemo.c that tracks colored objects.
<p>
\note
-   (Python) A sample explaining the camshift tracking algorithm can be found at
    opencv_source_code/samples/python/camshift.py
 */
@Namespace("cv") public static native @ByVal RotatedRect CamShift( @ByVal Mat probImage, @ByRef Rect window,
                                   @ByVal TermCriteria criteria );
@Namespace("cv") public static native @ByVal RotatedRect CamShift( @ByVal UMat probImage, @ByRef Rect window,
                                   @ByVal TermCriteria criteria );
@Namespace("cv") public static native @ByVal RotatedRect CamShift( @ByVal GpuMat probImage, @ByRef Rect window,
                                   @ByVal TermCriteria criteria );
/** \example samples/cpp/camshiftdemo.cpp
An example using the mean-shift tracking algorithm
*/

/** \brief Finds an object on a back projection image.
<p>
@param probImage Back projection of the object histogram. See calcBackProject for details.
@param window Initial search window.
@param criteria Stop criteria for the iterative search algorithm.
returns
:   Number of iterations CAMSHIFT took to converge.
The function implements the iterative object search algorithm. It takes the input back projection of
an object and the initial position. The mass center in window of the back projection image is
computed and the search window center shifts to the mass center. The procedure is repeated until the
specified number of iterations criteria.maxCount is done or until the window center shifts by less
than criteria.epsilon. The algorithm is used inside CamShift and, unlike CamShift , the search
window size or orientation do not change during the search. You can simply pass the output of
calcBackProject to this function. But better results can be obtained if you pre-filter the back
projection and remove the noise. For example, you can do this by retrieving connected components
with findContours , throwing away contours with small area ( contourArea ), and rendering the
remaining contours with drawContours.
 <p>
 */
@Namespace("cv") public static native int meanShift( @ByVal Mat probImage, @ByRef Rect window, @ByVal TermCriteria criteria );
@Namespace("cv") public static native int meanShift( @ByVal UMat probImage, @ByRef Rect window, @ByVal TermCriteria criteria );
@Namespace("cv") public static native int meanShift( @ByVal GpuMat probImage, @ByRef Rect window, @ByVal TermCriteria criteria );

/** \brief Constructs the image pyramid which can be passed to calcOpticalFlowPyrLK.
<p>
@param img 8-bit input image.
@param pyramid output pyramid.
@param winSize window size of optical flow algorithm. Must be not less than winSize argument of
calcOpticalFlowPyrLK. It is needed to calculate required padding for pyramid levels.
@param maxLevel 0-based maximal pyramid level number.
@param withDerivatives set to precompute gradients for the every pyramid level. If pyramid is
constructed without the gradients then calcOpticalFlowPyrLK will calculate them internally.
@param pyrBorder the border mode for pyramid layers.
@param derivBorder the border mode for gradients.
@param tryReuseInputImage put ROI of input image into the pyramid if possible. You can pass false
to force data copying.
@return number of levels in constructed pyramid. Can be less than maxLevel.
 */
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal Mat img, @ByVal MatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal Mat img, @ByVal MatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal Mat img, @ByVal UMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal Mat img, @ByVal UMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal Mat img, @ByVal GpuMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal Mat img, @ByVal GpuMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal UMat img, @ByVal MatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal UMat img, @ByVal MatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal UMat img, @ByVal UMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal UMat img, @ByVal UMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal UMat img, @ByVal GpuMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal UMat img, @ByVal GpuMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal GpuMat img, @ByVal MatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal GpuMat img, @ByVal MatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal GpuMat img, @ByVal UMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal GpuMat img, @ByVal UMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal GpuMat img, @ByVal GpuMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel, @Cast("bool") boolean withDerivatives/*=true*/,
                                          int pyrBorder/*=cv::BORDER_REFLECT_101*/,
                                          int derivBorder/*=cv::BORDER_CONSTANT*/,
                                          @Cast("bool") boolean tryReuseInputImage/*=true*/ );
@Namespace("cv") public static native int buildOpticalFlowPyramid( @ByVal GpuMat img, @ByVal GpuMatVector pyramid,
                                          @ByVal Size winSize, int maxLevel );

/** \example samples/cpp/lkdemo.cpp
An example using the Lucas-Kanade optical flow algorithm
*/

/** \brief Calculates an optical flow for a sparse feature set using the iterative Lucas-Kanade method with
pyramids.
<p>
@param prevImg first 8-bit input image or pyramid constructed by buildOpticalFlowPyramid.
@param nextImg second input image or pyramid of the same size and the same type as prevImg.
@param prevPts vector of 2D points for which the flow needs to be found; point coordinates must be
single-precision floating-point numbers.
@param nextPts output vector of 2D points (with single-precision floating-point coordinates)
containing the calculated new positions of input features in the second image; when
OPTFLOW_USE_INITIAL_FLOW flag is passed, the vector must have the same size as in the input.
@param status output status vector (of unsigned chars); each element of the vector is set to 1 if
the flow for the corresponding features has been found, otherwise, it is set to 0.
@param err output vector of errors; each element of the vector is set to an error for the
corresponding feature, type of the error measure can be set in flags parameter; if the flow wasn't
found then the error is not defined (use the status parameter to find such cases).
@param winSize size of the search window at each pyramid level.
@param maxLevel 0-based maximal pyramid level number; if set to 0, pyramids are not used (single
level), if set to 1, two levels are used, and so on; if pyramids are passed to input then
algorithm will use as many levels as pyramids have but no more than maxLevel.
@param criteria parameter, specifying the termination criteria of the iterative search algorithm
(after the specified maximum number of iterations criteria.maxCount or when the search window
moves by less than criteria.epsilon.
@param flags operation flags:
 -   **OPTFLOW_USE_INITIAL_FLOW** uses initial estimations, stored in nextPts; if the flag is
     not set, then prevPts is copied to nextPts and is considered the initial estimate.
 -   **OPTFLOW_LK_GET_MIN_EIGENVALS** use minimum eigen values as an error measure (see
     minEigThreshold description); if the flag is not set, then L1 distance between patches
     around the original and a moved point, divided by number of pixels in a window, is used as a
     error measure.
@param minEigThreshold the algorithm calculates the minimum eigen value of a 2x2 normal matrix of
optical flow equations (this matrix is called a spatial gradient matrix in \cite Bouguet00), divided
by number of pixels in a window; if this value is less than minEigThreshold, then a corresponding
feature is filtered out and its flow is not processed, so it allows to remove bad points and get a
performance boost.
<p>
The function implements a sparse iterative version of the Lucas-Kanade optical flow in pyramids. See
\cite Bouguet00 . The function is parallelized with the TBB library.
<p>
\note
<p>
-   An example using the Lucas-Kanade optical flow algorithm can be found at
    opencv_source_code/samples/cpp/lkdemo.cpp
-   (Python) An example using the Lucas-Kanade optical flow algorithm can be found at
    opencv_source_code/samples/python/lk_track.py
-   (Python) An example using the Lucas-Kanade tracker for homography matching can be found at
    opencv_source_code/samples/python/lk_homography.py
 */
@Namespace("cv") public static native void calcOpticalFlowPyrLK( @ByVal Mat prevImg, @ByVal Mat nextImg,
                                        @ByVal Mat prevPts, @ByVal Mat nextPts,
                                        @ByVal Mat status, @ByVal Mat err,
                                        @ByVal(nullValue = "cv::Size(21,21)") Size winSize, int maxLevel/*=3*/,
                                        @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 30, 0.01)") TermCriteria criteria,
                                        int flags/*=0*/, double minEigThreshold/*=1e-4*/ );
@Namespace("cv") public static native void calcOpticalFlowPyrLK( @ByVal Mat prevImg, @ByVal Mat nextImg,
                                        @ByVal Mat prevPts, @ByVal Mat nextPts,
                                        @ByVal Mat status, @ByVal Mat err );
@Namespace("cv") public static native void calcOpticalFlowPyrLK( @ByVal UMat prevImg, @ByVal UMat nextImg,
                                        @ByVal UMat prevPts, @ByVal UMat nextPts,
                                        @ByVal UMat status, @ByVal UMat err,
                                        @ByVal(nullValue = "cv::Size(21,21)") Size winSize, int maxLevel/*=3*/,
                                        @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 30, 0.01)") TermCriteria criteria,
                                        int flags/*=0*/, double minEigThreshold/*=1e-4*/ );
@Namespace("cv") public static native void calcOpticalFlowPyrLK( @ByVal UMat prevImg, @ByVal UMat nextImg,
                                        @ByVal UMat prevPts, @ByVal UMat nextPts,
                                        @ByVal UMat status, @ByVal UMat err );
@Namespace("cv") public static native void calcOpticalFlowPyrLK( @ByVal GpuMat prevImg, @ByVal GpuMat nextImg,
                                        @ByVal GpuMat prevPts, @ByVal GpuMat nextPts,
                                        @ByVal GpuMat status, @ByVal GpuMat err,
                                        @ByVal(nullValue = "cv::Size(21,21)") Size winSize, int maxLevel/*=3*/,
                                        @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 30, 0.01)") TermCriteria criteria,
                                        int flags/*=0*/, double minEigThreshold/*=1e-4*/ );
@Namespace("cv") public static native void calcOpticalFlowPyrLK( @ByVal GpuMat prevImg, @ByVal GpuMat nextImg,
                                        @ByVal GpuMat prevPts, @ByVal GpuMat nextPts,
                                        @ByVal GpuMat status, @ByVal GpuMat err );

/** \brief Computes a dense optical flow using the Gunnar Farneback's algorithm.
<p>
@param prev first 8-bit single-channel input image.
@param next second input image of the same size and the same type as prev.
@param flow computed flow image that has the same size as prev and type CV_32FC2.
@param pyr_scale parameter, specifying the image scale (\<1) to build pyramids for each image;
pyr_scale=0.5 means a classical pyramid, where each next layer is twice smaller than the previous
one.
@param levels number of pyramid layers including the initial image; levels=1 means that no extra
layers are created and only the original images are used.
@param winsize averaging window size; larger values increase the algorithm robustness to image
noise and give more chances for fast motion detection, but yield more blurred motion field.
@param iterations number of iterations the algorithm does at each pyramid level.
@param poly_n size of the pixel neighborhood used to find polynomial expansion in each pixel;
larger values mean that the image will be approximated with smoother surfaces, yielding more
robust algorithm and more blurred motion field, typically poly_n =5 or 7.
@param poly_sigma standard deviation of the Gaussian that is used to smooth derivatives used as a
basis for the polynomial expansion; for poly_n=5, you can set poly_sigma=1.1, for poly_n=7, a
good value would be poly_sigma=1.5.
@param flags operation flags that can be a combination of the following:
 -   **OPTFLOW_USE_INITIAL_FLOW** uses the input flow as an initial flow approximation.
 -   **OPTFLOW_FARNEBACK_GAUSSIAN** uses the Gaussian {@code \texttt{winsize}\times\texttt{winsize}}
     filter instead of a box filter of the same size for optical flow estimation; usually, this
     option gives z more accurate flow than with a box filter, at the cost of lower speed;
     normally, winsize for a Gaussian window should be set to a larger value to achieve the same
     level of robustness.
<p>
The function finds an optical flow for each prev pixel using the \cite Farneback2003 algorithm so that
<p>
<pre>{@code \[\texttt{prev} (y,x)  \sim \texttt{next} ( y + \texttt{flow} (y,x)[1],  x + \texttt{flow} (y,x)[0])\]}</pre>
<p>
\note
<p>
-   An example using the optical flow algorithm described by Gunnar Farneback can be found at
    opencv_source_code/samples/cpp/fback.cpp
-   (Python) An example using the optical flow algorithm described by Gunnar Farneback can be
    found at opencv_source_code/samples/python/opt_flow.py
 */
@Namespace("cv") public static native void calcOpticalFlowFarneback( @ByVal Mat prev, @ByVal Mat next, @ByVal Mat flow,
                                            double pyr_scale, int levels, int winsize,
                                            int iterations, int poly_n, double poly_sigma,
                                            int flags );
@Namespace("cv") public static native void calcOpticalFlowFarneback( @ByVal UMat prev, @ByVal UMat next, @ByVal UMat flow,
                                            double pyr_scale, int levels, int winsize,
                                            int iterations, int poly_n, double poly_sigma,
                                            int flags );
@Namespace("cv") public static native void calcOpticalFlowFarneback( @ByVal GpuMat prev, @ByVal GpuMat next, @ByVal GpuMat flow,
                                            double pyr_scale, int levels, int winsize,
                                            int iterations, int poly_n, double poly_sigma,
                                            int flags );

/** \brief Computes an optimal affine transformation between two 2D point sets.
<p>
@param src First input 2D point set stored in std::vector or Mat, or an image stored in Mat.
@param dst Second input 2D point set of the same size and the same type as A, or another image.
@param fullAffine If true, the function finds an optimal affine transformation with no additional
restrictions (6 degrees of freedom). Otherwise, the class of transformations to choose from is
limited to combinations of translation, rotation, and uniform scaling (4 degrees of freedom).
<p>
The function finds an optimal affine transform *[A|b]* (a 2 x 3 floating-point matrix) that
approximates best the affine transformation between:
<p>
*   Two point sets
*   Two raster images. In this case, the function first finds some features in the src image and
    finds the corresponding features in dst image. After that, the problem is reduced to the first
    case.
In case of point sets, the problem is formulated as follows: you need to find a 2x2 matrix *A* and
2x1 vector *b* so that:
<p>
<pre>{@code \[[A^*|b^*] = arg  \min _{[A|b]}  \sum _i  \| \texttt{dst}[i] - A { \texttt{src}[i]}^T - b  \| ^2\]}</pre>
where src[i] and dst[i] are the i-th points in src and dst, respectively
{@code [A|b]} can be either arbitrary (when fullAffine=true ) or have a form of
<pre>{@code \[\begin{bmatrix} a_{11} & a_{12} & b_1  \\ -a_{12} & a_{11} & b_2  \end{bmatrix}\]}</pre>
when fullAffine=false.
<p>
@deprecated Use cv::estimateAffine2D, cv::estimateAffinePartial2D instead. If you are using this function
with images, extract points using cv::calcOpticalFlowPyrLK and then use the estimation functions.
<p>
@see
estimateAffine2D, estimateAffinePartial2D, getAffineTransform, getPerspectiveTransform, findHomography
 */
@Namespace("cv") public static native @Deprecated @ByVal Mat estimateRigidTransform( @ByVal Mat src, @ByVal Mat dst, @Cast("bool") boolean fullAffine );
@Namespace("cv") public static native @Deprecated @ByVal Mat estimateRigidTransform( @ByVal UMat src, @ByVal UMat dst, @Cast("bool") boolean fullAffine );
@Namespace("cv") public static native @Deprecated @ByVal Mat estimateRigidTransform( @ByVal GpuMat src, @ByVal GpuMat dst, @Cast("bool") boolean fullAffine );

/** enum cv:: */
public static final int
    MOTION_TRANSLATION = 0,
    MOTION_EUCLIDEAN   = 1,
    MOTION_AFFINE      = 2,
    MOTION_HOMOGRAPHY  = 3;

/** \brief Computes the Enhanced Correlation Coefficient value between two images \cite EP08 .
<p>
@param templateImage single-channel template image; CV_8U or CV_32F array.
@param inputImage single-channel input image to be warped to provide an image similar to
 templateImage, same type as templateImage.
@param inputMask An optional mask to indicate valid values of inputImage.
<p>
@see
findTransformECC
 */

@Namespace("cv") public static native double computeECC(@ByVal Mat templateImage, @ByVal Mat inputImage, @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat inputMask);
@Namespace("cv") public static native double computeECC(@ByVal Mat templateImage, @ByVal Mat inputImage);
@Namespace("cv") public static native double computeECC(@ByVal UMat templateImage, @ByVal UMat inputImage, @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat inputMask);
@Namespace("cv") public static native double computeECC(@ByVal UMat templateImage, @ByVal UMat inputImage);
@Namespace("cv") public static native double computeECC(@ByVal GpuMat templateImage, @ByVal GpuMat inputImage, @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat inputMask);
@Namespace("cv") public static native double computeECC(@ByVal GpuMat templateImage, @ByVal GpuMat inputImage);

/** \example samples/cpp/image_alignment.cpp
An example using the image alignment ECC algorithm
*/

/** \brief Finds the geometric transform (warp) between two images in terms of the ECC criterion \cite EP08 .
<p>
@param templateImage single-channel template image; CV_8U or CV_32F array.
@param inputImage single-channel input image which should be warped with the final warpMatrix in
order to provide an image similar to templateImage, same type as templateImage.
@param warpMatrix floating-point {@code 2\times 3} or {@code 3\times 3} mapping matrix (warp).
@param motionType parameter, specifying the type of motion:
 -   **MOTION_TRANSLATION** sets a translational motion model; warpMatrix is {@code 2\times 3} with
     the first {@code 2\times 2} part being the unity matrix and the rest two parameters being
     estimated.
 -   **MOTION_EUCLIDEAN** sets a Euclidean (rigid) transformation as motion model; three
     parameters are estimated; warpMatrix is {@code 2\times 3}.
 -   **MOTION_AFFINE** sets an affine motion model (DEFAULT); six parameters are estimated;
     warpMatrix is {@code 2\times 3}.
 -   **MOTION_HOMOGRAPHY** sets a homography as a motion model; eight parameters are
     estimated;\{@code warpMatrix\} is {@code 3\times 3}.
@param criteria parameter, specifying the termination criteria of the ECC algorithm;
criteria.epsilon defines the threshold of the increment in the correlation coefficient between two
iterations (a negative criteria.epsilon makes criteria.maxcount the only termination criterion).
Default values are shown in the declaration above.
@param inputMask An optional mask to indicate valid values of inputImage.
@param gaussFiltSize An optional value indicating size of gaussian blur filter; (DEFAULT: 5)
<p>
The function estimates the optimum transformation (warpMatrix) with respect to ECC criterion
(\cite EP08), that is
<p>
<pre>{@code \[\texttt{warpMatrix} = \arg\max_{W} \texttt{ECC}(\texttt{templateImage}(x,y),\texttt{inputImage}(x',y'))\]}</pre>
<p>
where
<p>
<pre>{@code \[\begin{bmatrix} x' \\ y' \end{bmatrix} = W \cdot \begin{bmatrix} x \\ y \\ 1 \end{bmatrix}\]}</pre>
<p>
(the equation holds with homogeneous coordinates for homography). It returns the final enhanced
correlation coefficient, that is the correlation coefficient between the template image and the
final warped input image. When a {@code 3\times 3} matrix is given with motionType =0, 1 or 2, the third
row is ignored.
<p>
Unlike findHomography and estimateRigidTransform, the function findTransformECC implements an
area-based alignment that builds on intensity similarities. In essence, the function updates the
initial transformation that roughly aligns the images. If this information is missing, the identity
warp (unity matrix) is used as an initialization. Note that if images undergo strong
displacements/rotations, an initial transformation that roughly aligns the images is necessary
(e.g., a simple euclidean/similarity transform that allows for the images showing the same image
content approximately). Use inverse warping in the second image to take an image close to the first
one, i.e. use the flag WARP_INVERSE_MAP with warpAffine or warpPerspective. See also the OpenCV
sample image_alignment.cpp that demonstrates the use of the function. Note that the function throws
an exception if algorithm does not converges.
<p>
@see
computeECC, estimateAffine2D, estimateAffinePartial2D, findHomography
 */
@Namespace("cv") public static native double findTransformECC( @ByVal Mat templateImage, @ByVal Mat inputImage,
                                      @ByVal Mat warpMatrix, int motionType,
                                      @ByVal TermCriteria criteria,
                                      @ByVal Mat inputMask, int gaussFiltSize);
@Namespace("cv") public static native double findTransformECC( @ByVal UMat templateImage, @ByVal UMat inputImage,
                                      @ByVal UMat warpMatrix, int motionType,
                                      @ByVal TermCriteria criteria,
                                      @ByVal UMat inputMask, int gaussFiltSize);
@Namespace("cv") public static native double findTransformECC( @ByVal GpuMat templateImage, @ByVal GpuMat inputImage,
                                      @ByVal GpuMat warpMatrix, int motionType,
                                      @ByVal TermCriteria criteria,
                                      @ByVal GpuMat inputMask, int gaussFiltSize);

/** \overload */
@Namespace("cv") public static native double findTransformECC(@ByVal Mat templateImage, @ByVal Mat inputImage,
    @ByVal Mat warpMatrix, int motionType/*=cv::MOTION_AFFINE*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 50, 0.001)") TermCriteria criteria,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") Mat inputMask);
@Namespace("cv") public static native double findTransformECC(@ByVal Mat templateImage, @ByVal Mat inputImage,
    @ByVal Mat warpMatrix);
@Namespace("cv") public static native double findTransformECC(@ByVal UMat templateImage, @ByVal UMat inputImage,
    @ByVal UMat warpMatrix, int motionType/*=cv::MOTION_AFFINE*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 50, 0.001)") TermCriteria criteria,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") UMat inputMask);
@Namespace("cv") public static native double findTransformECC(@ByVal UMat templateImage, @ByVal UMat inputImage,
    @ByVal UMat warpMatrix);
@Namespace("cv") public static native double findTransformECC(@ByVal GpuMat templateImage, @ByVal GpuMat inputImage,
    @ByVal GpuMat warpMatrix, int motionType/*=cv::MOTION_AFFINE*/,
    @ByVal(nullValue = "cv::TermCriteria(cv::TermCriteria::COUNT+cv::TermCriteria::EPS, 50, 0.001)") TermCriteria criteria,
    @ByVal(nullValue = "cv::InputArray(cv::noArray())") GpuMat inputMask);
@Namespace("cv") public static native double findTransformECC(@ByVal GpuMat templateImage, @ByVal GpuMat inputImage,
    @ByVal GpuMat warpMatrix);
// Targeting ..\opencv_video\KalmanFilter.java




/** \brief Read a .flo file
 <p>
 @param path Path to the file to be loaded
 <p>
 The function readOpticalFlow loads a flow field from a file and returns it as a single matrix.
 Resulting Mat has a type CV_32FC2 - floating-point, 2-channel. First channel corresponds to the
 flow in the horizontal direction (u), second - vertical (v).
 */
@Namespace("cv") public static native @ByVal Mat readOpticalFlow( @Str BytePointer path );
@Namespace("cv") public static native @ByVal Mat readOpticalFlow( @Str String path );
/** \brief Write a .flo to disk
 <p>
 @param path Path to the file to be written
 @param flow Flow field to be stored
 <p>
 The function stores a flow field in a file, returns true on success, false otherwise.
 The flow field must be a 2-channel, floating-point matrix (CV_32FC2). First channel corresponds
 to the flow in the horizontal direction (u), second - vertical (v).
 */
@Namespace("cv") public static native @Cast("bool") boolean writeOpticalFlow( @Str BytePointer path, @ByVal Mat flow );
@Namespace("cv") public static native @Cast("bool") boolean writeOpticalFlow( @Str String path, @ByVal Mat flow );
@Namespace("cv") public static native @Cast("bool") boolean writeOpticalFlow( @Str String path, @ByVal UMat flow );
@Namespace("cv") public static native @Cast("bool") boolean writeOpticalFlow( @Str BytePointer path, @ByVal UMat flow );
@Namespace("cv") public static native @Cast("bool") boolean writeOpticalFlow( @Str BytePointer path, @ByVal GpuMat flow );
@Namespace("cv") public static native @Cast("bool") boolean writeOpticalFlow( @Str String path, @ByVal GpuMat flow );
// Targeting ..\opencv_video\DenseOpticalFlow.java


// Targeting ..\opencv_video\SparseOpticalFlow.java


// Targeting ..\opencv_video\FarnebackOpticalFlow.java


// Targeting ..\opencv_video\VariationalRefinement.java


// Targeting ..\opencv_video\DISOpticalFlow.java


// Targeting ..\opencv_video\SparsePyrLKOpticalFlow.java


// Targeting ..\opencv_video\Tracker.java


// Targeting ..\opencv_video\TrackerMIL.java


// Targeting ..\opencv_video\TrackerGOTURN.java


// Targeting ..\opencv_video\TrackerDaSiamRPN.java


// Targeting ..\opencv_video\TrackerNano.java



/** \} video_track */

 // cv

// #endif


// Parsed from <opencv2/video/background_segm.hpp>

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                          License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Copyright (C) 2013, OpenCV Foundation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef OPENCV_BACKGROUND_SEGM_HPP
// #define OPENCV_BACKGROUND_SEGM_HPP

// #include "opencv2/core.hpp"
// Targeting ..\opencv_video\BackgroundSubtractor.java


// Targeting ..\opencv_video\BackgroundSubtractorMOG2.java



/** \brief Creates MOG2 Background Subtractor
<p>
@param history Length of the history.
@param varThreshold Threshold on the squared Mahalanobis distance between the pixel and the model
to decide whether a pixel is well described by the background model. This parameter does not
affect the background update.
@param detectShadows If true, the algorithm will detect shadows and mark them. It decreases the
speed a bit, so if you do not need this feature, set the parameter to false.
 */
@Namespace("cv") public static native @Ptr BackgroundSubtractorMOG2 createBackgroundSubtractorMOG2(int history/*=500*/, double varThreshold/*=16*/,
                                   @Cast("bool") boolean detectShadows/*=true*/);
@Namespace("cv") public static native @Ptr BackgroundSubtractorMOG2 createBackgroundSubtractorMOG2();
// Targeting ..\opencv_video\BackgroundSubtractorKNN.java



/** \brief Creates KNN Background Subtractor
<p>
@param history Length of the history.
@param dist2Threshold Threshold on the squared distance between the pixel and the sample to decide
whether a pixel is close to that sample. This parameter does not affect the background update.
@param detectShadows If true, the algorithm will detect shadows and mark them. It decreases the
speed a bit, so if you do not need this feature, set the parameter to false.
 */
@Namespace("cv") public static native @Ptr BackgroundSubtractorKNN createBackgroundSubtractorKNN(int history/*=500*/, double dist2Threshold/*=400.0*/,
                                   @Cast("bool") boolean detectShadows/*=true*/);
@Namespace("cv") public static native @Ptr BackgroundSubtractorKNN createBackgroundSubtractorKNN();

/** \} video_motion */

 // cv

// #endif


}
