// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_ml;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;

import static org.bytedeco.opencv.global.opencv_ml.*;


/** \brief Base class for statistical models in OpenCV ML.
 */
@Namespace("cv::ml") @Properties(inherit = org.bytedeco.opencv.presets.opencv_ml.class)
public class StatModel extends AbstractStatModel {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StatModel(Pointer p) { super(p); }

    /** Predict options */
    /** enum cv::ml::StatModel::Flags */
    public static final int
        UPDATE_MODEL = 1,
        /** makes the method return the raw results (the sum), not the class label */
        RAW_OUTPUT = 1,
        COMPRESSED_INPUT = 2,
        PREPROCESSED_INPUT = 4;

    /** \brief Returns the number of variables in training samples */
    public native int getVarCount();

    public native @Cast("bool") @Override boolean empty();

    /** \brief Returns true if the model is trained */
    public native @Cast("bool") boolean isTrained();
    /** \brief Returns true if the model is classifier */
    public native @Cast("bool") boolean isClassifier();

    /** \brief Trains the statistical model
    <p>
    @param trainData training data that can be loaded from file using TrainData::loadFromCSV or
        created with TrainData::create.
    @param flags optional flags, depending on the model. Some of the models can be updated with the
        new training samples, not completely overwritten (such as NormalBayesClassifier or ANN_MLP).
     */
    public native @Cast("bool") boolean train( @Ptr TrainData trainData, int flags/*=0*/ );
    public native @Cast("bool") boolean train( @Ptr TrainData trainData );

    /** \brief Trains the statistical model
    <p>
    @param samples training samples
    @param layout See ml::SampleTypes.
    @param responses vector of responses associated with the training samples.
    */
    public native @Cast("bool") boolean train( @ByVal Mat samples, int layout, @ByVal Mat responses );
    public native @Cast("bool") boolean train( @ByVal UMat samples, int layout, @ByVal UMat responses );
    public native @Cast("bool") boolean train( @ByVal GpuMat samples, int layout, @ByVal GpuMat responses );

    /** \brief Computes error on the training or test dataset
    <p>
    @param data the training data
    @param test if true, the error is computed over the test subset of the data, otherwise it's
        computed over the training subset of the data. Please note that if you loaded a completely
        different dataset to evaluate already trained classifier, you will probably want not to set
        the test subset at all with TrainData::setTrainTestSplitRatio and specify test=false, so
        that the error is computed for the whole new set. Yes, this sounds a bit confusing.
    @param resp the optional output responses.
    <p>
    The method uses StatModel::predict to compute the error. For regression models the error is
    computed as RMS, for classifiers - as a percent of missclassified samples (0%-100%).
     */
    public native float calcError( @Ptr TrainData data, @Cast("bool") boolean test, @ByVal Mat resp );
    public native float calcError( @Ptr TrainData data, @Cast("bool") boolean test, @ByVal UMat resp );
    public native float calcError( @Ptr TrainData data, @Cast("bool") boolean test, @ByVal GpuMat resp );

    /** \brief Predicts response(s) for the provided sample(s)
    <p>
    @param samples The input samples, floating-point matrix
    @param results The optional output matrix of results.
    @param flags The optional flags, model-dependent. See cv::ml::StatModel::Flags.
     */
    public native float predict( @ByVal Mat samples, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") Mat results, int flags/*=0*/ );
    public native float predict( @ByVal Mat samples );
    public native float predict( @ByVal UMat samples, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") UMat results, int flags/*=0*/ );
    public native float predict( @ByVal UMat samples );
    public native float predict( @ByVal GpuMat samples, @ByVal(nullValue = "cv::OutputArray(cv::noArray())") GpuMat results, int flags/*=0*/ );
    public native float predict( @ByVal GpuMat samples );

    /** \brief Create and train model with default parameters
    <p>
    The class must implement static {@code create()} method with no parameters or with all default parameter values
    */
}
