// Targeted by JavaCPP version 1.5.9: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_objdetect;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;

import static org.bytedeco.opencv.global.opencv_objdetect.*;


/** \brief struct DetectorParameters is used by ArucoDetector
 */
@Namespace("cv::aruco") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_objdetect.class)
public class DetectorParameters extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DetectorParameters(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public DetectorParameters(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public DetectorParameters position(long position) {
        return (DetectorParameters)super.position(position);
    }
    @Override public DetectorParameters getPointer(long i) {
        return new DetectorParameters((Pointer)this).offsetAddress(i);
    }

    public DetectorParameters() { super((Pointer)null); allocate(); }
    private native void allocate();

    /** \brief Read a new set of DetectorParameters from FileNode (use FileStorage.root()).
     */
    public native @Cast("bool") boolean readDetectorParameters(@Const @ByRef FileNode fn);

    /** \brief Write a set of DetectorParameters to FileStorage
     */
    public native @Cast("bool") boolean writeDetectorParameters(@ByRef FileStorage fs, @Str BytePointer name/*=cv::String()*/);
    public native @Cast("bool") boolean writeDetectorParameters(@ByRef FileStorage fs);
    public native @Cast("bool") boolean writeDetectorParameters(@ByRef FileStorage fs, @Str String name/*=cv::String()*/);

    /** minimum window size for adaptive thresholding before finding contours (default 3). */
    public native int adaptiveThreshWinSizeMin(); public native DetectorParameters adaptiveThreshWinSizeMin(int setter);

    /** maximum window size for adaptive thresholding before finding contours (default 23). */
    public native int adaptiveThreshWinSizeMax(); public native DetectorParameters adaptiveThreshWinSizeMax(int setter);

    /** increments from adaptiveThreshWinSizeMin to adaptiveThreshWinSizeMax during the thresholding (default 10). */
    public native int adaptiveThreshWinSizeStep(); public native DetectorParameters adaptiveThreshWinSizeStep(int setter);

    /** constant for adaptive thresholding before finding contours (default 7) */
    public native double adaptiveThreshConstant(); public native DetectorParameters adaptiveThreshConstant(double setter);

    /** \brief determine minimum perimeter for marker contour to be detected.
     *
     * This is defined as a rate respect to the maximum dimension of the input image (default 0.03).
     */
    public native double minMarkerPerimeterRate(); public native DetectorParameters minMarkerPerimeterRate(double setter);

    /** \brief determine maximum perimeter for marker contour to be detected.
     *
     * This is defined as a rate respect to the maximum dimension of the input image (default 4.0).
     */
    public native double maxMarkerPerimeterRate(); public native DetectorParameters maxMarkerPerimeterRate(double setter);

    /** minimum accuracy during the polygonal approximation process to determine which contours are squares. (default 0.03) */
    public native double polygonalApproxAccuracyRate(); public native DetectorParameters polygonalApproxAccuracyRate(double setter);

    /** minimum distance between corners for detected markers relative to its perimeter (default 0.05) */
    public native double minCornerDistanceRate(); public native DetectorParameters minCornerDistanceRate(double setter);

    /** minimum distance of any corner to the image border for detected markers (in pixels) (default 3) */
    public native int minDistanceToBorder(); public native DetectorParameters minDistanceToBorder(int setter);

    /** \brief minimum mean distance beetween two marker corners to be considered imilar, so that the smaller one is removed.
     *
     * The rate is relative to the smaller perimeter of the two markers (default 0.05).
     */
    public native double minMarkerDistanceRate(); public native DetectorParameters minMarkerDistanceRate(double setter);

    /** \brief default value CORNER_REFINE_NONE */
    public native @Cast("cv::aruco::CornerRefineMethod") int cornerRefinementMethod(); public native DetectorParameters cornerRefinementMethod(int setter);

    /** window size for the corner refinement process (in pixels) (default 5). */
    public native int cornerRefinementWinSize(); public native DetectorParameters cornerRefinementWinSize(int setter);

    /** maximum number of iterations for stop criteria of the corner refinement process (default 30). */
    public native int cornerRefinementMaxIterations(); public native DetectorParameters cornerRefinementMaxIterations(int setter);

    /** minimum error for the stop cristeria of the corner refinement process (default: 0.1) */
    public native double cornerRefinementMinAccuracy(); public native DetectorParameters cornerRefinementMinAccuracy(double setter);

    /** number of bits of the marker border, i.e. marker border width (default 1). */
    public native int markerBorderBits(); public native DetectorParameters markerBorderBits(int setter);

    /** number of bits (per dimension) for each cell of the marker when removing the perspective (default 4). */
    public native int perspectiveRemovePixelPerCell(); public native DetectorParameters perspectiveRemovePixelPerCell(int setter);

    /** \brief width of the margin of pixels on each cell not considered for the determination of the cell bit.
     *
     * Represents the rate respect to the total size of the cell, i.e. perspectiveRemovePixelPerCell (default 0.13)
     */
    public native double perspectiveRemoveIgnoredMarginPerCell(); public native DetectorParameters perspectiveRemoveIgnoredMarginPerCell(double setter);

    /** \brief  maximum number of accepted erroneous bits in the border (i.e. number of allowed white bits in the border).
     *
     * Represented as a rate respect to the total number of bits per marker (default 0.35).
     */
    public native double maxErroneousBitsInBorderRate(); public native DetectorParameters maxErroneousBitsInBorderRate(double setter);

    /** \brief minimun standard deviation in pixels values during the decodification step to apply Otsu
     * thresholding (otherwise, all the bits are set to 0 or 1 depending on mean higher than 128 or not) (default 5.0)
     */
    public native double minOtsuStdDev(); public native DetectorParameters minOtsuStdDev(double setter);

    /** error correction rate respect to the maximun error correction capability for each dictionary (default 0.6). */
    public native double errorCorrectionRate(); public native DetectorParameters errorCorrectionRate(double setter);

    /** \brief April :: User-configurable parameters.
     *
     * Detection of quads can be done on a lower-resolution image, improving speed at a cost of
     * pose accuracy and a slight decrease in detection rate. Decoding the binary payload is still
     */
    public native float aprilTagQuadDecimate(); public native DetectorParameters aprilTagQuadDecimate(float setter);

    /** what Gaussian blur should be applied to the segmented image (used for quad detection?) */
    public native float aprilTagQuadSigma(); public native DetectorParameters aprilTagQuadSigma(float setter);

    // April :: Internal variables
    /** reject quads containing too few pixels (default 5). */
    public native int aprilTagMinClusterPixels(); public native DetectorParameters aprilTagMinClusterPixels(int setter);

    /** how many corner candidates to consider when segmenting a group of pixels into a quad (default 10). */
    public native int aprilTagMaxNmaxima(); public native DetectorParameters aprilTagMaxNmaxima(int setter);

    /** \brief reject quads where pairs of edges have angles that are close to straight or close to 180 degrees.
     *
     * Zero means that no quads are rejected. (In radians) (default 10*PI/180)
     */
    public native float aprilTagCriticalRad(); public native DetectorParameters aprilTagCriticalRad(float setter);

    /** when fitting lines to the contours, what is the maximum mean squared error */
    public native float aprilTagMaxLineFitMse(); public native DetectorParameters aprilTagMaxLineFitMse(float setter);

    /** \brief add an extra check that the white model must be (overall) brighter than the black model.
     *
     * When we build our model of black & white pixels, we add an extra check that the white model must be (overall)
     * brighter than the black model. How much brighter? (in pixel values, [0,255]), (default 5)
     */
    public native int aprilTagMinWhiteBlackDiff(); public native DetectorParameters aprilTagMinWhiteBlackDiff(int setter);

    /** should the thresholded image be deglitched? Only useful for very noisy images (default 0). */
    public native int aprilTagDeglitch(); public native DetectorParameters aprilTagDeglitch(int setter);

    /** \brief to check if there is a white marker.
     *
     * In order to generate a "white" marker just invert a normal marker by using a tilde, ~markerImage. (default false)
     */
    public native @Cast("bool") boolean detectInvertedMarker(); public native DetectorParameters detectInvertedMarker(boolean setter);

    /** \brief enable the new and faster Aruco detection strategy.
     *
     * Proposed in the paper:
     * Romero-Ramirez et al: Speeded up detection of squared fiducial markers (2018)
     * https://www.researchgate.net/publication/325787310_Speeded_Up_Detection_of_Squared_Fiducial_Markers
     */
    public native @Cast("bool") boolean useAruco3Detection(); public native DetectorParameters useAruco3Detection(boolean setter);

    /** minimum side length of a marker in the canonical image. Latter is the binarized image in which contours are searched. */
    public native int minSideLengthCanonicalImg(); public native DetectorParameters minSideLengthCanonicalImg(int setter);

    /** range [0,1], eq (2) from paper. The parameter tau_i has a direct influence on the processing speed. */
    public native float minMarkerLengthRatioOriginalImg(); public native DetectorParameters minMarkerLengthRatioOriginalImg(float setter);
}
