// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_xfeatures2d;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_ml.*;
import static org.bytedeco.opencv.global.opencv_ml.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_shape.*;
import static org.bytedeco.opencv.global.opencv_shape.*;

import static org.bytedeco.opencv.global.opencv_xfeatures2d.*;


/** \brief Class implementing TEBLID (Triplet-based Efficient Binary Local Image Descriptor),
 * described in \cite Suarez2021TEBLID.
<p>
TEBLID stands for Triplet-based Efficient Binary Local Image Descriptor, although originally it was called BAD
\cite Suarez2021TEBLID. It is an improvement over BEBLID \cite Suarez2020BEBLID, that uses triplet loss,
hard negative mining, and anchor swap to improve the image matching results.
It is able to describe keypoints from any detector just by changing the scale_factor parameter.
TEBLID is as efficient as ORB, BEBLID or BRISK, but the triplet-based training objective selected more
discriminative features that explain the accuracy gain. It is also more compact than BEBLID,
when running the [AKAZE example](https://github.com/opencv/opencv/blob/4.x/samples/cpp/tutorial_code/features2D/AKAZE_match.cpp)
with 10000 keypoints detected by ORB, BEBLID obtains 561 inliers (75%) with 512 bits, whereas
TEBLID obtains 621 (75.2%) with 256 bits. ORB obtains only 493 inliers (63%).
<p>
If you find this code useful, please add a reference to the following paper:
<BLOCKQUOTE> Iago Suárez, José M. Buenaposada, and Luis Baumela.
Revisiting Binary Local Image Description for Resource Limited Devices.
IEEE Robotics and Automation Letters, vol. 6, no. 4, pp. 8317-8324, Oct. 2021. </BLOCKQUOTE>
<p>
The descriptor was trained in Liberty split of the UBC datasets \cite winder2007learning .
*/
@Namespace("cv::xfeatures2d") @Properties(inherit = org.bytedeco.opencv.presets.opencv_xfeatures2d.class)
public class TEBLID extends Feature2D {
    static { Loader.load(); }
    /** Default native constructor. */
    public TEBLID() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public TEBLID(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TEBLID(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public TEBLID position(long position) {
        return (TEBLID)super.position(position);
    }
    @Override public TEBLID getPointer(long i) {
        return new TEBLID((Pointer)this).offsetAddress(i);
    }
    /** Downcast constructor. */
    public TEBLID(Algorithm pointer) { super((Pointer)null); allocate(pointer); }
    @Namespace private native @Name("dynamic_cast<cv::xfeatures2d::TEBLID*>") void allocate(Algorithm pointer);

    /**
     * \brief  Descriptor number of bits, each bit is a box average difference.
     * The user can choose between 256 or 512 bits.
     */
    /** enum cv::xfeatures2d::TEBLID::TeblidSize */
    public static final int
        SIZE_256_BITS = 102, SIZE_512_BITS = 103;
    /** \brief Creates the TEBLID descriptor.
    @param scale_factor Adjust the sampling window around detected keypoints:
    - <b> 1.00f </b> should be the scale for ORB keypoints
    - <b> 6.75f </b> should be the scale for SIFT detected keypoints
    - <b> 6.25f </b> is default and fits for KAZE, SURF detected keypoints
    - <b> 5.00f </b> should be the scale for AKAZE, MSD, AGAST, FAST, BRISK keypoints
    @param n_bits Determine the number of bits in the descriptor. Should be either
     TEBLID::SIZE_256_BITS or TEBLID::SIZE_512_BITS.
    */
    public static native @Ptr TEBLID create(float scale_factor, int n_bits/*=cv::xfeatures2d::TEBLID::SIZE_256_BITS*/);
    public static native @Ptr TEBLID create(float scale_factor);

    public native @Str @Override BytePointer getDefaultName();
}
