/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.opennlp;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.GZIPInputStream;
import opennlp.maxent.io.BinaryGISModelReader;
import opennlp.model.MaxentModel;
import opennlp.model.RealValueFileEventStream;
import org.cleartk.classifier.encoder.features.NameNumber;
import org.cleartk.classifier.jar.ClassifierBuilder_ImplBase;
import org.cleartk.classifier.jar.JarStreams;
import org.cleartk.classifier.opennlp.MaxentClassifier_ImplBase;

public abstract class MaxentClassifierBuilder_ImplBase<CLASSIFIER_TYPE extends MaxentClassifier_ImplBase<OUTCOME_TYPE>, OUTCOME_TYPE>
extends ClassifierBuilder_ImplBase<CLASSIFIER_TYPE, List<NameNumber>, OUTCOME_TYPE, String> {
    private static final String MODEL_NAME = "model.maxent";
    protected MaxentModel model;

    public File getTrainingDataFile(File dir) {
        return new File(dir, "training-data.maxent");
    }

    public void trainClassifier(File dir, String ... args) throws Exception {
        String[] maxentArgs = new String[args.length + 1];
        maxentArgs[0] = this.getTrainingDataFile(dir).getPath();
        System.arraycopy(args, 0, maxentArgs, 1, args.length);
        RealValueFileEventStream.main((String[])maxentArgs);
    }

    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)MODEL_NAME, (File)new File(dir, "training-data.maxent.bin.gz"));
        File featureLookup = new File(dir, "names-lookup.txt");
        if (featureLookup.exists()) {
            JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)"name-lookup.txt", (File)featureLookup);
        }
    }

    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        super.unpackageClassifier(modelStream);
        JarStreams.getNextJarEntry((JarInputStream)modelStream, (String)MODEL_NAME);
        this.model = new BinaryGISModelReader(new DataInputStream(new GZIPInputStream(modelStream))).getModel();
    }
}

