/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.opennlp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import opennlp.model.MaxentModel;
import org.cleartk.classifier.CleartkProcessingException;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.ScoredOutcome;
import org.cleartk.classifier.encoder.CleartkEncoderException;
import org.cleartk.classifier.encoder.features.FeaturesEncoder;
import org.cleartk.classifier.encoder.features.NameNumber;
import org.cleartk.classifier.encoder.outcome.OutcomeEncoder;
import org.cleartk.classifier.jar.Classifier_ImplBase;

public abstract class MaxentClassifier_ImplBase<OUTCOME_TYPE>
extends Classifier_ImplBase<List<NameNumber>, OUTCOME_TYPE, String> {
    protected MaxentModel model;

    public MaxentClassifier_ImplBase(FeaturesEncoder<List<NameNumber>> featuresEncoder, OutcomeEncoder<OUTCOME_TYPE, String> outcomeEncoder, MaxentModel model) {
        super(featuresEncoder, outcomeEncoder);
        this.model = model;
    }

    public OUTCOME_TYPE classify(List<Feature> features) throws CleartkProcessingException {
        EvalParams evalParams = this.convertToEvalParams(features);
        String encodedOutcome = this.model.getBestOutcome(this.model.eval(evalParams.getContext(), evalParams.getValues()));
        return (OUTCOME_TYPE)this.outcomeEncoder.decode((Object)encodedOutcome);
    }

    public List<ScoredOutcome<OUTCOME_TYPE>> score(List<Feature> features, int maxResults) throws CleartkProcessingException {
        EvalParams evalParams = this.convertToEvalParams(features);
        double[] evalResults = this.model.eval(evalParams.getContext(), evalParams.getValues());
        String[] encodedOutcomes = (String[])this.model.getDataStructures()[2];
        ArrayList<ScoredOutcome<OUTCOME_TYPE>> returnValues = new ArrayList<ScoredOutcome<OUTCOME_TYPE>>();
        if (maxResults == 1) {
            String bestOutcome = this.model.getBestOutcome(evalResults);
            Object encodedBestOutcome = this.outcomeEncoder.decode((Object)bestOutcome);
            double bestResult = evalResults[this.model.getIndex(bestOutcome)];
            returnValues.add(new ScoredOutcome(encodedBestOutcome, bestResult));
            return returnValues;
        }
        for (int i = 0; i < evalResults.length; ++i) {
            returnValues.add(new ScoredOutcome(this.outcomeEncoder.decode((Object)encodedOutcomes[i]), evalResults[i]));
        }
        Collections.sort(returnValues);
        if (returnValues.size() > maxResults) {
            return returnValues.subList(0, maxResults);
        }
        return returnValues;
    }

    protected EvalParams convertToEvalParams(List<Feature> features) throws CleartkEncoderException {
        List contexts = (List)this.featuresEncoder.encodeAll(features);
        String[] context = new String[contexts.size()];
        float[] values = new float[contexts.size()];
        for (int i = 0; i < contexts.size(); ++i) {
            NameNumber contextValue = (NameNumber)contexts.get(i);
            context[i] = contextValue.name;
            values[i] = contextValue.number.floatValue();
        }
        return new EvalParams(context, values);
    }

    public class EvalParams {
        private String[] context;
        private float[] values;

        public String[] getContext() {
            return this.context;
        }

        public float[] getValues() {
            return this.values;
        }

        public EvalParams(String[] context, float[] values) {
            this.context = context;
            this.values = values;
        }
    }
}

