/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.opennlp;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.cleartk.classifier.CleartkProcessingException;
import org.cleartk.classifier.encoder.features.BooleanEncoder;
import org.cleartk.classifier.encoder.features.FeatureEncoder;
import org.cleartk.classifier.encoder.features.FeaturesEncoder;
import org.cleartk.classifier.encoder.features.NameNumber;
import org.cleartk.classifier.encoder.features.NameNumberFeaturesEncoder;
import org.cleartk.classifier.encoder.features.NumberEncoder;
import org.cleartk.classifier.encoder.features.StringEncoder;
import org.cleartk.classifier.jar.DataWriter_ImplBase;
import org.cleartk.classifier.opennlp.MaxentClassifierBuilder_ImplBase;
import org.cleartk.classifier.opennlp.MaxentClassifier_ImplBase;

public abstract class MaxentDataWriter_ImplBase<CLASSIFIER_BUILDER_TYPE extends MaxentClassifierBuilder_ImplBase<? extends MaxentClassifier_ImplBase<OUTCOME_TYPE>, OUTCOME_TYPE>, OUTCOME_TYPE>
extends DataWriter_ImplBase<CLASSIFIER_BUILDER_TYPE, List<NameNumber>, OUTCOME_TYPE, String> {
    public MaxentDataWriter_ImplBase(File outputDirectory) throws IOException {
        super(outputDirectory);
        NameNumberFeaturesEncoder ftrsNcdr = new NameNumberFeaturesEncoder();
        ftrsNcdr.addEncoder((FeatureEncoder)new NumberEncoder());
        ftrsNcdr.addEncoder((FeatureEncoder)new BooleanEncoder());
        ftrsNcdr.addEncoder((FeatureEncoder)new StringEncoder());
        this.setFeaturesEncoder((FeaturesEncoder)ftrsNcdr);
    }

    public void writeEncoded(List<NameNumber> features, String outcome) throws CleartkProcessingException {
        if (outcome == null) {
            throw CleartkProcessingException.noInstanceOutcome(features);
        }
        this.trainingDataWriter.print(outcome);
        if (features.size() == 0) {
            this.trainingDataWriter.print(" null=0");
        }
        for (NameNumber nameNumber : features) {
            this.trainingDataWriter.print(' ');
            if (nameNumber.number.doubleValue() == 1.0) {
                this.trainingDataWriter.print(nameNumber.name);
                continue;
            }
            this.trainingDataWriter.print(nameNumber.name + "=" + nameNumber.number);
        }
        this.trainingDataWriter.println();
    }
}

