/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.chunker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.chunker.ChunkLabeler;
import org.cleartk.util.UIMAUtil;
import org.uimafit.component.initialize.ConfigurationParameterInitializer;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.factory.initializable.Initializable;
import org.uimafit.factory.initializable.InitializableFactory;
import org.uimafit.util.JCasUtil;

@Deprecated
public abstract class ChunkLabeler_ImplBase
implements ChunkLabeler,
Initializable {
    public static final String PARAM_CHUNK_ANNOTATION_CLASS_NAME = ConfigurationParameterFactory.createConfigurationParameterName(ChunkLabeler_ImplBase.class, (String)"chunkAnnotationClassName");
    @ConfigurationParameter(mandatory=true, description="names the class of the type system chunk annotation type. An example value might be something like: 'org.cleartk.type.ne.NamedEntityMention'")
    private String chunkAnnotationClassName;
    @ConfigurationParameter(name="org.cleartk.chunker.Chunker.labeledAnnotationClassName", mandatory=true, description="names the class of the type system type used to associate B, I, and O (for example) labels with.  An example value might be 'org.cleartk.type.Token'")
    private String labeledAnnotationClassName;
    public static final String BEGIN_PREFIX = "B";
    public static final String INSIDE_PREFIX = "I";
    public static final String OUTSIDE_LABEL = "O";
    public static final String SEPARATOR = "-";
    protected Class<? extends Annotation> chunkAnnotationClass;
    protected Type chunkAnnotationType;
    protected Class<? extends Annotation> labeledAnnotationClass;
    protected Type labeledAnnotationType;
    protected boolean typesInitialized = false;
    protected Map<Annotation, String> annotationLabels;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        ConfigurationParameterInitializer.initialize((Object)this, (UimaContext)context);
        this.labeledAnnotationClass = InitializableFactory.getClass((String)this.labeledAnnotationClassName, Annotation.class);
        this.chunkAnnotationClass = InitializableFactory.getClass((String)this.chunkAnnotationClassName, Annotation.class);
        this.annotationLabels = new HashMap<Annotation, String>();
    }

    public abstract String getChunkLabel(JCas var1, Annotation var2) throws AnalysisEngineProcessException;

    public abstract Annotation createChunk(JCas var1, List<? extends Annotation> var2, String var3) throws AnalysisEngineProcessException;

    protected void initializeTypes(JCas jCas) throws AnalysisEngineProcessException {
        try {
            this.chunkAnnotationType = UIMAUtil.getCasType((JCas)jCas, this.chunkAnnotationClass);
            this.labeledAnnotationType = UIMAUtil.getCasType((JCas)jCas, this.labeledAnnotationClass);
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        this.typesInitialized = true;
    }

    @Override
    public void chunks2Labels(JCas jCas, Annotation sequence) throws AnalysisEngineProcessException {
        if (!this.typesInitialized) {
            this.initializeTypes(jCas);
        }
        this.annotationLabels.clear();
        FSIterator chunkAnnotations = jCas.getAnnotationIndex(this.chunkAnnotationType).subiterator((AnnotationFS)sequence);
        while (chunkAnnotations.hasNext()) {
            String labelBase;
            Annotation chunkAnnotation = (Annotation)chunkAnnotations.next();
            String label = labelBase = this.getChunkLabel(jCas, chunkAnnotation);
            List labeledAnnotations = JCasUtil.selectCovered((JCas)jCas, this.labeledAnnotationClass, (AnnotationFS)chunkAnnotation);
            boolean begin = true;
            for (Annotation labelAnnotation : labeledAnnotations) {
                label = begin ? "B-" + labelBase : "I-" + labelBase;
                begin = false;
                this.setLabel(labelAnnotation, label);
            }
        }
    }

    @Override
    public List<Annotation> labels2Chunks(JCas jCas, Annotation sequence) throws AnalysisEngineProcessException {
        Annotation chunk;
        if (!this.typesInitialized) {
            this.initializeTypes(jCas);
        }
        ArrayList<Annotation> returnValues = new ArrayList<Annotation>();
        FSIterator labeledAnnotations = jCas.getAnnotationIndex(this.labeledAnnotationType).subiterator((AnnotationFS)sequence);
        String currentLabelValue = null;
        ArrayList<Annotation> currentLabeledAnnotations = new ArrayList<Annotation>();
        while (labeledAnnotations.hasNext()) {
            String labelValue;
            Annotation labeledAnnotation = (Annotation)labeledAnnotations.next();
            String label = this.getLabel(labeledAnnotation);
            if (label == null) {
                label = OUTSIDE_LABEL;
            }
            String labelPrefix = label.equals(OUTSIDE_LABEL) ? null : label.substring(0, 1);
            String string = labelValue = label.equals(OUTSIDE_LABEL) ? null : label.substring(2);
            if (labelPrefix == null || labelPrefix.equals(BEGIN_PREFIX) || !labelValue.equals(currentLabelValue)) {
                Annotation chunk2;
                if (currentLabeledAnnotations.size() > 0 && (chunk2 = this.createChunk(jCas, currentLabeledAnnotations, currentLabelValue)) != null) {
                    returnValues.add(chunk2);
                }
                currentLabeledAnnotations.clear();
                currentLabelValue = labelValue;
            }
            if (labelValue == null) continue;
            currentLabeledAnnotations.add(labeledAnnotation);
        }
        if (currentLabeledAnnotations.size() > 0 && (chunk = this.createChunk(jCas, currentLabeledAnnotations, currentLabelValue)) != null) {
            returnValues.add(chunk);
        }
        return returnValues;
    }

    @Override
    public String getLabel(Annotation labeledAnnotation) throws AnalysisEngineProcessException {
        if (this.annotationLabels.containsKey(labeledAnnotation)) {
            return this.annotationLabels.get(labeledAnnotation);
        }
        return OUTSIDE_LABEL;
    }

    @Override
    public void setLabel(Annotation labeledAnnotation, String label) throws AnalysisEngineProcessException {
        this.annotationLabels.put(labeledAnnotation, label);
    }

    public void setChunkAnnotationClassName(String chunkAnnotationClassName) {
        this.chunkAnnotationClassName = chunkAnnotationClassName;
    }

    public void setLabeledAnnotationClassName(String labeledAnnotationClassName) {
        this.labeledAnnotationClassName = labeledAnnotationClassName;
    }
}

