/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.chunker;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.chunker.ChunkLabeler;
import org.cleartk.chunker.ChunkerFeatureExtractor;
import org.cleartk.classifier.CleartkSequenceAnnotator;
import org.cleartk.classifier.Instance;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.factory.initializable.InitializableFactory;
import org.uimafit.util.JCasUtil;

@Deprecated
public class Chunker
extends CleartkSequenceAnnotator<String> {
    public static final String PARAM_LABELED_ANNOTATION_CLASS_NAME = "org.cleartk.chunker.Chunker.labeledAnnotationClassName";
    @ConfigurationParameter(mandatory=true, description="names the class of the type system type used to associate B, I, and O (for example) labels with.  An example value might be 'org.cleartk.type.Token'")
    protected String labeledAnnotationClassName;
    public static final String PARAM_SEQUENCE_CLASS_NAME = ConfigurationParameterFactory.createConfigurationParameterName(Chunker.class, (String)"sequenceClassName");
    @ConfigurationParameter(mandatory=true, description="names the class of the type system type that specifies a 'sequence' of labels.  An example might be something like 'org.cleartk.type.Sentence'")
    protected String sequenceClassName;
    public static final String PARAM_CHUNK_LABELER_CLASS_NAME = ConfigurationParameterFactory.createConfigurationParameterName(Chunker.class, (String)"chunkLabelerClassName");
    @ConfigurationParameter(mandatory=true, description="provides the class name of a class that extends org.cleartk.chunk.ChunkLabeler.")
    protected String chunkLabelerClassName;
    public static final String PARAM_CHUNKER_FEATURE_EXTRACTOR_CLASS_NAME = ConfigurationParameterFactory.createConfigurationParameterName(Chunker.class, (String)"chunkerFeatureExtractorClassName");
    @ConfigurationParameter(mandatory=true, description="provides the class name of a class that extends org.cleartk.chunk.ChunkFeatureExtractor.")
    protected String chunkerFeatureExtractorClassName;
    protected Class<? extends Annotation> labeledAnnotationClass;
    protected Class<? extends Annotation> sequenceClass;
    protected ChunkLabeler chunkLabeler;
    protected ChunkerFeatureExtractor featureExtractor;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.labeledAnnotationClass = InitializableFactory.getClass((String)this.labeledAnnotationClassName, Annotation.class);
        this.sequenceClass = InitializableFactory.getClass((String)this.sequenceClassName, Annotation.class);
        this.chunkLabeler = (ChunkLabeler)InitializableFactory.create((UimaContext)context, (String)this.chunkLabelerClassName, ChunkLabeler.class);
        this.featureExtractor = (ChunkerFeatureExtractor)InitializableFactory.create((UimaContext)context, (String)this.chunkerFeatureExtractorClassName, ChunkerFeatureExtractor.class);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        ArrayList instances = new ArrayList();
        ArrayList<Annotation> labeledAnnotationList = new ArrayList<Annotation>();
        for (Annotation sequence : JCasUtil.select((JCas)jCas, this.sequenceClass)) {
            if (this.isTraining()) {
                this.chunkLabeler.chunks2Labels(jCas, sequence);
            }
            instances.clear();
            labeledAnnotationList.clear();
            List labeledAnnotations = JCasUtil.selectCovered((JCas)jCas, this.labeledAnnotationClass, (AnnotationFS)sequence);
            if (labeledAnnotations.size() == 0) {
                throw new RuntimeException(String.format("Found %s containing no %s: \"%s\" %s", this.sequenceClassName, this.labeledAnnotationClassName, sequence.getCoveredText(), sequence));
            }
            for (Annotation labeledAnnotation : labeledAnnotations) {
                labeledAnnotationList.add(labeledAnnotation);
                Instance<String> instance = this.featureExtractor.extractFeatures(jCas, labeledAnnotation, sequence);
                String label = this.chunkLabeler.getLabel(labeledAnnotation);
                instance.setOutcome(label);
                instances.add(instance);
            }
            if (this.isTraining()) {
                this.dataWriter.write(instances);
                continue;
            }
            List results = this.classify(instances);
            for (int i = 0; i < results.size(); ++i) {
                Annotation labeledAnnotation = (Annotation)labeledAnnotationList.get(i);
                String label = (String)results.get(i);
                this.chunkLabeler.setLabel(labeledAnnotation, label);
            }
            this.chunkLabeler.labels2Chunks(jCas, sequence);
        }
    }

    public void setLabeledAnnotationClassName(String labeledAnnotationClassName) {
        this.labeledAnnotationClassName = labeledAnnotationClassName;
    }

    public void setSequenceClassName(String sequenceClassName) {
        this.sequenceClassName = sequenceClassName;
    }

    public void setChunkLabelerClassName(String chunkLabelerClassName) {
        this.chunkLabelerClassName = chunkLabelerClassName;
    }

    public void setChunkerFeatureExtractorClassName(String chunkerFeatureExtractorClassName) {
        this.chunkerFeatureExtractorClassName = chunkerFeatureExtractorClassName;
    }
}

