/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier;

import java.io.IOException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.Classifier;
import org.cleartk.classifier.ClassifierFactory;
import org.cleartk.classifier.DataWriter;
import org.cleartk.classifier.DataWriterFactory;
import org.cleartk.classifier.jar.DirectoryDataWriterFactory;
import org.cleartk.classifier.jar.GenericJarClassifierFactory;
import org.cleartk.util.CleartkInitializationException;
import org.cleartk.util.ReflectionUtil;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.factory.initializable.Initializable;
import org.uimafit.factory.initializable.InitializableFactory;

public abstract class CleartkAnnotator<OUTCOME_TYPE>
extends JCasAnnotator_ImplBase
implements Initializable {
    public static final String PARAM_CLASSIFIER_FACTORY_CLASS_NAME = ConfigurationParameterFactory.createConfigurationParameterName(CleartkAnnotator.class, (String)"classifierFactoryClassName");
    private static final String DEFAULT_CLASSIFIER_FACTORY_CLASS_NAME = "org.cleartk.classifier.jar.JarClassifierFactory";
    @ConfigurationParameter(mandatory=false, description="provides the full name of the ClassifierFactory class to be used.", defaultValue={"org.cleartk.classifier.jar.JarClassifierFactory"})
    private String classifierFactoryClassName;
    public static final String PARAM_DATA_WRITER_FACTORY_CLASS_NAME = ConfigurationParameterFactory.createConfigurationParameterName(CleartkAnnotator.class, (String)"dataWriterFactoryClassName");
    private static final String DEFAULT_DATA_WRITER_FACTORY_CLASS_NAME = "org.cleartk.classifier.jar.DefaultDataWriterFactory";
    @ConfigurationParameter(mandatory=false, description="provides the full name of the DataWriterFactory class to be used.", defaultValue={"org.cleartk.classifier.jar.DefaultDataWriterFactory"})
    private String dataWriterFactoryClassName;
    public static final String PARAM_IS_TRAINING = ConfigurationParameterFactory.createConfigurationParameterName(CleartkAnnotator.class, (String)"isTraining");
    @ConfigurationParameter(mandatory=false, description="determines whether this annotator is writing training data or using a classifier to annotate. Normally inferred automatically based on whether or not a DataWriterFactory class has been set.")
    private Boolean isTraining;
    private boolean primitiveIsTraining;
    protected Classifier<OUTCOME_TYPE> classifier;
    protected DataWriter<OUTCOME_TYPE> dataWriter;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        if (this.dataWriterFactoryClassName == null && this.classifierFactoryClassName == null) {
            CleartkInitializationException.neitherParameterSet((String)PARAM_DATA_WRITER_FACTORY_CLASS_NAME, (Object)this.dataWriterFactoryClassName, (String)PARAM_CLASSIFIER_FACTORY_CLASS_NAME, (Object)this.classifierFactoryClassName);
        }
        if (this.isTraining != null) {
            this.primitiveIsTraining = this.isTraining;
        } else if (!DEFAULT_DATA_WRITER_FACTORY_CLASS_NAME.equals(this.dataWriterFactoryClassName)) {
            this.primitiveIsTraining = true;
        } else if (context.getConfigParameterValue(DirectoryDataWriterFactory.PARAM_OUTPUT_DIRECTORY) != null) {
            this.primitiveIsTraining = true;
        } else if (!DEFAULT_CLASSIFIER_FACTORY_CLASS_NAME.equals(this.classifierFactoryClassName)) {
            this.primitiveIsTraining = false;
        } else if (context.getConfigParameterValue(GenericJarClassifierFactory.PARAM_CLASSIFIER_JAR_PATH) != null) {
            this.primitiveIsTraining = false;
        } else {
            String message = "Please specify PARAM_IS_TRAINING - unable to infer it from context";
            throw new IllegalArgumentException(message);
        }
        if (this.isTraining()) {
            DataWriter untypedDataWriter;
            DataWriterFactory factory = (DataWriterFactory)InitializableFactory.create((UimaContext)context, (String)this.dataWriterFactoryClassName, DataWriterFactory.class);
            try {
                untypedDataWriter = factory.createDataWriter();
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            InitializableFactory.initialize(untypedDataWriter, (UimaContext)context);
            this.dataWriter = (DataWriter)ReflectionUtil.uncheckedCast(untypedDataWriter);
        } else {
            Classifier untypedClassifier;
            ClassifierFactory factory = (ClassifierFactory)InitializableFactory.create((UimaContext)context, (String)this.classifierFactoryClassName, ClassifierFactory.class);
            try {
                untypedClassifier = factory.createClassifier();
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            this.classifier = (Classifier)ReflectionUtil.uncheckedCast(untypedClassifier);
            ReflectionUtil.checkTypeParameterIsAssignable(CleartkAnnotator.class, (String)"OUTCOME_TYPE", (Object)((Object)this), Classifier.class, (String)"OUTCOME_TYPE", this.classifier);
            InitializableFactory.initialize(untypedClassifier, (UimaContext)context);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        if (this.isTraining()) {
            this.dataWriter.finish();
        }
    }

    protected boolean isTraining() {
        return this.primitiveIsTraining;
    }
}

