/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.CleartkProcessingException;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.Instance;
import org.cleartk.classifier.SequenceClassifier;
import org.cleartk.classifier.SequenceClassifierFactory;
import org.cleartk.classifier.SequenceDataWriter;
import org.cleartk.classifier.SequenceDataWriterFactory;
import org.cleartk.classifier.jar.DirectoryDataWriterFactory;
import org.cleartk.classifier.jar.GenericJarClassifierFactory;
import org.cleartk.util.CleartkInitializationException;
import org.cleartk.util.ReflectionUtil;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.factory.initializable.Initializable;
import org.uimafit.factory.initializable.InitializableFactory;

public abstract class CleartkSequenceAnnotator<OUTCOME_TYPE>
extends JCasAnnotator_ImplBase
implements Initializable {
    public static final String PARAM_CLASSIFIER_FACTORY_CLASS_NAME = ConfigurationParameterFactory.createConfigurationParameterName(CleartkSequenceAnnotator.class, (String)"classifierFactoryClassName");
    private static final String DEFAULT_CLASSIFIER_FACTORY_CLASS_NAME = "org.cleartk.classifier.jar.SequenceJarClassifierFactory";
    @ConfigurationParameter(mandatory=false, description="provides the full name of the SequenceClassifierFactory class to be used.", defaultValue={"org.cleartk.classifier.jar.SequenceJarClassifierFactory"})
    private String classifierFactoryClassName;
    public static final String PARAM_DATA_WRITER_FACTORY_CLASS_NAME = ConfigurationParameterFactory.createConfigurationParameterName(CleartkSequenceAnnotator.class, (String)"dataWriterFactoryClassName");
    private static final String DEFAULT_DATA_WRITER_FACTORY_CLASS_NAME = "org.cleartk.classifier.jar.DefaultSequenceDataWriterFactory";
    @ConfigurationParameter(mandatory=false, description="provides the full name of the SequenceDataWriterFactory class to be used.", defaultValue={"org.cleartk.classifier.jar.DefaultSequenceDataWriterFactory"})
    private String dataWriterFactoryClassName;
    public static final String PARAM_IS_TRAINING = ConfigurationParameterFactory.createConfigurationParameterName(CleartkSequenceAnnotator.class, (String)"isTraining");
    @ConfigurationParameter(mandatory=false, description="determines whether this annotator is writing training data or using a classifier to annotate. Normally inferred automatically based on whether or not a DataWriterFactory class has been set.")
    private Boolean isTraining;
    private boolean primitiveIsTraining;
    protected SequenceDataWriter<OUTCOME_TYPE> dataWriter;
    protected SequenceClassifier<OUTCOME_TYPE> classifier;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        if (this.dataWriterFactoryClassName == null && this.classifierFactoryClassName == null) {
            CleartkInitializationException.neitherParameterSet((String)PARAM_DATA_WRITER_FACTORY_CLASS_NAME, (Object)this.dataWriterFactoryClassName, (String)PARAM_CLASSIFIER_FACTORY_CLASS_NAME, (Object)this.classifierFactoryClassName);
        }
        if (this.isTraining != null) {
            this.primitiveIsTraining = this.isTraining;
        } else if (!DEFAULT_DATA_WRITER_FACTORY_CLASS_NAME.equals(this.dataWriterFactoryClassName)) {
            this.primitiveIsTraining = true;
        } else if (context.getConfigParameterValue(DirectoryDataWriterFactory.PARAM_OUTPUT_DIRECTORY) != null) {
            this.primitiveIsTraining = true;
        } else if (!DEFAULT_CLASSIFIER_FACTORY_CLASS_NAME.equals(this.classifierFactoryClassName)) {
            this.primitiveIsTraining = false;
        } else if (context.getConfigParameterValue(GenericJarClassifierFactory.PARAM_CLASSIFIER_JAR_PATH) != null) {
            this.primitiveIsTraining = false;
        } else {
            String message = "Please specify PARAM_IS_TRAINING - unable to infer it from context";
            throw new IllegalArgumentException(message);
        }
        if (this.isTraining()) {
            SequenceDataWriter untypedDataWriter;
            SequenceDataWriterFactory factory = (SequenceDataWriterFactory)InitializableFactory.create((UimaContext)context, (String)this.dataWriterFactoryClassName, SequenceDataWriterFactory.class);
            try {
                untypedDataWriter = factory.createDataWriter();
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            InitializableFactory.initialize(untypedDataWriter, (UimaContext)context);
            this.dataWriter = (SequenceDataWriter)ReflectionUtil.uncheckedCast(untypedDataWriter);
        } else {
            SequenceClassifier untypedClassifier;
            SequenceClassifierFactory factory = (SequenceClassifierFactory)InitializableFactory.create((UimaContext)context, (String)this.classifierFactoryClassName, SequenceClassifierFactory.class);
            try {
                untypedClassifier = factory.createClassifier();
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            this.classifier = (SequenceClassifier)ReflectionUtil.uncheckedCast(untypedClassifier);
            ReflectionUtil.checkTypeParameterIsAssignable(CleartkSequenceAnnotator.class, (String)"OUTCOME_TYPE", (Object)((Object)this), SequenceClassifier.class, (String)"OUTCOME_TYPE", this.classifier);
            InitializableFactory.initialize(untypedClassifier, (UimaContext)context);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
        if (this.isTraining()) {
            this.dataWriter.finish();
        }
    }

    protected boolean isTraining() {
        return this.primitiveIsTraining;
    }

    protected List<OUTCOME_TYPE> classify(List<Instance<OUTCOME_TYPE>> instances) throws CleartkProcessingException {
        ArrayList<List<Feature>> instanceFeatures = new ArrayList<List<Feature>>();
        for (Instance<OUTCOME_TYPE> instance : instances) {
            instanceFeatures.add(instance.getFeatures());
        }
        return this.classifier.classify(instanceFeatures);
    }
}

