/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.baseline;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.cleartk.classifier.CleartkProcessingException;
import org.cleartk.classifier.DataWriter;
import org.cleartk.classifier.Instance;
import org.cleartk.classifier.baseline.SingleOutcomeClassifier;
import org.cleartk.classifier.baseline.SingleOutcomeClassifierBuilder;
import org.cleartk.classifier.jar.DirectoryDataWriter;

public abstract class OutcomeOnlyDataWriter<CLASSIFIER_BUILDER extends SingleOutcomeClassifierBuilder<OUTCOME_TYPE>, OUTCOME_TYPE>
extends DirectoryDataWriter<CLASSIFIER_BUILDER, SingleOutcomeClassifier<OUTCOME_TYPE>>
implements DataWriter<OUTCOME_TYPE> {
    protected File trainingDataFile;
    protected PrintWriter trainingDataWriter;

    public OutcomeOnlyDataWriter(File outputDirectory) throws FileNotFoundException {
        super(outputDirectory);
        this.trainingDataFile = ((SingleOutcomeClassifierBuilder)this.classifierBuilder).getTrainingDataFile(this.outputDirectory);
        this.trainingDataWriter = new PrintWriter(this.trainingDataFile);
    }

    @Override
    public void write(Instance<OUTCOME_TYPE> instance) throws CleartkProcessingException {
        this.trainingDataWriter.println(instance.getOutcome());
    }

    @Override
    public void finish() throws CleartkProcessingException {
        this.trainingDataWriter.close();
        super.finish();
    }
}

