/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.baseline;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.cleartk.classifier.baseline.SingleOutcomeClassifier;
import org.cleartk.classifier.jar.JarClassifierBuilder;
import org.cleartk.classifier.jar.JarStreams;

public abstract class SingleOutcomeClassifierBuilder<OUTCOME_TYPE>
extends JarClassifierBuilder<SingleOutcomeClassifier<OUTCOME_TYPE>> {
    private static final String MODEL_NAME = "model.singlevalue";
    protected OUTCOME_TYPE value;

    public File getTrainingDataFile(File dir) {
        return new File(dir, "training-data.outcomes");
    }

    protected abstract OUTCOME_TYPE parseOutcome(String var1);

    protected void writeOutcome(File dir, OUTCOME_TYPE outcome) throws IOException {
        Files.write((CharSequence)outcome.toString(), (File)new File(dir, MODEL_NAME), (Charset)Charsets.US_ASCII);
    }

    @Override
    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        JarStreams.putNextJarEntry(modelStream, MODEL_NAME, new File(dir, MODEL_NAME));
    }

    @Override
    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        super.unpackageClassifier(modelStream);
        JarStreams.getNextJarEntry(modelStream, MODEL_NAME);
        InputStreamReader reader = new InputStreamReader((InputStream)modelStream, Charsets.US_ASCII);
        this.value = this.parseOutcome(CharStreams.toString((Readable)reader));
    }

    @Override
    protected SingleOutcomeClassifier<OUTCOME_TYPE> newClassifier() {
        return new SingleOutcomeClassifier<OUTCOME_TYPE>(this.value);
    }
}

