/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.encoder.features;

import java.util.ArrayList;
import java.util.List;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.encoder.features.FeatureEncoder;
import org.cleartk.classifier.encoder.features.NameNumber;
import org.cleartk.classifier.encoder.features.normalizer.NOPNormalizer;
import org.cleartk.classifier.encoder.features.normalizer.NameNumberNormalizer;
import org.cleartk.classifier.feature.Counts;

public class BagEncoder
implements FeatureEncoder<NameNumber> {
    private static final long serialVersionUID = -5280514188425612793L;
    private String identifier;
    private NameNumberNormalizer normalizer;

    public BagEncoder(String identifier, NameNumberNormalizer normalizer) {
        this.identifier = identifier;
        this.normalizer = normalizer;
    }

    public BagEncoder(String identifier) {
        this(identifier, new NOPNormalizer());
    }

    public BagEncoder(NameNumberNormalizer normalizer) {
        this(null, normalizer);
    }

    public BagEncoder() {
        this(null, new NOPNormalizer());
    }

    @Override
    public List<NameNumber> encode(Feature feature) {
        ArrayList<NameNumber> fves = new ArrayList<NameNumber>();
        Counts frequencies = (Counts)feature.getValue();
        String prefix = frequencies.getFeatureName();
        for (Object object : frequencies.getValues()) {
            if (frequencies.getCount(object) <= 0) continue;
            String name = Feature.createName(prefix, object.toString());
            NameNumber fve = new NameNumber(name, 1);
            fves.add(fve);
        }
        this.normalizer.normalize(fves);
        return fves;
    }

    @Override
    public boolean encodes(Feature feature) {
        if (!(feature.getValue() instanceof Counts)) {
            return false;
        }
        Counts counts = (Counts)feature.getValue();
        if (this.identifier == null) {
            return true;
        }
        return this.identifier.equals(counts.getIdentifier());
    }
}

