/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.encoder.features;

import java.util.ArrayList;
import java.util.List;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.encoder.CleartkEncoderException;
import org.cleartk.classifier.encoder.features.FeatureEncoder;

public class FeatureEncoderChain<ENCODED_TYPE>
implements FeatureEncoder<ENCODED_TYPE> {
    private static final long serialVersionUID = -3363875258541749972L;
    protected List<FeatureEncoder<ENCODED_TYPE>> featureEncoders = new ArrayList<FeatureEncoder<ENCODED_TYPE>>();

    public void addEncoder(FeatureEncoder<ENCODED_TYPE> encoder) {
        this.featureEncoders.add(encoder);
    }

    @Override
    public List<ENCODED_TYPE> encode(Feature feature) throws CleartkEncoderException {
        for (FeatureEncoder<ENCODED_TYPE> featureEncoder : this.featureEncoders) {
            if (!featureEncoder.encodes(feature)) continue;
            return featureEncoder.encode(feature);
        }
        throw CleartkEncoderException.noMatchingEncoder(feature, this.featureEncoders);
    }

    @Override
    public boolean encodes(Feature feature) {
        for (FeatureEncoder<ENCODED_TYPE> encoder : this.featureEncoders) {
            if (!encoder.encodes(feature)) continue;
            return true;
        }
        return false;
    }
}

