/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.encoder.features;

import java.util.ArrayList;
import java.util.List;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.encoder.features.FeatureEncoder;
import org.cleartk.classifier.encoder.features.NameNumber;
import org.cleartk.classifier.encoder.features.normalizer.NOPNormalizer;
import org.cleartk.classifier.encoder.features.normalizer.NameNumberNormalizer;
import org.cleartk.classifier.feature.Counts;

public class MultiBagEncoder
implements FeatureEncoder<NameNumber> {
    private static final long serialVersionUID = -5280514188425612793L;
    private String identifier;
    private NameNumberNormalizer normalizer;

    public MultiBagEncoder(String identifier, NameNumberNormalizer normalizer) {
        this.identifier = identifier;
        this.normalizer = normalizer;
    }

    public MultiBagEncoder(String identifier) {
        this(identifier, new NOPNormalizer());
    }

    public MultiBagEncoder(NameNumberNormalizer normalizer) {
        this(null, normalizer);
    }

    public MultiBagEncoder() {
        this(null, new NOPNormalizer());
    }

    @Override
    public List<NameNumber> encode(Feature feature) {
        ArrayList<NameNumber> fves = new ArrayList<NameNumber>();
        Counts frequencies = (Counts)feature.getValue();
        String prefix = frequencies.getFeatureName();
        for (Object object : frequencies.getValues()) {
            String name = Feature.createName(prefix, object.toString());
            NameNumber fve = new NameNumber(name, frequencies.getCount(object));
            fves.add(fve);
        }
        this.normalizer.normalize(fves);
        return fves;
    }

    @Override
    public boolean encodes(Feature feature) {
        if (!(feature.getValue() instanceof Counts)) {
            return false;
        }
        Counts counts = (Counts)feature.getValue();
        if (this.identifier == null) {
            return true;
        }
        return this.identifier.equals(counts.getIdentifier());
    }
}

