/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.encoder.features;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.encoder.CleartkEncoderException;
import org.cleartk.classifier.encoder.FeatureEncoderUtil;
import org.cleartk.classifier.encoder.features.FeaturesEncoder_ImplBase;
import org.cleartk.classifier.encoder.features.NameNumber;
import org.cleartk.util.collection.CompressedStringBiMap;

public class NameNumberFeaturesEncoder
extends FeaturesEncoder_ImplBase<List<NameNumber>, NameNumber> {
    private static final long serialVersionUID = 7508330794260661987L;
    public static final String LOOKUP_FILE_NAME = "names-lookup.txt";
    private CompressedStringBiMap csbm;
    private boolean compressFeatures;
    private boolean allowNewFeatures = true;
    private boolean sortNameLookup;

    public boolean isCompressFeatures() {
        return this.compressFeatures;
    }

    public NameNumberFeaturesEncoder(boolean compressFeatures, boolean sortNameLookup) {
        this.compressFeatures = compressFeatures;
        this.sortNameLookup = sortNameLookup;
        if (compressFeatures) {
            this.csbm = new CompressedStringBiMap();
        }
    }

    public NameNumberFeaturesEncoder() {
        this(false, false);
    }

    @Override
    public List<NameNumber> encodeAll(Iterable<Feature> features) throws CleartkEncoderException {
        ArrayList<NameNumber> returnValues = new ArrayList<NameNumber>();
        for (Feature feature : features) {
            for (NameNumber nameNumber : this.encode(feature)) {
                nameNumber.name = this.compress(this.escape(nameNumber.name));
                if (nameNumber.name == null) continue;
                returnValues.add(nameNumber);
            }
        }
        return returnValues;
    }

    @Override
    public void finalizeFeatureSet(File outputDirectory) throws IOException {
        this.allowNewFeatures = false;
        if (this.compressFeatures) {
            File lookupFile = new File(outputDirectory, LOOKUP_FILE_NAME);
            PrintWriter writer = new PrintWriter(lookupFile);
            this.csbm.write((Writer)writer, this.sortNameLookup);
            writer.close();
        }
    }

    private String escape(String string) {
        return FeatureEncoderUtil.escape(string, new char[]{'='});
    }

    private String compress(String featureString) {
        if (this.compressFeatures) {
            if (this.allowNewFeatures) {
                return this.csbm.getOrGenerateKey(featureString);
            }
            return (String)this.csbm.inverse().get((Object)featureString);
        }
        return featureString;
    }
}

