/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.encoder.features;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.encoder.features.FeatureEncoder;
import org.cleartk.classifier.encoder.features.NameNumber;
import org.cleartk.classifier.encoder.features.normalizer.EuclidianNormalizer;
import org.cleartk.classifier.encoder.features.normalizer.NameNumberNormalizer;
import org.cleartk.classifier.feature.Counts;
import org.cleartk.classifier.util.tfidf.IDFMap;

@Deprecated
public class TFIDFEncoder
implements FeatureEncoder<NameNumber> {
    private static final long serialVersionUID = -5280514188425612793L;
    private String identifier;
    private NameNumberNormalizer normalizer;
    private IDFMap idfMap;

    public TFIDFEncoder(String identifier, File idfMapFile, NameNumberNormalizer normalizer) throws IOException {
        this.identifier = identifier;
        this.normalizer = normalizer;
        this.idfMap = IDFMap.read(idfMapFile);
    }

    public TFIDFEncoder(String identifier, File idfFile) throws IOException {
        this(identifier, idfFile, new EuclidianNormalizer());
    }

    public TFIDFEncoder(File idfFile, NameNumberNormalizer normalizer) throws IOException {
        this(null, idfFile, normalizer);
    }

    public TFIDFEncoder(File idfFile) throws IOException {
        this(null, idfFile, new EuclidianNormalizer());
    }

    @Override
    public List<NameNumber> encode(Feature feature) {
        ArrayList<NameNumber> fves = new ArrayList<NameNumber>();
        Counts counts = (Counts)feature.getValue();
        String prefix = counts.getFeatureName();
        for (Object object : counts.getValues()) {
            double tf = TFIDFEncoder.getTF(counts, object);
            double idf = this.idfMap.getIDF(object);
            String name = Feature.createName(prefix, object.toString());
            NameNumber fve = new NameNumber(name, tf * idf);
            fves.add(fve);
        }
        this.normalizer.normalize(fves);
        return fves;
    }

    @Override
    public boolean encodes(Feature feature) {
        if (!(feature.getValue() instanceof Counts)) {
            return false;
        }
        Counts counts = (Counts)feature.getValue();
        if (this.identifier == null) {
            return true;
        }
        return this.identifier.equals(counts.getIdentifier());
    }

    private static double getTF(Counts counts, Object key) {
        return (double)counts.getCount(key) / (double)counts.getTotalCount();
    }
}

