/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.extractor;

import com.google.common.base.Joiner;
import com.google.common.collect.LinkedHashMultiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.extractor.BetweenAnnotationsFeatureExtractor;
import org.cleartk.classifier.feature.extractor.CleartkExtractorException;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleNamedFeatureExtractor;
import org.uimafit.util.JCasUtil;

public class CleartkExtractor
implements SimpleFeatureExtractor,
BetweenAnnotationsFeatureExtractor {
    private Class<? extends Annotation> annotationClass;
    private SimpleFeatureExtractor extractor;
    private Context[] contexts;

    public CleartkExtractor(Class<? extends Annotation> annotationClass, SimpleFeatureExtractor extractor, Context ... contexts) {
        this.annotationClass = annotationClass;
        this.extractor = extractor;
        this.contexts = contexts;
    }

    @Override
    public List<Feature> extract(JCas view, Annotation focusAnnotation) throws CleartkExtractorException {
        return this.extract(view, focusAnnotation, new NoBounds());
    }

    public List<Feature> extractWithin(JCas view, Annotation focusAnnotation, Annotation boundsAnnotation) throws CleartkExtractorException {
        SpanBounds bounds = new SpanBounds(boundsAnnotation.getBegin(), boundsAnnotation.getEnd());
        return this.extract(view, focusAnnotation, bounds);
    }

    @Override
    public List<Feature> extractBetween(JCas view, Annotation annotation1, Annotation annotation2) throws CleartkExtractorException {
        int begin = annotation1.getEnd();
        int end = annotation2.getBegin();
        Annotation focusAnnotation = new Annotation(view, begin, end);
        return this.extract(view, focusAnnotation, new NoBounds());
    }

    private List<Feature> extract(JCas view, Annotation focusAnnotation, Bounds bounds) throws CleartkExtractorException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Context context : this.contexts) {
            features.addAll(context.extract(view, focusAnnotation, bounds, this.annotationClass, this.extractor));
        }
        return features;
    }

    public static class Ngrams
    implements Context {
        private int n;
        private Context[] contexts;
        private String name;

        public Ngrams(int n, Context ... contexts) {
            this.n = n;
            this.contexts = contexts;
            String[] names = new String[contexts.length + 1];
            names[0] = this.n + "grams";
            for (int i = 1; i < names.length; ++i) {
                names[i] = contexts[i - 1].getName();
            }
            this.name = Feature.createName(names);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public <T extends Annotation> List<Feature> extract(JCas jCas, Annotation focusAnnotation, Bounds bounds, Class<T> annotationClass, SimpleFeatureExtractor extractor) throws CleartkExtractorException {
            String featureName = extractor instanceof SimpleNamedFeatureExtractor ? ((SimpleNamedFeatureExtractor)extractor).getFeatureName() : null;
            featureName = Feature.createName(this.name, featureName);
            ArrayList<Feature> extractedFeatures = new ArrayList<Feature>();
            for (Context context : this.contexts) {
                extractedFeatures.addAll(context.extract(jCas, focusAnnotation, bounds, annotationClass, extractor));
            }
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (int i = 0; i < extractedFeatures.size() - this.n + 1; ++i) {
                ArrayList<String> values = new ArrayList<String>();
                for (Feature feature : extractedFeatures.subList(i, i + this.n)) {
                    values.add(feature.getValue().toString());
                }
                features.add(new Feature(featureName, Joiner.on((char)'_').join(values)));
            }
            return features;
        }
    }

    public static class Ngram
    implements Context {
        private Context[] contexts;
        private String name;

        public Ngram(Context ... contexts) {
            this.contexts = contexts;
            String[] names = new String[contexts.length + 1];
            names[0] = "Ngram";
            for (int i = 1; i < names.length; ++i) {
                names[i] = contexts[i - 1].getName();
            }
            this.name = Feature.createName(names);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public <T extends Annotation> List<Feature> extract(JCas jCas, Annotation focusAnnotation, Bounds bounds, Class<T> annotationClass, SimpleFeatureExtractor extractor) throws CleartkExtractorException {
            String featureName = extractor instanceof SimpleNamedFeatureExtractor ? ((SimpleNamedFeatureExtractor)extractor).getFeatureName() : null;
            featureName = Feature.createName(this.name, featureName);
            ArrayList<String> values = new ArrayList<String>();
            for (Context context : this.contexts) {
                for (Feature feature : context.extract(jCas, focusAnnotation, bounds, annotationClass, extractor)) {
                    values.add(String.valueOf(feature.getValue()));
                }
            }
            return Arrays.asList(new Feature(featureName, StringUtils.join(values, (char)'_')));
        }
    }

    public static class Count
    implements Context {
        private Context[] contexts;
        private String name;

        public Count(Context ... contexts) {
            this.contexts = contexts;
            String[] names = new String[contexts.length + 1];
            names[0] = "Count";
            for (int i = 1; i < names.length; ++i) {
                names[i] = contexts[i - 1].getName();
            }
            this.name = Feature.createName(names);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public <T extends Annotation> List<Feature> extract(JCas jCas, Annotation focusAnnotation, Bounds bounds, Class<T> annotationClass, SimpleFeatureExtractor extractor) throws CleartkExtractorException {
            LinkedHashMultiset featureCounts = LinkedHashMultiset.create();
            for (Context context : this.contexts) {
                for (Feature feature : context.extract(jCas, focusAnnotation, bounds, annotationClass, extractor)) {
                    ContextFeature contextFeature = (ContextFeature)feature;
                    String featureName = Feature.createName(this.name, contextFeature.feature.getName(), String.valueOf(feature.getValue()));
                    featureCounts.add((Object)featureName);
                }
            }
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (String featureName : featureCounts.elementSet()) {
                features.add(new Feature(featureName, featureCounts.count((Object)featureName)));
            }
            return features;
        }
    }

    public static class Bag
    implements Context {
        private Context[] contexts;
        private String name;

        public Bag(Context ... contexts) {
            this.contexts = contexts;
            String[] names = new String[contexts.length + 1];
            names[0] = "Bag";
            for (int i = 1; i < names.length; ++i) {
                names[i] = contexts[i - 1].getName();
            }
            this.name = Feature.createName(names);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public <T extends Annotation> List<Feature> extract(JCas jCas, Annotation focusAnnotation, Bounds bounds, Class<T> annotationClass, SimpleFeatureExtractor extractor) throws CleartkExtractorException {
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (Context context : this.contexts) {
                for (Feature feature : context.extract(jCas, focusAnnotation, bounds, annotationClass, extractor)) {
                    ContextFeature contextFeature = (ContextFeature)feature;
                    String fName = Feature.createName(this.name, contextFeature.feature.getName());
                    features.add(new Feature(fName, feature.getValue()));
                }
            }
            return features;
        }
    }

    public static class LastCovered
    extends RightToLeftContext {
        public LastCovered(int end) {
            super(0, end);
        }

        public LastCovered(int begin, int end) {
            super(begin, end);
        }

        @Override
        protected <T extends Annotation> List<T> select(JCas jCas, Annotation focusAnnotation, Class<T> annotationClass, int count) {
            List anns = JCasUtil.selectCovered((JCas)jCas, annotationClass, (AnnotationFS)focusAnnotation);
            return anns.subList(Math.max(anns.size() - count, 0), anns.size());
        }
    }

    public static class FirstCovered
    extends LeftToRightContext {
        public FirstCovered(int end) {
            super(0, end);
        }

        public FirstCovered(int begin, int end) {
            super(begin, end);
        }

        @Override
        protected <T extends Annotation> List<T> select(JCas jCas, Annotation focusAnnotation, Class<T> annotationClass, int count) {
            List anns = JCasUtil.selectCovered((JCas)jCas, annotationClass, (AnnotationFS)focusAnnotation);
            return anns.subList(0, Math.min(count, anns.size()));
        }
    }

    public static class Covered
    implements Context {
        @Override
        public String getName() {
            return "Covered";
        }

        @Override
        public <T extends Annotation> List<Feature> extract(JCas jCas, Annotation focusAnnotation, Bounds bounds, Class<T> annotationClass, SimpleFeatureExtractor extractor) throws CleartkExtractorException {
            ArrayList<Feature> features = new ArrayList<Feature>();
            int pos = 0;
            for (Annotation ann : JCasUtil.selectCovered((JCas)jCas, annotationClass, (AnnotationFS)focusAnnotation)) {
                for (Feature feature : extractor.extract(jCas, ann)) {
                    features.add(new ContextFeature(this.getName(), pos, feature));
                }
                ++pos;
            }
            return features;
        }
    }

    public static class Following
    extends LeftToRightContext {
        public Following(int end) {
            super(0, end);
        }

        public Following(int begin, int end) {
            super(begin, end);
        }

        @Override
        protected <T extends Annotation> List<T> select(JCas jCas, Annotation focusAnnotation, Class<T> annotationClass, int count) {
            return JCasUtil.selectFollowing((JCas)jCas, annotationClass, (AnnotationFS)focusAnnotation, (int)count);
        }
    }

    public static class Preceding
    extends RightToLeftContext {
        public Preceding(int end) {
            super(0, end);
        }

        public Preceding(int begin, int end) {
            super(begin, end);
        }

        @Override
        protected <T extends Annotation> List<T> select(JCas jCas, Annotation focusAnnotation, Class<T> annotationClass, int count) {
            return JCasUtil.selectPreceding((JCas)jCas, annotationClass, (AnnotationFS)focusAnnotation, (int)count);
        }
    }

    public static class Focus
    implements Context {
        private String name = this.getClass().getSimpleName();

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public <T extends Annotation> List<Feature> extract(JCas jCas, Annotation focusAnnotation, Bounds bounds, Class<T> annotationClass, SimpleFeatureExtractor extractor) throws CleartkExtractorException {
            if (!annotationClass.isInstance(focusAnnotation)) {
                String message = "%s is not an instance of %s";
                throw new IllegalArgumentException(String.format(message, focusAnnotation, annotationClass));
            }
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (Feature feature : extractor.extract(jCas, focusAnnotation)) {
                features.add(new ContextFeature(this.getName(), feature));
            }
            return features;
        }
    }

    private static abstract class LeftToRightContext
    extends Context_ImplBase {
        public LeftToRightContext(int begin, int end) {
            super(begin, end);
        }

        @Override
        public <T extends Annotation> List<Feature> extract(JCas jCas, Annotation focusAnnotation, Bounds bounds, Class<T> annotationClass, SimpleFeatureExtractor extractor) throws CleartkExtractorException {
            int oobStart;
            String featureName = extractor instanceof SimpleNamedFeatureExtractor ? ((SimpleNamedFeatureExtractor)extractor).getFeatureName() : null;
            List<T> anns = this.select(jCas, focusAnnotation, annotationClass, this.end);
            if (this.begin <= anns.size()) {
                oobStart = 1;
                anns = anns.subList(this.begin, anns.size());
            } else {
                oobStart = this.begin - anns.size() + 1;
                anns = new ArrayList<T>();
            }
            ArrayList<Feature> features = new ArrayList<Feature>();
            Iterator<T> iter = anns.iterator();
            int oobPos = oobStart;
            for (int pos = this.begin; pos < this.end; ++pos) {
                Annotation ann;
                Annotation annotation = ann = iter.hasNext() ? (Annotation)iter.next() : null;
                if (ann != null && bounds.contains(ann)) {
                    for (Feature feature : extractor.extract(jCas, ann)) {
                        features.add(new ContextFeature(this.getName(), pos, feature));
                    }
                    continue;
                }
                features.add(new ContextFeature(this.getName(), pos, oobPos, featureName));
                ++oobPos;
            }
            return features;
        }
    }

    private static abstract class RightToLeftContext
    extends Context_ImplBase {
        public RightToLeftContext(int begin, int end) {
            super(begin, end);
        }

        @Override
        public <T extends Annotation> List<Feature> extract(JCas jCas, Annotation focusAnnotation, Bounds bounds, Class<T> annotationClass, SimpleFeatureExtractor extractor) throws CleartkExtractorException {
            String featureName = extractor instanceof SimpleNamedFeatureExtractor ? ((SimpleNamedFeatureExtractor)extractor).getFeatureName() : null;
            List<T> anns = this.select(jCas, focusAnnotation, annotationClass, this.end);
            int missing = this.end - anns.size();
            anns = anns.subList(0, Math.max(0, anns.size() - this.begin));
            int oobPos = missing;
            for (Annotation ann : anns) {
                if (bounds.contains(ann)) continue;
                ++oobPos;
            }
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (int pos = this.end - 1; pos >= this.begin; --pos) {
                Annotation ann;
                int adjustedPos = this.end - 1 - pos - missing;
                Annotation annotation = ann = adjustedPos >= 0 ? (Annotation)anns.get(adjustedPos) : null;
                if (ann != null && bounds.contains(ann)) {
                    for (Feature feature : extractor.extract(jCas, ann)) {
                        features.add(new ContextFeature(this.getName(), pos, feature));
                    }
                    continue;
                }
                features.add(new ContextFeature(this.getName(), pos, oobPos, featureName));
                --oobPos;
            }
            return features;
        }
    }

    private static abstract class Context_ImplBase
    implements Context {
        protected int begin;
        protected int end;
        private String name;

        public Context_ImplBase(int begin, int end) {
            if (begin > end) {
                String message = "expected begin < end, found begin=%d end=%d";
                throw new IllegalArgumentException(String.format(message, begin, end));
            }
            this.begin = begin;
            this.end = end;
            this.name = Feature.createName(this.getClass().getSimpleName(), String.valueOf(this.begin), String.valueOf(this.end));
        }

        @Override
        public String getName() {
            return this.name;
        }

        protected abstract <T extends Annotation> List<T> select(JCas var1, Annotation var2, Class<T> var3, int var4);
    }

    private static class ContextFeature
    extends Feature {
        private static final long serialVersionUID = 1L;
        public Feature feature;

        public ContextFeature(String baseName, Feature feature) {
            this.feature = feature;
            this.setName(Feature.createName(baseName, feature.getName()));
            this.setValue(this.feature.getValue());
        }

        public ContextFeature(String baseName, int position, Feature feature) {
            this.feature = feature;
            this.setName(Feature.createName(baseName, String.valueOf(position), feature.getName()));
            this.setValue(feature.getValue());
        }

        public ContextFeature(String baseName, int position, int oobPosition, String featureName) {
            this.feature = new Feature(featureName, String.format(Locale.ROOT, "OOB%d", oobPosition));
            this.setName(Feature.createName(baseName, String.valueOf(position), featureName));
            this.setValue(this.feature.getValue());
        }
    }

    public static interface Context {
        public String getName();

        public <T extends Annotation> List<Feature> extract(JCas var1, Annotation var2, Bounds var3, Class<T> var4, SimpleFeatureExtractor var5) throws CleartkExtractorException;
    }

    private static class SpanBounds
    implements Bounds {
        private int begin;
        private int end;

        public SpanBounds(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        @Override
        public boolean contains(Annotation annotation) {
            return annotation.getBegin() >= this.begin && annotation.getEnd() <= this.end;
        }
    }

    private static class NoBounds
    implements Bounds {
        @Override
        public boolean contains(Annotation annotation) {
            return true;
        }
    }

    public static interface Bounds {
        public boolean contains(Annotation var1);
    }
}

