/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.extractor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.WindowFeature;
import org.cleartk.classifier.feature.extractor.CleartkExtractorException;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.util.AnnotationUtil;
import org.cleartk.util.UIMAUtil;
import org.uimafit.util.JCasUtil;

@Deprecated
public class WindowExtractor {
    Class<? extends Annotation> featureClass;
    Type featureType;
    SimpleFeatureExtractor featureExtractor;
    String windowOrientation;
    int windowStart;
    int windowEnd;
    protected String name;

    public WindowExtractor(Class<? extends Annotation> featureClass, SimpleFeatureExtractor featureExtractor, String windowOrientation, int windowStart, int windowEnd) {
        this.featureClass = featureClass;
        this.featureExtractor = featureExtractor;
        this.windowOrientation = windowOrientation;
        this.windowStart = windowStart;
        this.windowEnd = windowEnd;
    }

    public WindowExtractor(String name, Class<? extends Annotation> featureClass, SimpleFeatureExtractor featureExtractor, String windowOrientation, int windowStart, int windowEnd) {
        this(featureClass, featureExtractor, windowOrientation, windowStart, windowEnd);
        this.name = name;
    }

    public List<Feature> extract(JCas jCas, Annotation focusAnnotation, Class<? extends Annotation> cls) throws CleartkExtractorException {
        int annEnd;
        int annBegin = focusAnnotation.getBegin();
        List covering = JCasUtil.selectCovering((JCas)jCas, cls, (int)annBegin, (int)(annEnd = focusAnnotation.getEnd()));
        Annotation windowAnnotation = covering.size() > 0 ? (Annotation)covering.get(0) : null;
        return this.extract(jCas, focusAnnotation, windowAnnotation);
    }

    public List<Feature> extract(JCas jCas, Annotation focusAnnotation, Annotation windowAnnotation) throws CleartkExtractorException {
        if (this.featureType == null) {
            this.featureType = UIMAUtil.getCasType((JCas)jCas, this.featureClass);
        }
        ArrayList<Feature> returnValues = new ArrayList<Feature>();
        Annotation startAnnotation = this.getStartAnnotation(jCas, focusAnnotation);
        FSIterator featureAnnotationIterator = jCas.getAnnotationIndex(this.featureType).iterator();
        if (startAnnotation != null) {
            featureAnnotationIterator.moveTo((FeatureStructure)startAnnotation);
        }
        int outOfBoundsDistance = 0;
        for (int i = 0; i < this.windowEnd; ++i) {
            Annotation featureAnnotation;
            if (outOfBoundsDistance == 0 && startAnnotation != null && featureAnnotationIterator.isValid() && this.isWithinBoundaries(featureAnnotation = (Annotation)featureAnnotationIterator.get(), focusAnnotation, windowAnnotation)) {
                if (i >= this.windowStart) {
                    returnValues.addAll(this.extractWindowedFeatures(jCas, i, featureAnnotation));
                }
                this.moveIterator((FSIterator<Annotation>)featureAnnotationIterator);
                continue;
            }
            ++outOfBoundsDistance;
            if (i < this.windowStart) continue;
            WindowFeature feature = new WindowFeature(this.name, null, this.windowOrientation, (Integer)i, outOfBoundsDistance);
            returnValues.add(feature);
        }
        return returnValues;
    }

    private boolean isWithinBoundaries(Annotation featureAnnotation, Annotation focusAnnotation, Annotation windowAnnotation) {
        if (this.windowOrientation.equals("L") || this.windowOrientation.equals("R")) {
            return AnnotationUtil.contains((Annotation)windowAnnotation, (Annotation)featureAnnotation);
        }
        return AnnotationUtil.contains((Annotation)windowAnnotation, (Annotation)featureAnnotation) && AnnotationUtil.contains((Annotation)focusAnnotation, (Annotation)featureAnnotation);
    }

    private void moveIterator(FSIterator<Annotation> windowIterator) {
        if (this.windowOrientation.equals("L") || this.windowOrientation.equals("MR")) {
            windowIterator.moveToPrevious();
        } else if (this.windowOrientation.equals("R") || this.windowOrientation.equals("M")) {
            windowIterator.moveToNext();
        }
    }

    private List<Feature> extractWindowedFeatures(JCas jCas, int i, Annotation annotation) throws CleartkExtractorException {
        List<Feature> windowedFeatures = this.featureExtractor.extract(jCas, annotation);
        ArrayList<Feature> returnValues = new ArrayList<Feature>();
        if (windowedFeatures != null && windowedFeatures.size() > 0) {
            for (Feature windowedFeature : windowedFeatures) {
                WindowFeature feature = new WindowFeature(this.name, windowedFeature.getValue(), this.windowOrientation, i, windowedFeature, 0);
                returnValues.add(feature);
            }
            return returnValues;
        }
        WindowFeature feature = new WindowFeature(this.name, null, this.windowOrientation, (Integer)i, 0);
        return Collections.singletonList(feature);
    }

    public Annotation getStartAnnotation(JCas jCas, Annotation annotation) {
        return WindowFeature.getStartAnnotation(jCas, this.featureClass, annotation, this.windowOrientation);
    }

    public Class<? extends Annotation> getFeatureClass() {
        return this.featureClass;
    }

    public SimpleFeatureExtractor getFeatureExtractor() {
        return this.featureExtractor;
    }

    public String getName() {
        return this.name;
    }

    public int getWindowEnd() {
        return this.windowEnd;
    }

    public String getWindowOrientation() {
        return this.windowOrientation;
    }

    public int getWindowStart() {
        return this.windowStart;
    }
}

