/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.extractor;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.WindowFeature;
import org.cleartk.classifier.feature.WindowNGramFeature;
import org.cleartk.classifier.feature.extractor.CleartkExtractorException;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.util.AnnotationUtil;
import org.cleartk.util.UIMAUtil;
import org.uimafit.util.JCasUtil;

@Deprecated
public class WindowNGramExtractor {
    Class<? extends Annotation> featureClass;
    Type featureType;
    SimpleFeatureExtractor featureExtractor;
    String orientation;
    String direction;
    String separator;
    int start;
    int end;
    protected String name;

    public WindowNGramExtractor(Class<? extends Annotation> featureClass, SimpleFeatureExtractor featureExtractor, String ngramOrientation, String ngramDirection, String ngramSeparator, int ngramStart, int ngramEnd) {
        this.featureClass = featureClass;
        this.featureExtractor = featureExtractor;
        this.orientation = ngramOrientation;
        this.direction = ngramDirection;
        this.separator = ngramSeparator;
        this.start = ngramStart;
        this.end = ngramEnd;
    }

    public WindowNGramExtractor(String name, Class<? extends Annotation> featureClass, SimpleFeatureExtractor featureExtractor, String ngramOrientation, String ngramDirection, String ngramSeparator, int ngramStart, int ngramEnd) {
        this(featureClass, featureExtractor, ngramOrientation, ngramDirection, ngramSeparator, ngramStart, ngramEnd);
        this.name = name;
    }

    public Feature extract(JCas jCas, Annotation focusAnnotation, Class<? extends Annotation> cls) throws CleartkExtractorException {
        int annEnd;
        int annBegin = focusAnnotation.getBegin();
        List covering = JCasUtil.selectCovering((JCas)jCas, cls, (int)annBegin, (int)(annEnd = focusAnnotation.getEnd()));
        Annotation ngramAnnotation = covering.size() > 0 ? (Annotation)covering.get(0) : null;
        return this.extract(jCas, focusAnnotation, ngramAnnotation);
    }

    public Feature extract(JCas jCas, Annotation focusAnnotation, Annotation ngramAnnotation) throws CleartkExtractorException {
        if (this.featureType == null) {
            this.featureType = UIMAUtil.getCasType((JCas)jCas, this.featureClass);
        }
        ArrayList<String> ngramValues = new ArrayList<String>();
        Annotation startAnnotation = this.getStartAnnotation(jCas, focusAnnotation);
        FSIterator featureAnnotationIterator = jCas.getAnnotationIndex(this.featureType).iterator();
        if (startAnnotation != null) {
            featureAnnotationIterator.moveTo((FeatureStructure)startAnnotation);
        }
        int outOfBoundsDistance = 0;
        ArrayList<Feature> windowedFeatures = new ArrayList<Feature>();
        for (int i = 0; i < this.end; ++i) {
            Annotation featureAnnotation;
            if (outOfBoundsDistance == 0 && startAnnotation != null && featureAnnotationIterator.isValid() && this.isWithinBoundaries(featureAnnotation = (Annotation)featureAnnotationIterator.get(), focusAnnotation, ngramAnnotation)) {
                if (i >= this.start) {
                    Feature ngrammedFeature = this.extactNGrammedFeature(jCas, i, featureAnnotation);
                    if (ngrammedFeature != null) {
                        ngramValues.add(ngrammedFeature.getValue().toString());
                        windowedFeatures.add(ngrammedFeature);
                    } else {
                        ngramValues.add("NULL");
                    }
                }
                this.moveIterator((FSIterator<Annotation>)featureAnnotationIterator);
                continue;
            }
            ++outOfBoundsDistance;
            if (i < this.start) continue;
            ngramValues.add("OOB" + outOfBoundsDistance);
        }
        StringBuffer featureValue = new StringBuffer();
        if (this.direction.equals("L2R") && this.orientation.equals("R") || this.direction.equals("R2L") && this.orientation.equals("L")) {
            for (int i = 0; i < ngramValues.size(); ++i) {
                featureValue.append((String)ngramValues.get(i));
                if (i >= ngramValues.size() - 1) continue;
                featureValue.append(this.separator);
            }
        } else if (this.direction.equals("R2L") && this.orientation.equals("R") || this.direction.equals("L2R") && this.orientation.equals("L")) {
            for (int i = ngramValues.size() - 1; i >= 0; --i) {
                featureValue.append((String)ngramValues.get(i));
                if (i <= 0) continue;
                featureValue.append(this.separator);
            }
        }
        WindowNGramFeature windowNGramFeature = new WindowNGramFeature(null, featureValue.toString(), this.orientation, this.direction, this.separator, this.end - this.start, this.start, windowedFeatures);
        return windowNGramFeature;
    }

    private boolean isWithinBoundaries(Annotation featureAnnotation, Annotation focusAnnotation, Annotation ngramAnnotation) {
        if (this.orientation.equals("L") || this.orientation.equals("R")) {
            return AnnotationUtil.contains((Annotation)ngramAnnotation, (Annotation)featureAnnotation);
        }
        return AnnotationUtil.contains((Annotation)ngramAnnotation, (Annotation)featureAnnotation) && AnnotationUtil.contains((Annotation)focusAnnotation, (Annotation)featureAnnotation);
    }

    private void moveIterator(FSIterator<Annotation> ngramIterator) {
        if (this.orientation.equals("L") || this.orientation.equals("MR")) {
            ngramIterator.moveToPrevious();
        } else if (this.orientation.equals("R") || this.orientation.equals("M")) {
            ngramIterator.moveToNext();
        }
    }

    private Feature extactNGrammedFeature(JCas jCas, int i, Annotation annotation) throws CleartkExtractorException {
        List<Feature> ngramedFeatures = this.featureExtractor.extract(jCas, annotation);
        if (ngramedFeatures != null && ngramedFeatures.size() > 0) {
            return ngramedFeatures.get(0);
        }
        return null;
    }

    public Annotation getStartAnnotation(JCas jCas, Annotation annotation) {
        return WindowFeature.getStartAnnotation(jCas, this.featureClass, annotation, this.orientation);
    }

    public Class<? extends Annotation> getFeatureClass() {
        return this.featureClass;
    }

    public SimpleFeatureExtractor getFeatureExtractor() {
        return this.featureExtractor;
    }

    public String getName() {
        return this.name;
    }

    public int getEnd() {
        return this.end;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public int getStart() {
        return this.start;
    }
}

