/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.extractor.annotationpair;

import java.util.Collections;
import java.util.List;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.extractor.annotationpair.AnnotationPairFeatureExtractor;
import org.uimafit.util.JCasUtil;

public class DistanceExtractor
implements AnnotationPairFeatureExtractor {
    String name;
    Class<? extends Annotation> unitClass;

    public DistanceExtractor(String name, Class<? extends Annotation> unitClass) {
        this.name = name;
        this.unitClass = unitClass;
    }

    @Override
    public List<Feature> extract(JCas jCas, Annotation annotation1, Annotation annotation2) {
        int featureValue;
        Annotation secondAnnotation;
        Annotation firstAnnotation;
        if (annotation1.getBegin() <= annotation2.getBegin()) {
            firstAnnotation = annotation1;
            secondAnnotation = annotation2;
        } else {
            firstAnnotation = annotation2;
            secondAnnotation = annotation1;
        }
        String featureName = Feature.createName(this.name, "Distance", this.unitClass.getSimpleName());
        if (secondAnnotation.getBegin() <= firstAnnotation.getEnd()) {
            featureValue = 0;
        } else {
            List annotations = JCasUtil.selectCovered((JCas)jCas, this.unitClass, (int)firstAnnotation.getEnd(), (int)secondAnnotation.getBegin());
            featureValue = annotations.size();
        }
        return Collections.singletonList(new Feature(featureName, featureValue));
    }
}

