/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.extractor.annotationpair;

import java.util.List;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.extractor.CleartkExtractorException;
import org.cleartk.classifier.feature.extractor.annotationpair.AnnotationPairFeatureExtractor;
import org.cleartk.classifier.feature.extractor.annotationpair.CombinedAnnotationPairFeatureExtractor;
import org.cleartk.util.AnnotationUtil;

public class MatchingAnnotationPairExtractor
implements AnnotationPairFeatureExtractor {
    private Class<? extends Annotation> leftType;
    private Class<? extends Annotation> rightType;
    private AnnotationPairFeatureExtractor subExtractor;

    public MatchingAnnotationPairExtractor(Class<? extends Annotation> leftType, Class<? extends Annotation> rightType, AnnotationPairFeatureExtractor subExtractor) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.subExtractor = subExtractor;
    }

    public MatchingAnnotationPairExtractor(Class<? extends Annotation> leftType, Class<? extends Annotation> rightType, AnnotationPairFeatureExtractor ... subExtractors) {
        this(leftType, rightType, (AnnotationPairFeatureExtractor)new CombinedAnnotationPairFeatureExtractor(subExtractors));
    }

    @Override
    public List<Feature> extract(JCas view, Annotation leftAnnotation, Annotation rightAnnotation) throws CleartkExtractorException {
        Annotation rightMatchingAnnotation;
        Annotation leftMatchingAnnotation;
        if (!this.leftType.isInstance(leftAnnotation)) {
            leftMatchingAnnotation = AnnotationUtil.selectFirstMatching((JCas)view, this.leftType, (Annotation)leftAnnotation);
            if (leftMatchingAnnotation == null) {
                throw CleartkExtractorException.noAnnotationMatchingWindow(this.leftType, leftAnnotation);
            }
        } else {
            leftMatchingAnnotation = this.leftType.cast(leftAnnotation);
        }
        if (!this.rightType.isInstance(rightAnnotation)) {
            rightMatchingAnnotation = AnnotationUtil.selectFirstMatching((JCas)view, this.rightType, (Annotation)rightAnnotation);
            if (rightMatchingAnnotation == null) {
                throw CleartkExtractorException.noAnnotationMatchingWindow(this.rightType, rightAnnotation);
            }
        } else {
            rightMatchingAnnotation = this.rightType.cast(rightAnnotation);
        }
        return this.subExtractor.extract(view, leftMatchingAnnotation, rightMatchingAnnotation);
    }
}

