/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.extractor.annotationpair;

import java.util.Collections;
import java.util.List;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.extractor.annotationpair.AnnotationPairFeatureExtractor;

public class RelativePositionExtractor
implements AnnotationPairFeatureExtractor {
    public static final String EQUALS = "EQUALS";
    public static final String CONTAINS = "CONTAINS";
    public static final String CONTAINEDBY = "CONTAINEDBY";
    public static final String OVERLAPS_LEFT = "OVERLAPS_LEFT";
    public static final String OVERLAPS_RIGHT = "OVERLAPS_RIGHT";
    public static final String LEFTOF = "LEFTOF";
    public static final String RIGHTOF = "RIGHTOF";

    @Override
    public List<Feature> extract(JCas view, Annotation annotation1, Annotation annotation2) {
        String result = this.equals(annotation1, annotation2) ? EQUALS : (this.contains(annotation1, annotation2) ? CONTAINS : (this.contains(annotation2, annotation1) ? CONTAINEDBY : (this.overlaps(annotation1, annotation2) && this.beginsFirst(annotation1, annotation2) ? OVERLAPS_LEFT : (this.overlaps(annotation1, annotation2) ? OVERLAPS_RIGHT : (this.beginsFirst(annotation1, annotation2) ? LEFTOF : RIGHTOF)))));
        return Collections.singletonList(new Feature("RelativePosition", result));
    }

    private boolean equals(Annotation a1, Annotation a2) {
        return a1.getBegin() == a2.getBegin() && a1.getEnd() == a2.getEnd();
    }

    private boolean contains(Annotation a1, Annotation a2) {
        return a1.getBegin() <= a2.getBegin() && a1.getEnd() >= a2.getEnd();
    }

    private boolean overlaps(Annotation a1, Annotation a2) {
        return a1.getBegin() < a2.getEnd() && a1.getEnd() > a2.getBegin();
    }

    private boolean beginsFirst(Annotation a1, Annotation a2) {
        return a1.getBegin() < a2.getBegin();
    }
}

