/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.extractor.simple;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.Counts;
import org.cleartk.classifier.feature.FeatureCollection;
import org.cleartk.classifier.feature.extractor.CleartkExtractorException;
import org.cleartk.classifier.feature.extractor.simple.BagExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;

@Deprecated
public class CountsExtractor
implements SimpleFeatureExtractor {
    private SimpleFeatureExtractor subExtractor;
    private String identifier;

    public CountsExtractor(String identifier, SimpleFeatureExtractor subExtractor) {
        this.subExtractor = subExtractor;
        this.identifier = identifier;
    }

    public CountsExtractor(SimpleFeatureExtractor subExtractor) {
        this((String)null, subExtractor);
    }

    public CountsExtractor(String identifier, Class<? extends Annotation> annotationType, SimpleFeatureExtractor subExtractor) {
        this(identifier, (SimpleFeatureExtractor)new BagExtractor(annotationType, subExtractor));
    }

    public CountsExtractor(Class<? extends Annotation> annotationType, SimpleFeatureExtractor subExtractor) {
        this(null, annotationType, subExtractor);
    }

    @Override
    public List<Feature> extract(JCas view, Annotation annotation) throws CleartkExtractorException {
        HashMap<Object, Integer> countsMap = new HashMap<Object, Integer>();
        FeatureName featureName = new FeatureName();
        this.count(this.subExtractor.extract(view, annotation), countsMap, featureName);
        Counts frequencies = new Counts(featureName.getFeatureName(), this.identifier, countsMap);
        Feature feature = new Feature(String.format("Count(%s)", featureName), frequencies);
        return Collections.singletonList(feature);
    }

    private void count(Collection<Feature> features, Map<Object, Integer> countsMap, FeatureName featureName) throws CleartkExtractorException {
        for (Feature feature : features) {
            if (feature.getValue() instanceof FeatureCollection) {
                FeatureCollection fc = (FeatureCollection)feature.getValue();
                Collection<Feature> subFeatures = fc.getFeatures();
                for (Feature subFeature : subFeatures) {
                    subFeature.setName(Feature.createName(feature.getName(), subFeature.getName()));
                }
                this.count(subFeatures, countsMap, featureName);
                continue;
            }
            featureName.setFeatureName(feature.getName());
            Object o = feature.getValue();
            if (countsMap.containsKey(o)) {
                countsMap.put(o, countsMap.get(o) + 1);
                continue;
            }
            countsMap.put(o, 1);
        }
    }

    private static class FeatureName {
        private String featureName = null;

        public void setFeatureName(String f) throws CleartkExtractorException {
            if (this.featureName != null && !this.featureName.equals(f)) {
                throw CleartkExtractorException.moreThanOneName(this.featureName, f);
            }
            this.featureName = f;
        }

        public String getFeatureName() {
            return this.featureName;
        }
    }
}

