/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.extractor.simple;

import java.util.List;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.extractor.CleartkExtractorException;
import org.cleartk.classifier.feature.extractor.simple.CombinedExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.util.AnnotationUtil;

public class MatchingAnnotationExtractor
implements SimpleFeatureExtractor {
    private Class<? extends Annotation> annotationType;
    private SimpleFeatureExtractor subExtractor;

    public MatchingAnnotationExtractor(Class<? extends Annotation> annotationType, SimpleFeatureExtractor subExtractor) {
        this.annotationType = annotationType;
        this.subExtractor = subExtractor;
    }

    public MatchingAnnotationExtractor(Class<? extends Annotation> annotationType, SimpleFeatureExtractor ... subExtractors) {
        this(annotationType, (SimpleFeatureExtractor)new CombinedExtractor(subExtractors));
    }

    @Override
    public List<Feature> extract(JCas view, Annotation focusAnnotation) throws CleartkExtractorException {
        if (!this.annotationType.isInstance(focusAnnotation) && (focusAnnotation = AnnotationUtil.selectFirstMatching((JCas)view, this.annotationType, (Annotation)focusAnnotation)) == null) {
            throw CleartkExtractorException.noAnnotationMatchingWindow(this.annotationType, focusAnnotation);
        }
        return this.subExtractor.extract(view, focusAnnotation);
    }
}

