/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.extractor.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.BooleanArray;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.TypePathFeature;
import org.cleartk.classifier.feature.extractor.CleartkExtractorException;
import org.cleartk.classifier.feature.extractor.simple.SimpleNamedFeatureExtractor;
import org.uimafit.util.JCasUtil;

public class TypePathExtractor
implements SimpleNamedFeatureExtractor {
    String featureName;
    Class<? extends Annotation> focusClass;
    Type type;
    String path;
    boolean allPaths;
    boolean allValues;
    boolean uniqueValues;
    boolean pathChecked = false;
    TypeSystem typeSystem;
    Logger logger = Logger.getLogger(TypePathExtractor.class.getName());
    private static Pattern pattern = Pattern.compile("/([^/])?");
    private static final String[] HANDLED_TYPES = new String[]{"uima.cas.Boolean", "uima.cas.BooleanArray", "uima.cas.Byte", "uima.cas.ByteArray", "uima.cas.Double", "uima.cas.DoubleArray", "uima.cas.Float", "uima.cas.FloatArray", "uima.cas.FloatList", "uima.cas.Integer", "uima.cas.IntegerArray", "uima.cas.IntegerList", "uima.cas.Long", "uima.cas.LongArray", "uima.cas.Short", "uima.cas.ShortArray", "uima.cas.String", "uima.cas.StringArray", "uima.cas.StringList", "uima.tcas.Annotation"};

    public TypePathExtractor(Class<? extends Annotation> focusClass, String typePath, boolean traverseAllPaths, boolean returnAllValues, boolean uniqueValues) {
        this.featureName = TypePathExtractor.createName(null, typePath);
        this.focusClass = focusClass;
        this.path = typePath;
        this.allPaths = traverseAllPaths;
        this.allValues = returnAllValues;
        this.uniqueValues = uniqueValues;
    }

    public static String createName(String namePrefix, String typePath) {
        if (namePrefix == null) {
            namePrefix = "TypePath";
        }
        String typePathString = typePath == null ? "" : typePath;
        Matcher matcher = pattern.matcher(typePathString);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
                continue;
            }
            matcher.appendReplacement(sb, "");
        }
        matcher.appendTail(sb);
        if (sb.length() > 0) {
            sb.replace(0, 1, sb.substring(0, 1).toUpperCase());
        }
        if (sb.length() > 0) {
            return String.format("%s(%s)", namePrefix, sb.toString());
        }
        return null;
    }

    public TypePathExtractor(Class<? extends Annotation> focusClass, String typePath) {
        this(focusClass, typePath, false, false, true);
    }

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public List<Feature> extract(JCas view, Annotation focusAnnotation) throws CleartkExtractorException {
        if (this.type == null) {
            this.type = JCasUtil.getType((JCas)view, this.focusClass);
        }
        this.typeSystem = view.getTypeSystem();
        if (!this.isValidPath(view)) {
            throw CleartkExtractorException.invalidTypePath(this.path, this.type);
        }
        String[] pathMembers = this.path.split("/");
        ArrayList<Object> pathValues = new ArrayList<Object>();
        this._extract(view, (FeatureStructure)focusAnnotation, pathMembers, pathValues);
        ArrayList<Feature> returnValues = new ArrayList<Feature>();
        HashSet values = new HashSet();
        for (Object e : pathValues) {
            if (this.uniqueValues && values.contains(e)) continue;
            returnValues.add(new TypePathFeature(null, e, this.path, this.featureName));
            values.add(e);
        }
        return returnValues;
    }

    private void _extract(JCas view, FeatureStructure featureStructure, String[] pathMembers, List<Object> pathValues) throws CleartkExtractorException {
        if (pathMembers.length == 1) {
            org.apache.uima.cas.Feature feature = featureStructure.getType().getFeatureByBaseName(pathMembers[0]);
            if (feature == null) {
                return;
            }
            Type featureType = feature.getRange();
            if (featureType.isPrimitive()) {
                Object pathValue = TypePathExtractor.getPrimitiveFeatureValue(view, featureStructure, feature);
                if (pathValue != null) {
                    pathValues.add(pathValue);
                }
            } else if (this.typeSystem.subsumes(this.typeSystem.getType("uima.tcas.Annotation"), featureType)) {
                String coveredText = ((Annotation)featureStructure.getFeatureValue(feature)).getCoveredText();
                if (coveredText != null) {
                    pathValues.add(coveredText);
                }
            } else if (featureType.isArray()) {
                Type componentType = featureType.getComponentType();
                if (componentType.isPrimitive()) {
                    Object[] values = TypePathExtractor.getPrimitiveArrayFeatureValue(view, featureStructure, feature);
                    if (this.allValues) {
                        pathValues.addAll(Arrays.asList(values));
                    } else if (values.length > 0) {
                        pathValues.add(values[0]);
                    }
                } else if (this.typeSystem.subsumes(this.typeSystem.getType("uima.tcas.Annotation"), componentType)) {
                    ArrayFS fsArray = (ArrayFS)featureStructure.getFeatureValue(feature);
                    FeatureStructure[] array = fsArray.toArray();
                    if (this.allValues) {
                        for (FeatureStructure ftr : array) {
                            pathValues.add(((Annotation)ftr).getCoveredText());
                        }
                    } else if (array.length > 0) {
                        pathValues.add(((Annotation)array[0]).getCoveredText());
                    }
                }
            }
        } else {
            String[] remainingPathMembers = new String[pathMembers.length - 1];
            System.arraycopy(pathMembers, 1, remainingPathMembers, 0, pathMembers.length - 1);
            org.apache.uima.cas.Feature feature = featureStructure.getType().getFeatureByBaseName(pathMembers[0]);
            FeatureStructure featureValue = featureStructure.getFeatureValue(feature);
            if (featureValue == null) {
                return;
            }
            if (featureValue instanceof FSArray) {
                FSArray fsArray = (FSArray)featureValue;
                if (this.allPaths) {
                    for (int i = 0; i < fsArray.size(); ++i) {
                        FeatureStructure fs = fsArray.get(i);
                        this._extract(view, fs, remainingPathMembers, pathValues);
                    }
                } else if (fsArray.size() > 0) {
                    this._extract(view, fsArray.get(0), remainingPathMembers, pathValues);
                }
            } else {
                this._extract(view, featureValue, remainingPathMembers, pathValues);
            }
        }
    }

    private boolean isValidPath(JCas view) {
        if (!this.pathChecked) {
            boolean validPath = TypePathExtractor.isValidPath(this.type, this.path, view);
            if (validPath) {
                this.pathChecked = true;
            }
            return validPath;
        }
        return true;
    }

    public static boolean isValidPath(Type type, String path, JCas view) {
        String[] pathMembers = path.split("/");
        Type pathMemberType = type;
        for (String pathMember : pathMembers) {
            org.apache.uima.cas.Feature feature = pathMemberType.getFeatureByBaseName(pathMember);
            if (feature == null) {
                return false;
            }
            pathMemberType = feature.getRange();
            if (!pathMemberType.isArray()) continue;
            pathMemberType = pathMemberType.getComponentType();
        }
        return TypePathExtractor.isValidType(pathMemberType, view.getTypeSystem());
    }

    public static boolean isValidType(Type type, TypeSystem typeSystem) {
        String typeName = type.getName();
        for (String handledType : HANDLED_TYPES) {
            if (!typeName.equals(handledType)) continue;
            return true;
        }
        if (typeSystem.subsumes(typeSystem.getType("uima.cas.String"), type)) {
            return true;
        }
        return typeSystem.subsumes(typeSystem.getType("uima.tcas.Annotation"), type);
    }

    private static Object getPrimitiveFeatureValue(JCas view, FeatureStructure featureStructure, org.apache.uima.cas.Feature feature) throws CleartkExtractorException {
        TypeSystem typeSystem = view.getTypeSystem();
        Type type = feature.getRange();
        if (type.equals(typeSystem.getType("uima.cas.Boolean"))) {
            return featureStructure.getBooleanValue(feature);
        }
        if (type.equals(typeSystem.getType("uima.cas.Double"))) {
            return featureStructure.getDoubleValue(feature);
        }
        if (type.equals(typeSystem.getType("uima.cas.Float"))) {
            return Float.valueOf(featureStructure.getFloatValue(feature));
        }
        if (type.equals(typeSystem.getType("uima.cas.Byte"))) {
            return featureStructure.getByteValue(feature);
        }
        if (type.equals(typeSystem.getType("uima.cas.Short"))) {
            return featureStructure.getShortValue(feature);
        }
        if (type.equals(typeSystem.getType("uima.cas.Integer"))) {
            return featureStructure.getIntValue(feature);
        }
        if (type.equals(typeSystem.getType("uima.cas.Long"))) {
            return featureStructure.getLongValue(feature);
        }
        if (type.equals(typeSystem.getType("uima.cas.String"))) {
            return featureStructure.getStringValue(feature);
        }
        throw CleartkExtractorException.notPrimitive(feature);
    }

    private static Object[] getPrimitiveArrayFeatureValue(JCas view, FeatureStructure featureStructure, org.apache.uima.cas.Feature feature) throws CleartkExtractorException {
        TypeSystem typeSystem = view.getTypeSystem();
        Type type = feature.getRange();
        if (type.isArray()) {
            Type componentType = type.getComponentType();
            FeatureStructure featureValue = featureStructure.getFeatureValue(feature);
            if (componentType.equals(typeSystem.getType("uima.cas.String"))) {
                return ((StringArray)featureValue).toArray();
            }
            if (componentType.equals(typeSystem.getType("uima.cas.Boolean"))) {
                return Arrays.asList(new boolean[][]{((BooleanArray)featureValue).toArray()}).toArray();
            }
            if (componentType.equals(typeSystem.getType("uima.cas.Double"))) {
                return Arrays.asList(new double[][]{((DoubleArray)featureValue).toArray()}).toArray();
            }
            if (componentType.equals(typeSystem.getType("uima.cas.Float"))) {
                return Arrays.asList(new float[][]{((FloatArray)featureValue).toArray()}).toArray();
            }
            if (componentType.equals(typeSystem.getType("uima.cas.Byte"))) {
                return Arrays.asList(new byte[][]{((ByteArray)featureValue).toArray()}).toArray();
            }
            if (componentType.equals(typeSystem.getType("uima.cas.Short"))) {
                return Arrays.asList(new short[][]{((ShortArray)featureValue).toArray()}).toArray();
            }
            if (componentType.equals(typeSystem.getType("uima.cas.Integer"))) {
                return Arrays.asList(new int[][]{((IntegerArray)featureValue).toArray()}).toArray();
            }
            if (componentType.equals(typeSystem.getType("uima.cas.Long"))) {
                return Arrays.asList(new long[][]{((LongArray)featureValue).toArray()}).toArray();
            }
        } else {
            throw CleartkExtractorException.notPrimitiveArray(feature);
        }
        return null;
    }

    public boolean isAllPaths() {
        return this.allPaths;
    }

    public boolean isAllValues() {
        return this.allValues;
    }

    public Class<? extends Annotation> getFocusClass() {
        return this.focusClass;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isUniqueValues() {
        return this.uniqueValues;
    }
}

