/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.extractor.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.extractor.CleartkExtractorException;
import org.cleartk.classifier.feature.extractor.simple.SimpleNamedFeatureExtractor;

public class WhiteSpaceExtractor
implements SimpleNamedFeatureExtractor {
    private static final String FEATURE_NAME = "whitespace";
    public static final String WhiteSpaceRegex = "\\s";
    public static final Pattern WhiteSpacePattern = Pattern.compile("\\s");
    public static final String ORIENTATION_LEFT = "L";
    public static final String ORIENTATION_RIGHT = "R";

    @Override
    public String getFeatureName() {
        return FEATURE_NAME;
    }

    @Override
    public List<Feature> extract(JCas view, Annotation focusAnnotation) throws CleartkExtractorException {
        Feature feature;
        Feature feature2;
        ArrayList<Feature> features = new ArrayList<Feature>();
        String text = view.getDocumentText();
        int begin = focusAnnotation.getBegin();
        int end = focusAnnotation.getEnd();
        if (begin == 0) {
            feature2 = new Feature(FEATURE_NAME, ORIENTATION_LEFT);
            features.add(feature2);
        } else {
            char leftChar = text.charAt(begin - 1);
            if (Character.isWhitespace(leftChar)) {
                feature = new Feature(FEATURE_NAME, ORIENTATION_LEFT);
                features.add(feature);
            }
        }
        if (end == text.length()) {
            feature2 = new Feature(FEATURE_NAME, ORIENTATION_RIGHT);
            features.add(feature2);
        } else {
            char rightChar = text.charAt(end);
            if (Character.isWhitespace(rightChar)) {
                feature = new Feature(FEATURE_NAME, ORIENTATION_RIGHT);
                features.add(feature);
            }
        }
        return features;
    }
}

