/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.feature.function;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.extractor.CleartkExtractorException;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.classifier.feature.function.FeatureFunction;

public class FeatureFunctionExtractor
implements SimpleFeatureExtractor {
    private SimpleFeatureExtractor extractor;
    private FeatureFunction[] featureFunctions;

    public FeatureFunctionExtractor(SimpleFeatureExtractor extractor, FeatureFunction ... featureFunctions) {
        this.extractor = extractor;
        this.featureFunctions = featureFunctions;
    }

    @Override
    public List<Feature> extract(JCas jCas, Annotation focusAnnotation) throws CleartkExtractorException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        List<Feature> baseFeatures = this.extractor.extract(jCas, focusAnnotation);
        features.addAll(baseFeatures);
        for (FeatureFunction featureFunction : this.featureFunctions) {
            features.addAll(FeatureFunctionExtractor.apply(featureFunction, baseFeatures));
        }
        return features;
    }

    public static List<Feature> apply(Function<Feature, List<Feature>> featureFunction, List<Feature> features) {
        ArrayList<Feature> returnValues = new ArrayList<Feature>();
        for (Feature feature : features) {
            returnValues.addAll((Collection)featureFunction.apply((Object)feature));
        }
        return returnValues;
    }
}

